/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.cal.business.bizgroup;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.cal.business.bizgroup.BizGroupRecordCompletedHelper;

public class BizGroupRecordDelete4Im {
    private static final String SELECT_FIELDS = "id,groupvalue,iscompleted,updatetime,entryentity.type,entryentity.formid,entryentity.bizbillid,entryentity.bizentryid,entryentity.baseqty,entryentity.islastentry,entryentity.isdel,entryentity.ischargeoffed";

    public static Set<Long> deleteRecord(Map<String, Set<Long>> formId2BizbillidMap, boolean isDelete) {
        Set<Long> bizBillIds = BizGroupRecordDelete4Im.getAllBizBillIds(formId2BizbillidMap);
        HashSet<Long> allBizBillIds = new HashSet<Long>(16);
        Lists.partition(new ArrayList<Long>(bizBillIds), (int)1000).forEach(list -> {
            DynamicObject[] records;
            HashSet curPartBizBillids = new HashSet(1000);
            curPartBizBillids.addAll(list);
            HashSet<Long> deleteRecordIds = new HashSet<Long>(16);
            HashSet<DynamicObject> updateRecords = new HashSet<DynamicObject>(16);
            QFilter filter = new QFilter("entryentity.bizbillid", "in", list);
            for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"im_bgrecord", (String)SELECT_FIELDS, (QFilter[])filter.toArray())) {
                DynamicObjectCollection entry = record.getDynamicObjectCollection("entryentity");
                Iterator iterator = entry.iterator();
                while (iterator.hasNext()) {
                    DynamicObject entryRow = (DynamicObject)iterator.next();
                    Long bizbillid = entryRow.getLong("bizbillid");
                    allBizBillIds.add(bizbillid);
                    if (!curPartBizBillids.contains(bizbillid)) continue;
                    if (isDelete) {
                        iterator.remove();
                        continue;
                    }
                    entryRow.set("isdel", (Object)Boolean.TRUE);
                }
                boolean hasSrc = false;
                boolean hasDest = false;
                for (DynamicObject entryRow : entry) {
                    String type = entryRow.getString("type");
                    if ("0".equals(type)) {
                        hasSrc = true;
                        continue;
                    }
                    if (!"1".equals(type)) continue;
                    hasDest = true;
                }
                if (hasSrc && hasDest) {
                    updateRecords.add(record);
                    BizGroupRecordCompletedHelper.resolveGroupRecordComplted(record);
                    record.set("updatetime", (Object)TimeServiceHelper.now());
                    continue;
                }
                deleteRecordIds.add(record.getLong("id"));
            }
            BizGroupRecordDelete4Im.deleteSave2DB(deleteRecordIds);
            BizGroupRecordDelete4Im.updateSave2DB(updateRecords);
        });
        return allBizBillIds;
    }

    private static void updateSave2DB(Set<DynamicObject> updateRecords) {
        Lists.partition(new ArrayList<DynamicObject>(updateRecords), (int)1000).forEach(list -> SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0])));
    }

    private static void deleteSave2DB(Set<Long> deleteRecordIds) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"im_bgrecord");
        Lists.partition(new ArrayList<Long>(deleteRecordIds), (int)1000).forEach(list -> DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])list.toArray()));
    }

    private static Set<Long> getAllBizBillIds(Map<String, Set<Long>> formId2BizbillidMap) {
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (Set<Long> value : formId2BizbillidMap.values()) {
            bizBillIds.addAll(value);
        }
        return bizBillIds;
    }
}

