/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.cal.business.bizgroup;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.cal.business.bizgroup.BizGroupRecordCompletedHelper;

public class BizGroupRecordHolder {
    public static final String GROUPRCORD_SELECTFIELD = "bgsetting.id,groupvalue,iscompleted,createtime,updatetime,type,bizbillid,bizentryid,billno,bookdate,bizdate,material.id,owner.id,baseqty,islastentry,ischargeoffed,formid,isdel";
    public static final String[] ENTRYFIELD = new String[]{"type", "bizbillid", "bizentryid", "billno", "bookdate", "bizdate", "material", "owner", "baseqty", "islastentry", "ischargeoffed", "formid"};
    private Map<Long, Map<String, DynamicObject>> groupRecordMap = new HashMap<Long, Map<String, DynamicObject>>(4);
    private Map<String, DynamicObject> existGroupRecordMap = new HashMap<String, DynamicObject>(4);
    private Map<String, Set<Long>> existGroupRecordBizEntryIdMap = new HashMap<String, Set<Long>>(4);
    private Set<String> hasRecordBizEntryIds = new HashSet<String>(16);
    private Set<Long> hasRecordBizBillIds = new HashSet<Long>(16);
    private Long bizGroupSettingId = 0L;
    private String[] relfields = new String[0];
    private int BATCHSIZE = 1000;
    private List<DynamicObject> updateRecords = new ArrayList<DynamicObject>(16);
    private List<DynamicObject> newRecords = new ArrayList<DynamicObject>(16);

    public void setBizGroupSetting(Long bizGroupSetting) {
        this.bizGroupSettingId = bizGroupSetting;
    }

    public void setRelfields(String[] relfields) {
        this.relfields = relfields;
    }

    public Set<Long> getHasRecordBizBillIds() {
        return this.hasRecordBizBillIds;
    }

    public void addGroupRecord(Set<DynamicObject> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        for (DynamicObject record : records) {
            Map map = this.groupRecordMap.computeIfAbsent(this.bizGroupSettingId, k -> new HashMap(16));
            String groupValue = record.getString("groupvalue");
            map.put(groupValue, record);
            DynamicObjectCollection entry = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : entry) {
                this.hasRecordBizBillIds.add(entryRow.getLong("bizbillid"));
            }
        }
    }

    public void addGroupRecord(Row row) {
        Long dest_bizbillid = row.getLong("dest_bizbillid");
        Long dest_bizentryid = row.getLong("dest_bizentryid");
        String dest_billno = row.getString("dest_billno");
        Date dest_bookdate = row.getDate("dest_bookdate");
        Date dest_bizdate = row.getDate("dest_bizdate");
        Long dest_material = row.getLong("dest_material");
        Long dest_owner = row.getLong("dest_owner");
        BigDecimal dest_baseqty = row.getBigDecimal("dest_baseqty");
        boolean dest_islastentry = row.getBoolean("dest_islastentry");
        boolean dest_ischargeoffed = row.getBoolean("dest_ischargeoffed");
        String dest_formid = row.getString("dest_formid");
        Long src_bizbillid = row.getLong("src_bizbillid");
        Long src_bizentryid = row.getLong("src_bizentryid");
        String src_billno = row.getString("src_billno");
        Date src_bookdate = row.getDate("src_bookdate");
        Date src_bizdate = row.getDate("src_bizdate");
        Long src_material = row.getLong("src_material");
        Long src_owner = row.getLong("src_owner");
        BigDecimal src_baseqty = row.getBigDecimal("src_baseqty");
        boolean src_islastentry = row.getBoolean("src_islastentry");
        boolean src_ischargeoffed = row.getBoolean("src_ischargeoffed");
        String src_formid = row.getString("src_formid");
        ArrayList<String> groupValues = new ArrayList<String>(16);
        for (String relfield : this.relfields) {
            groupValues.add(row.getString(relfield));
        }
        String groupValue = String.join((CharSequence)"#", groupValues);
        Map map = this.groupRecordMap.computeIfAbsent(this.bizGroupSettingId, k -> new HashMap(16));
        DynamicObject groupRecord = (DynamicObject)map.get(groupValue);
        if (groupRecord == null) {
            groupRecord = BusinessDataServiceHelper.newDynamicObject((String)"im_bgrecord");
            groupRecord.set("bgsetting", (Object)this.bizGroupSettingId);
            groupRecord.set("groupvalue", (Object)groupValue);
            groupRecord.set("createtime", (Object)TimeServiceHelper.now());
            groupRecord.set("updatetime", (Object)TimeServiceHelper.now());
            map.put(groupValue, groupRecord);
        }
        DynamicObjectCollection entryentity = groupRecord.getDynamicObjectCollection("entryentity");
        this.addRecordEntry(src_bizbillid, src_bizentryid, src_billno, src_bookdate, src_bizdate, src_material, src_owner, src_baseqty, src_islastentry, src_ischargeoffed, src_formid, entryentity, "0");
        this.addRecordEntry(dest_bizbillid, dest_bizentryid, dest_billno, dest_bookdate, dest_bizdate, dest_material, dest_owner, dest_baseqty, dest_islastentry, dest_ischargeoffed, dest_formid, entryentity, "1");
    }

    private void addRecordEntry(Long bizbillid, Long bizentryid, String billno, Date bookdate, Date bizdate, Long material, Long owner, BigDecimal baseqty, boolean islastentry, boolean ischargeoffed, String formid, DynamicObjectCollection entryentity, String type) {
        if (!this.hasRecordBizEntryIds.add(this.bizGroupSettingId + "#" + bizentryid)) {
            return;
        }
        this.hasRecordBizBillIds.add(bizbillid);
        DynamicObject entry = entryentity.addNew();
        entry.set("type", (Object)type);
        entry.set("bizbillid", (Object)bizbillid);
        entry.set("bizentryid", (Object)bizentryid);
        entry.set("billno", (Object)billno);
        entry.set("bookdate", (Object)bookdate);
        entry.set("bizdate", (Object)bizdate);
        entry.set("material", (Object)material);
        entry.set("owner", (Object)owner);
        entry.set("baseqty", (Object)baseqty);
        entry.set("islastentry", (Object)islastentry);
        entry.set("ischargeoffed", (Object)ischargeoffed);
        entry.set("formid", (Object)formid);
        entry.set("formid_id", (Object)formid);
        entry.set("isdel", (Object)Boolean.FALSE);
    }

    public void saveRecord() {
        if (this.groupRecordMap.isEmpty()) {
            return;
        }
        this.initExistGroupRecord();
        this.addEntrySetComplete();
        DynamicObject calDBParam = QueryServiceHelper.queryOne((String)"cal_dbparam", (String)"id,value", (QFilter[])new QFilter("key", "=", (Object)"bizgroup_save_size").toArray());
        if (calDBParam != null) {
            this.BATCHSIZE = Integer.parseInt(calDBParam.getString("value"));
        }
        this.save2DB(this.updateRecords);
        this.save2DB(this.newRecords);
    }

    private void save2DB(List<DynamicObject> records) {
        if (!records.isEmpty()) {
            Lists.partition(records, (int)this.BATCHSIZE).forEach(list -> SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0])));
        }
    }

    private void addEntrySetComplete() {
        for (Map.Entry<Long, Map<String, DynamicObject>> mapEntry : this.groupRecordMap.entrySet()) {
            Long settingid = mapEntry.getKey();
            Map<String, DynamicObject> value = mapEntry.getValue();
            for (Map.Entry<String, DynamicObject> mapEntry2 : value.entrySet()) {
                String groupvalue = mapEntry2.getKey();
                DynamicObject groupRecord = mapEntry2.getValue();
                String key = settingid + "#" + groupvalue;
                DynamicObject existRecord = this.existGroupRecordMap.get(key);
                if (existRecord == null) {
                    BizGroupRecordCompletedHelper.resolveGroupRecordComplted(groupRecord);
                    this.newRecords.add(groupRecord);
                    continue;
                }
                Set<Long> bizentryids = this.existGroupRecordBizEntryIdMap.get(key);
                DynamicObjectCollection existEntry = existRecord.getDynamicObjectCollection("entryentity");
                DynamicObjectCollection entry = groupRecord.getDynamicObjectCollection("entryentity");
                boolean isAddNew = false;
                for (DynamicObject entryRow : entry) {
                    Long bizentryid = entryRow.getLong("bizentryid");
                    if (!bizentryids.add(bizentryid)) continue;
                    DynamicObject newEntry = existEntry.addNew();
                    this.copyEntry(newEntry, entryRow);
                    isAddNew = true;
                }
                if (!isAddNew) continue;
                existRecord.set("updatetime", (Object)TimeServiceHelper.now());
                BizGroupRecordCompletedHelper.resolveGroupRecordComplted(existRecord);
                this.updateRecords.add(existRecord);
            }
        }
    }

    private void copyEntry(DynamicObject newEntry, DynamicObject oldEntry) {
        for (String field : ENTRYFIELD) {
            newEntry.set(field, oldEntry.get(field));
        }
    }

    private void initExistGroupRecord() {
        HashSet<Long> setIds = new HashSet<Long>(16);
        HashSet<String> groupValues = new HashSet<String>(16);
        for (Map.Entry<Long, Map<String, DynamicObject>> mapEntry : this.groupRecordMap.entrySet()) {
            setIds.add(mapEntry.getKey());
            groupValues.addAll(mapEntry.getValue().keySet());
        }
        QFilter filter = new QFilter("bgsetting", "in", setIds);
        filter.and("groupvalue", "in", groupValues);
        DynamicObject[] existRecords = BusinessDataServiceHelper.load((String)"im_bgrecord", (String)GROUPRCORD_SELECTFIELD, (QFilter[])filter.toArray());
        if (existRecords != null) {
            for (DynamicObject existRecord : existRecords) {
                Long settingid = existRecord.getLong("bgsetting.id");
                String groupvalue = existRecord.getString("groupvalue");
                String key = settingid + "#" + groupvalue;
                this.existGroupRecordMap.put(key, existRecord);
                DynamicObjectCollection entry = existRecord.getDynamicObjectCollection("entryentity");
                HashSet<Long> bizEntryids = new HashSet<Long>(16);
                for (DynamicObject entryRow : entry) {
                    boolean isdel = entryRow.getBoolean("isdel");
                    if (isdel) continue;
                    bizEntryids.add(entryRow.getLong("bizentryid"));
                }
                this.existGroupRecordBizEntryIdMap.put(key, bizEntryids);
            }
        }
    }
}

