/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.cal.business.bizgroup;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.sdk.scmc.im.extpoint.IInvGroupBillExpand;

public class ReturnApplyBillGroupPlugin
implements IInvGroupBillExpand {
    public static final String DEST_SELECT = "id as dest_bizbillid,billentry.id as dest_bizentryid,billno as dest_billno,bookdate as dest_bookdate,biztime as dest_bizdate,billentry.material.masterid as dest_material,billentry.outowner as dest_owner,billentry.baseqty as dest_baseqty,ischargeoffed as dest_ischargeoffed,billentry.srcbillid as saloutsrcbillid,billentry.srcbillentryid as saloutsrcbillentryid,billentry.srcbillentity";
    public static final String SRC_SELECT = "id as src_bizbillid,billentry.id as src_bizentryid,billno as src_billno,bookdate as src_bookdate,biztime as src_bizdate,billentry.material.masterid as src_material,billentry.outowner as src_owner,billentry.baseqty as src_baseqty,ischargeoffed as src_ischargeoffed";
    public static final String APPLYBILL_SELECT = "id as applybillid,billentry.id as applybillentryid,billentry.srcbillentryid as applysrcbillentryid,billentry.srcbillid as applysrcbillid,billentry.srcbillentity as  applysrcbillentity";
    private Set<Long> hasRecordBizEntryIds;

    public Set<DynamicObject> createGroupRecord(Set<Long> bizBillIds, List<QFilter> findQFilters, boolean isByDestBill) {
        DataSet srcSalOutBill;
        DataSet returnApplyBill;
        DataSet destSalOutBill;
        this.hasRecordBizEntryIds = new HashSet<Long>(16);
        if (isByDestBill) {
            destSalOutBill = this.getDestSalOutBill(new QFilter[]{new QFilter("id", "in", bizBillIds)});
            returnApplyBill = this.getReturnApplyBillByDownRedBill(destSalOutBill.copy());
            srcSalOutBill = this.getSrcSalOutBillByDownApplyBill(returnApplyBill.copy(), findQFilters);
        } else {
            srcSalOutBill = this.getSrcSalOutBill(new QFilter[]{new QFilter("id", "in", bizBillIds)});
            returnApplyBill = this.getReturnApplyBillByUpBlueBill(bizBillIds);
            destSalOutBill = this.getDestSalOutBillByUpApplyBill(returnApplyBill.copy(), findQFilters);
        }
        Set<DynamicObject> groupRecord = this.createRecord(destSalOutBill, returnApplyBill, srcSalOutBill);
        return groupRecord;
    }

    private DataSet getDestSalOutBillByUpApplyBill(DataSet returnApplyBill, List<QFilter> findQFilters) {
        HashSet<Long> returnApplyIds = new HashSet<Long>(16);
        for (Row row : returnApplyBill) {
            returnApplyIds.add(row.getLong("applybillid"));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("billentry.srcbillentity", "=", (Object)"sm_returnapply"));
        filters.add(new QFilter("billentry.srcbillid", "in", returnApplyIds));
        if (findQFilters != null && !findQFilters.isEmpty()) {
            filters.addAll(findQFilters);
        }
        DataSet dataSet = this.getDestSalOutBill(filters.toArray(new QFilter[0]));
        return dataSet;
    }

    private DataSet getReturnApplyBillByUpBlueBill(Set<Long> salOutBillids) {
        QFilter filter = new QFilter("billentry.srcbillid", "in", salOutBillids);
        filter.and("billentry.srcbillentity", "=", (Object)"im_saloutbill");
        DataSet dataSet = this.getReturnApplyBill(filter);
        return dataSet;
    }

    private Set<DynamicObject> createRecord(DataSet destSalOutBill, DataSet returnApplyBill, DataSet srcSalOutBill) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        DataSet dataSet = destSalOutBill.join(returnApplyBill, JoinType.INNER).on("saloutsrcbillentryid", "applybillentryid").select(destSalOutBill.getRowMeta().getFieldNames(), returnApplyBill.getRowMeta().getFieldNames()).finish();
        dataSet = dataSet.join(srcSalOutBill, JoinType.INNER).on("applysrcbillentryid", "src_bizentryid").select(dataSet.getRowMeta().getFieldNames(), srcSalOutBill.getRowMeta().getFieldNames()).finish();
        for (Row row : dataSet) {
            Long dest_bizbillid = row.getLong("dest_bizbillid");
            Long dest_bizentryid = row.getLong("dest_bizentryid");
            String dest_billno = row.getString("dest_billno");
            Date dest_bookdate = row.getDate("dest_bookdate");
            Date dest_bizdate = row.getDate("dest_bizdate");
            Long dest_material = row.getLong("dest_material");
            Long dest_owner = row.getLong("dest_owner");
            BigDecimal dest_baseqty = row.getBigDecimal("dest_baseqty");
            boolean dest_islastentry = false;
            boolean dest_ischargeoffed = row.getBoolean("dest_ischargeoffed");
            String dest_formid = "im_saloutbill";
            Long src_bizbillid = row.getLong("src_bizbillid");
            Long src_bizentryid = row.getLong("src_bizentryid");
            String src_billno = row.getString("src_billno");
            Date src_bookdate = row.getDate("src_bookdate");
            Date src_bizdate = row.getDate("src_bizdate");
            Long src_material = row.getLong("src_material");
            Long src_owner = row.getLong("src_owner");
            BigDecimal src_baseqty = row.getBigDecimal("src_baseqty");
            boolean src_islastentry = false;
            boolean src_ischargeoffed = row.getBoolean("src_ischargeoffed");
            String src_formid = "im_saloutbill";
            String groupValue = src_bizentryid + "#";
            DynamicObject groupRecord = (DynamicObject)map.get(groupValue);
            if (groupRecord == null) {
                groupRecord = BusinessDataServiceHelper.newDynamicObject((String)"im_bgrecord");
                groupRecord.set("bgsetting", (Object)this.getSettingId());
                groupRecord.set("groupvalue", (Object)groupValue);
                groupRecord.set("createtime", (Object)TimeServiceHelper.now());
                groupRecord.set("updatetime", (Object)TimeServiceHelper.now());
                map.put(groupValue, groupRecord);
            }
            DynamicObjectCollection entryentity = groupRecord.getDynamicObjectCollection("entryentity");
            this.addRecordEntry(src_bizbillid, src_bizentryid, src_billno, src_bookdate, src_bizdate, src_material, src_owner, src_baseqty, src_islastentry, src_ischargeoffed, src_formid, entryentity, "0");
            this.addRecordEntry(dest_bizbillid, dest_bizentryid, dest_billno, dest_bookdate, dest_bizdate, dest_material, dest_owner, dest_baseqty, dest_islastentry, dest_ischargeoffed, dest_formid, entryentity, "1");
        }
        return new HashSet<DynamicObject>(map.values());
    }

    private void addRecordEntry(Long bizbillid, Long bizentryid, String billno, Date bookdate, Date bizdate, Long material, Long owner, BigDecimal baseqty, boolean islastentry, boolean ischargeoffed, String formid, DynamicObjectCollection entryentity, String type) {
        if (!this.hasRecordBizEntryIds.add(bizentryid)) {
            return;
        }
        DynamicObject entry = entryentity.addNew();
        entry.set("type", (Object)type);
        entry.set("bizbillid", (Object)bizbillid);
        entry.set("bizentryid", (Object)bizentryid);
        entry.set("billno", (Object)billno);
        entry.set("bookdate", (Object)bookdate);
        entry.set("bizdate", (Object)bizdate);
        entry.set("material", (Object)material);
        entry.set("owner", (Object)owner);
        entry.set("baseqty", (Object)baseqty);
        entry.set("islastentry", (Object)islastentry);
        entry.set("ischargeoffed", (Object)ischargeoffed);
        entry.set("formid", (Object)formid);
        entry.set("isdel", (Object)Boolean.FALSE);
    }

    private DataSet getSrcSalOutBillByDownApplyBill(DataSet returnApplyBill, List<QFilter> findQFilters) {
        HashSet<Long> srcBillIds = new HashSet<Long>(16);
        for (Row row : returnApplyBill) {
            String entity = row.getString("applysrcbillentity");
            if (!"im_saloutbill".equals(entity)) continue;
            srcBillIds.add(row.getLong("applysrcbillid"));
        }
        QFilter filter = new QFilter("id", "in", srcBillIds);
        ArrayList<QFilter> allFilter = new ArrayList<QFilter>(4);
        allFilter.add(filter);
        if (findQFilters != null && !findQFilters.isEmpty()) {
            allFilter.addAll(findQFilters);
        }
        DataSet srcDataSet = this.getSrcSalOutBill(allFilter.toArray(new QFilter[0]));
        return srcDataSet;
    }

    private DataSet getSrcSalOutBill(QFilter[] allFilter) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_saloutbill", (String)SRC_SELECT, (QFilter[])allFilter, null);
        return dataSet;
    }

    private DataSet getReturnApplyBillByDownRedBill(DataSet destSalOutBill) {
        HashSet<Long> returnApplyIds = new HashSet<Long>(16);
        for (Row row : destSalOutBill) {
            String entity = row.getString("billentry.srcbillentity");
            if (!"sm_returnapply".equals(entity)) continue;
            returnApplyIds.add(row.getLong("saloutsrcbillid"));
        }
        QFilter filter = new QFilter("id", "in", returnApplyIds);
        DataSet dataSet = this.getReturnApplyBill(filter);
        return dataSet;
    }

    private DataSet getReturnApplyBill(QFilter filter) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sm_returnapply", (String)APPLYBILL_SELECT, (QFilter[])filter.toArray(), null);
        return dataSet;
    }

    private DataSet getDestSalOutBill(QFilter[] filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_saloutbill", (String)DEST_SELECT, (QFilter[])filters, null);
        return dataSet;
    }

    public Long getSettingId() {
        return 1701657031800350720L;
    }
}

