/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.cal.formplugin.bizgroup;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.cal.common.helper.BillTreeBuildParameter;
import kd.scmc.im.cal.common.helper.CalDebugModelHelper;
import kd.scmc.im.cal.common.helper.EntityParseHelper;
import kd.scmc.im.cal.common.helper.FilterInfoChecker;

public class BizGroupSettingPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String MULBILL_TYPE = "A";
    public static final String CHARGEOFFBILL_TYPE = "B";
    public static final String SINBILL_TYPE = "C";
    public static final String SIN2SIN_TYPE = "A";
    public static final String SIN2MUL_TYPE = "B";
    public static final String MUL2SIN_TYPE = "C";
    public static final String SRCBILL_TYPE = "D";
    public static final String MINBILL_TYPE = "E";
    public static final String KEY_GROUPBILLENTRY = "groupbillentry";
    public static final String KEY_RELATIONENTRY = "relationentry";
    public static final int GROUPBILLMAXCOUNT = 5;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"filter", "cfilter", "fieldkey0", "fieldkey1", "fieldkey2", "fieldkey3", "fieldkey4", "validate"});
        BasedataEdit formid = (BasedataEdit)this.getControl("formid");
        formid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String grouptype = (String)this.getModel().getValue("grouptype");
        if (!"A".equals(grouptype)) {
            this.initRelType(grouptype);
            ((ComboEdit)this.getView().getControl("reltype")).setMustInput(true);
        } else {
            ((TextEdit)this.getView().getControl("filter")).setMustInput(true);
            ((ComboEdit)this.getView().getControl("type")).setMustInput(true);
        }
        this.setRelEntryVisable();
        if (CalDebugModelHelper.isDebugModel()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"group_validate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"group_validate"});
        }
    }

    private void initRelType(String grouptype) {
        ComboProp reltype = (ComboProp)this.getModel().getProperty("reltype");
        List comboItems = reltype.getComboItems();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(8);
        if ("B".equals(grouptype)) {
            for (ValueMapItem comboItem : comboItems) {
                String key = comboItem.getValue();
                if (!SRCBILL_TYPE.equals(key) && !MINBILL_TYPE.equals(key)) continue;
                items.add(new ComboItem(comboItem.getName(), key));
            }
        } else if ("C".equals(grouptype)) {
            for (ValueMapItem comboItem : comboItems) {
                String key = comboItem.getValue();
                if (!"A".equals(key) && !"B".equals(key) && !"C".equals(key)) continue;
                items.add(new ComboItem(comboItem.getName(), key));
            }
        }
        ComboEdit co = (ComboEdit)this.getView().getControl("reltype");
        co.setComboItems(items);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String grouptype = (String)this.getModel().getValue("grouptype");
        if ("A".equals(grouptype)) {
            this.initRelationEntryHead();
            this.setRelEntryVisable();
            this.setNameAndFilter();
        }
        this.getModel().setDataChanged(false);
    }

    private void setNameAndFilter() {
        DynamicObjectCollection groupbillentry = this.getModel().getEntryEntity(KEY_GROUPBILLENTRY);
        for (int i = 0; i < groupbillentry.size(); ++i) {
            DynamicObject groupbill = (DynamicObject)groupbillentry.get(i);
            DynamicObject formid = groupbill.getDynamicObject("formid");
            if (formid == null) continue;
            String filter = groupbill.getString("filterjson_tag");
            String cfilter = groupbill.getString("cfilterjson_tag");
            String formidStr = formid.getString("id");
            this.setFilterTran(filter, formidStr, "filter", i);
            this.setFilterTran(cfilter, formidStr, "cfilter", i);
            EntityParseHelper.bindColNames(this.getModel(), KEY_RELATIONENTRY, formidStr, "fieldkey" + i, "fieldname" + i);
        }
    }

    private void setFilterTran(String filter, String formidStr, String filterTranKey, int index) {
        if (StringUtils.isEmpty((String)formidStr)) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        CRCondition condition = new CRCondition();
        condition.setFilterCondition(filterCondition);
        String exprTran = this.tranFormula((CRFormula)condition, formidStr);
        exprTran = exprTran.length() > 500 ? exprTran.substring(0, 500) + "..." : exprTran;
        this.getModel().setValue(filterTranKey, (Object)exprTran, index);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if ("deleteentry".equals(opKey)) {
            EntryGrid entrygrid = (EntryGrid)this.getView().getControl(KEY_GROUPBILLENTRY);
            int[] selectRows = entrygrid.getSelectRows();
            if (selectRows == null) {
                return;
            }
            for (int selectRow : selectRows) {
                boolean eispreset = (Boolean)this.getModel().getValue("eispreset", selectRow);
                if (!eispreset) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8bbe\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BizGroupSettingPlugin_2", (String)"scmc-im-cal", (Object[])new Object[0]));
            }
        } else if ("copy".equals(opKey)) {
            String grouptype = (String)this.getModel().getValue("grouptype");
            if (!"A".equals(grouptype)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6210\u7ec4\u7c7b\u578b\u4e3a\u201c\u4e00\u5355\u53cc\u65b9\u5411\u201d\u6216\u8005\u201c\u51b2\u56de\u201d\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"BizGroupSettingPlugin_7", (String)"scmc-im-cal", (Object[])new Object[0]));
            }
        } else if ("validate".equals(opKey)) {
            this.doValidate();
        }
    }

    private void doValidate() {
        DynamicObjectCollection bills = this.getModel().getEntryEntity("validatebill");
        if (bills.isEmpty()) {
            return;
        }
        String grouptype = (String)this.getModel().getValue("grouptype");
        if (!"A".equals(grouptype)) {
            String msg = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u201c\u8de8\u5355/\u9000\u56de\u201d\u6210\u7ec4\u7c7b\u578b\u8fdb\u884c\u9a8c\u8bc1\u3002", (String)"BizGroupSettingPlugin_5", (String)"scmc-im-cal", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        for (int i = 0; i < bills.size(); ++i) {
            Map<Long, String> checkErrorInfo;
            this.getModel().setValue("billname", this.getModel().getValue("groupbillname", i), i);
            DynamicObject bill = (DynamicObject)bills.get(i);
            String billno = bill.getString("billno");
            String formid = this.getgroupBillFormid(i);
            if (StringUtils.isEmpty((String)billno) || StringUtils.isEmpty((String)formid)) continue;
            String filter = (String)this.getModel().getValue("filterjson_tag", i);
            String cfilter = (String)this.getModel().getValue("cfilterjson_tag", i);
            DynamicObject billinfo = QueryServiceHelper.queryOne((String)formid, (String)"id", (QFilter[])new QFilter("billno", "=", (Object)billno).toArray());
            if (billinfo == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u5355\u636e\u7f16\u53f7\u201c%1$s\u201d\u672a\u67e5\u8be2\u5230\u5355\u636e\uff0c\u8bf7\u5f55\u5165\u6b63\u786e\u7684\u5355\u636e\u7f16\u53f7\u3002", (String)"BizGroupSettingPlugin_4", (String)"scmc-im-cal", (Object[])new Object[0]), billno);
                throw new KDBizException(msg);
            }
            HashSet<Long> ids = new HashSet<Long>(4);
            ids.add(billinfo.getLong("id"));
            FilterInfoChecker checker = new FilterInfoChecker(formid, ids);
            checker.loadSyncBillsByID();
            if (!StringUtils.isEmpty((String)filter)) {
                checker.setFilterStr(filter);
                checkErrorInfo = checker.doCheckErrorInfo();
                if (!checkErrorInfo.isEmpty()) {
                    this.getModel().setValue("filterinfo", (Object)checkErrorInfo.values().iterator().next(), i);
                }
            }
            if (!StringUtils.isEmpty((String)cfilter)) {
                checker.setFilterStr(cfilter);
                checkErrorInfo = checker.doCheckErrorInfo();
                if (!checkErrorInfo.isEmpty()) {
                    this.getModel().setValue("cfilterinfo", (Object)checkErrorInfo.values().iterator().next(), i);
                }
            }
            QFilter billFilter = new QFilter("id", "in", (Object)billinfo.getLong("id"));
            String selectFields = this.getSelectFields(i, formid);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)formid, (String)selectFields, (QFilter[])billFilter.toArray(), null);
            String[] fieldNames = dataSet.getRowMeta().getFieldNames();
            StringBuilder builder = new StringBuilder();
            for (Row row : dataSet) {
                for (String fieldName : fieldNames) {
                    builder.append(fieldName);
                    builder.append(":");
                    builder.append(row.get(fieldName));
                    builder.append(";");
                }
                builder.append("\r\n");
            }
            this.getModel().setValue("relinfo", (Object)builder.toString(), i);
        }
        this.getView().updateView("validatebill");
    }

    private String getSelectFields(int i, String formid) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formid);
        DynamicObjectCollection relationEntry = this.getModel().getEntryEntity(KEY_RELATIONENTRY);
        ArrayList<String> selects = new ArrayList<String>(4);
        for (DynamicObject dynamicObject : relationEntry) {
            String fieldkey = dynamicObject.getString("fieldkey" + i);
            String fullField = this.getFullField(fieldkey, dataEntityType);
            selects.add(fullField);
        }
        return String.join((CharSequence)",", selects);
    }

    private String getFullField(String fieldkey, MainEntityType mainEntityType) {
        IDataEntityProperty bizEntity = mainEntityType.findProperty(fieldkey.split("\\.")[0]);
        IDataEntityType parentyCalEntity = bizEntity.getParent();
        StringBuilder fullField = new StringBuilder();
        if (parentyCalEntity instanceof SubEntryType) {
            fullField.append(parentyCalEntity.getParent().getName());
            fullField.append(".");
            fullField.append(parentyCalEntity.getName());
            fullField.append(".");
            fullField.append(fieldkey);
        } else if (parentyCalEntity instanceof EntryType) {
            fullField.append(parentyCalEntity.getName());
            fullField.append(".");
            fullField.append(fieldkey);
        } else {
            fullField.append(fieldkey);
        }
        fullField.append(" as ");
        fullField.append(fieldkey);
        return fullField.toString();
    }

    private void initRelationEntryHead() {
        String grouptype = (String)this.getModel().getValue("grouptype");
        if (!"A".equals(grouptype)) {
            return;
        }
        DynamicObjectCollection groupbillentry = this.getModel().getEntryEntity(KEY_GROUPBILLENTRY);
        EntryGrid entrygrid = (EntryGrid)this.getView().getControl(KEY_RELATIONENTRY);
        if (groupbillentry.size() < 1) {
            return;
        }
        for (int i = 0; i < groupbillentry.size(); ++i) {
            DynamicObject groupbill = (DynamicObject)groupbillentry.get(i);
            String groupbillname = groupbill.getString("groupbillname");
            entrygrid.setColumnProperty("relation" + i, "header", (Object)groupbillname);
            entrygrid.setColumnProperty("relation" + i, "vi", (Object)63);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (KEY_GROUPBILLENTRY.equals(entryName)) {
            this.initRelationEntryHead();
            this.setRelationEntryValue(e);
            this.setRelEntryVisable();
        }
    }

    private void setRelationEntryValue(AfterDeleteRowEventArgs e) {
        int[] rowIndexs = e.getRowIndexs();
        if (rowIndexs != null && rowIndexs.length > 0) {
            int rowIndex = rowIndexs[0];
            int rCount = this.getModel().getEntryRowCount(KEY_RELATIONENTRY);
            for (int i = rowIndex; i < 4; ++i) {
                for (int j = 0; j < rCount; ++j) {
                    this.getModel().setValue("fieldkey" + i, this.getModel().getValue("fieldkey" + (i + 1), j), j);
                    this.getModel().setValue("fieldname" + i, this.getModel().getValue("fieldname" + (i + 1), j), j);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.equals("groupbillname")) {
            int index = this.getModel().getEntryCurrentRowIndex(KEY_GROUPBILLENTRY);
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("groupbillname", index);
            EntryGrid entrygrid = (EntryGrid)this.getView().getControl(KEY_RELATIONENTRY);
            entrygrid.setColumnProperty("relation" + index, "header", (Object)name.getLocaleValue());
            entrygrid.setColumnProperty("relation" + index, "vi", (Object)63);
            entrygrid.updateColFmt("relation" + index);
            this.setRelEntryVisable();
        } else if (key.startsWith("fieldkey")) {
            int index = this.getModel().getEntryCurrentRowIndex(KEY_RELATIONENTRY);
            String value = (String)this.getModel().getValue(key, index);
            String nameKey = key.replace("key", "name");
            if (StringUtils.isEmpty((String)value)) {
                this.getModel().setValue(nameKey, null, index);
            }
        } else if (key.equals("formid")) {
            int index = this.getModel().getEntryCurrentRowIndex(KEY_GROUPBILLENTRY);
            this.getModel().setValue("filter", null, index);
            this.getModel().setValue("filterjson_tag", null, index);
            this.getModel().setValue("cfilter", null, index);
            this.getModel().setValue("cfilterjson_tag", null, index);
            int size = this.getModel().getEntryRowCount(KEY_RELATIONENTRY);
            if (size == 0) {
                return;
            }
            this.getModel().beginInit();
            for (int i = 0; i < size; ++i) {
                this.getModel().setValue("fieldkey" + index, null, i);
                this.getModel().setValue("fieldname" + index, null, i);
            }
            this.getModel().endInit();
            this.getView().updateView(KEY_RELATIONENTRY);
        } else if (key.equals("filter")) {
            int index = this.getModel().getEntryCurrentRowIndex(KEY_GROUPBILLENTRY);
            String filter = (String)this.getModel().getValue("filter", index);
            if (StringUtils.isEmpty((String)filter)) {
                this.getModel().setValue("filterjson_tag", null, index);
            }
        } else if (key.equals("cfilter")) {
            int index = this.getModel().getEntryCurrentRowIndex(KEY_GROUPBILLENTRY);
            String filter = (String)this.getModel().getValue("cfilter", index);
            if (StringUtils.isEmpty((String)filter)) {
                this.getModel().setValue("cfilterjson_tag", null, index);
            }
        }
    }

    private void setRelEntryVisable() {
        EntryGrid entrygrid = (EntryGrid)this.getView().getControl(KEY_RELATIONENTRY);
        int gCount = this.getModel().getEntryRowCount(KEY_GROUPBILLENTRY);
        int rCount = this.getModel().getEntryRowCount(KEY_RELATIONENTRY);
        for (int i = 0; i < 5; ++i) {
            if (i < gCount) {
                entrygrid.setColumnProperty("relation" + i, "vi", (Object)63);
                continue;
            }
            entrygrid.setColumnProperty("relation" + i, "vi", (Object)0);
            if (rCount == 0) continue;
            for (int j = 0; j < rCount; ++j) {
                this.getModel().setValue("fieldkey" + i, null, j);
                this.getModel().setValue("fieldname" + i, null, j);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if (source instanceof TextEdit) {
            int groupBillIndex = this.getModel().getEntryCurrentRowIndex(KEY_GROUPBILLENTRY);
            if ("filter".equals(fieldKey) || "cfilter".equals(fieldKey)) {
                String entityObjectId = this.getgroupBillFormid(groupBillIndex);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("cal_billfilter");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                String filterstr = (String)this.getModel().getValue(fieldKey + "json_tag", groupBillIndex);
                showParameter.getCustomParams().put("entityNumber", entityObjectId);
                showParameter.getCustomParams().put("billfilterstr", filterstr);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
                this.getView().showForm(showParameter);
            } else if (fieldKey.startsWith("fieldkey")) {
                int index = Integer.parseInt(fieldKey.replaceAll("fieldkey", ""));
                String entityObjectId = this.getgroupBillFormid(index);
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityObjectId);
                BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainEntityType);
                parameter.setIncludePKField(true);
                TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes(parameter);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("cal_bd_selectfield");
                String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
                showParameter.getCustomParams().put("treenodes", nodesJson);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("save".equals(key) && e.getOperationResult().isSuccess()) {
            this.getView().updateView();
        }
    }

    protected String tranFormula(CRFormula formulaObj, String ENTITYNUMBER) {
        MainEntityType mainType = null;
        mainType = MetadataServiceHelper.getDataEntityType((String)ENTITYNUMBER);
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>();
            if (StringUtils.isNotEmpty((String)scripts[1])) {
                descs.add(scripts[1]);
            }
            String tranExpr = String.join((CharSequence)ResManager.loadKDString((String)" \u4e14 ", (String)"BizGroupSettingPlugin_8", (String)"scmc-im-cal", (Object[])new Object[0]), descs);
            return tranExpr;
        }
        return "";
    }

    private String getgroupBillFormid(int groupBillIndex) {
        DynamicObject formentity = (DynamicObject)this.getModel().getValue("formid", groupBillIndex);
        if (formentity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"BizGroupSettingPlugin_1", (String)"scmc-im-cal", (Object[])new Object[0]));
        }
        String entityObjectId = (String)formentity.getPkValue();
        return entityObjectId;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String fieldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("filter".equals(fieldKey) || "cfilter".equals(fieldKey)) {
            Map returnDataMap = (Map)returnData;
            if (returnData == null || StringUtils.isEmpty((String)((String)returnDataMap.get("filter")))) {
                this.getModel().setValue(fieldKey, (Object)"");
                this.getModel().setValue(fieldKey + "json_tag", (Object)"");
            } else {
                String filter = (String)returnDataMap.get("filter");
                int groupBillIndex = this.getModel().getEntryCurrentRowIndex(KEY_GROUPBILLENTRY);
                String entityObjectId = this.getgroupBillFormid(groupBillIndex);
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
                CRCondition condition = new CRCondition();
                condition.setFilterCondition(filterCondition);
                String exprTran = this.tranFormula((CRFormula)condition, entityObjectId);
                exprTran = exprTran.length() > 500 ? exprTran.substring(0, 500) + "..." : exprTran;
                this.getModel().setValue(fieldKey, (Object)exprTran);
                this.getModel().setValue(fieldKey + "json_tag", (Object)filter);
            }
        } else if (fieldKey.startsWith("fieldkey")) {
            if (StringUtils.isEmpty((String)((String)returnData))) {
                return;
            }
            int index = Integer.parseInt(fieldKey.replaceAll("fieldkey", ""));
            String entityObjectId = this.getgroupBillFormid(index);
            String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)EntityMetadataCache.getDataEntityType((String)entityObjectId), (String)returnData);
            int row = this.getModel().getEntryCurrentRowIndex(KEY_RELATIONENTRY);
            this.getModel().setValue(fieldKey, returnData, row);
            this.getModel().setValue("fieldname" + index, (Object)fieldCaption, row);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String sourceID = beforeF7SelectEvent.getProperty().getName();
        if (sourceID.contains("formid")) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            HashSet<String> ids = new HashSet<String>(16);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_calbillrule", (String)"sourcebill", null, null);){
                for (Row row : dataSet) {
                    ids.add(row.getString("sourcebill"));
                }
            }
            ids.remove("im_initbill");
            QFilter entityFilter = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter(entityFilter);
        }
    }
}

