/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.bcmreport;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.mservice.api.bcmreport.Im4BcmRptFormulaService;
import kd.scmc.im.mservice.bcmreport.InvSumBcpRptHandler;
import org.apache.commons.io.IOUtils;

public class Im4BcmRptFormulaServiceImpl
implements Im4BcmRptFormulaService {
    private Log logger = LogFactory.getLog(this.getClass());

    public String dispatchIm(String formulaName, String paramJson) throws ParseException, IOException {
        this.logger.info("Im4BcmRptFormulaServiceImpl:\u8fdb\u5165dispatchIm\u65b9\u6cd5\u3002");
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)paramJson, Map.class);
        Map paramListMap = (Map)paramMap.get("param");
        Map commParam = (Map)paramMap.get("commParam");
        List paramNameList = (List)commParam.get("formulaParamNames");
        HashMap resultMap = new HashMap(16);
        InvSumBcpRptHandler handler = new InvSumBcpRptHandler();
        this.logger.info("Im4BcmRptFormulaServiceImpl:\u5206\u6b65\u8c03\u7528InvSumBcpRptHandler\u5904\u7406\u3002");
        for (Map.Entry entry : paramListMap.entrySet()) {
            String paramId = (String)entry.getKey();
            List params = (List)entry.getValue();
            if (params.size() != paramNameList.size()) continue;
            HashMap<String, Number> singleMap = new HashMap<String, Number>(4);
            BigDecimal result = handler.handle(formulaName, params, paramNameList, commParam);
            singleMap.put("v", result);
            singleMap.put("type", 1);
            resultMap.put(paramId, singleMap);
        }
        this.logger.info("Im4BcmRptFormulaServiceImpl:\u8c03\u7528InvSumBcpRptHandler\u5904\u7406\u7ed3\u675f\u3002");
        return SerializationUtils.toJsonString(resultMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormulaDef() throws ParseException, IOException {
        String formula_catalog;
        String formula_def;
        InputStream formula_def_list = null;
        InputStream formula_catalog_list = null;
        try {
            formula_def_list = Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/imformula/im_formula_list.json");
            assert (formula_def_list != null);
            formula_def = IOUtils.toString((InputStream)formula_def_list);
            formula_catalog_list = Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/imformula/im_formula_catalog_list.json");
            assert (formula_catalog_list != null);
            formula_catalog = IOUtils.toString((InputStream)formula_catalog_list);
            if (formula_def_list != null) {
                this.closeSafeLy(formula_def_list);
            }
            if (formula_catalog_list != null) {
                this.closeSafeLy(formula_catalog_list);
            }
        }
        catch (Throwable throwable) {
            if (formula_def_list != null) {
                this.closeSafeLy(formula_def_list);
            }
            if (formula_catalog_list != null) {
                this.closeSafeLy(formula_catalog_list);
            }
            throw throwable;
        }
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)formula_def) && StringUtils.isNotEmpty((CharSequence)formula_catalog)) {
            configMap.put("formula_catalog_list", formula_catalog);
            configMap.put("formula_def_list", formula_def);
        }
        return SerializationUtils.toJsonString(configMap);
    }

    private void closeSafeLy(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                this.logger.error("Im4BcmRptFormulaServiceImpl close stream error : " + e.getMessage());
            }
        }
    }
}

