/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.botp;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scmc.im.mservice.api.botp.PoToReceiveBotpService;

public class PoToReceiveBotpServiceImpl
implements PoToReceiveBotpService {
    private static final String RECEIVEBASEQTYSUM = "receiveBaseQtySum";
    private static final String INBASEQTYSUM = "inBaseQtySum";

    public boolean checkVerUpdate() {
        return true;
    }

    public Map<String, Map<String, String>> getMainSumBaseQty(Map<String, String> paramMap) {
        HashMap<String, Map<String, String>> mainSumBaseQty = new HashMap<String, Map<String, String>>(2);
        if (paramMap == null || paramMap.isEmpty()) {
            return mainSumBaseQty;
        }
        String coreBillEntryIds = paramMap.get("coreBillEntryIds");
        if (StringUtils.isBlank((CharSequence)coreBillEntryIds)) {
            return mainSumBaseQty;
        }
        List mainBillEntryIdList = (List)SerializationUtils.fromJsonString((String)coreBillEntryIds, List.class);
        if (mainBillEntryIdList.isEmpty()) {
            return mainSumBaseQty;
        }
        TableDefine receiveBillTable = EntityMetadataCache.loadTableDefine((String)"im_purreceivebill", (String)"im_purreceivebill");
        Long receiveTableId = receiveBillTable.getTableId();
        QFilter qtyFilter = new QFilter("isvirtualbill", "=", (Object)"0").and("ischargeoff", "=", (Object)"0").and("ischargeoffed", "=", (Object)"0").and("billentry.baseqty", ">", (Object)BigDecimal.ZERO).and("billentry.mainbillentryid", "in", (Object)mainBillEntryIdList);
        DataSet receiveSumData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_purreceivebill", (String)"billentry.mainbillentryid as mainbillentryid, billentry.baseqty as baseqty", (QFilter[])qtyFilter.toArray(), null).groupBy(new String[]{"mainbillentryid"}).sum("baseqty").finish();
        if (receiveSumData != null) {
            for (Row row : receiveSumData) {
                Long mainBillEntryId = row.getLong("mainbillentryid");
                BigDecimal baseQtySum = row.getBigDecimal("baseqty");
                mainSumBaseQty.putIfAbsent(String.valueOf(mainBillEntryId), new HashMap(1));
                Map sumBaseQty = (Map)mainSumBaseQty.get(String.valueOf(mainBillEntryId));
                sumBaseQty.put(RECEIVEBASEQTYSUM, baseQtySum.toPlainString());
            }
        }
        QFilter billFilter = new QFilter("billentry.mainbillentryid", "in", (Object)mainBillEntryIdList);
        List inBillIdList = QueryServiceHelper.queryPrimaryKeys((String)this.getClass().getName(), (String)"im_purinbill", (QFilter[])billFilter.toArray(), null, (int)-1);
        List distinctBillIds = inBillIdList.stream().distinct().collect(Collectors.toList());
        Long[] inBillIds = (Long[])inBillIdList.stream().map(Long.class::cast).toArray(Long[]::new);
        Map linkUpNodes = BFTrackerServiceHelper.loadBillLinkUpNodes((String)"im_purinbill", (Long[])inBillIds, (boolean)false);
        block1: for (Map.Entry linkUpNodeEntry : linkUpNodes.entrySet()) {
            Long inBillId = (Long)linkUpNodeEntry.getKey();
            List allSourceNodes = ((BFRowLinkUpNode)linkUpNodeEntry.getValue()).findAllSourceNodes();
            for (BFRowLinkUpNode allSourceNode : allSourceNodes) {
                BFRowId rowId = allSourceNode.getRowId();
                Long mainTableId = rowId.getMainTableId();
                if (!receiveTableId.equals(mainTableId)) continue;
                distinctBillIds.remove(inBillId);
                continue block1;
            }
        }
        if (distinctBillIds.isEmpty()) {
            return mainSumBaseQty;
        }
        qtyFilter.and("id", "in", distinctBillIds);
        DataSet inSumData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_purinbill", (String)"billentry.mainbillentryid as mainbillentryid, billentry.baseqty as baseqty", (QFilter[])qtyFilter.toArray(), null).groupBy(new String[]{"mainbillentryid"}).sum("baseqty").finish();
        if (inSumData != null) {
            for (Row row : inSumData) {
                String mainBillEntryId = row.getString("mainbillentryid");
                BigDecimal baseQtySum = row.getBigDecimal("baseqty");
                mainSumBaseQty.putIfAbsent(mainBillEntryId, new HashMap(1));
                Map sumBaseQty = (Map)mainSumBaseQty.get(mainBillEntryId);
                sumBaseQty.put(INBASEQTYSUM, baseQtySum.toPlainString());
            }
        }
        return mainSumBaseQty;
    }

    public Map<String, Map<String, String>> getStockSumBaseQty(Map<String, String> paramMap) {
        Map sumBaseQty;
        BigDecimal baseQtySum;
        String srcSysBillEntryId;
        HashMap<String, Map<String, String>> stockSumBaseQty = new HashMap<String, Map<String, String>>(2);
        String salOutStockEntryIds = paramMap.get("salOutStockEntryIds");
        if (StringUtils.isBlank((CharSequence)salOutStockEntryIds)) {
            return stockSumBaseQty;
        }
        List stockEntryIdList = (List)SerializationUtils.fromJsonString((String)salOutStockEntryIds, List.class);
        if (stockEntryIdList == null || stockEntryIdList.isEmpty()) {
            return stockSumBaseQty;
        }
        QFilter qtyFilter = new QFilter("isvirtualbill", "=", (Object)"0").and("ischargeoff", "=", (Object)"0").and("ischargeoffed", "=", (Object)"0").and("billentry.baseqty", ">", (Object)BigDecimal.ZERO).and("billentry.srcsysbillentryid", "in", (Object)stockEntryIdList);
        DataSet receiveSumData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_purreceivebill", (String)"billentry.srcsysbillentryid as srcsysbillentryid, billentry.baseqty as baseqty", (QFilter[])qtyFilter.toArray(), null).groupBy(new String[]{"srcsysbillentryid"}).sum("baseqty").finish();
        DataSet inSumData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_purinbill", (String)"billentry.srcsysbillentryid as srcsysbillentryid, billentry.baseqty as baseqty", (QFilter[])qtyFilter.toArray(), null).groupBy(new String[]{"srcsysbillentryid"}).sum("baseqty").finish();
        if (receiveSumData != null) {
            for (Row row : receiveSumData) {
                srcSysBillEntryId = row.getString("srcsysbillentryid");
                baseQtySum = row.getBigDecimal("baseqty");
                stockSumBaseQty.putIfAbsent(srcSysBillEntryId, new HashMap(1));
                sumBaseQty = (Map)stockSumBaseQty.get(srcSysBillEntryId);
                sumBaseQty.put(RECEIVEBASEQTYSUM, baseQtySum.toPlainString());
            }
        }
        if (inSumData != null) {
            for (Row row : inSumData) {
                srcSysBillEntryId = row.getString("srcsysbillentryid");
                baseQtySum = row.getBigDecimal("baseqty");
                stockSumBaseQty.putIfAbsent(srcSysBillEntryId, new HashMap(1));
                sumBaseQty = (Map)stockSumBaseQty.get(srcSysBillEntryId);
                sumBaseQty.put(INBASEQTYSUM, baseQtySum.toPlainString());
            }
        }
        return stockSumBaseQty;
    }
}

