/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.event.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.business.helper.logisticsbill.LogisticsBillHelper;
import kd.scmc.im.mservice.event.service.InvInvokeCalService;

public class InvInvokeWriteOffService {
    private static final Log logger = LogFactory.getLog(InvInvokeCalService.class);
    private Map<Object, Object> apAutoVerifyParameterCache = new HashMap<Object, Object>(8);
    private String formId;
    private String operate;
    private List<Object> pkIds;

    public InvInvokeWriteOffService(String formId, String operate, List<Object> pkIds) {
        this.formId = formId;
        this.operate = operate;
        this.pkIds = pkIds;
    }

    public void invoke() {
        boolean isPurInOrSaleOutBill = "im_purinbill".equals(this.formId) || "im_saloutbill".equals(this.formId) && !this.notAutoSalRBVerify();
        boolean isAuditOp = "audit".equalsIgnoreCase(this.operate);
        if (!isPurInOrSaleOutBill || !isAuditOp) {
            return;
        }
        if (SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0005")) {
            this.autoVerify();
        } else {
            logger.info("\u5e93\u5b58\u4e0e\u5e94\u6536\u5e94\u4ed8\u7cfb\u7edf\u8054\u7528\u53c2\u6570\u672a\u542f\u7528,\u4e0d\u8c03\u7528\u5e94\u6536\u5e94\u4ed8\u7684\u670d\u52a1\uff1a" + this.formId + "|" + this.operate + "|" + this.pkIds);
        }
    }

    private boolean notAutoSalRBVerify() {
        DynamicObject result = QueryServiceHelper.queryOne((String)"im_invdbparam", (String)"value", (QFilter[])new QFilter("key", "=", (Object)"salautoverify").toArray());
        if (result != null) {
            return "0".equals(result.getString("value"));
        }
        return false;
    }

    private void autoVerify() {
        List<Long> curBillPksParam = this.getCurBillPksParamList();
        if (curBillPksParam.isEmpty()) {
            return;
        }
        this.billIsWfPlan(curBillPksParam);
        Long[] billIds = curBillPksParam.toArray(new Long[0]);
        Map findDirtSourceBills = BFTrackerServiceHelper.findDirtSourceBills((String)this.formId, (Long[])billIds);
        ConvertDataService reader = new ConvertDataService();
        HashSet<Long> sourcePurBillPks = new HashSet<Long>(billIds.length);
        for (List bfRow : findDirtSourceBills.values()) {
            for (BFRow row : bfRow) {
                BFRowId sId = row.getSId();
                String entityNumber = reader.loadTableDefine(sId.getTableId()).getEntityNumber();
                if (!this.formId.equals(entityNumber)) continue;
                sourcePurBillPks.add(sId.getBillId());
            }
        }
        if (sourcePurBillPks == null || sourcePurBillPks.isEmpty()) {
            return;
        }
        boolean isAllEntryEmpty = this.isAllEntryEmpty(sourcePurBillPks);
        if (isAllEntryEmpty) {
            return;
        }
        if ("im_purinbill".equals(this.formId)) {
            logger.info("\u91c7\u8d2d\u5165\u5e93\u5355\u5ba1\u6838\u8c03\u7528AP\uff0cAutoVerify\u63a5\u53e3\u5f00\u59cb");
            this.filterBlueBill(sourcePurBillPks);
            if (!sourcePurBillPks.isEmpty()) {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"purself", (String)"autoVerifyById", (Object[])new Object[]{new ArrayList<Long>(sourcePurBillPks), curBillPksParam});
            }
            logger.info("\u91c7\u8d2d\u5165\u5e93\u5355\u5ba1\u6838\u8c03\u7528AP\uff0cAutoVerify\u63a5\u53e3\u7ed3\u675f");
        } else if ("im_saloutbill".equals(this.formId)) {
            logger.info("InvInvokeCalService:\u9500\u552e\u51fa\u5e93\u5355\u5ba1\u6838\u8c03\u7528\u5e94\u6536\u6838\u9500\u63a5\u53e3\u5f00\u59cb");
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"salself", (String)"autoVerifyById", (Object[])new Object[]{new ArrayList<Long>(sourcePurBillPks), curBillPksParam});
            logger.info("InvInvokeCalService:\u9500\u552e\u51fa\u5e93\u5355\u5ba1\u6838\u8c03\u7528\u5e94\u6536\u6838\u9500\u63a5\u53e3\u7ed3\u675f");
        }
    }

    private void billIsWfPlan(List<Long> curBillPksParam) {
        String sql = "select fid,forgid from t_im_invdbparam where fkey = 'iswriteoffplan' and fvalue = '1'";
        DBRoute route = new DBRoute("scm");
        DataSet queryDataSet = DB.queryDataSet((String)"InvInvokeWriteOffService", (DBRoute)route, (String)sql);
        HashSet<Long> orgSet = new HashSet<Long>(16);
        while (queryDataSet.hasNext()) {
            Row param = queryDataSet.next();
            orgSet.add(param.getLong("forgid"));
        }
        if (orgSet.isEmpty()) {
            return;
        }
        if (orgSet.contains(0L)) {
            curBillPksParam.clear();
        }
        if ("im_purinbill".equals(this.formId) || "im_saloutbill".equals(this.formId)) {
            DynamicObject[] bills;
            QFilter qFilter = new QFilter("id", "in", curBillPksParam);
            for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)this.formId, (String)"id,org", (QFilter[])qFilter.toArray())) {
                Long id;
                DynamicObject org = bill.getDynamicObject("org");
                if (org == null || !orgSet.contains(id = Long.valueOf(org.getLong("id")))) continue;
                curBillPksParam.remove((Long)bill.getPkValue());
            }
        }
    }

    private void filterBlueBill(Set<Long> sourcePurBillPks) {
        if (!SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0004")) {
            return;
        }
        DataSet bills = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_purinbill", (String)"id, supplier.issuppcolla as issuppcolla, billentry.id as entryid", (QFilter[])new QFilter("id", "in", sourcePurBillPks).toArray(), (String)"");
        HashMap<Long, List> billIdMap = new HashMap<Long, List>(sourcePurBillPks.size());
        HashSet<Long> unSuppcollaBill = new HashSet<Long>(sourcePurBillPks.size());
        while (bills.hasNext()) {
            Row bill = bills.next();
            Long billId = bill.getLong("id");
            if (unSuppcollaBill.contains(billId)) continue;
            Boolean isSuppColla = bill.getBoolean("issuppcolla");
            if (!isSuppColla.booleanValue()) {
                unSuppcollaBill.add(billId);
            }
            Long entryId = bill.getLong("entryid");
            List entryIds = billIdMap.computeIfAbsent(billId, k -> new ArrayList(8));
            entryIds.add(entryId);
        }
        HashMap<String, Object> validatorInfo = new HashMap<String, Object>(8);
        validatorInfo.put("entityName", "im_purinbill");
        validatorInfo.put("entryKey", "billentry");
        validatorInfo.put("billIds", billIdMap);
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"ICancelVerifyService", (String)"CanCancelVerify", (Object[])new Object[]{validatorInfo});
        Boolean success = (Boolean)resultMap.get("succed");
        Map reconciliation = (Map)resultMap.get("data");
        if (!success.booleanValue() && !reconciliation.isEmpty()) {
            logger.info("\u672c\u6b21\u84dd\u5b57\u5165\u5e93\u5355\u51c6\u5907\u6838\u9500\u5355\u636e\uff1a" + sourcePurBillPks);
            logger.info("\u4ee5\u4e0b\u84dd\u5b57\u5165\u5e93\u5355\u5df2\u5bf9\u8d26\uff0c\u4e0d\u81ea\u52a8\u6838\u9500\uff1a" + reconciliation.keySet());
            sourcePurBillPks.removeAll(reconciliation.keySet());
        }
    }

    private String getVerifyFields() {
        ArrayList<String> verifyFields = new ArrayList<String>(16);
        verifyFields.add("ischargeoff");
        verifyFields.add("org");
        verifyFields.add("invscheme");
        verifyFields.add("id");
        verifyFields.add("billno");
        verifyFields.add("billentry.id");
        verifyFields.add("billentry.logisticsbill");
        verifyFields.add("billentry.unverifyqty");
        return String.join((CharSequence)",", verifyFields);
    }

    private boolean isAllEntryEmpty(Set<Long> sourcePurBillPks) {
        QFilter qf = new QFilter("id", "in", sourcePurBillPks);
        DynamicObject[] sourceBillObject = BusinessDataServiceHelper.load((String)this.formId, (String)"id,billentry.unverifyqty", (QFilter[])qf.toArray());
        boolean isAllEntryEmpty = true;
        for (DynamicObject bill : sourceBillObject) {
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entryList) {
                BigDecimal unVerifyQty = entry.getBigDecimal("unverifyqty");
                if (unVerifyQty.compareTo(BigDecimal.ZERO) == 0) continue;
                isAllEntryEmpty = false;
            }
        }
        return isAllEntryEmpty;
    }

    private List<Long> getCurBillPksParamList() {
        QFilter qFilter = new QFilter("id", "in", this.pkIds);
        DynamicObject[] curBills = BusinessDataServiceHelper.load((String)this.formId, (String)this.getVerifyFields(), (QFilter[])qFilter.toArray());
        ArrayList<Long> curBillPksParam = new ArrayList<Long>(curBills.length);
        for (int i = 0; i < curBills.length; ++i) {
            DynamicObject curBill = curBills[i];
            boolean isAutoVerifyOrRedBill = this.getAutoVerifyOrRedBill(curBill);
            boolean isChargeOff = curBill.getBoolean("ischargeoff");
            boolean isLogisticsBill = LogisticsBillHelper.isLogisticsBill((DynamicObject)curBill);
            if (!isAutoVerifyOrRedBill || isChargeOff || isLogisticsBill) continue;
            curBillPksParam.add(curBill.getLong("id"));
        }
        return curBillPksParam;
    }

    private boolean getAutoVerifyOrRedBill(DynamicObject curBill) {
        if ("im_purinbill".equals(this.formId)) {
            return this.isOpenAutoVerify(curBill);
        }
        return this.isRedBill(curBill);
    }

    private boolean isOpenAutoVerify(DynamicObject dynamicObject) {
        boolean isOpenAutoVerify = true;
        DynamicObject org = (DynamicObject)dynamicObject.get("org");
        Object orgid = org.getPkValue();
        String billNo = dynamicObject.getString("billno");
        AppParam appParam = new AppParam();
        appParam.setAppId("=9Q86DR2P+Q");
        appParam.setOrgId(Long.valueOf(orgid.toString()));
        Object writeOff = this.apAutoVerifyParameterCache.get(orgid);
        if (writeOff == null) {
            writeOff = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"puriniswithbluedocauto");
            this.apAutoVerifyParameterCache.put(orgid, writeOff);
        }
        if ("1".equals(writeOff)) {
            isOpenAutoVerify = false;
            logger.info("\u91c7\u8d2d\u5165\u5e93\u5355\u5ba1\u6838\u64cd\u4f5c:\u3010" + org.get("number") + "\u3011\u7ec4\u7ec7\u672a\u5f00\u542f\u548c\u84dd\u5355\u81ea\u52a8\u6838\u9500\uff0c" + billNo + "\u4e0d\u8c03\u7528\u53cd\u6838\u9500\u63a5\u53e3");
        }
        return isOpenAutoVerify;
    }

    private boolean isRedBill(DynamicObject bill) {
        DynamicObject invScheme = bill.getDynamicObject("invscheme");
        String bizDirection = invScheme.getString("bizdirection");
        return "1".equals(bizDirection);
    }
}

