/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.invquery;

import java.sql.ResultSet;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class InvQueryConfigUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(InvQueryConfigUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute route = new DBRoute("scm");
        String querySql = "select fvalue from t_im_invdbparam where fkey = 'newInvqryCfg'";
        String value = (String)DB.query((DBRoute)route, (String)querySql, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return resultSet.getString("fvalue");
                }
                return null;
            }
        });
        if (value != null && "0".equals(value)) {
            try (TXHandle handle = TX.requiresNew();){
                this.doUpdate(route);
            }
            String log = "Inventory query configuration upgrade successful.";
            result.setLog(log);
            result.setSuccess(true);
        }
        return result;
    }

    private void doUpdate(DBRoute route) {
        String querySql = "select top 1 fid from t_im_inv_realbalance";
        try (DataSet queryData = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)route, (String)querySql);){
            if (!queryData.hasNext()) {
                String updateSql = "update t_im_invqueryconf set fenable = '1' where fusetype = 'A' and fispreset = '1'";
                DB.execute((DBRoute)route, (String)updateSql);
                String updateConfigSql = "update t_im_invdbparam set fvalue = '1' where fkey = 'newInvqryCfg'";
                DB.execute((DBRoute)route, (String)updateConfigSql);
            }
        }
    }
}

