/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.kit;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.KitManagementHelper;
import kd.scmc.im.mservice.api.kit.InvKitService;

public class InvKitServiceImpl
implements InvKitService {
    private static final String BIZDIRECTION_FORWARD = "0";
    private static final String BIZDIRECTION_INVERSE = "1";

    public Map<Long, Map<String, Object>> getMaxBaseQty(List<Map<String, Object>> parameters) {
        ArrayList mainBillParams = new ArrayList(16);
        ArrayList<Long> salOutBillIds = new ArrayList<Long>(16);
        ArrayList<Long> salOutBillEntryIds = new ArrayList<Long>(16);
        HashMap<Long, Long> billEntryIdMap = new HashMap<Long, Long>(16);
        for (Map<String, Object> parameter : parameters) {
            Object salOutBillId = parameter.get("salOutBillId");
            Object salOutBillEntryId = parameter.get("salOutBillEntryId");
            if (salOutBillId == null || salOutBillEntryId == null) continue;
            salOutBillIds.add((Long)salOutBillId);
            salOutBillEntryIds.add((Long)salOutBillEntryId);
        }
        ArrayList<Long> bluePids = new ArrayList<Long>(16);
        ArrayList<Long> redPids = new ArrayList<Long>(16);
        if (!salOutBillIds.isEmpty() && !salOutBillEntryIds.isEmpty()) {
            String selectProperties = "invscheme.bizdirection, ischargeoff, billentry.id, billentry.mainbillentity, billentry.mainbillid, billentry.mainbillentryid";
            QFilter filter = new QFilter("id", "in", salOutBillIds).and("billentry.id", "in", salOutBillEntryIds);
            DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_saloutbill", (String)selectProperties, (QFilter[])filter.toArray(), null);
            for (Row row : mainDataSet) {
                boolean blueBill;
                HashMap<String, Object> mainParam = new HashMap<String, Object>(3);
                String mainBillEntity = row.getString("billentry.mainbillentity");
                Long mainBillId = row.getLong("billentry.mainbillid");
                Long mainBillEntryId = row.getLong("billentry.mainbillentryid");
                Long salOutEntryId = row.getLong("billentry.id");
                mainParam.put("billEntity", mainBillEntity);
                mainParam.put("billId", mainBillId);
                mainParam.put("billEntryId", mainBillEntryId);
                mainBillParams.add(mainParam);
                if (mainBillEntryId != null && salOutEntryId != null) {
                    billEntryIdMap.put(salOutEntryId, mainBillEntryId);
                }
                String bizDirection = row.getString("invscheme.bizdirection");
                Boolean isChargeOff = row.getBoolean("ischargeoff");
                boolean redBill = BIZDIRECTION_INVERSE.equalsIgnoreCase(bizDirection) && Boolean.FALSE.equals(isChargeOff) || BIZDIRECTION_FORWARD.equals(bizDirection) && Boolean.TRUE.equals(isChargeOff);
                boolean bl = blueBill = BIZDIRECTION_FORWARD.equalsIgnoreCase(bizDirection) && Boolean.FALSE.equals(isChargeOff) || BIZDIRECTION_INVERSE.equals(bizDirection) && Boolean.TRUE.equals(isChargeOff);
                if (redBill) {
                    redPids.add(mainBillEntryId);
                    continue;
                }
                if (!blueBill) continue;
                bluePids.add(mainBillEntryId);
            }
        }
        if (mainBillParams.isEmpty()) {
            return new HashMap<Long, Map<String, Object>>(1);
        }
        String expandKitStructures = (String)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"SalService", (String)"expandKitStructure", (Object[])new Object[]{mainBillParams});
        Map kitResult = (Map)JSON.parseObject((String)expandKitStructures, Map.class);
        if (kitResult == null || kitResult.isEmpty()) {
            return new HashMap<Long, Map<String, Object>>(1);
        }
        Map calMaxBaseQtyMap = KitManagementHelper.calMaxBaseQty((Map)kitResult, bluePids, redPids);
        HashMap<Long, Map<String, Object>> maxBaseQtyMap = new HashMap<Long, Map<String, Object>>(16);
        for (Map.Entry billEntryIdMapEntry : billEntryIdMap.entrySet()) {
            Long salOutBillEntryId = (Long)billEntryIdMapEntry.getKey();
            Long mainBillEntryId = (Long)billEntryIdMapEntry.getValue();
            Map calEntryMaxBaseQtyMap = (Map)calMaxBaseQtyMap.get(mainBillEntryId);
            if (salOutBillEntryId == null || calEntryMaxBaseQtyMap == null) continue;
            HashMap<String, Long> entryMaxBaseQtyMap = new HashMap<String, Long>(calEntryMaxBaseQtyMap);
            entryMaxBaseQtyMap.put("mainBillEntryId", mainBillEntryId);
            maxBaseQtyMap.put(salOutBillEntryId, entryMaxBaseQtyMap);
        }
        return maxBaseQtyMap;
    }
}

