/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.mobile.adjust;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.im.business.helper.AdjustBizTypeHelper;
import kd.scmc.im.consts.AdjustBillConst;
import kd.scmc.im.enums.PrecisionAccountEnum;
import kd.scmc.im.mservice.api.mobile.adjust.AdjustPropChange4MobileService;
import kd.scmc.im.mservice.mobile.adjust.BaseTransformBillPropChangeService;
import kd.scmc.im.utils.BigDecimalUtils;

public class AdjustBillPropChangeServiceImpl
extends BaseTransformBillPropChangeService
implements AdjustPropChange4MobileService {
    public DynamicObject propChange4Mobile(DynamicObject pcEntity, String changeHeadFieldKeys, Map<Long, String> changeEntryInfo, Map<Long, Map<Long, String>> changeSubEntryInfo) {
        super.propertyChanged(pcEntity, changeHeadFieldKeys, changeEntryInfo, changeSubEntryInfo);
        if ("biztype".equals(changeHeadFieldKeys)) {
            DynamicObjectCollection entryEntity = pcEntity.getDynamicObjectCollection("billentry");
            entryEntity.clear();
            return pcEntity;
        }
        DynamicObject bizType = pcEntity.getDynamicObject("biztype");
        Object bizTypeId = bizType == null ? Long.valueOf(0L) : bizType.getPkValue();
        DynamicObjectCollection billEntry = pcEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : billEntry) {
            Long entryId = entry.getLong("id");
            String propName = changeEntryInfo.get(entryId);
            DynamicObjectCollection afterEntities = entry.getDynamicObjectCollection("afterentity");
            if (propName != null) {
                switch (propName) {
                    case "material": {
                        this.changeMaterial(entry);
                        break;
                    }
                }
                List<String> needSyncFields = this.getNeedSyncFields(bizTypeId);
                if (needSyncFields.contains(propName)) {
                    this.copyFieldToAfterEntry(propName, entry);
                    if ("unit".equals(propName) || "qty".equals(propName)) {
                        for (DynamicObject afterEntry : afterEntities) {
                            this.dealQtyFieldToAfterEntry(propName, afterEntry);
                        }
                    }
                } else if (propName.equals("qty") && AdjustBillConst.BIZTYPE_UNITADJUST.equals(bizTypeId)) {
                    this.copyFieldToAfterEntry("baseqty", entry);
                }
                if (("qty".equals(propName) || "baseqty".equals(propName)) && AdjustBillConst.BIZTYPE_UNITADJUST.equals(bizTypeId)) {
                    for (DynamicObject afterEntity : afterEntities) {
                        this.calQtyByAfterBaseQty(afterEntity);
                    }
                }
            }
            if (changeSubEntryInfo.get(entryId) == null) continue;
            Map<Long, String> subEntryInfo = changeSubEntryInfo.get(entryId);
            for (DynamicObject afterEntity : afterEntities) {
                Long subEntryId = afterEntity.getLong("id");
                String afterPropName = subEntryInfo.get(subEntryId);
                if (!"qty1".equals(afterPropName) && !"baseqty1".equals(propName) || !AdjustBillConst.BIZTYPE_UNITADJUST.equals(bizTypeId)) continue;
                this.calQtyByAfterBaseQty(afterEntity);
            }
            this.subEntryChanged(afterEntities, subEntryInfo);
        }
        return pcEntity;
    }

    private void subEntryChanged(DynamicObjectCollection afterEntries, Map<Long, String> subEntryInfo) {
        if (afterEntries == null || afterEntries.size() == 0) {
            return;
        }
        for (DynamicObject afterEntry : afterEntries) {
            Long entryId = afterEntry.getLong("id");
            String afterPropName = subEntryInfo.get(entryId);
            if (StringUtils.isEmpty((CharSequence)afterPropName)) continue;
            switch (afterPropName) {
                case "warehouse1": {
                    this.changeWarehouse("location1", afterEntry);
                    break;
                }
            }
        }
    }

    private void dealQtyFieldToAfterEntry(String propName, DynamicObject afterEntry) {
        propName = propName + "1";
        Object newValue = afterEntry.get(propName);
        this.setAfterBizQtyAndUnit(afterEntry, propName, newValue);
        this.setAfterAuxBizQtyAndUnit(afterEntry, propName);
    }

    private void calQtyByAfterBaseQty(DynamicObject afterEntity) {
        DynamicObject baseUnit = afterEntity.getDynamicObject("baseunit1");
        DynamicObject unit = afterEntity.getDynamicObject("unit1");
        DynamicObject materialInv = afterEntity.getDynamicObject("material1");
        if (materialInv == null) {
            return;
        }
        DynamicObject material = materialInv.getDynamicObject("masterid");
        BigDecimal baseQty = afterEntity.getBigDecimal("baseqty1");
        BigDecimal unitRate = null;
        if (material != null && baseUnit != null && unit != null) {
            unitRate = this.getUnitRateConv((Long)material.getPkValue(), (Long)unit.getPkValue(), (Long)baseUnit.getPkValue());
        }
        BigDecimal qty = BigDecimal.ZERO;
        if (unitRate != null && baseQty != null && baseQty.compareTo(BigDecimal.ZERO) != 0 && unitRate.compareTo(BigDecimal.ZERO) != 0) {
            qty = baseQty.divide(unitRate, unit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)unit.getInt("precisionaccount")));
        }
        BigDecimalUtils.showBigDecimalErrorTip((DynamicObject)afterEntity, (BigDecimal)qty, (String)"qty1");
        afterEntity.set("qty1", (Object)qty);
    }

    private List<String> getNeedSyncFields(Object bizTypeId) {
        return AdjustBizTypeHelper.getNeedSyncFields((Object)bizTypeId);
    }

    private void copyFieldToAfterEntry(String propName, DynamicObject entry) {
        DynamicObjectCollection entries = entry.getDynamicObjectCollection("afterentity");
        String subkey = propName + "1";
        DynamicObject material = entry.getDynamicObject("material");
        boolean isOnShelf = false;
        Date produceDate = null;
        Date expireDate = null;
        if (material != null) {
            boolean bl = isOnShelf = material.getBoolean("enableshelflifemgr") && "producedate".equals(propName) || "expirydate".equals(propName);
            if (isOnShelf) {
                produceDate = entry.getDate("producedate");
                expireDate = entry.getDate("expirydate");
            }
        }
        Object value = entry.get(propName);
        for (DynamicObject entryDy : entries) {
            if ("warehouse".equals(propName) || "location".equals(propName)) {
                if (entryDy.get("warehouse1") != null) continue;
                entryDy.set(subkey, value);
                continue;
            }
            if (isOnShelf) {
                entryDy.set("producedate1", (Object)produceDate);
                entryDy.set("expirydate1", (Object)expireDate);
                continue;
            }
            entryDy.set(subkey, value);
        }
    }

    private void changeMaterial(DynamicObject entry) {
        DynamicObjectCollection afterEntity = entry.getDynamicObjectCollection("afterentity");
        afterEntity.clear();
    }
}

