/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.mobile.adjust;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.CloseDateHelper;
import kd.scmc.im.business.helper.PrecisionAccountHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.helper.DaysCalcHelper;
import kd.scmc.im.utils.BigDecimalUtils;
import kd.scmc.im.utils.DateUtils;

public class BaseTransformBillPropChangeService {
    private static final Log logger = LogFactory.getLog(BaseTransformBillPropChangeService.class);
    protected IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);

    protected void propertyChanged(DynamicObject pcEntity, String changeHeadFieldKey, Map<Long, String> changeEntryInfo, Map<Long, Map<Long, String>> changeSubEntryInfo) {
        if ("biztime".equals(changeHeadFieldKey)) {
            this.changeBizData(pcEntity, pcEntity.get("biztime"));
        }
        DynamicObjectCollection billEntry = pcEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : billEntry) {
            Long entryId = entry.getLong("id");
            String propName = changeEntryInfo.get(entryId);
            if (propName != null) {
                switch (propName) {
                    case "material": {
                        this.changeMaterial(propName, entry, false);
                        this.update2Version(entry, "material", "mversion");
                        break;
                    }
                    case "warehouse": {
                        this.changeWarehouse("location", entry);
                        break;
                    }
                    case "qty": 
                    case "unit": {
                        this.changeQtyOrUnit(propName, entry);
                    }
                }
            }
            if (changeSubEntryInfo.get(entryId) == null) continue;
            Map<Long, String> subEntryInfo = changeSubEntryInfo.get(entryId);
            DynamicObjectCollection afterEntries = entry.getDynamicObjectCollection("afterentity");
            this.subEntryPropertyChanged(afterEntries, subEntryInfo);
        }
    }

    protected void subEntryPropertyChanged(DynamicObjectCollection afterEntries, Map<Long, String> subEntryInfo) {
        if (afterEntries == null || afterEntries.size() == 0) {
            return;
        }
        for (DynamicObject afterEntry : afterEntries) {
            Long entryId = afterEntry.getLong("id");
            String afterPropName = subEntryInfo.get(entryId);
            if (afterPropName == null) continue;
            switch (afterPropName) {
                case "material1": {
                    this.changeMaterial(afterPropName, afterEntry, true);
                    this.update2Version(afterEntry, "material1", "mversion1");
                    break;
                }
                case "unit1": 
                case "qty1": {
                    this.changeAfterQtyOrUnit(afterPropName, afterEntry);
                    break;
                }
            }
        }
    }

    protected void changeAfterQtyOrUnit(String key, DynamicObject afterEntry) {
        DynamicObject material;
        Object masterMaterial = material = afterEntry.getDynamicObject("material1");
        masterMaterial = afterEntry.get("materialmasterid1");
        if (material == null || masterMaterial == null || "0".equals(masterMaterial)) {
            return;
        }
        this.setAfterBizQtyAndUnit(afterEntry, key, afterEntry.get(key));
        this.setAfterAuxBizQtyAndUnit(afterEntry, key);
    }

    protected void changeQtyOrUnit(String key, DynamicObject entry) {
        DynamicObject material;
        Object materialMasterId = material = entry.getDynamicObject("material");
        materialMasterId = entry.get("materialmasterid");
        if (material == null || materialMasterId == null || "0".equals(materialMasterId)) {
            return;
        }
        DynamicObject masterId = material.getDynamicObject("masterid");
        if (masterId == null) {
            return;
        }
        switch (key) {
            case "qty": {
                this.changeQty(entry, masterId);
                this.changeUntAndQty(entry, masterId);
                break;
            }
            case "unit": {
                this.changeUnit(entry, masterId);
                this.changeUntAndQty(entry, masterId);
                break;
            }
        }
    }

    private void changeUntAndQty(DynamicObject entry, DynamicObject material) {
        boolean isConvert;
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null) {
            return;
        }
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        String unitConvertDir = material.getString("unitconvertdir");
        boolean bl = isConvert = "A".equals(unitConvertDir) || "C".equals(unitConvertDir);
        if (!isConvert) {
            return;
        }
        if (BigDecimal.ZERO.compareTo(baseQty) == 0) {
            entry.set("qtyunit2nd", (Object)BigDecimal.ZERO);
            return;
        }
        BigDecimal qtyUnit2nd = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxptyUnit);
        BigDecimalUtils.showBigDecimalErrorTip((DynamicObject)entry, (BigDecimal)qtyUnit2nd, (String)"qtyunit2nd");
        entry.set("qtyunit2nd", (Object)qtyUnit2nd);
    }

    private void changeUnit(DynamicObject entry, DynamicObject materialMasterId) {
        DynamicObject unit = entry.getDynamicObject("unit");
        if (unit == null) {
            return;
        }
        BigDecimal qty = entry.getBigDecimal("qty");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        qty = PrecisionAccountHelper.dealWithprecision((DynamicObject)unit, (BigDecimal)qty);
        entry.set("qty", (Object)qty);
        BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)materialMasterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
        BigDecimalUtils.showBigDecimalErrorTip((DynamicObject)entry, (BigDecimal)baseQty, (String)"baseqty");
        entry.set("baseqty", (Object)baseQty);
    }

    private void changeQty(DynamicObject entry, DynamicObject materialMasterId) {
        DynamicObject unit = entry.getDynamicObject("unit");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)materialMasterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
        BigDecimalUtils.showBigDecimalErrorTip((DynamicObject)entry, (BigDecimal)baseQty, (String)"qtyunit2nd");
        entry.set("baseqty", (Object)baseQty);
    }

    protected void update2Version(DynamicObject entry, String material, String version) {
        DynamicObject materialInvInfo = entry.getDynamicObject(material);
        if (materialInvInfo == null) {
            entry.set(version, null);
            return;
        }
        try {
            String versionId = (String)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataService", (String)"getVersionByMaterial", (Object[])new Object[]{materialInvInfo.getLong("masterid_id")});
            if (StringUtils.isNotBlank((CharSequence)versionId) && !"0".equals(versionId)) {
                entry.set(version, (Object)Long.valueOf(versionId));
            } else {
                entry.set(version, null);
            }
        }
        catch (Exception e) {
            throw new KDBizException("call IMasterDataService.getVersionByMaterial() error : " + e);
        }
    }

    protected void changeWarehouse(String key, DynamicObject entry) {
        entry.set(key, null);
    }

    protected void changeMaterial(String key, DynamicObject entry, boolean isAfterEntry) {
        if (entry == null || key == null) {
            return;
        }
        DynamicObject material = entry.getDynamicObject(key);
        if (material != null) {
            DynamicObject masterId = material.getDynamicObject("masterid");
            this.clearMaterialInfo(entry, isAfterEntry);
            if (masterId != null) {
                entry.set(isAfterEntry ? "materialmasterid1" : "materialmasterid", (Object)masterId);
                this.resetMaterialInfo(entry, material, masterId, isAfterEntry);
            }
        }
    }

    private void resetMaterialInfo(DynamicObject entry, DynamicObject materialInv, DynamicObject masterMaterial, boolean isAfterEntry) {
        boolean isUseUnit2nd;
        if (masterMaterial == null) {
            return;
        }
        DynamicObject baseUnit = masterMaterial.getDynamicObject("baseunit");
        if (baseUnit == null) {
            return;
        }
        entry.set(isAfterEntry ? "baseunit1" : "baseunit", (Object)baseUnit);
        DynamicObject auxptyUnit = masterMaterial.getDynamicObject("auxptyunit");
        boolean bl = isUseUnit2nd = auxptyUnit != null;
        if (isUseUnit2nd) {
            entry.set(isAfterEntry ? "unit2nd1" : "unit2nd", (Object)auxptyUnit);
        }
        DynamicObject unit = materialInv.getDynamicObject("inventoryunit");
        entry.set(isAfterEntry ? "unit1" : "unit", (Object)unit);
        entry.set(isAfterEntry ? "lotnumber1" : "lotnumber", null);
    }

    private void clearMaterialInfo(DynamicObject entry, boolean isAfterEntry) {
        entry.set(isAfterEntry ? "auxpty1" : "auxpty", null);
        entry.set(isAfterEntry ? "unit1" : "unit", null);
        entry.set(isAfterEntry ? "qty1" : "qty", null);
        entry.set(isAfterEntry ? "baseunit1" : "baseunit", null);
        entry.set(isAfterEntry ? "baseqty1" : "baseqty", null);
        entry.set(isAfterEntry ? "unit2nd1" : "unit2nd", null);
        entry.set(isAfterEntry ? "qtyunit2nd1" : "qtyunit2nd", null);
        entry.set(isAfterEntry ? "producedate1" : "producedate", null);
        entry.set(isAfterEntry ? "expirydate1" : "expirydate", null);
        entry.set(isAfterEntry ? "configuredcode1" : "configuredcode", null);
    }

    protected void setAfterBizQtyAndUnit(DynamicObject afterEntry, String propName, Object newValue) {
        BigDecimal baseQty = afterEntry.getBigDecimal("baseqty1");
        DynamicObject unit = afterEntry.getDynamicObject("unit1");
        DynamicObject materialInv = afterEntry.getDynamicObject("material1");
        DynamicObject masterMaterial = materialInv.getDynamicObject("masterid");
        BigDecimal qty = afterEntry.getBigDecimal("qty1");
        DynamicObject baseUnit = afterEntry.getDynamicObject("baseunit1");
        BigDecimal unitRate = null;
        if (masterMaterial != null && baseUnit != null && unit != null) {
            unitRate = this.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)unit.getPkValue(), (Long)baseUnit.getPkValue());
        }
        if (unitRate != null) {
            unitRate = unitRate.setScale(10, 4);
        }
        switch (propName) {
            case "qty1": {
                qty = (BigDecimal)newValue;
                if (unitRate != null) {
                    baseQty = qty.multiply(unitRate);
                    baseQty = PrecisionAccountHelper.dealWithprecision((DynamicObject)baseUnit, (BigDecimal)baseQty);
                }
                BigDecimalUtils.showBigDecimalErrorTip((DynamicObject)afterEntry, (BigDecimal)baseQty, (String)"baseqty1");
                afterEntry.set("baseqty1", (Object)baseQty);
                break;
            }
            case "unit1": {
                unit = (DynamicObject)newValue;
                if (unit != null) {
                    int precision = unit.getInt("precision");
                    String precisionaccountStr = unit.getString("precisionaccount");
                    int precisionaccount = 4;
                    if (!StringUtils.isEmpty((CharSequence)precisionaccountStr)) {
                        precisionaccount = Integer.parseInt(precisionaccountStr);
                    }
                    qty = qty.setScale(precision, precisionaccount);
                    BigDecimalUtils.showBigDecimalErrorTip((DynamicObject)afterEntry, (BigDecimal)qty, (String)"qty1");
                    afterEntry.set("qty1", (Object)qty);
                }
                if (masterMaterial != null && unit != null && baseUnit != null) {
                    unitRate = this.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)unit.getPkValue(), (Long)baseUnit.getPkValue());
                }
                if (unitRate != null) {
                    baseQty = qty.multiply(unitRate);
                }
                BigDecimalUtils.showBigDecimalErrorTip((DynamicObject)afterEntry, (BigDecimal)baseQty, (String)"baseqty1");
                afterEntry.set("baseqty1", (Object)baseQty);
                break;
            }
        }
    }

    protected void setAfterAuxBizQtyAndUnit(DynamicObject afterEntry, String propName) {
        boolean isUseUnit2nd;
        DynamicObject materialInvInfo = afterEntry.getDynamicObject("material1");
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        DynamicObject unit2nd = material.getDynamicObject("auxptyunit");
        boolean bl = isUseUnit2nd = unit2nd != null;
        if (!isUseUnit2nd) {
            return;
        }
        BigDecimal baseQty = afterEntry.getBigDecimal("baseqty1");
        BigDecimal qty = afterEntry.getBigDecimal("qty1");
        DynamicObject unit = afterEntry.getDynamicObject("unit1");
        DynamicObject baseUnit = afterEntry.getDynamicObject("baseunit1");
        if (unit == null) {
            return;
        }
        String unitConvertDir = material.getString("unitconvertdir");
        BigDecimal qtyUnit2nd = afterEntry.getBigDecimal("qtyunit2nd1");
        BigDecimal unit2ndRate = this.getRate(material);
        if (unit2ndRate == null || Constants.ZERO.compareTo(unit2ndRate) == 0) {
            return;
        }
        unit2ndRate = unit2ndRate.setScale(10);
        boolean isConvert = false;
        switch (propName) {
            case "qty1": 
            case "unit1": {
                boolean bl2 = isConvert = "A".equals(unitConvertDir) || "C".equals(unitConvertDir);
                if (!isConvert || unit2ndRate.compareTo(BigDecimal.ZERO) == 0) break;
                qtyUnit2nd = BigDecimal.valueOf(baseQty.doubleValue() / unit2ndRate.doubleValue());
                qtyUnit2nd = PrecisionAccountHelper.dealWithprecision((DynamicObject)unit2nd, (BigDecimal)qtyUnit2nd);
                BigDecimalUtils.showBigDecimalErrorTip((DynamicObject)afterEntry, (BigDecimal)qtyUnit2nd, (String)"qtyunit2nd1");
                afterEntry.set("qtyunit2nd1", (Object)qtyUnit2nd);
                break;
            }
            case "qtyunit2nd1": {
                BigDecimal unitRate = this.getUnitRateConv((Long)material.getPkValue(), (Long)unit.getPkValue(), baseUnit == null ? null : (Long)baseUnit.getPkValue());
                if (unitRate == null) break;
                unitRate = unitRate.setScale(10);
                boolean bl3 = isConvert = "B".equals(unitConvertDir) || "C".equals(unitConvertDir);
                if (!isConvert) break;
                baseQty = qtyUnit2nd.multiply(unit2ndRate);
                baseQty = PrecisionAccountHelper.dealWithprecision((DynamicObject)baseUnit, (BigDecimal)baseQty);
                qty = baseQty.divide(unitRate, 10, RoundingMode.HALF_UP);
                qty = PrecisionAccountHelper.dealWithprecision((DynamicObject)unit, (BigDecimal)qty);
                BigDecimalUtils.showBigDecimalErrorTip((DynamicObject)afterEntry, (BigDecimal)baseQty, (String)"baseqty1");
                BigDecimalUtils.showBigDecimalErrorTip((DynamicObject)afterEntry, (BigDecimal)qty, (String)"qty1");
                afterEntry.set("baseqty1", (Object)baseQty);
                afterEntry.set("qty1", (Object)qty);
                break;
            }
        }
    }

    protected BigDecimal getRate(DynamicObject material) {
        if (material == null) {
            return null;
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        DynamicObject baseUnit = material.getDynamicObject("baseunit");
        if (auxptyUnit == null || baseUnit == null) {
            return null;
        }
        if (material.getPkValue() == null || auxptyUnit.getPkValue() == null || baseUnit.getPkValue() == null) {
            return Constants.ZERO;
        }
        BigDecimal unitRate = this.getUnitRateConv((Long)material.getPkValue(), (Long)auxptyUnit.getPkValue(), (Long)baseUnit.getPkValue());
        return unitRate == null ? BigDecimal.ZERO : unitRate;
    }

    protected BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = Constants.ZERO;
        } else if (srcUnitId.equals(desUnitId)) {
            unitRate = Constants.ONE;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
            if (muConv != null && muConv.getInt("numerator") != 0) {
                unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
            }
        }
        if (unitRate == null) {
            unitRate = Constants.ZERO;
        }
        return unitRate;
    }

    protected void changeBizData(DynamicObject bill, Object newValue) {
        Date bizDate = (Date)newValue;
        if (bizDate == null) {
            return;
        }
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            return;
        }
        Date now = new Date();
        TimeZone orgZone = this.getOrgZone(org);
        if (orgZone == null) {
            return;
        }
        int fallowDays = 0;
        int differDays = 0;
        if (now.before(bizDate)) {
            Object beforeDays = AppParameterHelper.getAppParameter((String)"=9Q86DR2P+Q", (String)"05", (Long)((Long)org.getPkValue()), (String)"fallowbeforedays");
            differDays = DaysCalcHelper.differentDays((Date)bizDate, (Date)now, (ZoneId)orgZone.toZoneId());
            differDays = Math.abs(differDays);
            fallowDays = Integer.parseInt(beforeDays == null ? "0" : beforeDays.toString());
        } else if (now.after(bizDate)) {
            Object afterDays = AppParameterHelper.getAppParameter((String)"=9Q86DR2P+Q", (String)"05", (Long)((Long)org.getPkValue()), (String)"fallowafterdays");
            differDays = DaysCalcHelper.differentDays((Date)bizDate, (Date)now, (ZoneId)orgZone.toZoneId());
            differDays = Math.abs(differDays);
            fallowDays = Integer.parseInt(afterDays == null ? "0" : afterDays.toString());
        }
        if (differDays > fallowDays) {
            return;
        }
        this.changeBookDate(bill, bizDate);
    }

    private void changeBookDate(DynamicObject bill, Date bizDate) {
        Date closeDate;
        Date addDate;
        Map closeDateMap;
        String formId = bill.getDataEntityType().getName();
        Date bookDate = bizDate;
        if (!SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0004") && null != (closeDateMap = CloseDateHelper.getCloseDateMap((String)formId, (DynamicObject)bill)) && bizDate.before(addDate = DateUtils.addOneDay((Date)(closeDate = (Date)closeDateMap.get("closeDate"))))) {
            bookDate = addDate;
        }
        bill.set("bookdate", (Object)bookDate);
    }

    protected TimeZone getOrgZone(DynamicObject org) {
        TimeZone timeZone = null;
        DynamicObject timezone = org.getDynamicObject("timezone");
        if (timezone == null) {
            timeZone = this.getSysTimezone();
        } else {
            String timeArea = timezone.getString("number");
            timeZone = TimeZone.getTimeZone(timeArea);
        }
        return timeZone;
    }

    protected TimeZone getSysTimezone() {
        DynamicObject sysTimezoneMeta = this.service.getSysTimezone();
        String timeArea = sysTimezoneMeta.getString("number");
        return TimeZone.getTimeZone(timeArea);
    }
}

