/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AdjustBillBizTypeUpgradeServiceImpl
implements IUpgradeService {
    private static String[] billFromId = new String[]{"im_adjustbill"};
    private static Set<Object> billTypeToFromIdSet = new HashSet<Object>(16);
    private static Set<String> bizNumSet = new HashSet<String>(64);
    private static Map<String, String> defaultBillNumBizNumMapping = new HashMap<String, String>(32);
    private static String IM_INVDBPARAM_KEY = "AdjustBillTypeParam";
    private static Log logger;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute sysRoute = new DBRoute("sys");
        if (this.checkUpgrade()) {
            result.setSuccess(true);
            result.setLog("no need to update");
            return result;
        }
        logger.info("\u5f00\u59cb\u67e5\u8be2\u9700\u8981\u5347\u7ea7\u5230\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u4e2d\u7684\u65b0\u589e\u4e1a\u52a1\u7c7b\u578b\u3002");
        Map bizTypeEntityMap = BusinessDataServiceHelper.loadFromCache((String)"bd_biztype", (QFilter[])new QFilter("number", "in", bizNumSet).toArray());
        logger.info("\u67e5\u8be2\u9700\u8981\u5347\u7ea7\u5230\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u4e2d\u7684\u65b0\u589e\u4e1a\u52a1\u7c7b\u578b\u7ed3\u675f\u3002");
        HashMap<String, Set<DynamicObject>> billTypeNumToBizType = new HashMap<String, Set<DynamicObject>>(64);
        logger.info("\u5f00\u59cb\u83b7\u53d6\u3010\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u7f16\u7801 -- \u9700\u8981\u5173\u8054\u7684\u4e1a\u52a1\u7c7b\u578b\u5b9e\u4f53\u5217\u8868\u3011\u6620\u5c04");
        for (Map.Entry entry : bizTypeEntityMap.entrySet()) {
            DynamicObject bizEntity = (DynamicObject)entry.getValue();
            this.getBillTypeBizMapping(billTypeNumToBizType, bizEntity);
        }
        logger.info("\u83b7\u53d6\u3010\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u7f16\u7801 -- \u9700\u8981\u5173\u8054\u7684\u4e1a\u52a1\u7c7b\u578b\u5b9e\u4f53\u5217\u8868\u3011\u6620\u5c04\u7ed3\u675f");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fformid,a.fbilltypeid,a.fdata,b.fnumber ", new Object[0]).append("from t_bas_billtypeparameter a left join T_BAS_BILLTYPE b on a.fbilltypeid = b.fid where ", new Object[0]).appendIn("a.fformid", (Object[])billFromId);
        logger.info("\u5f00\u59cb\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u3002");
        DataSet billTypeDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (SqlBuilder)sqlBuilder);
        logger.info("\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u7ed3\u675f\u3002");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(32);
        logger.info("\u5f00\u59cb\u5904\u7406\u6279\u91cf\u66f4\u65b0\u7684\u53c2\u6570\u3002");
        while (billTypeDataSet.hasNext()) {
            Row next = billTypeDataSet.next();
            Object billTypeId = next.get("fbilltypeid");
            String fdata = next.getString("fdata");
            Map bizTypeMap = (Map)JSON.parse((String)fdata);
            Object number = next.get("fnumber");
            if (!billTypeToFromIdSet.contains(number)) continue;
            List entryList = (List)bizTypeMap.get("entryentity");
            ArrayList preEntryList = new ArrayList(16);
            HashSet bizNums = new HashSet(16);
            for (Map entryEntity : entryList) {
                Boolean isPreset = (Boolean)entryEntity.get("ispreset");
                Map biztypenumberMap = (Map)entryEntity.get("biztypenumber");
                if (!isPreset.booleanValue()) continue;
                Object bizNum = biztypenumberMap.get("number");
                bizNums.add(bizNum);
                preEntryList.add(entryEntity);
            }
            entryList.removeAll(preEntryList);
            int preEntrySize = preEntryList.size();
            Map<Object, List<Map<Object, Object>>> newBizTypeEntryList = this.getNewBizTypeEntryList(billTypeNumToBizType, preEntrySize);
            List<Map<Object, Object>> newBizTypelist = newBizTypeEntryList.get(number);
            ArrayList<Map> newPreBizTypelist = new ArrayList<Map>(16);
            for (Map map : newBizTypelist) {
                Map newBizNumberMap = (Map)map.get("biztypenumber");
                Object bizNum = newBizNumberMap.get("number");
                if (bizNums.isEmpty() || bizNums.contains(bizNum)) continue;
                newPreBizTypelist.add(map);
            }
            preEntryList.addAll(newPreBizTypelist);
            preEntrySize = preEntryList.size();
            for (Map map : entryList) {
                map.put("seq", preEntrySize + 1);
                ++preEntrySize;
            }
            preEntryList.addAll(entryList);
            bizTypeMap.put("entryentity", preEntryList);
            JSONObject jsonObject = new JSONObject(bizTypeMap);
            paramList.add(new Object[]{jsonObject.toString(), billTypeId});
        }
        logger.info("\u5904\u7406\u6279\u91cf\u66f4\u65b0\u7684\u53c2\u6570\u7ed3\u675f\u3002");
        try (TXHandle handle = TX.requiresNew();){
            logger.info("\u5f00\u59cb\u6267\u884c\u66f4\u65b0\uff0c\u6267\u884cSQL\u8bed\u53e5\u4e3a\uff1a\u3010update t_bas_billtypeparameter set fdata = ? where fbilltypeid = ?\u3011\uff1b\u66f4\u65b0\u53c2\u6570\u662f\uff1a\u3010" + ((Object)paramList).toString() + "\u3011\u3002");
            DB.executeBatch((DBRoute)sysRoute, (String)"update t_bas_billtypeparameter set fdata = ? where fbilltypeid = ?", paramList);
            logger.info("\u6267\u884c\u66f4\u65b0\u6210\u529f\u3002");
        }
        DB.execute((DBRoute)new DBRoute("scm"), (String)"update t_im_invdbparam set fvalue = '1' where fkey = ?", (Object[])new Object[]{IM_INVDBPARAM_KEY});
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private boolean checkUpgrade() {
        String switchSql = "select fvalue as value from t_im_invdbparam where fkey = ?";
        boolean flag = false;
        try (DataSet switchSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)switchSql, (Object[])new Object[]{IM_INVDBPARAM_KEY});){
            for (Row row : switchSet) {
                String value = row.getString("value");
                if (!"1".equals(value)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private Map<Object, List<Map<Object, Object>>> getNewBizTypeEntryList(Map<String, Set<DynamicObject>> billTypeNumToBizType, int preEntrySize) {
        HashMap<Object, List<Map<Object, Object>>> billTypeNumToJsonMapping = new HashMap<Object, List<Map<Object, Object>>>(128);
        for (Map.Entry<String, Set<DynamicObject>> entry : billTypeNumToBizType.entrySet()) {
            Set<DynamicObject> objectList = entry.getValue();
            Object[] sortStrings = new String[objectList.size()];
            ArrayList<String> list = new ArrayList<String>(objectList.size());
            HashMap<String, DynamicObject> sortMap = new HashMap<String, DynamicObject>(objectList.size());
            for (DynamicObject dynamicObject : objectList) {
                String number = dynamicObject.getString("number");
                list.add(number);
                sortMap.put(number, dynamicObject);
            }
            for (int i = 0; i < list.size(); ++i) {
                sortStrings[i] = (String)list.get(i);
            }
            Arrays.sort(sortStrings);
            ArrayList sortedList = new ArrayList(list.size());
            for (Object num : sortStrings) {
                sortedList.add(sortMap.get(num));
            }
            ArrayList arrayList = new ArrayList(256);
            int seq = preEntrySize + 1;
            for (DynamicObject bizTypeEntity : sortedList) {
                HashMap<String, Object> bizTypeSingleLineMap = new HashMap<String, Object>(16);
                Object status = bizTypeEntity.get("status");
                Object enable = bizTypeEntity.get("enable");
                Object ispreset = bizTypeEntity.get("ispreset");
                if (!"1".equals(enable) && !"C".equals(status)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                Object number = bizTypeEntity.get("number");
                Object masterid = bizTypeEntity.get("masterid");
                Object bizName = bizTypeEntity.get("name");
                Object id = bizTypeEntity.get("id");
                map.put("number", number);
                map.put("masterid", masterid);
                map.put("_Type_", "bd_biztype");
                DynamicObjectCollection multiLanguageText = bizTypeEntity.getDynamicObjectCollection("multilanguagetext");
                if (multiLanguageText.size() > 0) {
                    ArrayList textList = new ArrayList(256);
                    for (DynamicObject text : multiLanguageText) {
                        Object pkid = text.get("pkid");
                        Object localeid = text.get("localeid");
                        Object name = text.get("name");
                        Object description = text.get("description");
                        HashMap<String, Object> tmp = new HashMap<String, Object>(8);
                        tmp.put("_Type_", "locale");
                        tmp.put("pkid", pkid);
                        tmp.put("name", name);
                        tmp.put("description", description);
                        tmp.put("localeid", localeid);
                        textList.add(tmp);
                    }
                    map.put("multilanguagetext", textList);
                    map.put("ispreset", ispreset);
                    map.put("name", bizName);
                    map.put("id", id);
                }
                bizTypeSingleLineMap.put("_Type_", "entryentity");
                bizTypeSingleLineMap.put("biztypenumber", map);
                bizTypeSingleLineMap.put("biztypenumber_id", bizTypeEntity.getPkValue());
                bizTypeSingleLineMap.put("id", 0);
                if (number.equals(defaultBillNumBizNumMapping.get(entry.getKey()))) {
                    bizTypeSingleLineMap.put("isdefault", true);
                } else {
                    bizTypeSingleLineMap.put("isdefault", false);
                }
                bizTypeSingleLineMap.put("ispreset", true);
                bizTypeSingleLineMap.put("seq", seq);
                arrayList.add(bizTypeSingleLineMap);
                ++seq;
            }
            billTypeNumToJsonMapping.put(entry.getKey(), arrayList);
        }
        return billTypeNumToJsonMapping;
    }

    private void getBillTypeBizMapping(Map<String, Set<DynamicObject>> billTypeNumToBizType, DynamicObject bizEntity) {
        String number = bizEntity.getString("number");
        if ("520".equals(number)) {
            Set adjustMap = billTypeNumToBizType.computeIfAbsent("im_Adjustbill_STD_BT_S", key -> new HashSet());
            adjustMap.add(bizEntity);
        }
    }

    static {
        billTypeToFromIdSet.addAll(Collections.singleton("im_Adjustbill_STD_BT_S"));
        bizNumSet.addAll(Collections.singleton("520"));
        logger = LogFactory.getLog(AdjustBillBizTypeUpgradeServiceImpl.class);
    }
}

