/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BillType4MdcUpgradeServiceImpl
implements IUpgradeService {
    private static String[] billFromId = new String[]{"im_mdc_mftproorder", "im_mdc_mftreturnorder", "im_mdc_mftfeedorder", "im_mdc_mftmanuinbill", "im_mdc_mftreturnbill"};
    private static Set<Object> billTypeToFromIdSet = new HashSet<Object>(16);
    private static Set<String> bizNumSet = new HashSet<String>(64);
    private static Map<String, String> defaultBillNumBizNumMapping = new HashMap<String, String>(32);
    private Map<Object, String> billTypeNumToJsonMapping = new HashMap<Object, String>(128);
    private static Log logger;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute sysRoute = new DBRoute("sys");
        SqlBuilder sqlBuilder1 = new SqlBuilder();
        sqlBuilder1.append("select a.fformid,a.fbilltypeid,a.fdata,b.fnumber ", new Object[0]).append("from t_bas_billtypeparameter a left join T_BAS_BILLTYPE b on a.fbilltypeid = b.fid where ", new Object[0]).appendIn("b.fnumber", billTypeToFromIdSet.toArray());
        logger.info("BillType4MdcUpgradeServiceImpl:\u5f00\u59cb\u67e5\u8be2\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u548c\u53c2\u6570\u3002");
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (SqlBuilder)sqlBuilder1);
        logger.info("BillType4MdcUpgradeServiceImpl:\u67e5\u8be2\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u548c\u53c2\u6570\u7ed3\u675f\u3002");
        this.resolveDefaultBizType(dataSet);
        bizNumSet.addAll(defaultBillNumBizNumMapping.values());
        logger.info("\u5f00\u59cb\u67e5\u8be2\u9700\u8981\u5347\u7ea7\u5230\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u4e2d\u7684\u6240\u6709\u4e1a\u52a1\u7c7b\u578b\u3002");
        Map bizTypeEntityMap = BusinessDataServiceHelper.loadFromCache((String)"bd_biztype", (QFilter[])new QFilter("number", "in", bizNumSet).toArray());
        logger.info("\u67e5\u8be2\u9700\u8981\u5347\u7ea7\u5230\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u4e2d\u7684\u6240\u6709\u4e1a\u52a1\u7c7b\u578b\u7ed3\u675f\u3002");
        HashMap<String, Set<DynamicObject>> billTypeNumToBizType = new HashMap<String, Set<DynamicObject>>(64);
        logger.info("\u5f00\u59cb\u83b7\u53d6\u3010\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u7f16\u7801 -- \u9700\u8981\u5173\u8054\u7684\u4e1a\u52a1\u7c7b\u578b\u5b9e\u4f53\u5217\u8868\u3011\u6620\u5c04");
        bizTypeEntityMap.forEach((k, v) -> this.getBillTypeBizMapping((Map<String, Set<DynamicObject>>)billTypeNumToBizType, (DynamicObject)v));
        logger.info("\u83b7\u53d6\u3010\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u7f16\u7801 -- \u9700\u8981\u5173\u8054\u7684\u4e1a\u52a1\u7c7b\u578b\u5b9e\u4f53\u5217\u8868\u3011\u6620\u5c04\u7ed3\u675f");
        this.convertBillTypeEntityToJson(billTypeNumToBizType);
        SqlBuilder sqlBuilder2 = new SqlBuilder();
        sqlBuilder2.append("select a.fformid,a.fbilltypeid,a.fdata,b.fnumber ", new Object[0]).append("from t_bas_billtypeparameter a left join T_BAS_BILLTYPE b on a.fbilltypeid = b.fid where ", new Object[0]).appendIn("a.fformid", (Object[])billFromId);
        logger.info("BillType4MdcUpgradeServiceImpl:\u5f00\u59cb\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u3002");
        DataSet billTypeDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (SqlBuilder)sqlBuilder2);
        logger.info("BillType4MdcUpgradeServiceImpl:\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u7ed3\u675f\u3002");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(32);
        logger.info("BillType4MdcUpgradeServiceImpl:\u5f00\u59cb\u5904\u7406\u6279\u91cf\u66f4\u65b0\u7684\u53c2\u6570\u3002");
        while (billTypeDataSet.hasNext()) {
            Row next = billTypeDataSet.next();
            Object billTypeId = next.get("fbilltypeid");
            Object number = next.get("fnumber");
            if (billTypeToFromIdSet.contains(number)) {
                paramList.add(new Object[]{this.billTypeNumToJsonMapping.get(number), billTypeId});
                continue;
            }
            String data = next.getString("fdata");
            String json = this.convertOldJson(data);
            if (json == null) continue;
            paramList.add(new Object[]{json, billTypeId});
        }
        logger.info("BillType4MdcUpgradeServiceImpl:\u5904\u7406\u6279\u91cf\u66f4\u65b0\u7684\u53c2\u6570\u7ed3\u675f\u3002");
        try (TXHandle handle = TX.requiresNew();){
            logger.info("BillType4MdcUpgradeServiceImpl:\u5f00\u59cb\u6267\u884c\u66f4\u65b0\uff0c\u6267\u884cSQL\u8bed\u53e5\u4e3a\uff1a\u3010update t_bas_billtypeparameter set fdata = ? where fbilltypeid = ?\u3011\uff1b\u66f4\u65b0\u53c2\u6570\u662f\uff1a\u3010" + ((Object)paramList).toString() + "\u3011\u3002");
            DB.executeBatch((DBRoute)sysRoute, (String)"update t_bas_billtypeparameter set fdata = ? where fbilltypeid = ?", paramList);
            logger.info("BillType4MdcUpgradeServiceImpl:\u6267\u884c\u66f4\u65b0\u6210\u529f\u3002");
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private boolean checkUpgrade() {
        String switchSql = "select fvalue as value from t_im_invdbparam where fkey = ?";
        boolean flag = false;
        try (DataSet switchSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)switchSql, (Object[])new Object[]{"BillTypeParam"});){
            for (Row row : switchSet) {
                String value = row.getString("value");
                if (!"1".equals(value)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private String convertOldJson(String data) {
        Map oldBizType = (Map)JSONObject.parseObject((String)data, Map.class);
        if (oldBizType.get("biztype") == null) {
            return null;
        }
        Map entity = (Map)oldBizType.get("biztype");
        Long id = (Long)entity.get("masterid");
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        ArrayList entries = new ArrayList(10);
        HashMap<String, Object> bizNumMap = new HashMap<String, Object>(16);
        bizNumMap.put("_Type_", "entryentity");
        bizNumMap.put("biztypenumber", entity);
        bizNumMap.put("biztypenumber_id", id);
        bizNumMap.put("id", 0);
        bizNumMap.put("isdefault", true);
        bizNumMap.put("ispreset", false);
        entries.add(bizNumMap);
        resultMap.put("_Type_", "bd_billtypeparameter");
        resultMap.put("entryentity", entries);
        JSONObject jsonObject = new JSONObject(resultMap);
        return jsonObject.toJSONString();
    }

    private void resolveDefaultBizType(DataSet dataSet) {
        logger.info("BillType4MdcUpgradeServiceImpl:\u5f00\u59cb\u5904\u7406\u539f\u5148\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u5173\u8054\u7684\u9ed8\u8ba4\u4e1a\u52a1\u7c7b\u578b\u3002");
        while (dataSet.hasNext()) {
            JSONObject biztype;
            Row row = dataSet.next();
            String billTypeNumber = row.getString("fnumber");
            String data = row.getString("fdata");
            JSONObject jsonObject = JSONObject.parseObject((String)data);
            if (jsonObject == null || (biztype = jsonObject.getJSONObject("biztype")) == null) continue;
            String bizNum = biztype.getString("number");
            defaultBillNumBizNumMapping.put(billTypeNumber, bizNum);
        }
        logger.info("BillType4MdcUpgradeServiceImpl:\u5904\u7406\u539f\u5148\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u5173\u8054\u7684\u9ed8\u8ba4\u4e1a\u52a1\u7c7b\u578b\u7ed3\u675f\u3002");
    }

    private void convertBillTypeEntityToJson(Map<String, Set<DynamicObject>> billTypeNumToBizType) {
        logger.info("BillType4MdcUpgradeServiceImpl:\u5f00\u59cb\u5c06\u6bcf\u4e2a\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u5e94\u8be5\u5347\u7ea7\u7684\u4e1a\u52a1\u7c7b\u578b\u8f6c\u6210json\u6570\u636e\u3002");
        billTypeNumToBizType.forEach((k, v) -> {
            HashMap<String, Object> billTypeParamMap = new HashMap<String, Object>(16);
            ArrayList entryList = new ArrayList(256);
            int seq = 1;
            for (DynamicObject bizTypeEntity : v) {
                HashMap<String, Object> bizTypeSingleLineMap = new HashMap<String, Object>(16);
                Object status = bizTypeEntity.get("status");
                Object enable = bizTypeEntity.get("enable");
                Object ispreset = bizTypeEntity.get("ispreset");
                if (!"1".equals(enable) && !"C".equals(status)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                Object number = bizTypeEntity.get("number");
                Object masterid = bizTypeEntity.get("masterid");
                Object bizName = bizTypeEntity.get("name");
                Object id = bizTypeEntity.get("id");
                map.put("number", number);
                map.put("masterid", masterid);
                map.put("_Type_", "bd_biztype");
                DynamicObjectCollection multiLanguageText = bizTypeEntity.getDynamicObjectCollection("multilanguagetext");
                if (multiLanguageText.size() > 0) {
                    ArrayList textList = new ArrayList(256);
                    for (DynamicObject text : multiLanguageText) {
                        Object pkid = text.get("pkid");
                        Object localeid = text.get("localeid");
                        Object name = text.get("name");
                        Object description = text.get("description");
                        HashMap<String, Object> tmp = new HashMap<String, Object>(16);
                        tmp.put("_Type_", "locale");
                        tmp.put("pkid", pkid);
                        tmp.put("name", name);
                        tmp.put("description", description);
                        tmp.put("localeid", localeid);
                        textList.add(tmp);
                    }
                    map.put("multilanguagetext", textList);
                    map.put("ispreset", ispreset);
                    map.put("name", bizName);
                    map.put("id", id);
                }
                bizTypeSingleLineMap.put("_Type_", "entryentity");
                bizTypeSingleLineMap.put("biztypenumber", map);
                bizTypeSingleLineMap.put("biztypenumber_id", bizTypeEntity.getPkValue());
                bizTypeSingleLineMap.put("id", 0);
                if (number.equals(defaultBillNumBizNumMapping.get(k))) {
                    bizTypeSingleLineMap.put("isdefault", true);
                } else {
                    bizTypeSingleLineMap.put("isdefault", false);
                }
                bizTypeSingleLineMap.put("ispreset", true);
                bizTypeSingleLineMap.put("seq", seq);
                entryList.add(bizTypeSingleLineMap);
                ++seq;
            }
            billTypeParamMap.put("_Type_", "bd_billtypeparameter");
            billTypeParamMap.put("entryentity", entryList);
            JSONObject jsonObject = new JSONObject(billTypeParamMap);
            this.billTypeNumToJsonMapping.put(k, jsonObject.toJSONString());
        });
        logger.info("BillType4MdcUpgradeServiceImpl:\u5c06\u6bcf\u4e2a\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u5e94\u8be5\u5347\u7ea7\u7684\u4e1a\u52a1\u7c7b\u578b\u8f6c\u6210json\u6570\u636e\u7ed3\u675f\u3002");
    }

    private void getBillTypeBizMapping(Map<String, Set<DynamicObject>> billTypeNumToBizType, DynamicObject bizEntity) {
        Set productMap;
        String number = bizEntity.getString("number");
        if ("320".equals(number)) {
            Set materialReqMap = billTypeNumToBizType.computeIfAbsent("im_mdc_mftproorder_BT_S", key -> new HashSet());
            materialReqMap.add(bizEntity);
            Set materialReqOutMap = billTypeNumToBizType.computeIfAbsent("im_mdc_mftfeedorder_BT_R", key -> new HashSet());
            materialReqOutMap.add(bizEntity);
        }
        if ("3201".equals(number)) {
            Set materialReqOutMap = billTypeNumToBizType.computeIfAbsent("im_mdc_mftreturnorder_BT_S_R", key -> new HashSet());
            materialReqOutMap.add(bizEntity);
        }
        if ("330".equals(number)) {
            productMap = billTypeNumToBizType.computeIfAbsent("im_mdc_mftmanuinbill_BT_S", key -> new HashSet());
            productMap.add(bizEntity);
        }
        if ("3301".equals(number)) {
            productMap = billTypeNumToBizType.computeIfAbsent("im_mdc_mftreturnbill_BT_S", key -> new HashSet());
            productMap.add(bizEntity);
        }
        for (Map.Entry<String, String> entry : defaultBillNumBizNumMapping.entrySet()) {
            String num = entry.getValue();
            if (!num.equals(number)) continue;
            Set set = billTypeNumToBizType.computeIfAbsent(entry.getKey(), key -> new HashSet());
            set.add(bizEntity);
            break;
        }
    }

    static {
        billTypeToFromIdSet.addAll(Arrays.asList("im_mdc_mftproorder_BT_S", "im_mdc_mftfeedorder_BT_R", "im_mdc_mftreturnorder_BT_S_R", "im_mdc_mftreturnbill_BT_S", "im_mdc_mftmanuinbill_BT_S"));
        bizNumSet.addAll(Arrays.asList("330", "3301", "320", "322", "3201"));
        defaultBillNumBizNumMapping.put("im_mdc_mftproorder_BT_S", "320");
        defaultBillNumBizNumMapping.put("im_mdc_mftfeedorder_BT_R", "320");
        defaultBillNumBizNumMapping.put("im_mdc_mftreturnorder_BT_S_R", "3201");
        defaultBillNumBizNumMapping.put("im_mdc_mftmanuinbill_BT_S", "330");
        defaultBillNumBizNumMapping.put("im_mdc_mftreturnbill_BT_S", "3301");
        logger = LogFactory.getLog(BillType4MdcUpgradeServiceImpl.class);
    }
}

