/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterWriter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class InvDefaultBizTypeUpgradeServiceImpl
implements IUpgradeService {
    private static Map<Long, Long> upDefaultBizTypes = new HashMap<Long, Long>(5);
    private static Log logger;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ParameterWriter.removeBatchParameterCache(null, (String)"bos");
        UpgradeResult result = new UpgradeResult();
        DBRoute sysRoute = new DBRoute("sys");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fformid,fbilltypeid,fdata from t_bas_billtypeparameter  where ", new Object[0]).appendIn("fbilltypeid", new ArrayList<Long>(upDefaultBizTypes.keySet()));
        logger.info("\u5f00\u59cb\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u53c2\u6570\u3002");
        DataSet billTypeDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (SqlBuilder)sqlBuilder);
        logger.info("\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u53c2\u6570\u7ed3\u675f\u3002");
        while (billTypeDataSet.hasNext()) {
            Row next = billTypeDataSet.next();
            String formId = next.getString("fformid");
            Long billTypeId = next.getLong("fbilltypeid");
            String fdata = next.getString("fdata");
            Map bizTypeMap = (Map)JSON.parse((String)fdata);
            List entryList = (List)bizTypeMap.get("entryentity");
            Boolean hasDefault = false;
            for (Map entryEntity : entryList) {
                Boolean isDefault = (Boolean)entryEntity.get("isdefault");
                if (!isDefault.booleanValue()) continue;
                hasDefault = true;
                break;
            }
            if (hasDefault.booleanValue()) continue;
            ArrayList preEntryList = new ArrayList(16);
            Long bizType = upDefaultBizTypes.get(billTypeId);
            for (Map entryEntity : entryList) {
                Object bizTypeId = entryEntity.get("biztypenumber_id");
                if (!bizType.equals(bizTypeId)) continue;
                entryEntity.put("isdefault", true);
            }
            preEntryList.addAll(entryList);
            bizTypeMap.put("entryentity", preEntryList);
            JSONObject jsonObject = new JSONObject(bizTypeMap);
            ParameterWriter.saveBillTypeParameter((String)formId, (long)billTypeId, (String)jsonObject.toJSONString());
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    static {
        upDefaultBizTypes.put(697678838297318400L, 688864881516276736L);
        upDefaultBizTypes.put(508390081774497792L, 422889961931423744L);
        upDefaultBizTypes.put(474446067409107968L, 422889961931423744L);
        upDefaultBizTypes.put(366348248593474560L, 422857170485263360L);
        upDefaultBizTypes.put(366342412236234752L, 738270780932080640L);
        logger = LogFactory.getLog(InvDefaultBizTypeUpgradeServiceImpl.class);
    }
}

