/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class InvschemeUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(InvschemeUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Long fid;
        Row row;
        Long fid2;
        Row next;
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        logger.info("InvschemeUpgradeServiceImpl:\u67e5\u8be2\u5f00\u542f\u7cfb\u7edf\u9884\u8bbe\u7684\u5e93\u5b58\u4e8b\u52a1id");
        DataSet invSchemesWithId = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)"SELECT  fid FROM t_im_invschemes where fispreset = '1'");
        ArrayList<Long> ids = new ArrayList<Long>(128);
        while (invSchemesWithId.hasNext()) {
            Row row2 = invSchemesWithId.next();
            Long fid3 = row2.getLong("fid");
            ids.add(fid3);
        }
        if (CollectionUtils.isEmpty(ids)) {
            logger.info("InvschemeUpgradeServiceImpl:\u6ca1\u6709\u67e5\u8be2\u5230\u5f00\u542f\u7cfb\u7edf\u9884\u8bbe\u7684\u5e93\u5b58\u4e8b\u52a1id");
            return null;
        }
        DataSet invType = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)"SELECT fid,finvtypeispreset FROM t_im_invtypeentry");
        DataSet outInvType = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)"SELECT fid,foutinvtypeispreset FROM t_im_outinvtypeentry");
        while (invType.hasNext()) {
            next = invType.next();
            fid2 = next.getLong("fid");
            String finvtypeispreset = next.getString("finvtypeispreset");
            if (!ids.contains(fid2) || !"1".equals(finvtypeispreset)) continue;
            ids.remove(fid2);
        }
        while (outInvType.hasNext()) {
            next = outInvType.next();
            fid2 = next.getLong("fid");
            String foutinvtypeispreset = next.getString("foutinvtypeispreset");
            if (!ids.contains(fid2) || !"1".equals(foutinvtypeispreset)) continue;
            ids.remove(fid2);
        }
        if (CollectionUtils.isEmpty(ids)) {
            logger.info("InvschemeUpgradeServiceImpl:\u6ca1\u6709\u67e5\u8be2\u5230\u5f00\u542f\u7cfb\u7edf\u9884\u8bbe\u4e14\u9700\u8981\u66f4\u65b0\u5e93\u5b58\u7c7b\u578b\u7684\u5e93\u5b58\u4e8b\u52a1id");
            return null;
        }
        DataSet invSchemes = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)"SELECT fid,fispreset,finvstatusid,foutinvstatusid FROM t_im_invschemes");
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("(");
        Object[] params = new Object[ids.size() + 1];
        for (int i = 0; i < ids.size(); ++i) {
            sqlBuilder.append("?,");
            params[i + 1] = ids.get(i);
        }
        sqlBuilder.deleteCharAt(sqlBuilder.lastIndexOf(","));
        sqlBuilder.append(")");
        params[0] = "1";
        DataSet invStatus = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)"SELECT fid,finvstatusid FROM t_im_invstatusentry");
        DataSet outInvStatus = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)"SELECT fid,foutinvstatusid FROM t_im_outinvstatusentry");
        HashSet<String> invSchemeIdAndInvStatusSet = new HashSet<String>(512);
        HashSet<String> outInvSchemeIdAndInvStatusSet = new HashSet<String>(512);
        while (invStatus.hasNext()) {
            row = invStatus.next();
            fid = row.getLong("fid");
            Long finvstatusid = row.getLong("finvstatusid");
            invSchemeIdAndInvStatusSet.add(fid + "_" + finvstatusid);
        }
        while (outInvStatus.hasNext()) {
            row = outInvStatus.next();
            fid = row.getLong("fid");
            Long foutinvstatusid = row.getLong("foutinvstatusid");
            outInvSchemeIdAndInvStatusSet.add(fid + "_" + foutinvstatusid);
        }
        try (TXHandle handle = TX.requiresNew();){
            logger.info("InvschemeUpgradeServiceImpl:\u5c06\u5f00\u542f\u3010\u7cfb\u7edf\u9884\u8bbe\u3011\u7684\u5e93\u5b58\u4e8b\u52a1\u5bf9\u5e94\u7684\u5165\u5e93\u5e93\u5b58\u7c7b\u578b\u3010\u7cfb\u7edf\u9884\u8bbe\u3011\u5b57\u6bb5\u7f6e\u4e3a\u2018\u662f\u2019");
            String updateInvTypeSql = "UPDATE t_im_invtypeentry SET finvtypeispreset = ? WHERE fid IN " + sqlBuilder;
            DB.update((DBRoute)scmRoute, (String)updateInvTypeSql, (Object[])params);
            logger.info("InvschemeUpgradeServiceImpl:\u5c06\u5f00\u542f\u3010\u7cfb\u7edf\u9884\u8bbe\u3011\u7684\u5e93\u5b58\u4e8b\u52a1\u5bf9\u5e94\u7684\u51fa\u5e93\u5e93\u5b58\u7c7b\u578b\u3010\u7cfb\u7edf\u9884\u8bbe\u3011\u5b57\u6bb5\u7f6e\u4e3a\u2018\u662f\u2019");
            String updateOutInvTypeSql = "UPDATE t_im_outinvtypeentry SET foutinvtypeispreset = ? WHERE fid IN " + sqlBuilder;
            DB.update((DBRoute)scmRoute, (String)updateOutInvTypeSql, (Object[])params);
            logger.info("InvschemeUpgradeServiceImpl:\u5c06\u7cfb\u7edf\u9884\u8bbe\u7684\u5e93\u5b58\u4e8b\u52a1\u5bf9\u5e94\u7684\u5173\u8054\u4e1a\u52a1\u7c7b\u578b \u3010\u7cfb\u7edf\u9884\u8bbe\u3011 \u5b57\u6bb5\u8bbe\u4e3a \u662f");
            String updateBizTypeSql = "UPDATE t_im_biztypeentry SET fbiztypeispreset = ? WHERE fid IN " + sqlBuilder;
            DB.update((DBRoute)scmRoute, (String)updateBizTypeSql, (Object[])params);
            ArrayList<Object[]> inParamList = new ArrayList<Object[]>();
            ArrayList<Object[]> outParamList = new ArrayList<Object[]>();
            long[] invStatusEntryIds = DB.genGlobalLongIds((int)invSchemes.copy().count("finvstatusid", false));
            long[] outInvStatusEntryIds = DB.genGlobalLongIds((int)invSchemes.copy().count("foutinvstatusid", false));
            int inIdx = 0;
            int outIdx = 0;
            while (invSchemes.hasNext()) {
                boolean invOutStatusNeedUp;
                boolean invStatusNeedUp;
                Row next2 = invSchemes.next();
                Long id = next2.getLong("fid");
                Long invStatusId = next2.getLong("finvstatusid");
                Long outInvStatusId = next2.getLong("foutinvstatusid");
                String isPreset = next2.getString("fispreset");
                boolean bl = invStatusNeedUp = invSchemeIdAndInvStatusSet.isEmpty() || !invSchemeIdAndInvStatusSet.contains(id + "_" + invStatusId);
                if (invStatusId != 0L && invStatusNeedUp) {
                    Object[] inParam = new Object[]{id, invStatusEntryIds[inIdx++], 1L, invStatusId, "1", isPreset};
                    inParamList.add(inParam);
                }
                boolean bl2 = invOutStatusNeedUp = outInvSchemeIdAndInvStatusSet.isEmpty() || !outInvSchemeIdAndInvStatusSet.contains(id + "_" + outInvStatusId);
                if (outInvStatusId == 0L || !invOutStatusNeedUp) continue;
                Object[] outParam = new Object[]{id, outInvStatusEntryIds[outIdx++], 1L, outInvStatusId, "1", isPreset};
                outParamList.add(outParam);
            }
            if (!CollectionUtils.isEmpty(inParamList)) {
                logger.info("InvschemeUpgradeServiceImpl:\u5c06\u539f\u5e93\u5b58\u4e8b\u52a1\u7684\u3010\u5165\u5e93\u5e93\u5b58\u72b6\u6001\u3011\u5b57\u6bb5\u5347\u7ea7\u5230\u5217\u8868\u4e2d");
                String insertInvStatusSql = "INSERT INTO t_im_invstatusentry (fid,fentryid,fseq,finvstatusid,fisdefault,finvstatusispreset) VALUES (?,?,?,?,?,?)";
                DB.executeBatch((DBRoute)scmRoute, (String)insertInvStatusSql, inParamList);
            }
            if (!CollectionUtils.isEmpty(outParamList)) {
                logger.info("InvschemeUpgradeServiceImpl:\u5c06\u539f\u5e93\u5b58\u4e8b\u52a1\u7684\u3010\u51fa\u5e93\u5e93\u5b58\u72b6\u6001\u3011\u5b57\u6bb5\u5347\u7ea7\u5230\u5217\u8868\u4e2d");
                String insertOutInvStatusSql = "INSERT INTO t_im_outinvstatusentry (fid,fentryid,fseq,foutinvstatusid,fisdefault,foutinvstatusispreset) VALUES (?,?,?,?,?,?)";
                DB.executeBatch((DBRoute)scmRoute, (String)insertOutInvStatusSql, outParamList);
            }
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }
}

