/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class LotInTrackUpdateServiceImpl
implements IUpgradeService {
    public static final int BATCH_SIZE = 5000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        String querySql = "select fid,fmaterialid,fmaterialmasterid from t_im_lotintrack";
        HashMap<Long, Long> idToMaterialMap = new HashMap<Long, Long>();
        try (DataSet dataSet = DB.queryDataSet((String)LotInTrackUpdateServiceImpl.class.getName(), (DBRoute)scmRoute, (String)querySql);){
            for (Row row : dataSet) {
                if (0L == row.getLong(2)) {
                    idToMaterialMap.put(row.getLong(0), row.getLong(1));
                }
                if (idToMaterialMap.size() != 5000) continue;
                this.updateLotInTrack(idToMaterialMap);
                idToMaterialMap.clear();
            }
        }
        if (!idToMaterialMap.isEmpty()) {
            this.updateLotInTrack(idToMaterialMap);
        }
        result.setSuccess(true);
        result.setLog("lotintrack update success.");
        return result;
    }

    private void updateLotInTrack(Map<Long, Long> idToMaterialMap) {
        HashSet<Long> materialInvIds = new HashSet<Long>(idToMaterialMap.values());
        StringBuilder idBuilder = new StringBuilder(5000);
        for (Long materialInvId : materialInvIds) {
            if (idBuilder.length() > 0) {
                idBuilder.append(",");
            }
            idBuilder.append(materialInvId);
        }
        StringBuilder sqlBuilder = new StringBuilder(1000);
        sqlBuilder.append("select fid,fmasterid  from t_bd_materialinvinfo where fid in(").append((CharSequence)idBuilder).append(")");
        HashMap<Long, Long> idToMasterMap = new HashMap<Long, Long>(5000);
        DataSet dataSet = DB.queryDataSet((String)LotInTrackUpdateServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"sys"), (String)sqlBuilder.toString());
        Object object = null;
        try {
            for (Row row : dataSet) {
                idToMasterMap.put(row.getLong(0), row.getLong(1));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(idToMaterialMap.size());
        for (Map.Entry entry : idToMaterialMap.entrySet()) {
            paramList.add(new Object[]{idToMasterMap.get(entry.getValue()), entry.getKey()});
        }
        String updateSql = "update t_im_lotintrack set fmaterialmasterid = ? where fid = ?";
        try (TXHandle tXHandle = TX.requiresNew();){
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, paramList);
        }
    }
}

