/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade.bookdateupgrade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class BaseBookDateUpgradeServiceImpl
implements IUpgradeService {
    protected static final Log logger = LogFactory.getLog(BaseBookDateUpgradeServiceImpl.class);
    protected static int BATCH_EXEC_NUMS = 2500000;
    private static int BATCH_INTERVAL = 3;
    private static int THREAD_NUMS = 8;
    private static int MAX_ERROR_TIMES = 3;
    protected static DBRoute route = new DBRoute("scm");
    protected static UpgradeResult result = new UpgradeResult();
    protected String serviceName;
    protected static Date execTime = new Date();

    protected static boolean isIgnoreExecUpgrade(String switchname) {
        String switchSql = "select fvalue as value from t_im_invdbparam where fkey = ?";
        boolean flag = false;
        try (DataSet switchSet = DB.queryDataSet((String)BaseBookDateUpgradeServiceImpl.class.getName(), (DBRoute)route, (String)switchSql, (Object[])new Object[]{switchname});){
            for (Row row : switchSet) {
                String value = row.getString("value");
                if (!"1".equals(value)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    protected static void updateSwitch(String switchname) {
        String updateSql = "update t_im_invdbparam set fvalue = '1' where fkey = ?";
        DB.execute((DBRoute)route, (String)updateSql, (Object[])new Object[]{switchname});
        logger.info("BaseBookDateUpgradeServiceImpl.updateSwitch:\u66f4\u65b0\u5f00\u5173\u6267\u884c\u6210\u529f\u3002");
    }

    protected Map<Integer, Object[]> getExecSqlParams(String splitTablename, String idcol) {
        String countSql = "select count(1) as count,min(" + idcol + ") as minid,max(" + idcol + ") as maxid from " + splitTablename;
        long count = 0L;
        long minid = 0L;
        long maxid = 0L;
        try (DataSet countSet = DB.queryDataSet((String)BaseBookDateUpgradeServiceImpl.class.getName(), (DBRoute)route, (String)countSql);){
            for (Row row : countSet) {
                count = row.getLong("count");
                if (count <= 0L) continue;
                minid = row.getLong("minid");
                maxid = row.getLong("maxid");
                break;
            }
        }
        if (count <= 0L) {
            return Collections.emptyMap();
        }
        if (count <= (long)BATCH_EXEC_NUMS) {
            return Collections.singletonMap(1, new Object[]{minid, maxid + 1L, execTime});
        }
        int batchs = new BigDecimal(count).divide(new BigDecimal(BATCH_EXEC_NUMS), RoundingMode.CEILING).intValue();
        HashMap<Integer, Object[]> params = new HashMap<Integer, Object[]>(batchs);
        HashMap<Integer, Object[]> paramsReorder = new HashMap<Integer, Object[]>(batchs);
        long idFrom = minid;
        long idTo = 0L;
        String nextIdSql = "select top 1," + BATCH_EXEC_NUMS + " " + idcol + " as id from " + splitTablename + " where " + idcol + " >= ?" + " order by " + idcol;
        for (int i = 1; i <= batchs; ++i) {
            Object[] param2 = new Object[3];
            if (i == batchs) {
                idTo = maxid + 1L;
            } else {
                try (DataSet nextIdtoSet = this.queryMethod(idFrom, nextIdSql);){
                    if (nextIdtoSet.hasNext()) {
                        Row row = nextIdtoSet.next();
                        idTo = row.getLong("id");
                    }
                }
            }
            param2[0] = idFrom;
            param2[1] = idTo;
            param2[2] = execTime;
            params.put(i, param2);
            idFrom = idTo;
        }
        StringBuilder paramBuilder = new StringBuilder(this.serviceName).append(':');
        params.values().forEach(param -> paramBuilder.append(Arrays.toString(param)));
        logger.info(paramBuilder.toString());
        int index = 1;
        for (int i = 1; i <= BATCH_INTERVAL; ++i) {
            for (int j = i; j <= batchs; j += BATCH_INTERVAL) {
                Object[] param3 = (Object[])params.get(j);
                paramsReorder.put(index, param3);
                ++index;
            }
        }
        return paramsReorder;
    }

    private DataSet queryMethod(long idFrom, String nextIdSql) {
        return DB.queryDataSet((String)BaseBookDateUpgradeServiceImpl.class.getName(), (DBRoute)route, (String)nextIdSql, (Object[])new Object[]{idFrom});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeSplitSql(String splitUpdateSql, Map<Integer, Object[]> params) {
        int size = params.size();
        try (ThreadPool pool = null;){
            String tenantId = "Default";
            RequestContextInfo rci = RequestContextInfo.get();
            if (rci != null) {
                tenantId = rci.getTenantId();
            }
            String poolname = tenantId + '.' + this.serviceName;
            pool = ThreadPools.newCachedThreadPool((String)poolname, (int)THREAD_NUMS, (int)(THREAD_NUMS * 2));
            HashSet<Integer> execIndexes = new HashSet<Integer>(THREAD_NUMS);
            int errtimes = 0;
            while (!params.isEmpty()) {
                if (errtimes >= MAX_ERROR_TIMES) {
                    StringBuilder errlogBuilder = new StringBuilder(this.serviceName).append(" error:");
                    params.values().forEach(param -> errlogBuilder.append(Arrays.toString(param)));
                    errlogBuilder.append(splitUpdateSql);
                    String errlog = errlogBuilder.toString();
                    result.setLog(errlog);
                    result.setErrorInfo(errlog);
                    boolean bl = false;
                    return bl;
                }
                execIndexes.clear();
                int firstIndex = 0;
                for (int i = 1; i <= 2; ++i) {
                    for (int j = 1; j <= size && (i != 2 || j < firstIndex); ++j) {
                        if (params.containsKey(j)) {
                            if (firstIndex == 0) {
                                firstIndex = j;
                            }
                            execIndexes.add(j);
                        }
                        if (execIndexes.size() != THREAD_NUMS) continue;
                        this.concurrentHandleSql(pool, splitUpdateSql, params, execIndexes);
                        execIndexes.clear();
                        firstIndex = 0;
                    }
                }
                if (execIndexes.size() > 0) {
                    this.concurrentHandleSql(pool, splitUpdateSql, params, execIndexes);
                }
                ++errtimes;
            }
            boolean bl = true;
            return bl;
        }
    }

    private void concurrentHandleSql(ThreadPool pool, final String sql, Map<Integer, Object[]> params, Set<Integer> execIndexes) {
        HashMap<Integer, Future> execFutureMap = new HashMap<Integer, Future>(THREAD_NUMS);
        Iterator<Object> iterator = execIndexes.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            final Object[] param = params.get(n);
            Future future = pool.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    StringBuilder execBuilder = new StringBuilder(BaseBookDateUpgradeServiceImpl.this.serviceName).append(" exec:").append(Arrays.toString(param)).append(sql);
                    DB.execute((DBRoute)route, (String)sql, (Object[])param);
                    return true;
                }
            });
            execFutureMap.put(n, future);
        }
        for (Map.Entry entry : execFutureMap.entrySet()) {
            int index = (Integer)entry.getKey();
            try {
                if (!((Boolean)((Future)entry.getValue()).get()).booleanValue()) continue;
                params.remove(index);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("BaseBookDateUpgradeServiceImpl.concurrentHandleSql:\u83b7\u53d6\u6267\u884c\u7ed3\u679c\u5f02\u5e38.", (Throwable)e);
            }
        }
    }

    public UpgradeResult doUpgrade(String splitTablename, String switchname, String singleUpdateSql, String splitUpdateSql, String idcol) {
        logger.info("BaseBookDateUpgradeServiceImpl\uff1a\u8fdb\u5165doUpgrade\u65b9\u6cd5\uff0csplitTablename={}\uff0cswitchname={}\uff0csingleUpdateSql={}\uff0csplitUpdateSql={}\uff0cidcol={}", new Object[]{splitTablename, switchname, singleUpdateSql, splitUpdateSql, idcol});
        if (BaseBookDateUpgradeServiceImpl.isIgnoreExecUpgrade(switchname)) {
            logger.info("BaseBookDateUpgradeServiceImpl.doUpgrade:\u65e0\u9700\u6267\u884c\u66f4\u65b0\uff0c\u9000\u51fa\u3002");
            result.setSuccess(true);
            return result;
        }
        String sql = "select fexectime from t_bas_deployinfodetail where ffilename = 'kd_1.5.116_im_billimporttemplateupdate.sql'";
        DataSet dataSet = DB.queryDataSet((String)"", (DBRoute)new DBRoute("sys.meta"), (String)sql);
        for (Row row : dataSet) {
            execTime = row.getDate("fexectime");
        }
        Map<Integer, Object[]> params = this.getExecSqlParams(splitTablename, idcol);
        boolean execResult = false;
        if (params == null || params.isEmpty()) {
            logger.info("BaseBookDateUpgradeServiceImpl.doUpgrade:params=null\uff0c\u65e0\u9700\u6267\u884c\uff0c\u9000\u51fa\u3002");
            execResult = true;
        } else if (params.size() == 1) {
            logger.info("BaseBookDateUpgradeServiceImpl.doUpgrade:\u5355\u6279\u6267\u884c,params={}\u3002", params);
            DB.execute((DBRoute)route, (String)singleUpdateSql, (Object[])new Object[]{execTime});
            execResult = true;
        } else {
            logger.info("BaseBookDateUpgradeServiceImpl.doUpgrade:\u5206\u6279\u6267\u884c, params={}\u3002", params);
            execResult = this.executeSplitSql(splitUpdateSql, params);
        }
        if (execResult) {
            BaseBookDateUpgradeServiceImpl.updateSwitch(switchname);
        }
        result.setSuccess(execResult);
        logger.info("BaseBookDateUpgradeServiceImpl.doUpgrade:\u6267\u884c\u7ed3\u675f\uff0c\u9000\u51fa\u3002");
        return result;
    }
}

