/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.utils;

import java.math.BigDecimal;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class BigDecimalUtils {
    public static boolean isNullOrZero(BigDecimal value) {
        return value == null || value.compareTo(BigDecimal.ZERO) == 0;
    }

    public static void showBigDecimalErrorTip(IDataModel model, BigDecimal qtyAll, String key) {
        String langName = RequestContext.get().getLang().name();
        IDataEntityProperty property = model.getProperty(key);
        String displayName = (String)property.getDisplayName().get((Object)langName);
        if (qtyAll == null) {
            return;
        }
        if (qtyAll.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage(new InvBillErrorCode().getERROR_MAX_BY_DISPLAYNAME(displayName)));
        }
    }

    public static String getBigDecimalErrorTip(IDataModel model, BigDecimal qtyAll, String key, int index) {
        String langName = RequestContext.get().getLang().name();
        IDataEntityProperty property = model.getProperty(key);
        String displayName = (String)property.getDisplayName().get((Object)langName);
        if (qtyAll.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            return CommonUtils.getCodeErrorMessage(new InvBillErrorCode().getERROR_MAX_BY_DISPLAYNAME(displayName));
        }
        return null;
    }

    public static void showBigDecimalErrorTip(DynamicObject bill, BigDecimal qtyAll, String key) {
        String langName = RequestContext.get().getLang().name();
        DynamicProperty property = bill.getDynamicObjectType().getProperty(key);
        String displayName = (String)property.getDisplayName().get((Object)langName);
        if (qtyAll.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage(new InvBillErrorCode().getERROR_MAX_BY_DISPLAYNAME(displayName)));
        }
    }
}

