/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.algorithm;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.business.algorithm.AbstractAlgorithm;

public abstract class AbstractSimpleAlgorithm
extends AbstractAlgorithm {
    protected static Log log = LogFactory.getLog(AbstractSimpleAlgorithm.class);
    protected int amountPrecision = 2;
    protected int pricePrecision = 10;

    protected void initPrecision() {
        this.initPrecision("settlecurrency");
    }

    protected void initPrecision(String currencyKey) {
        DynamicObject currency = (DynamicObject)this.getValue(currencyKey);
        if (currency != null) {
            this.amountPrecision = currency.getInt("amtprecision");
        }
    }

    public boolean calByChange(String key) {
        boolean hasCal = false;
        return hasCal;
    }

    public boolean calByEntryChange(String key, int i) {
        boolean hasCal = true;
        switch (key) {
            case "qty": {
                this.calByQty(i);
                break;
            }
            case "qtyunit2nd": {
                this.calByQty(i);
                break;
            }
            case "price": {
                this.calByPrice(i);
                break;
            }
            case "amount": {
                this.calByAmount(i);
                break;
            }
            default: {
                hasCal = false;
            }
        }
        return hasCal;
    }

    protected void calByQty(int i) {
        this.calAmount(i);
    }

    protected void calByPrice(int i) {
        this.calAmount(i);
    }

    protected void calByAmount(int i) {
        this.calPrice(i);
    }

    private void calAmount(int i) {
        BigDecimal price = this.getNullToZero("price", i);
        BigDecimal qty = this.getNullToZero("qty", i);
        BigDecimal amount = BigDecimal.ZERO;
        amount = qty.multiply(price).setScale(this.amountPrecision, 4);
        this.setValue("amount", amount, i);
    }

    private void calPrice(int i) {
        BigDecimal amount = this.getNullToZero("amount", i);
        BigDecimal qty = this.getNullToZero("qty", i);
        BigDecimal price = BigDecimal.ZERO;
        if (amount.compareTo(BigDecimal.ZERO) != 0 && qty.compareTo(BigDecimal.ZERO) != 0) {
            price = amount.divide(qty, this.pricePrecision, 4);
        }
        this.setValue("price", price, i);
    }

    protected void reCalFieldsByInputAmount() {
        Boolean inputAmount = (Boolean)this.getValue("inputamount");
        int entrySize = this.getEntrySize();
        for (int i = 0; i < entrySize; ++i) {
            if (inputAmount.booleanValue()) {
                this.calByAmount(i);
                continue;
            }
            this.calByQty(i);
        }
    }
}

