/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.algorithm;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.business.algorithm.AbstractTaxAlgorithm;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.utils.BigDecimalUtils;

public class TaxAlgorithmForForm
extends AbstractTaxAlgorithm {
    protected static Log log = LogFactory.getLog(TaxAlgorithmForForm.class);
    protected IFormView view;
    protected IDataModel model;
    private StringBuilder errorMsg = new StringBuilder();
    private Set<String> clearKeys = new HashSet<String>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calByChange(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        if (MetaDataHelper.isExistField(this.model, "billentry", fieldName)) {
            for (int i = 0; i < valueSet.length; ++i) {
                int rowIndex = valueSet[i].getRowIndex();
                boolean hasCal = false;
                try {
                    this.model.beginInit();
                    hasCal = this.calByEntryChange(fieldName, rowIndex);
                    if (this.errorMsg != null && this.errorMsg.length() != 0) {
                        for (String clearKey : this.clearKeys) {
                            this.model.setValue(clearKey, null, rowIndex);
                        }
                    }
                }
                finally {
                    this.model.endInit();
                }
                if (!hasCal) continue;
                BillViewHelper.updateViewRow(this.view, rowIndex, "billentry");
            }
        } else if (MetaDataHelper.isExistField(this.model, fieldName)) {
            boolean hasCal = false;
            for (int i = 0; i < valueSet.length; ++i) {
                try {
                    this.model.beginInit();
                    hasCal = this.calByChange(fieldName);
                }
                finally {
                    this.model.endInit();
                }
                if (!hasCal) continue;
                int entrySize = this.getEntrySize();
                for (int j = 0; j < entrySize; ++j) {
                    if (this.errorMsg != null && this.errorMsg.length() != 0) {
                        for (String clearKey : this.clearKeys) {
                            this.model.beginInit();
                            this.model.setValue(clearKey, null, j);
                            this.model.endInit();
                        }
                    }
                    BillViewHelper.updateViewRow(this.view, j, "billentry");
                }
            }
        }
        if (this.errorMsg != null && this.errorMsg.length() != 0) {
            this.view.showErrorNotification(this.errorMsg.toString());
        }
    }

    public TaxAlgorithmForForm(IFormView view) {
        this.view = view;
        this.model = view.getModel();
        this.initPrecision();
    }

    @Override
    public void setValue(String key, Object value) {
        this.model.setValue(key, value);
    }

    @Override
    public void setValue(String key, Object value, int i) {
        String errorTip;
        if (value instanceof BigDecimal && (errorTip = BigDecimalUtils.getBigDecimalErrorTip((IDataModel)this.model, (BigDecimal)((BigDecimal)value), (String)key, (int)i)) != null) {
            this.clearKeys.add(key);
            this.errorMsg.append(errorTip).append("\n");
        }
        DynamicObject entryRowEntity = this.model.getEntryRowEntity("billentry", i);
        entryRowEntity.set(key, value);
    }

    @Override
    public Object getValue(String key) {
        return this.model.getValue(key);
    }

    @Override
    public Object getValue(String key, int i) {
        DynamicObject entryRowEntity = this.model.getEntryRowEntity("billentry", i);
        return entryRowEntity.get(key);
    }

    @Override
    protected int getEntrySize() {
        DynamicObjectCollection billEntry = this.model.getEntryEntity("billentry");
        return billEntry.size();
    }

    @Override
    protected String getEntityName() {
        return this.model.getDataEntityType().getName();
    }
}

