/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balance;

import java.util.List;
import java.util.Map;
import kd.bos.biz.balance.model.BalanceUpdateArgs;
import kd.bos.biz.balance.model.IBalanceUpdatePlugin;
import kd.bos.biz.balance.model.IDataTransform;
import kd.bos.biz.balance.model.UpdateRule;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.mservice.ReserveService;
import kd.scmc.im.business.balance.transform.SetNull4NoUpdateCols;
import kd.scmc.im.business.helper.InvcountSchemeHelper;

public class AggregateBalanceUpdate
implements IBalanceUpdatePlugin {
    public void addTransform(List<IDataTransform> transformCollector, UpdateRule rule) {
        Map logicColMap = rule.getLogicColMap();
        if (logicColMap.containsKey("noupdateinvfields")) {
            Map srcColMap = rule.getTargetSrcColMap();
            SetNull4NoUpdateCols transform = new SetNull4NoUpdateCols("noupdateinvfields", srcColMap);
            transformCollector.add(transform);
        }
    }

    public void afterUpdate(BalanceUpdateArgs args) {
        if (ReserveAggregateHelper.isAggregateInit()) {
            ReserveService.dealReserveForInvCheck((BalanceUpdateArgs)args);
        }
    }

    public void beforeJoinUpdate(BalanceUpdateArgs args) {
        InvcountSchemeHelper.check4BalanceUpdate(args);
    }
}

