/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balance;

import java.util.Map;
import kd.bos.biz.balance.model.BalanceTB;

public class BalUpdateInfo {
    private String updateSql;
    private String groupSpDataSqlPart;
    private String selectBalDataSqlPart;
    private String[] qtyCol;
    private String[] balQtyCol;
    public static final String BAL_COL_SUFFIX = "_bal";

    public String[] getQtyCol() {
        return this.qtyCol;
    }

    public String[] getBalQtyCol() {
        return this.balQtyCol;
    }

    public BalUpdateInfo buildInfo(BalanceTB tb) {
        this.qtyCol = tb.getOccCols().toArray(new String[0]);
        this.balQtyCol = new String[this.qtyCol.length];
        int len = this.qtyCol.length;
        for (int i = 0; i < len; ++i) {
            this.balQtyCol[i] = this.qtyCol[i] + BAL_COL_SUFFIX;
        }
        StringBuilder localUpdateSQL = new StringBuilder();
        localUpdateSQL.append(" UPDATE ").append(tb.getTb()).append(" SET ");
        Map colFieldMap = tb.getColFieldMap();
        int i = 0;
        for (String qty : this.qtyCol) {
            if (i != 0) {
                localUpdateSQL.append(',');
            }
            localUpdateSQL.append((String)colFieldMap.get(qty)).append(" = ?");
            ++i;
        }
        localUpdateSQL.append(" WHERE ").append("fkeycol").append(" = ?");
        StringBuilder localGroupSQL = new StringBuilder(" SELECT ");
        localGroupSQL.append("fkeycol");
        for (String qty : this.qtyCol) {
            localGroupSQL.append(",sum(").append(BalanceTB.parse2SnapName((String)((String)colFieldMap.get(qty)))).append(") ").append(qty);
        }
        localGroupSQL.append(" FROM ").append(tb.getSnapshotTb());
        localGroupSQL.append(" WHERE ").append("fstatus").append(" ='").append("A");
        localGroupSQL.append("' AND ");
        StringBuilder selectbalSql = new StringBuilder(" SELECT ");
        selectbalSql.append("fkeycol").append(' ').append("fkeycol_bal");
        for (int j = 0; j < this.qtyCol.length; ++j) {
            selectbalSql.append(',').append((String)colFieldMap.get(this.qtyCol[j])).append(' ').append(this.balQtyCol[j]);
        }
        selectbalSql.append(" FROM ").append(tb.getTb()).append(" WHERE ");
        this.updateSql = localUpdateSQL.toString();
        this.groupSpDataSqlPart = localGroupSQL.toString();
        this.selectBalDataSqlPart = selectbalSql.toString();
        return this;
    }

    public String getSelectBalDataSqlPart() {
        return this.selectBalDataSqlPart;
    }

    public String getGroupSpDataSqlPart() {
        return this.groupSpDataSqlPart;
    }

    public String getUpdateSql() {
        return this.updateSql;
    }
}

