/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.engine.BalanceUpdateManager;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.IRuleFilter;
import kd.bos.biz.balance.model.UpdateCtx;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.balance.BizDataType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.balance.BalanceRuleCacheUtils;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scmc.im.business.balance.recal.BalReCalCache;
import kd.scmc.im.business.util.ExceptionUtil;
import org.apache.commons.lang3.StringUtils;

public class BalanceUpdateHandle {
    private static ExecutorService ser = ThreadPools.newExecutorService((String)"reCalBalance", (int)12);
    private static final Log LOG = LogFactory.getLog(BalanceUpdateHandle.class);
    private static final String F_BILLSTATUS = "billstatus";
    private static final String F_ORG = "org";
    private static final String PERIOD_UPDATED = "period_updated";
    private static final String[] COLS = new String[]{"endid", "rule"};

    @Deprecated
    public static void clearBals(String ... balTBs) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    @Deprecated
    public static void reCalByBillFs(Date start, String[] balTBs, QFilter fs, String bill) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    private static List<Long> getInvOrgs(String bill, List<UpdateRule> rules, QFilter fs) {
        ArrayList invOrgs = null;
        if (bill != null && fs != null) {
            HashSet cols = new HashSet(2);
            for (UpdateRule rule : rules) {
                cols.add(rule.getSrcColFullNameMap().get(rule.getTargetSrcColMap().get(F_ORG)));
            }
            HashSet<Long> orgIds = new HashSet<Long>();
            fs = new QFilter(F_BILLSTATUS, "=", (Object)"C").and(fs);
            DataSet idDatas = QueryServiceHelper.queryDataSet((String)"kd.scmc.im.business.balance.BalanceUpdateHandle.getInvOrgs", (String)bill, (String)String.join((CharSequence)",", cols), (QFilter[])fs.toArray(), null);
            for (Row row : idDatas) {
                for (String col : cols) {
                    orgIds.add(row.getLong(col));
                }
            }
            invOrgs = new ArrayList(orgIds);
        } else {
            invOrgs = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"05", (boolean)true);
        }
        return invOrgs;
    }

    @Deprecated
    public static void realReCal(Date start, String ... balTBs) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    @Deprecated
    public static void periodReCal(Date start, String ... bals) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    private static long getStartDate() {
        IRuleFilter fs = new IRuleFilter(){

            public boolean filter(UpdateRule rule) {
                return "1".equals(rule.getPeriodPolicy());
            }
        };
        long start = Long.MAX_VALUE;
        List rules = UpdateRuleCache.getUpdateRuleByBal((String)"im_inv_periodbalance", (IRuleFilter)fs);
        rules.addAll(UpdateRuleCache.getUpdateRuleByBal((String)"im_cal_periodbalance", (IRuleFilter)fs));
        HashSet<String> billFsKey = new HashSet<String>(rules.size());
        String billName = null;
        String periodCol = null;
        for (UpdateRule rule : rules) {
            billName = rule.getEntityNumber();
            periodCol = (String)rule.getSrcColFullNameMap().get(rule.getPeriodColMap().get("per_date"));
            if (!StringUtils.isNotBlank((CharSequence)periodCol) || !billFsKey.add(billName + periodCol)) continue;
            long date = BalanceUpdateHandle.getStartDate(billName, periodCol);
            start = date < start ? date : start;
        }
        return start;
    }

    private static long getStartDate(String entityName, String periodCol) {
        Date startDate = null;
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"getStartDate", (String)entityName, (String)periodCol, (QFilter[])new QFilter[]{new QFilter(F_BILLSTATUS, "=", (Object)"C")}, (String)(periodCol + " asc"), (int)1);){
            for (Row row : data) {
                startDate = row.getDate(periodCol);
            }
        }
        return startDate == null ? Long.MAX_VALUE : startDate.getTime();
    }

    private static void batchPublish(List<DynamicObject> logs, MessagePublisher pub) {
        int size = logs.size();
        long[] ids = DB.genGlobalLongIds((int)size);
        DynamicObject[] logArrr = new DynamicObject[size];
        ArrayList<JSONObject> pubs = new ArrayList<JSONObject>(size);
        JSONObject p = null;
        for (int i = 0; i < size; ++i) {
            logs.get(i).set("id", (Object)ids[i]);
            logArrr[i] = logs.get(i);
            p = new JSONObject(1);
            p.put("taskid", (Object)ids[i]);
            pubs.add(p);
        }
        SaveServiceHelper.save((DynamicObject[])logArrr);
        for (JSONObject msg : pubs) {
            pub.publish(msg.toJSONString());
        }
    }

    private static void addPercent(int percent, String msg, StringBuilder log) {
        log.append("\r\n").append(percent).append("%-").append(msg);
        BalReCalCache.setReCalPercent(percent, log.toString());
    }

    private static void addPercent(int count, int total, String msg, StringBuilder log) {
        int percent = count * 100 / total;
        percent = percent >= 100 ? 99 : percent;
        BalanceUpdateHandle.addPercent(percent, msg, log);
    }

    @Deprecated
    public static void reSetKeyCol(String ... balTBs) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    @Deprecated
    public static void clearSnapData(String[] balTBs) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    public static void clearSnapData(BalanceTB tb, StringBuilder andStr) {
        String snapTb = tb.getSnapshotTb();
        StringBuilder sql = new StringBuilder("DELETE FROM ").append(snapTb);
        sql.append(" WHERE ").append("fstatus").append("='").append("B").append("' ");
        if (andStr != null) {
            sql.append((CharSequence)andStr);
        }
        DB.execute((DBRoute)tb.getDbRoute(), (String)sql.toString());
    }

    private static List<StringBuilder> getSet0Sql(BalanceTB tb, Object orgId, int period) {
        Map<String, List<String>> colGroup = BalanceUpdateHandle.groupCols(tb);
        ArrayList<StringBuilder> sqls = new ArrayList<StringBuilder>(colGroup.size());
        Map colFieldMap = tb.getColFieldMap();
        String tbExt = null;
        List<String> qtyCols = null;
        for (Map.Entry<String, List<String>> entry : colGroup.entrySet()) {
            tbExt = entry.getKey();
            qtyCols = entry.getValue();
            StringBuilder sql = new StringBuilder(" UPDATE ");
            sql.append(tb.getTb()).append(tbExt).append(" SET ");
            int index = 0;
            for (String qtyCol : qtyCols) {
                if (index != 0) {
                    sql.append(',');
                }
                sql.append((String)colFieldMap.get(qtyCol)).append(" = 0 ");
                ++index;
            }
            sql.append(BalanceUpdateHandle.getSqlWhere(tb, orgId, tbExt, period));
            sqls.add(sql);
        }
        return sqls;
    }

    private static Map<String, List<String>> groupCols(BalanceTB tb) {
        Map colTbMap = tb.getColTbMap();
        HashMap<String, List<String>> tbs = new HashMap<String, List<String>>(colTbMap.size());
        Set qtyCols = tb.getColsByDataType(new BizDataType[]{BizDataType.OCC});
        if ("realtime".equals(tb.getType())) {
            qtyCols = tb.getColsByDataType(new BizDataType[]{BizDataType.OCC});
        } else if ("period".equals(tb.getType())) {
            qtyCols = tb.getColsByDataType(new BizDataType[]{BizDataType.INIT, BizDataType.IN, BizDataType.OUT, BizDataType.BAL, BizDataType.YEAR_IN, BizDataType.YEAR_OUT});
        } else {
            return tbs;
        }
        String tbExt = null;
        ArrayList<String> cols = null;
        for (String qtyCol : qtyCols) {
            tbExt = (String)colTbMap.get(qtyCol);
            cols = (ArrayList<String>)tbs.get(tbExt);
            if (cols == null) {
                cols = new ArrayList<String>(8);
                tbs.put(tbExt, cols);
            }
            cols.add(qtyCol);
        }
        return tbs;
    }

    @Deprecated
    public static void setAll0(String[] balTBs) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    @Deprecated
    public static void realClearByBalFs(String[] balTBs, Long orgId) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    @Deprecated
    public static void realReCalByBalFs(Date start, String[] balTBs, Long orgId) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    private static StringBuilder getMainTbWhere(BalanceTB tb, Object orgId, int period) {
        StringBuilder where = new StringBuilder();
        if (orgId != null) {
            String forg = (String)tb.getColFieldMap().get(F_ORG);
            where.append(" WHERE ").append(forg).append(" = ").append(orgId);
        }
        String periodCol = tb.getPeriodCol();
        if (period > 0 && StringUtils.isNotBlank((CharSequence)periodCol)) {
            where.append(where.length() > 0 ? " AND " : " WHERE ");
            where.append((String)tb.getColFieldMap().get(periodCol)).append(" >= ").append(period);
        }
        return where;
    }

    private static String getDeleteSnapDataSql(BalanceTB tb, Long orgId, int period) {
        StringBuilder sql = new StringBuilder(orgId == null && period <= 0 ? "TRUNCATE TABLE " : "DELETE FROM ").append(tb.getSnapshotTb());
        StringBuilder whereFs = BalanceUpdateHandle.getMainTbWhere(tb, orgId, period);
        if (whereFs.length() > 0) {
            sql.append(" WHERE ").append("fkeycol").append(" IN (SELECT ").append("fkeycol");
            sql.append(" FROM ").append(tb.getTb()).append((CharSequence)whereFs).append(") ");
            String periodCol = tb.getPeriodCol();
            if (period > 0 && StringUtils.isNotBlank((CharSequence)periodCol)) {
                sql.append(" AND ");
                sql.append((String)tb.getColFieldMap().get(periodCol)).append(" >= ").append(period);
            }
        }
        return sql.toString();
    }

    private static String getSqlWhere(BalanceTB tb, Object orgId, String tbExt, int period) {
        StringBuilder where = new StringBuilder();
        StringBuilder mainTbWhere = BalanceUpdateHandle.getMainTbWhere(tb, orgId, period);
        if (mainTbWhere.length() > 0) {
            if (StringUtils.isBlank((CharSequence)tbExt)) {
                where.append((CharSequence)mainTbWhere);
            } else {
                where.append(" WHERE ").append("fid").append(" IN (SELECT ").append("fid");
                where.append(" FROM ").append(tb.getTb()).append((CharSequence)mainTbWhere).append(") ");
            }
        }
        return where.toString();
    }

    private static String getDeleteBalDataSql(BalanceTB tb, Long orgId, String tbExt, int period) {
        StringBuilder sql = new StringBuilder(orgId == null && period < 0 ? "TRUNCATE TABLE " : "DELETE FROM ").append(tb.getTb()).append(tbExt);
        sql.append(BalanceUpdateHandle.getSqlWhere(tb, orgId, tbExt, period));
        return sql.toString();
    }

    private static void executeMehod(Long orgId, int period, BalanceTB tb, String tbExt) {
        DB.execute((DBRoute)tb.getDbRoute(), (String)BalanceUpdateHandle.getDeleteBalDataSql(tb, orgId, tbExt, period));
    }

    private static void executeMehod(Long orgId, int period, BalanceTB tb) {
        DB.execute((DBRoute)tb.getDbRoute(), (String)BalanceUpdateHandle.getDeleteSnapDataSql(tb, orgId, period));
    }

    private static String parseMsg(Exception e, int i) {
        return ExceptionUtil.parseMsg(e, i);
    }

    @Deprecated
    public static void realSet0ByBalFs(String[] balTBs, Long orgId) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    private static void set0ByByBalFs(StringBuilder log, String[] balTBs, Long orgId, int period) {
    }

    private static void updateMehod(BalanceTB tb, StringBuilder sql) {
        DB.update((DBRoute)tb.getDbRoute(), (String)sql.toString());
    }

    @Deprecated
    public static void realClearZero(String[] balTBs) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    private static void deleteZeroRecord(BalanceTB tb) {
        Set qtyCols = tb.getOccCols();
        QFilter fs = null;
        for (String qtyCol : qtyCols) {
            if (fs == null) {
                fs = new QFilter(qtyCol, "=", (Object)0);
                continue;
            }
            fs.and(qtyCol, "=", (Object)0);
        }
        if (fs == null) {
            return;
        }
        DeleteServiceHelper.delete((String)tb.getName(), (QFilter[])fs.toArray());
    }

    @Deprecated
    public static void autoUpdatePeriod(boolean force) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    private static int updateAndGetCount(boolean force) {
        if (force) {
            return 0;
        }
        int count = -1;
        String sql = "SELECT fvalue FROM T_IM_INVDBPARAM WHERE FKEY = 'im_bal_update_count'";
        try (DataSet data = DB.queryDataSet((String)"kd.scmc.im.business.balance.BalanceUpdateHandle.getUpateCount()", (DBRoute)DBRoute.of((String)"im"), (String)sql);){
            if (data.hasNext()) {
                Row row = data.next();
                count = Integer.parseInt(row.getString("fvalue"));
            }
        }
        sql = count == -1 ? "insert into T_IM_INVDBPARAM(fid,fkey,fvalue) values (" + DB.genGlobalLongId() + ", 'im_bal_update_count','0')" : "update T_IM_INVDBPARAM set fvalue='" + (count + 1) + "'  WHERE FKEY = 'im_bal_update_count'";
        DB.execute((DBRoute)DBRoute.of((String)"im"), (String)sql);
        return count + 1;
    }

    private static void disableUpdateTask() {
        QFilter fs = new QFilter("number", "=", (Object)"BalAutoUpdateTask");
        DynamicObject info = BusinessDataServiceHelper.loadSingle((String)"sch_schedule", (String)"id,status", (QFilter[])fs.toArray());
        if (info != null) {
            info.set("status", (Object)"0");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
        }
    }

    private static void clearBeforeLogs(Date start, String[] tbs) {
        QFilter fs = new QFilter("start", "=", (Object)start);
        fs.and("bal", "in", (Object)tbs);
        DeleteServiceHelper.delete((String)"im_bal_recal_log", (QFilter[])fs.toArray());
    }

    private static void addIds(Set<Object> ids, String idStr, Set<Object> existsSet) {
        List idList = JSON.parseArray((String)idStr, Long.class);
        ids.addAll(idList);
        existsSet.removeAll(idList);
    }

    private static void doReCal(Map<String, Set<Object>> auditIds, Map<String, Set<Object>> unAuditIds) {
        BalanceUpdateHandle.reDoOp("audit", auditIds);
        BalanceUpdateHandle.reDoOp("unaudit", unAuditIds);
    }

    private static void reDoOp(String audiName, Map<String, Set<Object>> ids4Op) {
        String entity = null;
        Set<Object> ids = null;
        int batchCount = 2000;
        for (Map.Entry<String, Set<Object>> entry : ids4Op.entrySet()) {
            entity = entry.getKey();
            ids = entry.getValue();
            HashSet<Object> batchIds = new HashSet<Object>(batchCount);
            for (Object id : ids) {
                batchIds.add(id);
                if (batchIds.size() < batchCount) continue;
                BalanceUpdateManager.doUpdate((UpdateCtx)new UpdateCtx(audiName, entity, ids));
                batchIds.clear();
            }
            if (batchIds.isEmpty()) continue;
            BalanceUpdateManager.doUpdate((UpdateCtx)new UpdateCtx(audiName, entity, ids));
        }
    }

    @Deprecated
    public static void reCalByBillIds(String bill, String[] balTbs, Set<Object> billIds) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    private static Date getStartUpdateTime(boolean force) {
        Calendar cd = Calendar.getInstance();
        String sql = null;
        long start = 0L;
        if (force) {
            sql = "delete from T_IM_INVDBPARAM where fkey = 'im_bal_update_start'";
            DB.execute((DBRoute)DBRoute.of((String)"im"), (String)sql);
        } else {
            sql = "SELECT fvalue FROM T_IM_INVDBPARAM WHERE FKEY = 'im_bal_update_start'";
            try (DataSet data = DB.queryDataSet((String)"kd.scmc.im.business.balance.BalanceUpdateHandle.getUpateCount()", (DBRoute)DBRoute.of((String)"im"), (String)sql);){
                if (data.hasNext()) {
                    Row row = data.next();
                    start = Long.parseLong(row.getString("fvalue"));
                }
            }
        }
        if (start == 0L) {
            cd.set(14, 0);
            start = cd.getTimeInMillis();
            sql = "insert into T_IM_INVDBPARAM(fid,fkey,fvalue) values (" + DB.genGlobalLongId() + ", 'im_bal_update_start','" + String.valueOf(start) + "')";
            DB.execute((DBRoute)DBRoute.of((String)"im"), (String)sql);
        } else {
            cd.setTimeInMillis(start);
        }
        return cd.getTime();
    }

    private static void updateBalanceTBStatus(String[] tbNames, boolean disable) {
        DynamicObject[] tbs;
        QFilter fs = new QFilter("number", "in", (Object)tbNames);
        for (DynamicObject dynamicObject : tbs = BusinessDataServiceHelper.load((String)"bal_balanceinfo", (String)"id,custstatus", (QFilter[])fs.toArray())) {
            dynamicObject.set("custstatus", (Object)(disable ? "1" : "0"));
        }
        SaveServiceHelper.update((DynamicObject[])tbs);
        for (String string : tbNames) {
            BalanceRuleCacheUtils.removeBalVersion((String)string);
        }
    }

    public static boolean isNewPeriodBal() {
        String tb = (String)BalReCalCache.getImAppCache().get(PERIOD_UPDATED, String.class);
        boolean isNew = true;
        if (tb == null) {
            String sql = "select fid from T_IM_INVDBPARAM where fkey  = 'period_updated'";
            try (DataSet data = DB.queryDataSet((String)"kd.scmc.im.business.balance.BalanceUpdateHandle.isNewPeriodBal", (DBRoute)new DBRoute("scm"), (String)sql);){
                isNew = data.hasNext();
            }
            tb = String.valueOf(isNew);
            BalReCalCache.getImAppCache().put(PERIOD_UPDATED, (Object)tb);
        } else {
            isNew = "true".equalsIgnoreCase(tb);
        }
        return isNew;
    }

    public static boolean reLoadPeriodBalFlag() {
        BalReCalCache.getImAppCache().remove(PERIOD_UPDATED);
        return BalanceUpdateHandle.isNewPeriodBal();
    }

    public static void periodChangeEngine(boolean isNew) {
        String sql = null;
        sql = isNew ? "insert into T_IM_INVDBPARAM(fid,forgid,fkey,fvalue) values (" + DB.genGlobalLongId() + ", 0 ,'" + PERIOD_UPDATED + "','1')" : "delete from T_IM_INVDBPARAM where fkey = 'period_updated' ";
        DB.execute((DBRoute)new DBRoute("scm"), (String)sql);
        BalReCalCache.getImAppCache().remove(PERIOD_UPDATED);
    }

    static List<UpdateRule> getAllRules(String ... bals) {
        ArrayList<UpdateRule> rules = new ArrayList<UpdateRule>(126);
        IRuleFilter fs = new IRuleFilter(){

            public boolean filter(UpdateRule rule) {
                return rule.isEnable();
            }
        };
        for (String tb : bals) {
            rules.addAll(UpdateRuleCache.getUpdateRuleByBal((String)tb, (IRuleFilter)fs));
        }
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Long> queryLastIds(QFilter fs) {
        try (DataSet data = null;){
            data = QueryServiceHelper.queryDataSet((String)"kd.scmc.im.business.balance.BalanceUpdateHandle.queryLastIds", (String)"im_bal_recal_point", (String)String.join((CharSequence)",", COLS), (QFilter[])fs.toArray(), null);
            data = data.groupBy(new String[]{"rule"}).max("endid").finish();
            HashMap<String, Long> ruleStartId = new HashMap<String, Long>(64);
            for (Row row : data) {
                ruleStartId.put(row.getString("rule"), row.getLong("endid"));
            }
            HashMap<String, Long> hashMap = ruleStartId;
            return hashMap;
        }
    }

    @Deprecated
    public static void periodReCalByBalFs(Date start, String[] balTBs, Long orgId, int startPeriod) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    @Deprecated
    public static void periodClearByBalFs(String[] balTBs, Long orgId, int period) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    @Deprecated
    public static void periodSet0ByBalFs(String[] balTBs, Long orgId, int period) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    @Deprecated
    public static void realCheckBal(String tb) {
        LOG.warn("\u6b64\u65b9\u6cd5\u5df2\u8fc7\u65f6\uff0c\u8bf7\u53e6\u884c\u5904\u7406");
    }

    private static List<Long> getSpiltId(BalanceTB tb) {
        StringBuilder sql = new StringBuilder("SELECT min(fid) startid, max(fid) endid ");
        sql.append(" FROM ").append(tb.getTb());
        DataSet data = DB.queryDataSet((String)"getSpiltId", (DBRoute)tb.getDbRoute(), (String)sql.toString());
        Long startId = null;
        Long endId = null;
        for (Row row : data) {
            startId = row.getLong("startid");
            endId = row.getLong("endid");
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(startId);
        sql = new StringBuilder("SELECT TOP 1,1000000 ");
        sql.append("fid").append(" FROM ").append(tb.getTb());
        sql.append(" WHERE ").append("fid").append(" > ?").append(" order by ").append("fid").append(" asc ");
        Long tempStartId = startId;
        while (tempStartId != null) {
            data = BalanceUpdateHandle.queryMethod(tb, sql, tempStartId);
            tempStartId = null;
            for (Row row : data) {
                tempStartId = row.getLong("fid");
            }
            if (tempStartId == null) continue;
            ids.add(tempStartId);
        }
        ids.add(endId + 1L);
        return ids;
    }

    private static DataSet queryMethod(BalanceTB tb, StringBuilder sql, Long tempStartId) {
        return DB.queryDataSet((String)"getSpiltId", (DBRoute)tb.getDbRoute(), (String)sql.toString(), (Object[])new Object[]{tempStartId});
    }
}

