/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balance;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.business.balance.BalUpdateInfo;
import kd.scmc.im.business.util.ExceptionUtil;

public class CheckRealbalTask
implements Callable<String> {
    private static final Log log = LogFactory.getLog(CheckRealbalTask.class);
    private long startId;
    private long endId;
    private int batchSize = 512;
    private BalanceTB tb;
    private AtomicLong count = new AtomicLong(0L);
    private BalUpdateInfo info;
    private StringBuilder reCheckIds = new StringBuilder();
    private final RequestContext rc;

    public CheckRealbalTask(long startId, long endId, BalanceTB tb, BalUpdateInfo info) {
        this.startId = startId;
        this.endId = endId;
        this.tb = tb;
        this.info = info;
        this.rc = RequestContext.get();
    }

    private DataSet getData() {
        StringBuilder sql = new StringBuilder(" SELECT ").append("fid").append(',').append("fkeycol");
        sql.append(" FROM ").append(this.tb.getTb());
        sql.append(" WHERE ").append("fid").append(">=").append(this.startId);
        sql.append(" AND ").append("fid").append("<").append(this.endId);
        sql.append(" order by ").append("fid").append(" asc ");
        return DB.queryDataSet((String)"getData", (DBRoute)this.tb.getDbRoute(), (String)sql.toString());
    }

    @Override
    public String call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.rc);
        JSONObject json = new JSONObject();
        try {
            this.doCheckAndUpdate();
            json.put("succes", (Object)"true");
        }
        catch (Exception e) {
            json.put("succes", (Object)"false");
            json.put("msg", (Object)ExceptionUtil.parseMsg(e, 3000));
        }
        json.put("count", (Object)this.count.get());
        json.put("reCheckIds", (Object)this.reCheckIds.toString());
        return json.toJSONString();
    }

    private void doCheckAndUpdate() {
        DataSet data = this.getData();
        ArrayList<String> keys = new ArrayList<String>(this.batchSize);
        List<Object[]> params = null;
        for (Row row : data) {
            keys.add(row.getString("fkeycol"));
            if (keys.size() < this.batchSize) continue;
            params = this.check(keys);
            if (!params.isEmpty()) {
                this.updateBalQty(params);
            }
            keys.clear();
        }
        if (!keys.isEmpty()) {
            params = this.check(keys);
            if (!params.isEmpty()) {
                this.updateBalQty(params);
            }
            keys.clear();
        }
    }

    private List<String> getKeys(List<Object[]> params) {
        ArrayList<String> keys = new ArrayList<String>(params.size());
        for (Object[] param : params) {
            keys.add((String)param[param.length - 1]);
        }
        return keys;
    }

    private void updateBalQty(List<Object[]> params) {
        try (TXHandle tx = TX.requiresNew((String)"updateBalQty");){
            try {
                String updateSql = this.info.getUpdateSql();
                DB.executeBatch((DBRoute)this.tb.getDbRoute(), (String)updateSql, params);
                this.count.addAndGet(params.size());
                List<String> keys = this.getKeys(params);
                List<Object[]> newParams = this.check(keys);
                if (!newParams.isEmpty()) {
                    log.info("\u6821\u6b63\u5931\u8d25\uff1a" + keys);
                }
            }
            catch (Exception e) {
                tx.markRollback();
            }
        }
    }

    private StringBuilder getKeyColIn(List<String> keycols) {
        StringBuilder sql = new StringBuilder("fkeycol").append(" in ('");
        int i = 0;
        for (String keycol : keycols) {
            if (i != 0) {
                sql.append("','");
            }
            sql.append(keycol);
            ++i;
        }
        sql.append("') ");
        return sql;
    }

    private List<Object[]> check(List<String> keycols) {
        StringBuilder keyColIn = this.getKeyColIn(keycols);
        String spDataSql = this.info.getGroupSpDataSqlPart();
        String balDateSql = this.info.getSelectBalDataSqlPart();
        DataSet spData = DB.queryDataSet((String)"spData", (DBRoute)this.tb.getDbRoute(), (String)(spDataSql + keyColIn + "group by " + "fkeycol"));
        DataSet balData = DB.queryDataSet((String)"balData", (DBRoute)this.tb.getDbRoute(), (String)(balDateSql + keyColIn));
        JoinDataSet on = spData.join(balData).on("fkeycol", "fkeycol_bal");
        DataSet data = on.select(spData.getRowMeta().getFieldNames(), balData.getRowMeta().getFieldNames()).finish();
        String[] qtyCol = this.info.getQtyCol();
        String[] balQtyCol = this.info.getBalQtyCol();
        ArrayList<Object[]> params = new ArrayList<Object[]>(keycols.size());
        boolean notEqual = false;
        for (Row row : data) {
            notEqual = false;
            int len = qtyCol.length;
            for (int i = 0; i < len; ++i) {
                if (row.getBigDecimal(qtyCol[i]).compareTo(row.getBigDecimal(balQtyCol[i])) == 0) continue;
                notEqual = true;
                break;
            }
            if (!notEqual) continue;
            Object[] param = new Object[qtyCol.length + 1];
            int len2 = qtyCol.length;
            for (int i = 0; i < len2; ++i) {
                param[i] = row.getBigDecimal(qtyCol[i]);
            }
            param[qtyCol.length] = row.getString("fkeycol");
            params.add(param);
        }
        return params;
    }
}

