/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balance.recal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import org.apache.commons.lang3.StringUtils;

public class BalReCalCache {
    private static final IAppCache CACHE = AppCache.get((String)"im");
    public static final String PERCENT = "percent";
    public static final String TEXT = "text";
    private static final String KEY_SENT_TASK = "im_bal_sent_task";
    private static final String KEY_TASK_INFO = "im_bal_task_info";
    private static final String KEY_IS_RUNNING = "im_bal_is_running";
    private static final String KEY_BATCH_COUNT = "im_bal_batch_count";
    private static final String KEY_START_DATE = "im_bal_start_date";

    public static void setRunning(Object taskId) {
        CACHE.put(KEY_IS_RUNNING + taskId, (Object)"1");
    }

    public static void removeRunning(Object taskId) {
        CACHE.remove(KEY_IS_RUNNING + taskId);
    }

    public static boolean isRunning(Object taskId) {
        return CACHE.get(KEY_IS_RUNNING + taskId, String.class) != null;
    }

    public static void setStartDate(Date start, Long startPeriod) {
        CACHE.put(KEY_START_DATE + start.getTime(), (Object)startPeriod);
    }

    public static Long getStartDate(Date start) {
        return (Long)CACHE.get(KEY_START_DATE + start.getTime(), Long.class);
    }

    public static JSONObject getTaskInfo(Object taskId) {
        String key = KEY_TASK_INFO + taskId;
        return BalReCalCache.getPercentInfo(key);
    }

    public static void clearTaskPercent(Object taskId) {
        String key = KEY_TASK_INFO + taskId;
        CACHE.remove(key);
    }

    public static void setTaskPercent(Object taskId, int percent, String text) {
        String key = KEY_TASK_INFO + taskId;
        BalReCalCache.setPercent(key, percent, text);
    }

    public static JSONObject getReCalPercent() {
        return BalReCalCache.getPercentInfo(KEY_SENT_TASK);
    }

    private static JSONObject getPercentInfo(String key) {
        String value = (String)CACHE.get(key, String.class);
        JSONObject data = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value})) {
            data = JSON.parseObject((String)value);
        } else {
            data = new JSONObject();
            data.put(PERCENT, (Object)0);
            data.put(TEXT, (Object)"cache not find");
        }
        return data;
    }

    public static void setReCalPercent(int percent, String text) {
        BalReCalCache.setPercent(KEY_SENT_TASK, percent, text);
    }

    private static void setPercent(String key, int percent, String text) {
        JSONObject data = new JSONObject();
        data.put(PERCENT, (Object)percent);
        data.put(TEXT, (Object)text);
        CACHE.put(key, (Object)data.toJSONString());
    }

    public static void setReCalPercent(int count, int total, String text) {
        int percent = count * 100 / total;
        BalReCalCache.setReCalPercent(percent, text);
    }

    public static int getBatchCount() {
        Integer count = (Integer)CACHE.get(KEY_BATCH_COUNT, Integer.class);
        if (count == null) {
            return 1000;
        }
        return count;
    }

    public static void setBatchCount(int batchCount) {
        CACHE.put(KEY_BATCH_COUNT, (Object)batchCount);
    }

    public static IAppCache getImAppCache() {
        return CACHE;
    }
}

