/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balance.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.RowMeta;
import kd.bos.biz.balance.model.IDataTransform;
import kd.scmc.im.business.balance.transform.func.SetNullMapFunc;

public class SetNull4NoUpdateCols
implements IDataTransform {
    private String referCol;
    private Map<String, String> srcColMap;

    public SetNull4NoUpdateCols(String referCol, Map<String, String> srcColMap) {
        this.referCol = referCol;
        this.srcColMap = srcColMap;
    }

    public DataSet doTransform(DataSet srcData) {
        RowMeta rowMeta;
        if (srcData != null && (rowMeta = srcData.getRowMeta()).getFieldIndex(this.referCol, false) >= 0) {
            SetNullMapFunc func = new SetNullMapFunc(srcData.getRowMeta(), this.referCol);
            func.setColsMap(this.handleMap(this.srcColMap));
            srcData = srcData.map((MapFunction)func);
        }
        return srcData;
    }

    private Map<String, List<String>> handleMap(Map<String, String> srcColMap) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(srcColMap.size());
        for (Map.Entry<String, String> entry : srcColMap.entrySet()) {
            String srcKey = entry.getValue();
            String balKey = entry.getKey();
            List balKeys = result.computeIfAbsent(srcKey, k -> new ArrayList(8));
            balKeys.add(balKey);
            result.put(srcKey, balKeys);
        }
        return result;
    }
}

