/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.reserve.business.ReleaseHelper;
import kd.mpscmm.msbd.reserve.mservice.InventorySearchResult;
import kd.mpscmm.msbd.reserve.mservice.ReserveService;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.DemandModel;
import kd.scmc.im.business.balanceinv.pojo.MatchInfo;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.business.balanceinv.pojo.SupplyPolicy;
import kd.scmc.im.business.balanceinv.pojo.SupplyRelation;
import kd.scmc.im.business.balanceinv.pojo.UnMatchInfo;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.SupplyChainParameterHelper;
import kd.sdk.scmc.im.extpoint.IBalanceInvExpand;

public class BalanceInvExecuteHelper {
    private static String ALGO = "kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper";
    private static Log logger = LogFactory.getLog((String)"kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper");

    public static Long createBalanceInvLog(Map<String, Object> param) {
        BalanceInvExecuteHelper.checkLicense();
        Long balanceOrgId = (Long)param.get("balanceOrgId");
        DynamicObject calcLogInfo = BusinessDataServiceHelper.newDynamicObject((String)BalanceInvLogConstants.ENTITY_NUM);
        calcLogInfo.set(BalanceInvLogConstants.BALANCE_ORG, (Object)balanceOrgId);
        QFilter[] filterArr = new QFilter("balanceinvorg", "=", (Object)balanceOrgId).and("enable", "=", (Object)"1").toArray();
        DynamicObjectCollection schemeCol = QueryServiceHelper.query((String)"balanceinv_scheme", (String)"id", (QFilter[])filterArr, (String)"", (int)1);
        if (schemeCol != null && !schemeCol.isEmpty()) {
            calcLogInfo.set(BalanceInvLogConstants.SCHEME, (Object)((DynamicObject)schemeCol.get(0)).getLong("id"));
        }
        String calculateNum = BalanceInvExecuteHelper.genCalculateNum();
        calcLogInfo.set(BalanceInvLogConstants.CAL_NUM, (Object)calculateNum);
        calcLogInfo.set(BalanceInvLogConstants.STATUS, (Object)BalanceInvLogConstants.STEP_RESULT_A);
        calcLogInfo.set(BalanceInvLogConstants.START_TIME, (Object)TimeServiceHelper.now());
        RequestContext requestContext = RequestContext.get();
        calcLogInfo.set(BalanceInvLogConstants.EXECUTOR, (Object)requestContext.getCurrUserId());
        String loginIP = requestContext.getLoginIP();
        if (!StringUtils.isEmpty((String)loginIP) && loginIP.length() > 50) {
            loginIP = loginIP.substring(0, 50);
        }
        calcLogInfo.set(BalanceInvLogConstants.EXECUTE_IP, (Object)loginIP);
        QFilter filter = new QFilter("calctype", "=", (Object)"A");
        DynamicObjectCollection stepCol = QueryServiceHelper.query((String)"kd.scmc.im.business.balanceinv.BalanceInvLogHelper", (String)"im_balanceinv_step", (String)"id,step,name,implclass", (QFilter[])filter.toArray(), (String)"step");
        DynamicObjectCollection logEntries = calcLogInfo.getDynamicObjectCollection(BalanceInvLogConstants.ENTRY_ENTITY);
        int seq = 1;
        for (DynamicObject stepInfo : stepCol) {
            Long stepId = stepInfo.getLong("id");
            DynamicObject logEntry = logEntries.addNew();
            logEntry.set(BalanceInvLogConstants.CAL_STEP, (Object)stepId);
            logEntry.set("seq", (Object)seq++);
        }
        DistributeSessionlessCache sessionLessCache = BalanceInvExecuteHelper.getDistributeSessionlessCache();
        sessionLessCache.put(calculateNum, (Object)BalanceInvLogConstants.STATUS_RUNNING);
        Object[] logArr = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcLogInfo});
        return ((DynamicObject)logArr[0]).getLong("id");
    }

    public static DistributeSessionlessCache getDistributeSessionlessCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("balanceInventory");
    }

    public static String genCalculateNum() {
        ORM orm = ORM.create();
        return orm.genLongId("im_balanceinv_matchdetail") + "";
    }

    public static String getBillOperateErrorMsg(OperationResult operateResult) {
        StringBuilder errorMsgBuilder = new StringBuilder();
        if (!StringUtils.isEmpty((String)operateResult.getMessage())) {
            errorMsgBuilder.append(operateResult.getMessage()).append("\n");
        }
        List allErrorOrValidateInfo = operateResult.getAllErrorOrValidateInfo();
        Map<String, String> errorMap = BalanceInvExecuteHelper.getOperateErrorMsg(allErrorOrValidateInfo);
        Map billNos = operateResult.getBillNos();
        for (Map.Entry<String, String> error : errorMap.entrySet()) {
            if (!StringUtils.isEmpty((String)((String)billNos.get(error.getKey())))) {
                errorMsgBuilder.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a", (String)"BalanceInvExecuteHelper_0", (String)"scmc-im-business", (Object[])new Object[0])).append((String)billNos.get(error.getKey())).append("\n");
            }
            errorMsgBuilder.append(error.getValue());
        }
        return errorMsgBuilder.toString();
    }

    public static Map<String, String> getOperateErrorMsg(List<IOperateInfo> allErrorOrValidateInfo) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        if (allErrorOrValidateInfo != null && !allErrorOrValidateInfo.isEmpty()) {
            for (IOperateInfo operateInfo : allErrorOrValidateInfo) {
                Object billId = operateInfo.getPkValue();
                errorMap.putIfAbsent(billId.toString(), "");
                errorMap.put(billId.toString(), (String)errorMap.get(billId.toString()) + operateInfo.getMessage() + "\n");
            }
        }
        return errorMap;
    }

    public static String getExceptionMessage(Throwable e) {
        StringBuilder builder = new StringBuilder();
        if (e.getCause() != null) {
            builder.append(e.getCause()).append("\n");
            int i = 0;
            for (StackTraceElement stackTraceElement : e.getCause().getStackTrace()) {
                builder.append(stackTraceElement).append("\n");
                if (++i < 10) continue;
                builder.append("...").append("\n");
                break;
            }
        } else {
            builder.append(e).append("\n");
            int i = 0;
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                builder.append(stackTraceElement).append("\n");
                if (++i < 10) continue;
                builder.append("...").append("\n");
                break;
            }
        }
        return builder.toString();
    }

    public static Set<Long> getDemandMaterialIdSet(String entityNum, BalanceInventoryScheme balanceScheme, List<Long> entryIds) {
        List<QFilter> demandFilter = BalanceInvExecuteHelper.getDemandFilter(entityNum, entryIds, balanceScheme, true);
        Map<String, String> target2SourceFieldMap = balanceScheme.getDemandModel().getTarget2SourceFieldMap(entityNum);
        String materialField = target2SourceFieldMap.get("entryentity.material");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)entityNum, (String)materialField, (QFilter[])demandFilter.toArray(new QFilter[0]), (String)"");
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        for (Row row : dataSet) {
            materialIdSet.add(row.getLong(materialField));
        }
        return materialIdSet;
    }

    public static List<QFilter> getDemandFilter(String entityNum, List<Long> entryIds, BalanceInventoryScheme balanceScheme, boolean filterDataSource) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        DemandModel demandModel = balanceScheme.getDemandModel();
        String entryField = BalanceInvExecuteHelper.getDemandEntryField(entityNum, balanceScheme);
        if (entryIds != null && !entryIds.isEmpty()) {
            QFilter idFilter = new QFilter(entryField + ".id", "in", entryIds);
            filterList.add(idFilter);
        }
        if (filterDataSource) {
            QFilter dataSourceFilter = demandModel.getDataSourceFilter(entityNum);
            if (dataSourceFilter != null) {
                filterList.add(dataSourceFilter);
            }
            String demandOrgField = demandModel.getTarget2SourceFieldMap(entityNum).get("entryentity.demandorg");
            Set<Long> demandOrgIds = balanceScheme.getSupplyPolicyMap().keySet();
            QFilter demandOrgFilter = new QFilter(demandOrgField, "in", demandOrgIds);
            filterList.add(demandOrgFilter);
        }
        return filterList;
    }

    public static Object getValue(RowMeta rowMeta, Row row, String field) {
        if (rowMeta.getFieldIndex(field, false) < 0) {
            return null;
        }
        return row.get(field);
    }

    public static Object getValue(DynamicObject dynamicObject, String prop) {
        if (!dynamicObject.containsProperty(prop)) {
            return null;
        }
        return dynamicObject.get(prop);
    }

    public static ConvertOperationResult convertBill(String sourceEntity, String targetEntity, List<ListSelectedRow> selectedRows, String botpRuleId, boolean isSave) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceEntity);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setSelectedRows(selectedRows);
        pushArgs.setShowReport(true);
        pushArgs.setHasRight(false);
        pushArgs.setBuildConvReport(true);
        if (botpRuleId != null) {
            pushArgs.setRuleId(botpRuleId);
        }
        ConvertOperationResult covertResult = isSave ? ConvertServiceHelper.pushAndSave((PushArgs)pushArgs) : ConvertServiceHelper.push((PushArgs)pushArgs);
        return covertResult;
    }

    public static String getConvertErrorMsg(ConvertOperationResult result) {
        StringBuilder errorMsgBuilder = new StringBuilder();
        if (!StringUtils.isEmpty((String)result.getMessage())) {
            errorMsgBuilder.append(result.getMessage()).append("\n");
        }
        if (result.getBillReports() != null && !result.getBillReports().isEmpty()) {
            errorMsgBuilder.append(result.getBillReports().toString()).append("\n");
        }
        return errorMsgBuilder.toString();
    }

    public static String getDemandEntryField(String entityNum, BalanceInventoryScheme balanceScheme) {
        String entryField = balanceScheme.getDemandModel().getTarget2SourceFieldMap(entityNum).get("entryentity.material");
        if (entryField.contains(".")) {
            return entryField.split("\\.")[0];
        }
        return entryField;
    }

    public static Long getDemandInvOrg(Object demandOrg, Map<Long, Long> demandOrgCache) {
        if (demandOrg == null) {
            return null;
        }
        Long demandOrgId = null;
        demandOrgId = demandOrg instanceof DynamicObject ? Long.valueOf(((DynamicObject)demandOrg).getLong("id")) : (Long)demandOrg;
        if (!demandOrgCache.containsKey(demandOrgId)) {
            Long demandInvOrgId = 0L;
            DynamicObject demandOrgInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)demandOrgId, (String)"bos_org", (String)"fisinventory");
            if (demandOrgInfo.getBoolean("fisinventory") && NewInvOrgHelper.isStartInv(demandOrgId)) {
                demandInvOrgId = demandOrgId;
            } else {
                Map result = OrgUnitServiceHelper.getCompanyByOrg((Long)demandOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                if (result != null) {
                    Long companyId = (Long)result.get("id");
                    OrgRelationParam param = new OrgRelationParam();
                    param.setOrgId(companyId.longValue());
                    param.setFromViewType("10");
                    param.setToViewType("05");
                    param.setDirectViewType("toorg");
                    Map orgRelationMap = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
                    List orgRelations = (List)orgRelationMap.get("data");
                    if (orgRelations != null && !orgRelations.isEmpty()) {
                        Long defaultOrgId = null;
                        for (Map orgRelation : orgRelations) {
                            if (!Boolean.TRUE.equals(orgRelation.get("isDefault"))) continue;
                            defaultOrgId = (Long)orgRelation.get("orgId");
                            break;
                        }
                        if (defaultOrgId == null) {
                            defaultOrgId = (Long)((Map)orgRelations.get(0)).get("orgId");
                        }
                        demandInvOrgId = defaultOrgId;
                    }
                }
            }
            demandOrgCache.put(demandOrgId, demandInvOrgId);
        }
        return demandOrgCache.get(demandOrgId);
    }

    public static BigDecimal calculateQtyByBaseQty(BigDecimal matchBaseQty, long materialId, long unitId, long baseUnitId, Map<Long, Integer> unitPrecisionCache) {
        int unitPrecision = BalanceInvExecuteHelper.getUnitPrecision(unitId, unitPrecisionCache);
        BigDecimal unitRate = BillUnitAndQtytHelper.getUnitRateConv(materialId, unitId, baseUnitId);
        if (unitRate.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return matchBaseQty.divide(unitRate, unitPrecision, RoundingMode.HALF_UP);
    }

    public static int getUnitPrecision(Long unitId, Map<Long, Integer> unitPrecisionCache) {
        if (unitId == null) {
            return 10;
        }
        if (!unitPrecisionCache.containsKey(unitId)) {
            DynamicObject unit = BusinessDataServiceHelper.loadSingleFromCache((Object)unitId, (String)"bd_measureunits", (String)"precision");
            if (unit != null) {
                unitPrecisionCache.put(unitId, unit.getInt("precision"));
            } else {
                unitPrecisionCache.put(unitId, 10);
            }
        }
        return unitPrecisionCache.get(unitId);
    }

    public static DynamicObject addMatchResultEntry(DynamicObject demandBill, DynamicObject supplyBill, MatchInfo matchInfo, int demandOrder) {
        DynamicObject newEntry;
        BalanceInvContext context = BalanceInvContext.get();
        BalanceInventoryScheme balanceScheme = context.getScheme();
        Long matchDetailId = context.getMatchDetailId();
        DynamicObject matchResultInfo = context.getMatchResultInfo();
        if (matchResultInfo != null) {
            newEntry = context.getMatchResultInfo().getDynamicObjectCollection("entryentity").addNew();
        } else {
            newEntry = ORM.create().newDynamicObject("im_balanceinv_matchentry");
            newEntry.set("matchid", (Object)matchDetailId);
        }
        if (newEntry == null) {
            return null;
        }
        Map<String, String> demandMatchResultFieldMap = balanceScheme.getDemandMatchResultFieldMap();
        Map<String, String> supplyMatchResultFieldMap = balanceScheme.getSupplyMatchResultFieldMap();
        for (Map.Entry<String, String> demandMatchField : demandMatchResultFieldMap.entrySet()) {
            newEntry.set(demandMatchField.getValue(), BalanceInvExecuteHelper.getValue(demandBill, demandMatchField.getKey()));
        }
        for (Map.Entry<String, String> supplyMatchField : supplyMatchResultFieldMap.entrySet()) {
            newEntry.set(supplyMatchField.getValue(), BalanceInvExecuteHelper.getValue(supplyBill, supplyMatchField.getKey()));
        }
        newEntry.set("invorg", (Object)context.getBalanceOrgId());
        newEntry.set("previousbaseqty", (Object)matchInfo.getOriginDemandBaseQty());
        newEntry.set("demandbaseqty", (Object)matchInfo.getCurrentDemandBaseQty());
        newEntry.set("matchbaseqty", (Object)matchInfo.getMatchBaseQty());
        newEntry.set("matchqty", (Object)matchInfo.getMatchQty());
        newEntry.set("matchqty2nd", (Object)matchInfo.getMatchQty2nd());
        newEntry.set("level", (Object)demandOrder);
        String supplyType = BalanceInvExecuteHelper.getSupplyType(demandBill, supplyBill);
        newEntry.set("supplytype", (Object)supplyType);
        newEntry.set("supplytypelevel", (Object)BalanceInvExecuteHelper.getSupplyTypeOrder(supplyType));
        String billType = demandBill.getString("entryentity.billtype");
        if (!billType.equals("invp_safestock_record")) {
            String adviceType;
            String supplyDetailOrder;
            String invType = supplyBill.getString("entryentity.invtype");
            if ("B".equals(invType)) {
                supplyDetailOrder = BalanceInvExecuteHelper.getPreSupplyDetailOrder(balanceScheme, supplyBill, demandBill.getLong("entryentity.demandorg"));
                adviceType = "G";
            } else {
                supplyDetailOrder = BalanceInvExecuteHelper.getSupplyDetailOrder(supplyBill);
                adviceType = BalanceInvExecuteHelper.getBalanceAdviseType(supplyType);
            }
            newEntry.set("advicetype", (Object)adviceType);
            newEntry.set("supplydetaillevel", (Object)supplyDetailOrder);
        }
        return newEntry;
    }

    private static String getSupplyType(DynamicObject demandBill, DynamicObject supplyBill) {
        String supplyType = "A";
        long demandOrgId = demandBill.getLong("entryentity.demandorg");
        long supplyOrgId = supplyBill.getLong("entryentity.supplyorgunit");
        String ownerType = supplyBill.getString("entryentity.owertype");
        if ("bd_supplier".equals(ownerType)) {
            supplyType = "D";
            Long supplyStockOrgId = supplyBill.getLong("entryentity.stockorg");
            if (supplyStockOrgId != null) {
                BalanceInvContext ctx = BalanceInvContext.get();
                if (!ctx.getDemandCompanyMap().containsKey(demandOrgId)) {
                    Map result = OrgUnitServiceHelper.getCompanyByOrg((Long)demandOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                    if (result != null && !result.isEmpty()) {
                        ctx.getDemandCompanyMap().put(demandOrgId, (Long)result.get("id"));
                    } else {
                        ctx.getDemandCompanyMap().put(demandOrgId, null);
                    }
                }
                if (!ctx.getSupplyInvOrgCompanyMap().containsKey(supplyStockOrgId)) {
                    OrgRelationParam param = new OrgRelationParam();
                    param.setOrgId(supplyStockOrgId.longValue());
                    param.setFromViewType("10");
                    param.setToViewType("05");
                    param.setDirectViewType("fromorg");
                    param.setIncludeSelf(true);
                    List bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
                    HashSet companyOrgs = new HashSet(bizRelationOrgIds);
                    ctx.getSupplyInvOrgCompanyMap().put(supplyStockOrgId, companyOrgs);
                }
                Long demandCompanyOrgId = ctx.getDemandCompanyMap().get(demandOrgId);
                Set<Long> supplyCompanyOrgs = ctx.getSupplyInvOrgCompanyMap().get(supplyStockOrgId);
                if (demandCompanyOrgId != null && supplyCompanyOrgs.contains(demandCompanyOrgId)) {
                    supplyType = "C";
                }
            }
        } else {
            supplyType = demandOrgId == supplyOrgId ? "A" : "B";
        }
        return supplyType;
    }

    private static Integer getSupplyTypeOrder(String supplyType) {
        switch (supplyType) {
            case "A": {
                return 1;
            }
            case "C": {
                return 2;
            }
            case "B": {
                return 3;
            }
            case "D": {
                return 4;
            }
        }
        return 0;
    }

    private static String getSupplyDetailOrder(DynamicObject supplyBill) {
        StringBuilder detailOrder = new StringBuilder();
        detailOrder.append(supplyBill.getInt("invstatuspriority"));
        detailOrder.append("-").append(supplyBill.getInt("priority"));
        detailOrder.append("-");
        if (BalanceInvExecuteHelper.getValue(supplyBill, "supplypriority") != null && supplyBill.getInt("supplypriority") != -1) {
            detailOrder.append(supplyBill.getInt("supplypriority"));
        } else {
            detailOrder.append("?");
        }
        detailOrder.append("-");
        if (supplyBill.getInt("supplyorder") != -1) {
            detailOrder.append(supplyBill.getInt("supplyorder"));
        } else {
            detailOrder.append("?");
        }
        return detailOrder.toString();
    }

    private static String getPreSupplyDetailOrder(BalanceInventoryScheme balanceScheme, DynamicObject supplyBill, Long demandOrg) {
        SupplyPolicy supplyPolicy;
        StringBuilder detailOrder = new StringBuilder();
        detailOrder.append("?").append("-");
        Long stockOrgId = supplyBill.getLong("entryentity.stockorg");
        String stockOrgOrder = "?";
        if (stockOrgId != null && stockOrgId != 0L && (supplyPolicy = balanceScheme.getSupplyPolicyMap().get(demandOrg)) != null && supplyPolicy.getStorageOrderMap().containsKey(stockOrgId)) {
            stockOrgOrder = String.valueOf(supplyPolicy.getStorageOrderMap().get(stockOrgId));
        }
        detailOrder.append(stockOrgOrder).append("-");
        detailOrder.append("?").append("-");
        String supplyRelationOrder = "?";
        Long supplyOrgId = supplyBill.getLong("entryentity.supplyorgunit");
        SupplyRelation supplyRelation = balanceScheme.getSupplyRelationMap().get(demandOrg);
        if (supplyRelation != null && supplyRelation.getSupplyOrg2OrderMap().containsKey(supplyOrgId)) {
            supplyRelationOrder = String.valueOf(supplyRelation.getSupplyOrg2OrderMap().get(supplyOrgId));
        }
        detailOrder.append(supplyRelationOrder);
        return detailOrder.toString();
    }

    public static String getMatchedGroupValue(DynamicObject matchEntryInfo) {
        BalanceInvContext context = BalanceInvContext.get();
        List<String> splitRuleFields = context.getScheme().getSplitRuleFields();
        StringBuilder matchedGroupValueSb = new StringBuilder();
        if (splitRuleFields.isEmpty()) {
            matchedGroupValueSb.append(matchEntryInfo.getString("advicetype")).append("$");
            matchedGroupValueSb.append(matchEntryInfo.getString("demandbilltype")).append("$");
            matchedGroupValueSb.append(matchEntryInfo.getString("demandorg")).append("$");
            matchedGroupValueSb.append(matchEntryInfo.getString("invorg")).append("$");
            matchedGroupValueSb.append(matchEntryInfo.getString("supplyorg")).append("$");
            if ("C".equals(matchEntryInfo.getString("supplytype")) || "D".equals(matchEntryInfo.getString("supplytype"))) {
                matchedGroupValueSb.append(matchEntryInfo.getString("supplyowner")).append("$");
            }
            matchedGroupValueSb.append(matchEntryInfo.getString("biztype")).append("$");
            matchedGroupValueSb.append(matchEntryInfo.getString("demandkind")).append("$");
            matchedGroupValueSb.append(matchEntryInfo.getString("invstatus")).append("$");
        } else {
            for (String splitRuleField : splitRuleFields) {
                matchedGroupValueSb.append(matchEntryInfo.getString(splitRuleField)).append("$");
            }
        }
        return matchedGroupValueSb.toString();
    }

    public static DynamicObject addNoSupplyMatchResultEntry(DynamicObject demandBill, BigDecimal originDemandBaseQty, BigDecimal curDemandBaseQty, int demandOrder) {
        DynamicObject newEntry;
        BalanceInvContext context = BalanceInvContext.get();
        DynamicObject matchResultInfo = context.getMatchResultInfo();
        if (matchResultInfo != null) {
            newEntry = context.getMatchResultInfo().getDynamicObjectCollection("entryentity").addNew();
        } else {
            newEntry = ORM.create().newDynamicObject("im_balanceinv_matchentry");
            newEntry.set("matchid", (Object)context.getMatchDetailId());
        }
        if (newEntry == null) {
            return null;
        }
        Map<String, String> demandMatchResultFieldMap = context.getScheme().getDemandMatchResultFieldMap();
        for (Map.Entry<String, String> matchField : demandMatchResultFieldMap.entrySet()) {
            newEntry.set(matchField.getValue(), BalanceInvExecuteHelper.getValue(demandBill, matchField.getKey()));
        }
        newEntry.set("invorg", (Object)context.getBalanceOrgId());
        newEntry.set("level", (Object)demandOrder);
        newEntry.set("previousbaseqty", (Object)originDemandBaseQty);
        newEntry.set("demandbaseqty", (Object)curDemandBaseQty);
        newEntry.set("extrainfo", (Object)ResManager.loadKDString((String)"\u65e0\u5339\u914d\u7684\u4f9b\u5e94\u6570\u636e\uff0c\u8f6c\u51c0\u9700\u6c42\u3002", (String)"BalanceInvExecuteHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
        return newEntry;
    }

    public static UnMatchInfo buildUnMatchInfo(DynamicObject demandBill, BigDecimal demandQty) {
        UnMatchInfo unMatchInfo = new UnMatchInfo();
        unMatchInfo.setUnMatchQty(demandQty);
        if (BalanceInvExecuteHelper.getValue(demandBill, "entryentity.billid") != null) {
            unMatchInfo.setBillId(demandBill.getLong("entryentity.billid"));
        }
        if (BalanceInvExecuteHelper.getValue(demandBill, "entryentity.billentryid") != null) {
            unMatchInfo.setEntryId(demandBill.getLong("entryentity.billentryid"));
        }
        if (BalanceInvExecuteHelper.getValue(demandBill, "entryentity.billentity") != null) {
            unMatchInfo.setDemandSrcBillEntityNum(demandBill.getString("entryentity.billentity"));
        }
        if (BalanceInvExecuteHelper.getValue(demandBill, "entryentity.demandtype") != null) {
            unMatchInfo.setDemandKind(demandBill.getString("entryentity.demandtype"));
        }
        if (BalanceInvExecuteHelper.getValue(demandBill, "entryentity.biztype") != null) {
            unMatchInfo.setBizType(demandBill.getLong("entryentity.biztype"));
        }
        if (BalanceInvExecuteHelper.getValue(demandBill, "entryentity.balanceinvorg") != null) {
            unMatchInfo.setBalanceOrgId(demandBill.getLong("entryentity.balanceinvorg"));
        }
        if (BalanceInvExecuteHelper.getValue(demandBill, "entryentity.demandorg") != null) {
            unMatchInfo.setDemandOrgId(demandBill.getLong("entryentity.demandorg"));
        }
        if (BalanceInvExecuteHelper.getValue(demandBill, "entryentity.material") != null) {
            unMatchInfo.setMaterialId(demandBill.getLong("entryentity.material"));
        }
        if (BalanceInvExecuteHelper.getValue(demandBill, "entryentity.baseunit") != null) {
            unMatchInfo.setBaseUnitId(demandBill.getLong("entryentity.baseunit"));
        }
        return unMatchInfo;
    }

    public static UnMatchInfo buildUnMatchInfo(DynamicObject matchDetailInfo, String entityNumber) {
        UnMatchInfo unMatchInfo = new UnMatchInfo();
        unMatchInfo.setMatchEntryInfo(matchDetailInfo);
        unMatchInfo.setUnMatchQty(matchDetailInfo.getBigDecimal("demandbaseqty"));
        unMatchInfo.setBillId(matchDetailInfo.getLong("demandbillid"));
        unMatchInfo.setEntryId(matchDetailInfo.getLong("demandentryid"));
        unMatchInfo.setDemandSrcBillEntityNum(entityNumber);
        unMatchInfo.setDemandKind(matchDetailInfo.getString("demandkind"));
        unMatchInfo.setBizType(matchDetailInfo.getLong("biztype"));
        unMatchInfo.setBalanceOrgId(matchDetailInfo.getLong("invorg"));
        unMatchInfo.setDemandOrgId(matchDetailInfo.getLong("demandorg"));
        unMatchInfo.setMaterialId(matchDetailInfo.getLong("materiel"));
        unMatchInfo.setBaseUnitId(matchDetailInfo.getLong("baseunit"));
        unMatchInfo.setAdviseType(matchDetailInfo.getString("advicetype"));
        return unMatchInfo;
    }

    public static Map<String, List<UnMatchInfo>> getGroupedUnMatchInfoWithAdviseType(String entityNum, Map<Long, List<UnMatchInfo>> unMatchMapGByEntryId) {
        Map gatherPathResult;
        Map purStrategyResult;
        Serializable gatherPathParamMap;
        if (unMatchMapGByEntryId.isEmpty()) {
            return new HashMap<String, List<UnMatchInfo>>(0);
        }
        Boolean debugMode = BalanceInvContext.get().getDebugMode();
        ArrayList categoryParamList = new ArrayList();
        ArrayList purStrategyParamList = new ArrayList();
        ArrayList<Serializable> gatherPathParamList = new ArrayList<Serializable>();
        int uniqueKey = 0;
        for (List<UnMatchInfo> unMatchInfoList : unMatchMapGByEntryId.values()) {
            for (UnMatchInfo unMatchInfo : unMatchInfoList) {
                if ("invp_safestock_record".equals(entityNum)) {
                    HashMap<String, Object> categoryParamMap = new HashMap<String, Object>();
                    categoryParamMap.put("baseDataType", "2");
                    categoryParamMap.put("orgId", unMatchInfo.getBalanceOrgId());
                    categoryParamMap.put("baseDataId", unMatchInfo.getMaterialId());
                    categoryParamMap.put("bizType", unMatchInfo.getDemandKind().equals("A") ? "2" : "3");
                    categoryParamList.add(categoryParamMap);
                }
                HashMap<String, Object> purStrategyParamMap = new HashMap<String, Object>();
                purStrategyParamMap.put("baseDataType", "2");
                purStrategyParamMap.put("orgId", unMatchInfo.getBalanceOrgId());
                purStrategyParamMap.put("baseDataId", unMatchInfo.getMaterialId());
                purStrategyParamMap.put("billId", unMatchInfo.getBillId());
                purStrategyParamList.add(purStrategyParamMap);
                gatherPathParamMap = new HashMap();
                gatherPathParamMap.put("org", unMatchInfo.getBalanceOrgId());
                gatherPathParamMap.put("kind", unMatchInfo.getDemandKind());
                gatherPathParamMap.put("material", unMatchInfo.getMaterialId());
                unMatchInfo.setUniqueKey("" + uniqueKey);
                ++uniqueKey;
                gatherPathParamMap.put("uniqueKey", unMatchInfo.getUniqueKey());
                gatherPathParamList.add(gatherPathParamMap);
            }
        }
        if (debugMode.booleanValue()) {
            logger.info("\u8c03\u7528\u91c7\u8d2d\u76ee\u5f55\u63a5\u53e3\u7684\u53c2\u6570\uff1a\n" + categoryParamList);
            logger.info("\u8c03\u7528\u91c7\u8d2d\u6267\u884c\u7b56\u7565\u63a5\u53e3\u7684\u53c2\u6570\uff1a\n" + purStrategyParamList);
            logger.info("\u8c03\u7528\u9700\u6c42\u6c47\u603b\u8def\u5f84\u670d\u52a1\u63a5\u53e3\u7684\u53c2\u6570\uff1a\n" + gatherPathParamList);
        }
        Map categoryResult = null;
        Map reqEntryInfoMap = null;
        EntityTraceSpan span = EntityTracer.create((String)"BalanceInventoryOp", (String)"outService");
        gatherPathParamMap = null;
        try {
            if ("pm_requirapplybill".equals(entityNum)) {
                HashSet<Long> entryIds = new HashSet<Long>(unMatchMapGByEntryId.keySet());
                reqEntryInfoMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pssc", (String)"IPassReqBillService", (String)"queryReqStrategyInfo", (Object[])new Object[]{entryIds});
            }
            if ("invp_safestock_record".equals(entityNum)) {
                categoryResult = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"pbd", (String)"ICategoryService", (String)"batchGetPurChaseOrg", (Object[])new Object[]{categoryParamList, entityNum});
                if (debugMode.booleanValue()) {
                    logger.info("\u8c03\u7528\u91c7\u8d2d\u76ee\u5f55\u63a5\u53e3\u7684\u8fd4\u56de\u503c\u4e3a:\n" + SerializationUtils.toJsonString((Object)categoryResult));
                }
            }
            purStrategyResult = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"pbd", (String)"ICategoryService", (String)"matchPurChaseStrategy", (Object[])new Object[]{purStrategyParamList, entityNum});
            String resultJson = (String)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pssc", (String)"IReqGatherPathService", (String)"queryReqGatherPath", (Object[])new Object[]{SerializationUtils.toJsonString(gatherPathParamList)});
            if (debugMode.booleanValue()) {
                logger.info("\u8c03\u7528\u91c7\u8d2d\u6267\u884c\u7b56\u7565\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a:\n" + SerializationUtils.toJsonString((Object)purStrategyResult));
                logger.info("\u8c03\u7528\u9700\u6c42\u6c47\u603b\u8def\u5f84\u670d\u52a1\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a:\n" + resultJson);
            }
            gatherPathResult = (Map)SerializationUtils.fromJsonString((String)resultJson, Map.class);
        }
        catch (Throwable resultJson) {
            gatherPathParamMap = resultJson;
            throw resultJson;
        }
        finally {
            if (span != null) {
                if (gatherPathParamMap != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable resultJson) {
                        ((Throwable)gatherPathParamMap).addSuppressed(resultJson);
                    }
                } else {
                    span.close();
                }
            }
        }
        Map categoryMap = null;
        if (categoryResult != null && ((Boolean)categoryResult.get("success")).booleanValue()) {
            categoryMap = (Map)categoryResult.get("data");
        }
        Map purStrategyMap = null;
        if (purStrategyResult != null && ((Boolean)purStrategyResult.get("success")).booleanValue()) {
            purStrategyMap = (Map)purStrategyResult.get("data");
        }
        HashMap<String, String> gatherPathMap = new HashMap<String, String>();
        if (gatherPathResult != null && ((Boolean)gatherPathResult.get("success")).booleanValue()) {
            List gatherPathList = (List)gatherPathResult.get("data");
            for (Map gatherPathValue : gatherPathList) {
                gatherPathMap.put((String)gatherPathValue.get("uniqueKey"), (String)gatherPathValue.get("value"));
            }
        }
        HashMap<String, Set<Long>> billEntryMap = new HashMap<String, Set<Long>>();
        billEntryMap.put(entityNum, unMatchMapGByEntryId.keySet());
        Map entryIdTypeMap = new HashMap();
        BalanceInvContext context = BalanceInvContext.get();
        PluginProxy objectPluginProxy = PluginProxy.create(IBalanceInvExpand.class, (String)"SCMC_IM_BALANCEINVEXPEND");
        List maps = objectPluginProxy.callReplace(p -> p.getEntryAdviseType(context.getScheme().getId(), billEntryMap));
        if (maps != null && !maps.isEmpty() && maps.get(0) != null) {
            entryIdTypeMap = (Map)maps.get(0);
        }
        HashMap<String, List<UnMatchInfo>> groupedUnMatchMap = new HashMap<String, List<UnMatchInfo>>();
        for (List<UnMatchInfo> unMatchInfoList : unMatchMapGByEntryId.values()) {
            for (UnMatchInfo unMatchInfo : unMatchInfoList) {
                Long entryId = unMatchInfo.getEntryId();
                String adviseType = (String)entryIdTypeMap.get(entryId);
                if (StringUtils.isEmpty((String)adviseType)) {
                    adviseType = BalanceInvExecuteHelper.getUnMatchAdviseType(unMatchInfo, categoryMap, purStrategyMap, gatherPathMap, reqEntryInfoMap);
                }
                if (debugMode.booleanValue()) {
                    logger.info("\u672a\u5339\u914d\u4fe1\u606f\uff1a" + unMatchInfo + "\n \u83b7\u53d6\u7684\u5efa\u8bae\u7c7b\u578b\u4e3a\uff1a" + adviseType);
                }
                unMatchInfo.setAdviseType(adviseType);
                unMatchInfo.getMatchEntryInfo().set("advicetype", (Object)adviseType);
                String unMatchGroupValue = BalanceInvExecuteHelper.getUnMatchGroupValue(unMatchInfo);
                groupedUnMatchMap.putIfAbsent(unMatchGroupValue, new ArrayList());
                ((List)groupedUnMatchMap.get(unMatchGroupValue)).add(unMatchInfo);
            }
        }
        return groupedUnMatchMap;
    }

    private static String getUnMatchGroupValue(UnMatchInfo unMatchInfo) {
        BalanceInvContext context = BalanceInvContext.get();
        List<String> splitRuleFields = context.getScheme().getSplitRuleFields();
        StringBuilder groupValueSb = new StringBuilder();
        groupValueSb.append(unMatchInfo.getAdviseType()).append("$");
        if (splitRuleFields.isEmpty()) {
            groupValueSb.append(unMatchInfo.getBalanceOrgId()).append("$");
            groupValueSb.append(unMatchInfo.getDemandOrgId()).append("$");
            groupValueSb.append(unMatchInfo.getDemandKind()).append("$");
            groupValueSb.append(unMatchInfo.getDemandSrcBillEntityNum()).append("$");
            groupValueSb.append(unMatchInfo.getBizType()).append("$");
        } else {
            DynamicObject matchEntryInfo = unMatchInfo.getMatchEntryInfo();
            for (String splitRuleField : splitRuleFields) {
                groupValueSb.append(matchEntryInfo.getString(splitRuleField)).append("$");
            }
        }
        return groupValueSb.toString();
    }

    private static String getUnMatchAdviseType(UnMatchInfo unMatchInfo, Map<String, Map<String, Object>> catorgyMap, Map<String, Map<String, Object>> purStrategyMap, Map<String, String> gatherPathMap, Map<Long, Map<String, String>> reqEntryInfoMap) {
        Boolean debugMode = BalanceInvContext.get().getDebugMode();
        if (catorgyMap != null) {
            Map<String, Object> categoryValue = catorgyMap.get(unMatchInfo.getCategoryKey());
            if (debugMode.booleanValue()) {
                logger.info("\u83b7\u53d6\u91c7\u8d2d\u76ee\u5f55\u63a5\u53e3\u7ed3\u679c\u7684\u952e\u503c\uff1a" + unMatchInfo.getCategoryKey() + ",\u7ed3\u679c\uff1a" + categoryValue);
            }
            if (categoryValue == null) {
                return "A";
            }
            if ("2".equals(categoryValue.get("classtype"))) {
                return "A";
            }
        } else if (reqEntryInfoMap != null) {
            Long entryId = unMatchInfo.getEntryId();
            Map<String, String> reqEntryInfo = reqEntryInfoMap.get(entryId);
            if (reqEntryInfo == null) {
                return "A";
            }
            String reqKind = reqEntryInfo.get("reqKind");
            String classType = reqEntryInfo.get("classType");
            if (StringUtils.isEmpty((String)reqKind) || "B".equals(reqKind)) {
                return "A";
            }
            if (StringUtils.isEmpty((String)classType) || "2".equals(classType)) {
                return "A";
            }
        }
        if (purStrategyMap != null) {
            Map<String, Object> purStrategyValue = purStrategyMap.get(unMatchInfo.getPurStrategyKey());
            if (debugMode.booleanValue()) {
                logger.info("\u83b7\u53d6\u91c7\u8d2d\u6267\u884c\u7b56\u7565\u63a5\u53e3\u7ed3\u679c\u7684\u952e\u503c\uff1a" + unMatchInfo.getPurStrategyKey() + ",\u7ed3\u679c\uff1a" + purStrategyValue);
            }
            if (purStrategyValue != null && Boolean.parseBoolean(purStrategyValue.get("isMal").toString())) {
                return "A";
            }
        }
        if (gatherPathMap != null) {
            String gatherPath = gatherPathMap.get(unMatchInfo.getUniqueKey());
            if (debugMode.booleanValue()) {
                logger.info("\u83b7\u53d6\u9700\u6c42\u6c47\u603b\u8def\u5f84\u670d\u52a1\u63a5\u53e3\u7ed3\u679c\u7684\u952e\u503c\uff1a" + unMatchInfo.getUniqueKey() + ",\u7ed3\u679c\uff1a" + gatherPath);
            }
            if (StringUtils.isEmpty((String)gatherPath)) {
                return "A";
            }
            if ("true".equals(gatherPath)) {
                return "A";
            }
            return "F";
        }
        return "A";
    }

    public static Set<Long> genUnMatchedBalanceAdvise(BalanceInventoryScheme balanceScheme, Map<String, List<UnMatchInfo>> groupedUnMatchMap, Map<Long, Long> demandOrgCache, Map<Long, Long> purOrg2AccountOrgCache, Map<Long, Long> purOrg2InvOrgCache, StepResult stepResult, Map<Long, List<UnMatchInfo>> entryIdUnMatchMap) {
        HashSet<Long> adviseIdSet = new HashSet<Long>();
        String outPutResultEntity = balanceScheme.getDemandModel().getOutPutResultEntity();
        int centerPurCount = 0;
        int purCount = 0;
        StringBuilder stepErrorMsg = new StringBuilder();
        for (List<UnMatchInfo> unMatchInfoList : groupedUnMatchMap.values()) {
            if (unMatchInfoList == null || unMatchInfoList.isEmpty()) continue;
            String demandSrcBillEntityNum = unMatchInfoList.get(0).getDemandSrcBillEntityNum();
            String botpRuleId = balanceScheme.getDemandDsMap().get(demandSrcBillEntityNum);
            String demandEntryField = BalanceInvExecuteHelper.getDemandEntryField(demandSrcBillEntityNum, balanceScheme);
            ArrayList<ListSelectedRow> rowList = new ArrayList<ListSelectedRow>(unMatchInfoList.size());
            for (UnMatchInfo unMatchInfo : unMatchInfoList) {
                ListSelectedRow selectedRow = new ListSelectedRow();
                selectedRow.setPrimaryKeyValue((Object)unMatchInfo.getBillId());
                selectedRow.setEntryEntityKey(demandEntryField);
                selectedRow.setEntryPrimaryKeyValue((Object)unMatchInfo.getEntryId());
                rowList.add(selectedRow);
            }
            ConvertOperationResult covertResult = BalanceInvExecuteHelper.convertBill(demandSrcBillEntityNum, outPutResultEntity, rowList, botpRuleId, false);
            if (!covertResult.isSuccess()) {
                String balanceInvMsg2 = ResManager.loadKDString((String)"\u5229\u5e93\u5efa\u8bae", (String)"BalanceInvExecuteHelper_2", (String)"scmc-im-business", (Object[])new Object[0]);
                String balanceInvMsg3 = ResManager.loadKDString((String)"\u8f6c\u6362\u5931\u8d25\uff1a", (String)"BalanceInvExecuteHelper_3", (String)"scmc-im-business", (Object[])new Object[0]);
                stepErrorMsg.append(balanceInvMsg2).append(balanceInvMsg3);
                stepErrorMsg.append(BalanceInvExecuteHelper.getConvertErrorMsg(covertResult));
                stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_E);
            }
            MainEntityType balanceAdviseEntity = EntityMetadataCache.getDataEntityType((String)outPutResultEntity);
            List balanceAdviseList = covertResult.loadTargetDataObjects((objects, dataEntityType) -> BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)dataEntityType), balanceAdviseEntity);
            for (DynamicObject balanceAdvise : balanceAdviseList) {
                String adviseType;
                adviseIdSet.add(balanceAdvise.getLong("id"));
                BalanceInvExecuteHelper.handleAfterUnMatchAdviseConvert(balanceScheme, unMatchInfoList.get(0), balanceAdvise, demandOrgCache, purOrg2AccountOrgCache, purOrg2InvOrgCache, entryIdUnMatchMap);
                switch (adviseType = balanceAdvise.getString("advicetype")) {
                    case "A": {
                        ++purCount;
                        break;
                    }
                    case "F": {
                        ++centerPurCount;
                        break;
                    }
                }
            }
            TXHandle txHandle = TX.requiresNew();
            Throwable throwable = null;
            try {
                String balanceInvMsg2;
                try {
                    OperationResult result = SaveServiceHelper.saveOperate((String)"im_balanceinv_advice", (DynamicObject[])balanceAdviseList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                    if (result.isSuccess()) continue;
                    balanceInvMsg2 = ResManager.loadKDString((String)"\u5229\u5e93\u5efa\u8bae", (String)"BalanceInvExecuteHelper_2", (String)"scmc-im-business", (Object[])new Object[0]);
                    String balanceInvMsg4 = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"BalanceInvExecuteHelper_4", (String)"scmc-im-business", (Object[])new Object[0]);
                    stepErrorMsg.append(balanceInvMsg2).append(balanceInvMsg4).append("\n");
                    stepErrorMsg.append(BalanceInvExecuteHelper.getBillOperateErrorMsg(result));
                    stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_E);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    balanceInvMsg2 = ResManager.loadKDString((String)"\u5229\u5e93\u5efa\u8bae", (String)"BalanceInvExecuteHelper_2", (String)"scmc-im-business", (Object[])new Object[0]);
                    String balanceInvMsg4 = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"BalanceInvExecuteHelper_4", (String)"scmc-im-business", (Object[])new Object[0]);
                    stepErrorMsg.append(balanceInvMsg2).append(balanceInvMsg4).append("\n");
                    if (BalanceInvContext.get().getDebugMode()) {
                        stepErrorMsg.append(BalanceInvExecuteHelper.getExceptionMessage(e));
                    } else {
                        stepErrorMsg.append(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"BalanceInvStepExecutor_1", (String)"scmc-im-business", (Object[])new Object[0]));
                    }
                    stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_E);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txHandle == null) continue;
                if (throwable != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                txHandle.close();
            }
        }
        StringBuilder detailMsg = new StringBuilder();
        if (!StringUtils.isEmpty((String)stepResult.getDetailMsg())) {
            detailMsg.append(stepResult.getDetailMsg());
        }
        String balanceInvMsg5 = String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684\u5916\u8d2d\u5efa\u8bae\u6570\u91cf\uff1a%1$s\u6761\u3002", (String)"BalanceInvExecuteHelper_5", (String)"scmc-im-business", (Object[])new Object[0]), purCount);
        String balanceInvMsg6 = String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684\u96c6\u91c7\u5efa\u8bae\u6570\u91cf\uff1a%1$s\u6761\u3002", (String)"BalanceInvExecuteHelper_6", (String)"scmc-im-business", (Object[])new Object[0]), centerPurCount);
        detailMsg.append(balanceInvMsg5).append("\n").append(balanceInvMsg6).append("\n");
        detailMsg.append((CharSequence)stepErrorMsg);
        if (!StringUtils.isEmpty((String)stepErrorMsg.toString())) {
            stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_E);
        }
        stepResult.setDetailMsg(detailMsg.toString());
        stepResult.setProcessData(stepResult.getProcessData() + purCount + centerPurCount);
        return adviseIdSet;
    }

    private static void handleAfterUnMatchAdviseConvert(BalanceInventoryScheme balanceScheme, UnMatchInfo unMatchInfo, DynamicObject balanceAdvise, Map<Long, Long> demandOrgCache, Map<Long, Long> purOrg2AccountOrgCache, Map<Long, Long> purOrg2InvOrgCache, Map<Long, List<UnMatchInfo>> unMatchMapGByEntryId) {
        ORM orm = ORM.create();
        String adviceType = unMatchInfo.getAdviseType();
        Long balanceOrgId = BalanceInvContext.get().getBalanceOrgId();
        balanceAdvise.set("org", (Object)orm.newDynamicObject("bos_org", (Object)balanceOrgId));
        balanceAdvise.set("balanceinvscheme", (Object)orm.newDynamicObject("balanceinv_scheme", (Object)balanceScheme.getId()));
        balanceAdvise.set("calculatenum", (Object)BalanceInvContext.get().getCalcNum());
        balanceAdvise.set("advicetype", (Object)adviceType);
        boolean isPurAdvice = "A".equals(adviceType);
        if (isPurAdvice) {
            balanceAdvise.set("supplyorg", (Object)0);
        }
        MainEntityType orgEntityType = MetadataServiceHelper.getDataEntityType((String)"bos_org");
        MainEntityType matEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_material");
        MainEntityType unitEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_measureunits");
        DynamicObjectCollection entries = balanceAdvise.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection newEntries = new DynamicObjectCollection();
        for (DynamicObject entry : entries) {
            Long demandInvOrgId;
            DynamicObject demandInvOrg = entry.getDynamicObject("invorg");
            if (demandInvOrg == null && (demandInvOrgId = BalanceInvExecuteHelper.getDemandInvOrg(entry.get("demandorg"), demandOrgCache)) != null) {
                entry.set("invorg", (Object)new DynamicObject((DynamicObjectType)orgEntityType, (Object)demandInvOrgId));
            }
            if (isPurAdvice) {
                BalanceInvExecuteHelper.handlePurAdvice(entry, balanceOrgId, purOrg2AccountOrgCache, purOrg2InvOrgCache);
            }
            long demandSrcEntryId = entry.getLong("demandbillentryid");
            List<UnMatchInfo> entryMatchList = unMatchMapGByEntryId.get(demandSrcEntryId);
            int size = entryMatchList.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    entry = (DynamicObject)OrmUtils.clone((IDataEntityBase)entry, (boolean)false, (boolean)true);
                    newEntries.add((Object)entry);
                }
                if ("invp_safestock_record".equals(unMatchInfo.getDemandSrcBillEntityNum())) {
                    if (entry.get("material") == null) {
                        entry.set("material", (Object)new DynamicObject((DynamicObjectType)matEntityType, (Object)unMatchInfo.getMaterialId()));
                    }
                    if (entry.get("baseunit") == null) {
                        entry.set("baseunit", (Object)new DynamicObject((DynamicObjectType)unitEntityType, (Object)unMatchInfo.getBaseUnitId()));
                    }
                }
                Date finishDate = entry.getDate("planfinishdate");
                entry.set("planstartdate", (Object)finishDate);
                entry.set("adviseqty", (Object)entryMatchList.get(i).getUnMatchQty());
                entry.set("baseqty", (Object)entryMatchList.get(i).getUnMatchQty());
                entry.set("remaininbaseqty", (Object)entryMatchList.get(i).getUnMatchQty());
            }
        }
        entries.addAll((Collection)newEntries);
    }

    public static void autoOutPut(Set<Long> adviseIdSet, BalanceInventoryScheme balanceScheme, StepResult stepResult) {
        StringBuilder errorMsgBuilder = new StringBuilder();
        DynamicObjectCollection outPutParamColl = balanceScheme.getOutPutParamColl();
        HashMap<String, Integer> saveBillCountMap = new HashMap<String, Integer>();
        HashMap<String, Integer> submitBillCountMap = new HashMap<String, Integer>();
        HashMap<String, Integer> auditBillCountMap = new HashMap<String, Integer>();
        int adviseSubmitCount = 0;
        int adviseAuditCount = 0;
        for (DynamicObject outPutParam : outPutParamColl) {
            String billOp;
            List targetBillIds;
            OperationResult saveResult;
            String targetBillName;
            String targetEntityNum;
            String balanceInvMsg8;
            String balanceInvMsg7;
            StringBuilder msgBuilder;
            block25: {
                if (adviseIdSet == null || adviseIdSet.isEmpty() || !outPutParam.getBoolean("autoaudittarget")) continue;
                QFilter idFilter = BalanceInvExecuteHelper.getOutPutFilter(adviseIdSet, outPutParam);
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)ALGO, (String)"im_balanceinv_advice", (String)"id,billno,entryentity.id", (QFilter[])idFilter.toArray(), (String)"");
                HashSet<Long> needAuditIdSet = new HashSet<Long>();
                for (DynamicObject advise : dynamicObjectCollection) {
                    needAuditIdSet.add(advise.getLong("id"));
                    adviseIdSet.remove(advise.getLong("id"));
                }
                if (needAuditIdSet.isEmpty()) continue;
                adviseSubmitCount += needAuditIdSet.size();
                msgBuilder = new StringBuilder();
                String balanceInvMsg2 = ResManager.loadKDString((String)"\u5229\u5e93\u5efa\u8bae", (String)"BalanceInvExecuteHelper_2", (String)"scmc-im-business", (Object[])new Object[0]);
                balanceInvMsg7 = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a", (String)"BalanceInvExecuteHelper_7", (String)"scmc-im-business", (Object[])new Object[0]);
                msgBuilder.append(balanceInvMsg2);
                msgBuilder.append(balanceInvMsg7);
                Set<Object> submitedIdSet = BalanceInvExecuteHelper.doBillOperation("submit", "im_balanceinv_advice", needAuditIdSet.toArray(), msgBuilder.toString(), errorMsgBuilder);
                msgBuilder.setLength(0);
                adviseAuditCount += submitedIdSet.size();
                balanceInvMsg8 = ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff1a", (String)"BalanceInvExecuteHelper_8", (String)"scmc-im-business", (Object[])new Object[0]);
                msgBuilder.append(balanceInvMsg2);
                msgBuilder.append(balanceInvMsg8);
                Set<Object> auditedIdSet = BalanceInvExecuteHelper.doBillOperation("audit", "im_balanceinv_advice", submitedIdSet.toArray(), msgBuilder.toString(), errorMsgBuilder);
                msgBuilder.setLength(0);
                if (auditedIdSet.isEmpty() || !outPutParam.getBoolean("autoput")) continue;
                ArrayList<ListSelectedRow> rowList = new ArrayList<ListSelectedRow>(dynamicObjectCollection.size());
                for (DynamicObject advise : dynamicObjectCollection) {
                    if (!auditedIdSet.contains(advise.getLong("id"))) continue;
                    ListSelectedRow selectedRow = new ListSelectedRow();
                    selectedRow.setBillNo(advise.getString("billno"));
                    selectedRow.setPrimaryKeyValue((Object)advise.getLong("id"));
                    selectedRow.setEntryEntityKey("entryentity");
                    selectedRow.setEntryPrimaryKeyValue((Object)advise.getLong("entryentity.id"));
                    rowList.add(selectedRow);
                }
                targetEntityNum = outPutParam.getDynamicObject("targetputbill").getString("number");
                targetBillName = MetadataServiceHelper.getDataEntityType((String)targetEntityNum).getDisplayName().getLocaleValue();
                ConvertOperationResult result = BalanceInvExecuteHelper.convertBill("im_balanceinv_advice", targetEntityNum, rowList, outPutParam.getDynamicObject("autoputbotp").getString("id"), false);
                if (!result.isSuccess()) {
                    String balanceInvExecuteMsg3 = ResManager.loadKDString((String)"\u8f6c\u6362\u5931\u8d25\uff1a", (String)"BalanceInvExecuteHelper_3", (String)"scmc-im-business", (Object[])new Object[0]);
                    errorMsgBuilder.append(targetBillName).append(balanceInvExecuteMsg3).append("\n");
                    errorMsgBuilder.append(BalanceInvExecuteHelper.getConvertErrorMsg(result));
                }
                MainEntityType balanceAdviseEntity = EntityMetadataCache.getDataEntityType((String)targetEntityNum);
                List targetBillList = result.loadTargetDataObjects((objects, dataEntityType) -> BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)dataEntityType), balanceAdviseEntity);
                saveBillCountMap.putIfAbsent(targetBillName, 0);
                saveBillCountMap.put(targetBillName, (Integer)saveBillCountMap.get(targetBillName) + targetBillList.size());
                saveResult = null;
                try (TXHandle txHandle = TX.requiresNew();){
                    try {
                        saveResult = SaveServiceHelper.saveOperate((String)targetEntityNum, (DynamicObject[])targetBillList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                        if (!saveResult.isSuccess()) {
                            String balanceInvMsg4 = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"BalanceInvExecuteHelper_4", (String)"scmc-im-business", (Object[])new Object[0]);
                            errorMsgBuilder.append(targetBillName).append(balanceInvMsg4).append("\n");
                            errorMsgBuilder.append(BalanceInvExecuteHelper.getBillOperateErrorMsg(saveResult));
                        }
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                        String balanceInvMsg4 = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"BalanceInvExecuteHelper_4", (String)"scmc-im-business", (Object[])new Object[0]);
                        errorMsgBuilder.append(targetBillName).append(balanceInvMsg4).append("\n");
                        if (BalanceInvContext.get().getDebugMode()) {
                            errorMsgBuilder.append(BalanceInvExecuteHelper.getExceptionMessage(e));
                            break block25;
                        }
                        errorMsgBuilder.append(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"BalanceInvStepExecutor_1", (String)"scmc-im-business", (Object[])new Object[0]));
                    }
                }
            }
            if (saveResult == null || (targetBillIds = saveResult.getSuccessPkIds()) == null || targetBillIds.isEmpty() || !(billOp = outPutParam.getString("targetbillop")).equals("B") && !billOp.equals("C")) continue;
            submitBillCountMap.putIfAbsent(targetBillName, 0);
            submitBillCountMap.put(targetBillName, (Integer)submitBillCountMap.get(targetBillName) + targetBillIds.size());
            msgBuilder.append(targetBillName).append(balanceInvMsg7);
            Set<Object> submitIdSet = BalanceInvExecuteHelper.doBillOperation("submit", targetEntityNum, targetBillIds.toArray(), msgBuilder.toString(), errorMsgBuilder);
            msgBuilder.setLength(0);
            if (!billOp.equals("C") || submitIdSet == null || submitIdSet.isEmpty()) continue;
            auditBillCountMap.putIfAbsent(targetBillName, 0);
            auditBillCountMap.put(targetBillName, (Integer)auditBillCountMap.get(targetBillName) + submitIdSet.size());
            msgBuilder.append(targetBillName).append(balanceInvMsg8);
            BalanceInvExecuteHelper.doBillOperation("audit", targetEntityNum, submitIdSet.toArray(), msgBuilder.toString(), errorMsgBuilder);
            msgBuilder.setLength(0);
        }
        int processData = 0;
        StringBuilder detailMsg = new StringBuilder();
        processData += adviseSubmitCount;
        detailMsg.append(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u5229\u5e93\u5efa\u8bae\u6570\u91cf\uff1a%1$s\u6761\u3002", (String)"BalanceInvExecuteHelper_9", (String)"scmc-im-business", (Object[])new Object[0]), adviseSubmitCount)).append("\n");
        detailMsg.append(String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u7684\u5229\u5e93\u5efa\u8bae\u6570\u91cf\uff1a%1$s\u6761\u3002", (String)"BalanceInvExecuteHelper_10", (String)"scmc-im-business", (Object[])new Object[0]), adviseAuditCount)).append("\n");
        for (Map.Entry entry : saveBillCountMap.entrySet()) {
            processData += ((Integer)entry.getValue()).intValue();
            detailMsg.append(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u7684%1$s\u6570\u91cf\uff1a%2$s\u6761\u3002", (String)"BalanceInvExecuteHelper_11", (String)"scmc-im-business", (Object[])new Object[0]), entry.getKey(), entry.getValue())).append("\n");
        }
        for (Map.Entry entry : submitBillCountMap.entrySet()) {
            detailMsg.append(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u7684%1$s\u6570\u91cf\uff1a%2$s\u6761\u3002", (String)"BalanceInvExecuteHelper_12", (String)"scmc-im-business", (Object[])new Object[0]), entry.getKey(), entry.getValue())).append("\n");
        }
        for (Map.Entry entry : auditBillCountMap.entrySet()) {
            detailMsg.append(String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u7684%1$s\u6570\u91cf\uff1a%2$s\u6761\u3002", (String)"BalanceInvExecuteHelper_13", (String)"scmc-im-business", (Object[])new Object[0]), entry.getKey(), entry.getValue())).append("\n");
        }
        detailMsg.append((CharSequence)errorMsgBuilder);
        if (!StringUtils.isEmpty((String)errorMsgBuilder.toString())) {
            stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_E);
        }
        String errorMsg = detailMsg.toString();
        if (!StringUtils.isEmpty((String)stepResult.getDetailMsg())) {
            errorMsg = stepResult.getDetailMsg() + detailMsg;
        }
        stepResult.setDetailMsg(errorMsg);
        stepResult.setProcessData(stepResult.getProcessData() + processData);
    }

    private static QFilter getOutPutFilter(Set adviseIdSet, DynamicObject outPutParam) {
        QFilter outPutFilter = new QFilter("id", "in", (Object)adviseIdSet);
        String filterJson = outPutParam.getString("filtervalue");
        if (!StringUtils.isEmpty((String)filterJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
            MainEntityType adviseEntityType = MetadataServiceHelper.getDataEntityType((String)"im_balanceinv_advice");
            FilterBuilder builder = new FilterBuilder(adviseEntityType, filterCondition);
            builder.buildFilter();
            outPutFilter.and(builder.getQFilter());
        }
        return outPutFilter;
    }

    private static Set<Object> doBillOperation(String operate, String entityNum, Object[] ids, String message, StringBuilder errorMsgBuilder) {
        HashSet<Object> successIds;
        block16: {
            successIds = new HashSet<Object>();
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("WF", "false");
                    OperationResult auditResult = OperationServiceHelper.executeOperate((String)operate, (String)entityNum, (Object[])ids, (OperateOption)operateOption);
                    if (!auditResult.isSuccess()) {
                        errorMsgBuilder.append(message).append("\n");
                        errorMsgBuilder.append(BalanceInvExecuteHelper.getBillOperateErrorMsg(auditResult));
                    }
                    successIds.addAll(auditResult.getSuccessPkIds());
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    errorMsgBuilder.append(message).append("\n");
                    if (BalanceInvContext.get().getDebugMode()) {
                        errorMsgBuilder.append(BalanceInvExecuteHelper.getExceptionMessage(e));
                        break block16;
                    }
                    errorMsgBuilder.append(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"BalanceInvStepExecutor_1", (String)"scmc-im-business", (Object[])new Object[0]));
                }
            }
        }
        return successIds;
    }

    public static boolean isPropMustInput(IDataEntityProperty prop, Map<String, Boolean> propMustInputMap) {
        String propName = prop.getName();
        if (!propMustInputMap.containsKey(propName)) {
            boolean mustInput = false;
            try {
                Method method = prop.getClass().getMethod("isMustInput", new Class[0]);
                if (method != null) {
                    Object result = method.invoke((Object)prop, new Object[0]);
                    mustInput = (Boolean)result;
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u5b57\u6bb5\u662f\u5426\u5fc5\u5f55\u51fa\u9519", (Throwable)e);
            }
            propMustInputMap.put(propName, mustInput);
        }
        return propMustInputMap.get(propName);
    }

    public static Map<Long, Map<String, Object>> getEntryBFRowIdMap(String entityNumber, String entryKey, List<Long> billIdList, List<Long> entryIdList) {
        HashSet<Long> entryIdSet = new HashSet<Long>(16);
        HashMap<Long, Map<String, Object>> entryIdSourceMap = new HashMap<Long, Map<String, Object>>();
        OperateOption operateOption = OperateOption.create();
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)entityNumber, (String)entryKey, (Long[])billIdList.toArray(new Long[0]), (Long[])entryIdList.toArray(new Long[0]), (OperateOption)operateOption);
        for (BFRowLinkUpNode bfRowLinkUpNode : bfRowLinkUpNodes) {
            Long entryId;
            Long billId;
            BFRowId targetRowId = bfRowLinkUpNode.getRowId();
            Long targetEntryId = targetRowId.getEntryId();
            Long tarBillId = targetRowId.getBillId();
            List allSourceNodes = bfRowLinkUpNode.findAllSourceNodes();
            BFRowLinkUpNode sourceNode = BalanceInvExecuteHelper.getSourceBillNode(allSourceNodes, "pm_requirapplybill");
            if (sourceNode == null || (billId = sourceNode.getRowId().getBillId()).equals(entryId = sourceNode.getRowId().getEntryId())) continue;
            HashMap<String, Long> sourceInfo = new HashMap<String, Long>(16);
            sourceInfo.put("id", billId);
            sourceInfo.put("entryid", entryId);
            sourceInfo.put("tarbillid", tarBillId);
            entryIdSourceMap.put(targetEntryId, sourceInfo);
            entryIdSet.add(entryId);
        }
        if (!entryIdSet.isEmpty()) {
            Long entryId;
            QFilter filter = new QFilter("billentry.id", "in", entryIdSet);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"pm_requirapplybill", (String)"billentry.id,billentry.seq", (QFilter[])filter.toArray(), (String)"");
            HashMap<Long, Integer> entrySeqMap = new HashMap<Long, Integer>(16);
            for (Row row : dataSet) {
                entryId = row.getLong("billentry.id");
                Integer entrySeq = row.getInteger("billentry.seq");
                entrySeqMap.put(entryId, entrySeq);
            }
            for (Map sourceInfoMap : entryIdSourceMap.values()) {
                entryId = sourceInfoMap.get("entryid");
                Integer seq = (Integer)entrySeqMap.get(entryId);
                sourceInfoMap.put("seq", seq);
            }
        }
        return entryIdSourceMap;
    }

    private static BFRowLinkUpNode getSourceBillNode(List<BFRowLinkUpNode> allSourceNodes, String entityNumber) {
        BFRowLinkUpNode minNode = null;
        int minWeight = -1;
        for (BFRowLinkUpNode sourceNode : allSourceNodes) {
            int weight;
            TableDefine mainTableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)sourceNode.getRowId().getMainTableId());
            String sourceEntityNumber = mainTableDefine.getEntityNumber();
            if (!entityNumber.equals(sourceEntityNumber) || (weight = BalanceInvExecuteHelper.getNodeWeight(sourceNode)) >= minWeight && minWeight != -1) continue;
            minWeight = weight;
            minNode = sourceNode;
        }
        return minNode;
    }

    private static int getNodeWeight(BFRowLinkUpNode node) {
        int weight = 0;
        List allSourceNodes = node.findAllSourceNodes();
        if (allSourceNodes != null && !allSourceNodes.isEmpty()) {
            weight = allSourceNodes.size();
        }
        return weight;
    }

    public static void checkLicense() {
        LicenseCheckResult result;
        String version = LicenseServiceHelper.getProductVersion();
        if (!"1.0".equals(version) && !(result = LicenseServiceHelper.checkPerformGroup((String)"PRO_BAL")).getHasLicense().booleanValue()) {
            throw new KDBizException(result.getMsg());
        }
    }

    public static Map<String, Object> buildReserveParam(DynamicObject matchInfo, Map<Long, Map<String, Object>> entryIdSourceMap, boolean isPredict) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Object billId = matchInfo.get("demandbillid");
        Object entryId = matchInfo.get("demandentryid");
        Object seq = matchInfo.get("demandbillseq");
        if (entryIdSourceMap != null && entryIdSourceMap.get(entryId) != null) {
            Map<String, Object> sourceInfoMap = entryIdSourceMap.get(entryId);
            billId = sourceInfoMap.get("id");
            entryId = sourceInfoMap.get("entryid");
            seq = sourceInfoMap.get("seq");
        }
        paramMap.put("billId", billId);
        paramMap.put("billEntryId", entryId);
        paramMap.put("billEntrySeq", seq);
        paramMap.put("invId", matchInfo.get("supplybillid"));
        paramMap.put("invEntryId", matchInfo.get("supplybillentryid"));
        paramMap.put("baseQty", matchInfo.get("matchbaseqty"));
        paramMap.put("qty", matchInfo.get("matchqty"));
        paramMap.put("qty2nd", matchInfo.get("matchqty2nd"));
        paramMap.put("org", matchInfo.get("supplyinvorg"));
        paramMap.put("material", matchInfo.get("materiel"));
        paramMap.put("isPredict", isPredict);
        return paramMap;
    }

    public static Map invokeReserveService(String demandEntityNum, String supplyEntityNum, List<Map<String, Object>> reserveParamList) {
        logger.info("\u4f20\u9012\u7ed9\u9884\u7559\u63a5\u53e3\u53c2\u6570\u4e3a\uff1a" + reserveParamList);
        String resultJson = (String)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"ReserveService", (String)"reserveBatchFree", (Object[])new Object[]{supplyEntityNum, demandEntityNum, false, reserveParamList});
        logger.info("\u7ed9\u9884\u7559\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + resultJson);
        Map reserveResult = (Map)SerializationUtils.fromJsonString((String)resultJson, Map.class);
        return reserveResult;
    }

    private static Long getAccountOrg(long orgId, Map<Long, Long> orgCacheMap) {
        Long accountOrgId = orgCacheMap.get(orgId);
        if (accountOrgId == null) {
            Map orgMap = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            accountOrgId = orgMap != null ? (Long)orgMap.get("id") : Long.valueOf(0L);
            orgCacheMap.put(orgId, accountOrgId);
        }
        return accountOrgId;
    }

    public static void handlePurAdvice(DynamicObject entry, Long balanceOrgId, Map<Long, Long> purOrg2AccountOrgCache, Map<Long, Long> purOrg2InvOrgCache) {
        entry.set("ownertype", (Object)"bos_org");
        DynamicObject purOrg = entry.getDynamicObject("purorg");
        Long ownerId = 0L;
        Long supplyInvOrgId = 0L;
        if (purOrg != null) {
            long purOrgId = purOrg.getLong("id");
            ownerId = BalanceInvExecuteHelper.getAccountOrg(purOrgId, purOrg2AccountOrgCache);
            supplyInvOrgId = BalanceInvExecuteHelper.getSupplyInvOrg(purOrgId, purOrg2InvOrgCache, true);
        } else {
            ownerId = BalanceInvExecuteHelper.getAccountOrg(balanceOrgId, purOrg2AccountOrgCache);
            supplyInvOrgId = BalanceInvExecuteHelper.getSupplyInvOrg(balanceOrgId, purOrg2InvOrgCache, false);
        }
        MainEntityType orgEntityType = MetadataServiceHelper.getDataEntityType((String)"bos_org");
        entry.set("owner", (Object)new DynamicObject((DynamicObjectType)orgEntityType, (Object)ownerId));
        entry.set("supplyinvorg", (Object)new DynamicObject((DynamicObjectType)orgEntityType, (Object)supplyInvOrgId));
    }

    private static Long getSupplyInvOrg(long orgId, Map<Long, Long> orgCacheMap, boolean isPurOrg) {
        Long res = orgCacheMap.get(orgId);
        if (res == null) {
            DynamicObject demandOrgInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"fisinventory");
            if (demandOrgInfo.getBoolean("fisinventory")) {
                res = orgId;
            } else if (isPurOrg) {
                OrgRelationParam param = new OrgRelationParam();
                param.setOrgId(orgId);
                param.setFromViewType("02");
                param.setToViewType("05");
                param.setDirectViewType("toorg");
                Map orgRelationMap = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
                List orgRelations = (List)orgRelationMap.get("data");
                if (orgRelations != null && !orgRelations.isEmpty()) {
                    Long defaultOrgId = (Long)((Map)orgRelations.get(0)).get("orgId");
                    for (Map orgRelation : orgRelations) {
                        if (!Boolean.TRUE.equals(orgRelation.get("isDefault"))) continue;
                        defaultOrgId = (Long)orgRelation.get("orgId");
                        break;
                    }
                    res = defaultOrgId;
                } else {
                    res = 0L;
                }
            } else {
                ArrayList<Long> idList = new ArrayList<Long>();
                idList.add(orgId);
                List list = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"05", idList, (boolean)false);
                res = list != null && list.size() > 0 ? (Long)list.get(0) : Long.valueOf(0L);
            }
            orgCacheMap.put(orgId, res);
        }
        return res;
    }

    public static DynamicObject getBalanceSchemeInfo(Long schemeId) {
        long fieldMapId;
        QFilter[] filterArr = new QFilter("id", "=", (Object)schemeId).and("enable", "=", (Object)"1").toArray();
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((String)"balanceinv_scheme", (QFilter[])filterArr);
        if (scheme == null) {
            return null;
        }
        DynamicObject demandModel = BusinessDataServiceHelper.loadSingle((Object)scheme.getDynamicObject("demandmodel").getLong("id"), (String)"balanceinv_register");
        scheme.set("demandmodel", (Object)demandModel);
        DynamicObject supplyModel = BusinessDataServiceHelper.loadSingle((Object)scheme.getDynamicObject("supplymodel").getLong("id"), (String)"balanceinv_register");
        scheme.set("supplymodel", (Object)supplyModel);
        HashSet<Long> filedMapIdSet = new HashSet<Long>();
        DynamicObjectCollection demandEntries = demandModel.getDynamicObjectCollection("entryentityds");
        for (Object entry : demandEntries) {
            filedMapIdSet.add(entry.getDynamicObject("billfieldmap").getLong("id"));
        }
        DynamicObjectCollection supplyEntries = supplyModel.getDynamicObjectCollection("entryentityds");
        for (DynamicObject entry : supplyEntries) {
            filedMapIdSet.add(entry.getDynamicObject("billfieldmap").getLong("id"));
        }
        Map fieldMap = BusinessDataServiceHelper.loadFromCache((Object[])filedMapIdSet.toArray(), (String)"sbs_billfieldmapping");
        for (DynamicObject demandEntry : demandEntries) {
            fieldMapId = demandEntry.getDynamicObject("billfieldmap").getLong("id");
            demandEntry.set("billfieldmap", fieldMap.get(fieldMapId));
        }
        for (DynamicObject supplyEntry : supplyEntries) {
            fieldMapId = supplyEntry.getDynamicObject("billfieldmap").getLong("id");
            supplyEntry.set("billfieldmap", fieldMap.get(fieldMapId));
        }
        return scheme;
    }

    public static boolean getNeedReserve() {
        return SupplyChainParameterHelper.getEnableScmParam("PHLK001");
    }

    public static String getBalanceAdviseType(String supplyType) {
        String adviseType = "B";
        switch (supplyType) {
            case "C": {
                adviseType = "C";
                break;
            }
            case "D": {
                adviseType = "D";
                break;
            }
            case "A": {
                adviseType = "B";
                break;
            }
            case "B": {
                adviseType = "E";
                break;
            }
        }
        return adviseType;
    }

    public static Set<Long> getNeedClearMatchDetail(Long schemeId) {
        StringBuilder sql = new StringBuilder(100);
        sql.append(" SELECT A.FID FROM T_IM_BALINV_MATCHDETAIL A \n");
        sql.append(" LEFT JOIN T_IM_INVADVICE B ON A.FCALCULATENUM = B.FCALCULATENUM \n");
        sql.append(" WHERE A.FSCHEMEID = ? AND B.FID IS NULL AND A.FCREATORID = ?");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"im_balanceinv_matchdetail");
        long currentUserId = UserServiceHelper.getCurrentUserId();
        Set needDeleteIds = (Set)DB.query((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)sql.toString(), (Object[])new Object[]{schemeId, currentUserId}, resultSet -> {
            HashSet<Long> ids = new HashSet<Long>(16);
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            return ids;
        });
        return needDeleteIds;
    }

    public static void releaseReserveRecord(Set<Long> entryIds) {
        if (entryIds == null || entryIds.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("billentryid", "in", entryIds);
        ArrayList<Long> reserveIdList = new ArrayList<Long>();
        HashSet<Long> idSet = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"balanceinv_pre_record", (String)"id,reserverecord", (QFilter[])filter.toArray(), null);){
            for (Row row : dataSet) {
                reserveIdList.add(row.getLong("reserverecord"));
                idSet.add(row.getLong("id"));
            }
        }
        if (!reserveIdList.isEmpty()) {
            var5_5 = null;
            try (TXHandle h = TX.required((String)"balanceinv-remove-reserve-record");){
                QFilter qFilter = new QFilter("id", "in", reserveIdList);
                DynamicObject[] col = BusinessDataServiceHelper.load((String)"msmod_reserve_record", (String)"id,base_qty,qty,qty2nd,expiredate,ispredict,bal_obj,reserve_scheme,bal_id,aggregateid,bill_obj,bill_id,bill_no,billentry_id,billentry_seq", (QFilter[])qFilter.toArray());
                if (col == null || col.length < 1) {
                    return;
                }
                try {
                    ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(col.length);
                    for (DynamicObject reserveRecord : col) {
                        reserveRecord.set("bal_obj", (Object)reserveRecord.getDynamicObject("bal_obj").getString("number"));
                        if (reserveRecord.getDynamicObject("reserve_scheme") != null) {
                            reserveRecord.set("reserve_scheme", reserveRecord.getDynamicObject("reserve_scheme").getPkValue());
                        }
                        recordList.add(reserveRecord);
                    }
                    ReleaseHelper.rmReserveByRecordNotSup(recordList);
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"balanceinv_pre_record"), (Object[])idSet.toArray());
                }
                catch (Exception e) {
                    h.markRollback();
                    logger.error("\u91ca\u653e\u9884\u8ba1\u5165\u9884\u7559\u5931\u8d25", (Throwable)e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
        }
    }

    public static String getStringFilter(List<QFilter> dataSetFilter) {
        QFilter qFilter = null;
        for (QFilter filter : dataSetFilter) {
            if (qFilter == null) {
                qFilter = filter;
                continue;
            }
            qFilter = qFilter.and(filter);
        }
        return qFilter == null ? null : qFilter.toString();
    }

    public static String doReserve(List<DynamicObject> reserveMatchInfoList) {
        BalanceInventoryScheme balanceScheme = BalanceInvContext.get().getScheme();
        Map groupedByEntity = reserveMatchInfoList.stream().collect(Collectors.groupingBy(matchInfo -> matchInfo.getString("demandbilltype"), Collectors.toList()));
        StringBuilder errorMsg = new StringBuilder();
        for (Map.Entry matchInfoEntry : groupedByEntity.entrySet()) {
            String demandEntityNum = matchInfoEntry.getKey();
            List matchInfoList = matchInfoEntry.getValue();
            ArrayList<Long> billIdList = new ArrayList<Long>(matchInfoList.size());
            ArrayList<Long> entryIdList = new ArrayList<Long>(matchInfoList.size());
            for (DynamicObject matchInfo2 : matchInfoList) {
                billIdList.add(matchInfo2.getLong("demandbillid"));
                entryIdList.add(matchInfo2.getLong("demandentryid"));
            }
            String entryField = BalanceInvExecuteHelper.getDemandEntryField(demandEntityNum, balanceScheme);
            if (!"pm_requirapplybill".equals(demandEntityNum)) continue;
            Map<Long, Map<String, Object>> entryIdSourceMap = BalanceInvExecuteHelper.getEntryBFRowIdMap(demandEntityNum, entryField, billIdList, entryIdList);
            HashMap<Long, String> srcReqBillId2CurBillId = new HashMap<Long, String>(16);
            HashMap<String, List> reserveParamList = new HashMap<String, List>(16);
            for (DynamicObject matchInfo3 : matchInfoList) {
                String invType = matchInfo3.getString("invstocktype");
                String supplyBillType = matchInfo3.getString("supplybilltype");
                if (StringUtils.isEmpty((String)supplyBillType)) continue;
                Object billId = matchInfo3.get("demandbillid");
                Object entryId = matchInfo3.get("demandentryid");
                boolean isPredict = "B".equals(invType);
                Map<String, Object> param = BalanceInvExecuteHelper.buildReserveParam(matchInfo3, entryIdSourceMap, isPredict);
                Long srcBillEntryId = (Long)param.get("billEntryId");
                srcReqBillId2CurBillId.computeIfAbsent(srcBillEntryId, k -> billId + "-" + entryId);
                reserveParamList.computeIfAbsent(supplyBillType, k -> new ArrayList()).add(param);
            }
            ArrayList<DynamicObject> preSupplyRecordList = new ArrayList<DynamicObject>();
            for (Map.Entry entry : reserveParamList.entrySet()) {
                InventorySearchResult result = ReserveService.reserveBatchNotSup((String)((String)entry.getKey()), (String)"pm_requirapplybill", (boolean)false, (List)((List)entry.getValue()));
                if (result.isSuccess()) {
                    preSupplyRecordList.addAll(BalanceInvExecuteHelper.createPreSupplyRecordObj(result.getCol(), srcReqBillId2CurBillId));
                    continue;
                }
                errorMsg.append(ResManager.loadKDString((String)"\u9884\u7559\u5931\u8d25\uff1a", (String)"BalanceInvGenMatchAdviseStep_3", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
                errorMsg.append(result.getErrMsg()).append("\n");
            }
            if (preSupplyRecordList.size() <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])preSupplyRecordList.toArray(new DynamicObject[0]));
        }
        return errorMsg.toString();
    }

    private static List<DynamicObject> createPreSupplyRecordObj(DynamicObjectCollection reserveRecordCol, Map<Long, String> srcReqBillId2CurBillId) {
        Date now = new Date();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        for (DynamicObject reserveRecord : reserveRecordCol) {
            DynamicObject preSupplyRecord = BusinessDataServiceHelper.newDynamicObject((String)"balanceinv_pre_record");
            preSupplyRecord.set("reserverecord", reserveRecord.getPkValue());
            Long reqBillId = 0L;
            Long reqBillEntryId = 0L;
            Long srcBillEntryId = reserveRecord.getLong("billentry_id");
            String reqBillInfo = srcReqBillId2CurBillId.get(srcBillEntryId);
            if (StringUtils.isNotEmpty((String)reqBillInfo)) {
                String[] billInfo = reqBillInfo.split("-");
                reqBillId = Long.valueOf(billInfo[0]);
                reqBillEntryId = Long.valueOf(billInfo[1]);
            }
            preSupplyRecord.set("billid", (Object)reqBillId);
            preSupplyRecord.set("billentryid", (Object)reqBillEntryId);
            preSupplyRecord.set("createdate", (Object)now);
            result.add(preSupplyRecord);
        }
        return result;
    }
}

