/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.DemandModel;
import kd.scmc.im.business.balanceinv.pojo.SupplyModel;

public class BalanceInvSchemeChecker {
    private static final String STATUS_DISABLE = "0";
    private Map<String, Boolean> demandPropMustInputMap = new HashMap<String, Boolean>();
    private Map<String, Boolean> supplyPropMustInputMap = new HashMap<String, Boolean>();

    public String checkSchemeDynamicObj(DynamicObject scheme, boolean isWorkBench) {
        StringBuilder msgBuilder = new StringBuilder();
        if (scheme == null) {
            msgBuilder.append(ResManager.loadKDString((String)"\u5e73\u8861\u5229\u5e93\u65b9\u6848\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"IM-E-344671", (String)"scmc-im-business", (Object[])new Object[0]));
            return msgBuilder.toString();
        }
        msgBuilder.append(this.getOrgParamCheckMsg(scheme));
        HashSet<String> demandMatchFields = new HashSet<String>(16);
        HashSet<String> supplyMatchFields = new HashSet<String>(16);
        msgBuilder.append(this.getMatchParamCheckMsg(scheme, demandMatchFields, supplyMatchFields));
        msgBuilder.append(this.getDemandParamCheckMsg(scheme, demandMatchFields, isWorkBench));
        msgBuilder.append(this.getSupplyParamCheckMsg(scheme, supplyMatchFields));
        if (!isWorkBench) {
            msgBuilder.append(this.getOutPutParamCheckMsg(scheme));
        }
        return msgBuilder.toString();
    }

    private String getOutPutParamCheckMsg(DynamicObject scheme) {
        StringBuilder msgBuilder = new StringBuilder();
        DynamicObjectCollection outPutEntries = scheme.getDynamicObjectCollection("autoputparamentry");
        int seq = 0;
        for (DynamicObject outPutEntry : outPutEntries) {
            ++seq;
            boolean autoOutPut = outPutEntry.getBoolean("autoput");
            if (!autoOutPut) continue;
            DynamicObject botpInfo = outPutEntry.getDynamicObject("autoputbotp");
            if (botpInfo == null) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u6295\u653e\u53c2\u6570\u7b2c%1$s\u884c\u5355\u636e\u8f6c\u6362\u89c4\u5219\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_13", (String)"scmc-im-business", (Object[])new Object[0]), seq)).append("\n");
                continue;
            }
            String enabled = botpInfo.getString("enabled");
            if (!STATUS_DISABLE.equals(enabled)) continue;
            msgBuilder.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362\u89c4\u5219\u201c%1$s\u201d\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_9", (String)"scmc-im-business", (Object[])new Object[0]), botpInfo.get("number"))).append("\n");
        }
        return msgBuilder.toString();
    }

    private String getMatchParamCheckMsg(DynamicObject scheme, Set<String> demandMatchFields, Set<String> supplyMatchFields) {
        StringBuilder msgBuilder = new StringBuilder();
        DynamicObject matchDimension = scheme.getDynamicObject("mappingdimen");
        boolean isEnable = matchDimension.getBoolean("isenable");
        if (!isEnable) {
            msgBuilder.append(String.format(ResManager.loadKDString((String)"\u4f9b\u9700\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\uff08\u7f16\u7801\uff1a%1$s\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_7", (String)"scmc-im-business", (Object[])new Object[0]), matchDimension.get("number"))).append("\n");
        }
        DynamicObjectCollection matchFieldCol = matchDimension.getDynamicObjectCollection("colsmap");
        DynamicObject targetObj = matchDimension.getDynamicObject("targetobj");
        String demandBillField = "sourcebillcol";
        String supplyBillField = "targetobjcol";
        if ("balanceinv_demandbill".equals(targetObj.get("number"))) {
            demandBillField = "targetobjcol";
            supplyBillField = "sourcebillcol";
        }
        for (DynamicObject matchFiledEntry : matchFieldCol) {
            String sourceFiled = matchFiledEntry.getString(demandBillField);
            String targetFiled = matchFiledEntry.getString(supplyBillField);
            demandMatchFields.add(sourceFiled);
            supplyMatchFields.add(targetFiled);
        }
        DynamicObjectCollection entries = scheme.getDynamicObjectCollection("matchentry");
        for (DynamicObject entry : entries) {
            String demandFieldKey = entry.getString("demandfieldkey");
            String supplyFieldKey = entry.getString("supplyfieldkey");
            if (!demandMatchFields.contains(demandFieldKey)) {
                msgBuilder.append(ResManager.loadKDString((String)"\u7a7a\u503c\u6a21\u7cca\u5339\u914d\u5b57\u6bb5\u4e2d\uff0c\u5e73\u8861\u5229\u5e93\u9700\u6c42\u5355\u636e\u7684\u5b57\u6bb5\u201c{0}\u201d\uff0c\u5fc5\u987b\u5305\u542b\u5728\u4f9b\u9700\u5339\u914d\u7ef4\u5ea6\u6620\u5c04\u5b57\u6bb5\u4e2d\u3002", (String)"BalanceInvPrepareStep_18", (String)"scmc-im-business", (Object[])new Object[]{demandFieldKey})).append("\n");
            }
            if (supplyMatchFields.contains(supplyFieldKey)) continue;
            msgBuilder.append(ResManager.loadKDString((String)"\u7a7a\u503c\u6a21\u7cca\u5339\u914d\u5b57\u6bb5\u4e2d\uff0c\u5e73\u8861\u5229\u5e93\u4f9b\u5e94\u5355\u636e\u7684\u5b57\u6bb5\u201c{0}\u201d\uff0c\u5fc5\u987b\u5305\u542b\u5728\u4f9b\u9700\u5339\u914d\u7ef4\u5ea6\u6620\u5c04\u5b57\u6bb5\u4e2d\u3002", (String)"BalanceInvPrepareStep_19", (String)"scmc-im-business", (Object[])new Object[]{supplyFieldKey})).append("\n");
        }
        return msgBuilder.toString();
    }

    public String checkSchemeInfo(BalanceInventoryScheme balanceScheme) {
        String checkMsg = this.checkBillInDemand("pm_requirapplybill", balanceScheme);
        if (StringUtils.isNotBlank((CharSequence)checkMsg)) {
            return checkMsg;
        }
        return this.getCheckMustInputFieldMsg(balanceScheme);
    }

    private String checkBillInDemand(String entityNum, BalanceInventoryScheme balanceScheme) {
        String errorMsg = null;
        if (!balanceScheme.getDemandDsMap().containsKey(entityNum)) {
            String billName = MetadataServiceHelper.getDataEntityType((String)entityNum).getDisplayName().getLocaleValue();
            errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e%1$s\u5728\u5229\u5e93\u65b9\u6848\u4e2d\u7684\u9700\u6c42\u53c2\u6570\u4e3a\u53c2\u4e0e\u5229\u5e93\u8fd0\u7b97\u3002", (String)"BalanceInvPrepareStep_2", (String)"scmc-im-business", (Object[])new Object[0]), billName);
        }
        return errorMsg;
    }

    private String getCheckMustInputFieldMsg(BalanceInventoryScheme balanceScheme) {
        DynamicObject billFiledMap;
        Set<String> targetFields;
        boolean mustInput;
        StringBuilder errorMsg = new StringBuilder();
        DemandModel demandModel = balanceScheme.getDemandModel();
        SupplyModel supplyModel = balanceScheme.getSupplyModel();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"balanceinv_demandbill");
        EntityType entryEntity = (EntityType)dataEntityType.getAllEntities().get("entryentity");
        Collection entryProps = entryEntity.getFields().values();
        for (IDataEntityProperty prop : entryProps) {
            mustInput = BalanceInvExecuteHelper.isPropMustInput(prop, this.demandPropMustInputMap);
            if (!mustInput) continue;
            for (String entityNum : demandModel.getDataSourceMap().keySet()) {
                targetFields = demandModel.getTargetFields(entityNum);
                billFiledMap = demandModel.getBillFiledMap(entityNum);
                if (targetFields.contains("entryentity." + prop.getName())) continue;
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u5e73\u8861\u5229\u5e93\u9700\u6c42\u5355\u4e2d\u5b57\u6bb5%1$s\u4e3a\u5fc5\u5f55\u5b57\u6bb5\uff0c\u4f46\u901a\u7528\u6620\u5c04\uff08\u7f16\u7801\uff1a%2$s\uff09\u4e2d\u672a\u914d\u7f6e\u6b64\u5b57\u6bb5\u7684\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_10", (String)"scmc-im-business", (Object[])new Object[0]), "entryentity." + prop.getName(), billFiledMap.getString("number"))).append("\n");
            }
        }
        dataEntityType = MetadataServiceHelper.getDataEntityType((String)"balanceinv_supplybill");
        entryEntity = (EntityType)dataEntityType.getAllEntities().get("entryentity");
        entryProps = entryEntity.getFields().values();
        for (IDataEntityProperty prop : entryProps) {
            mustInput = BalanceInvExecuteHelper.isPropMustInput(prop, this.supplyPropMustInputMap);
            if (!mustInput) continue;
            for (String entityNum : supplyModel.getDataSourceMap().keySet()) {
                targetFields = supplyModel.getTargetFields(entityNum);
                billFiledMap = supplyModel.getBillFiledMap(entityNum);
                if (targetFields.contains("entryentity." + prop.getName())) continue;
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u5e73\u8861\u5229\u5e93\u4f9b\u5e94\u5355\u4e2d\u5b57\u6bb5%1$s\u4e3a\u5fc5\u5f55\u5b57\u6bb5\uff0c\u4f46\u901a\u7528\u6620\u5c04\uff08\u7f16\u7801\uff1a%2$s\uff09\u4e2d\u672a\u914d\u7f6e\u6b64\u5b57\u6bb5\u7684\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_11", (String)"scmc-im-business", (Object[])new Object[0]), "entryentity." + prop.getName(), billFiledMap.getString("number"))).append("\n");
            }
        }
        return errorMsg.toString();
    }

    private String getDemandParamCheckMsg(DynamicObject scheme, Set<String> demandMatchFields, boolean isWorkBench) {
        DynamicObject splitRule;
        StringBuilder msgBuilder = new StringBuilder();
        DynamicObject demandModelInfo = scheme.getDynamicObject("demandmodel");
        String enable = demandModelInfo.getString("enable");
        if (STATUS_DISABLE.equals(enable)) {
            msgBuilder.append(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u6a21\u578b\uff08\u7f16\u7801\uff1a%1$s\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_6", (String)"scmc-im-business", (Object[])new Object[0]), demandModelInfo.get("number"))).append("\n");
        }
        DynamicObjectCollection modelEntries = demandModelInfo.getDynamicObjectCollection("entryentityds");
        HashSet<String> demandEntitySet = new HashSet<String>(modelEntries.size());
        for (DynamicObject modelEntry : modelEntries) {
            String entityNum = modelEntry.getDynamicObject("srcbillds").getString("number");
            demandEntitySet.add(entityNum);
            DynamicObject billFieldMapInfo = modelEntry.getDynamicObject("billfieldmap");
            boolean isEnable = billFieldMapInfo.getBoolean("isenable");
            if (!isEnable) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u4f9b\u9700\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\uff08\u7f16\u7801\uff1a%1$s\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_7", (String)"scmc-im-business", (Object[])new Object[0]), billFieldMapInfo.get("number"))).append("\n");
            }
            DynamicObjectCollection colMaps = billFieldMapInfo.getDynamicObjectCollection("colsmap");
            HashSet<String> fields = new HashSet<String>(colMaps.size());
            for (DynamicObject colMap : colMaps) {
                String targetField = colMap.getString("targetobjcol");
                fields.add(targetField);
            }
            if (entityNum.equals("invp_safestock_record")) continue;
            for (String demandMatchField : demandMatchFields) {
                if (fields.contains(demandMatchField)) continue;
                msgBuilder.append(ResManager.loadKDString((String)"\u4f9b\u9700\u5339\u914d\u7ef4\u5ea6\u4e2d\uff0c\u5e73\u8861\u5229\u5e93\u9700\u6c42\u5355\u636e\u7684\u5b57\u6bb5\u201c{0}\u201d\u5728\u7f16\u7801\u4e3a\u201c{1}\u201d\u7684\u4f9b\u9700\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\u4e2d\u4e3a\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"BalanceInvPrepareStep_16", (String)"scmc-im-business", (Object[])new Object[]{demandMatchField, billFieldMapInfo.get("number")})).append("\n");
            }
        }
        DynamicObjectCollection demandSrcEntries = scheme.getDynamicObjectCollection("demandsrcentry");
        for (int i = 0; i < demandSrcEntries.size(); ++i) {
            DynamicObject demandSrcEntry = (DynamicObject)demandSrcEntries.get(i);
            DynamicObject entityInfo = demandSrcEntry.getDynamicObject("demandsrc");
            String srcNumber = entityInfo.getString("number");
            if (!demandEntitySet.contains(srcNumber)) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7684\u9700\u6c42\u6570\u636e\u6765\u6e90\u4e2d\uff0c\u9700\u6c42\u6765\u6e90\u5b9e\u4f53\u201c%1$s\u201d\u5df2\u4ece\u9700\u6c42\u6a21\u578b\u7684\u9700\u6c42\u6570\u636e\u6e90\u914d\u7f6e\u4e2d\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_14", (String)"scmc-im-business", (Object[])new Object[0]), entityInfo.getString("name"))).append("\n");
            }
            if ("invp_safestock_record".equals(srcNumber) || isWorkBench) continue;
            DynamicObject botpInfo = demandSrcEntry.getDynamicObject("demoutputbotp");
            if (botpInfo == null) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7684\u9700\u6c42\u6570\u636e\u6765\u6e90\u7b2c%1$s\u884c\uff0c\u751f\u6210\u8f93\u51fa\u7ed3\u679c\u5355\u636e\u8f6c\u6362\u89c4\u5219\u5df2\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_12", (String)"scmc-im-business", (Object[])new Object[0]), i + 1)).append("\n");
                continue;
            }
            String enabled = botpInfo.getString("enabled");
            if (!STATUS_DISABLE.equals(enabled)) continue;
            msgBuilder.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362\u89c4\u5219\u201c%1$s\u201d\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_9", (String)"scmc-im-business", (Object[])new Object[0]), botpInfo.get("number"))).append("\n");
        }
        if (!isWorkBench && (splitRule = scheme.getDynamicObject("splitrule")) != null && !splitRule.getBoolean("enable")) {
            msgBuilder.append(ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u4e2d\u7684\u5206\u5355\u89c4\u5219\uff08\u7f16\u7801\uff1a{0}\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_20", (String)"scmc-im-business", (Object[])new Object[]{splitRule.getString("number")})).append("\n");
        }
        return msgBuilder.toString();
    }

    private String getOrgParamCheckMsg(DynamicObject scheme) {
        DynamicObjectCollection orgEntries = scheme.getDynamicObjectCollection("orgentryentity");
        StringBuilder msgBuilder = new StringBuilder();
        for (DynamicObject orgEntry : orgEntries) {
            String enable;
            DynamicObject supplyRelationInfo = orgEntry.getDynamicObject("supplyrelation");
            DynamicObject invStrategy = orgEntry.getDynamicObject("invstrategy");
            if (supplyRelationInfo != null && STATUS_DISABLE.equals(enable = supplyRelationInfo.getString("enable"))) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u5185\u90e8\u4f9b\u5e94\u5173\u7cfb\uff08\u7f16\u7801\uff1a%1$s\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_4", (String)"scmc-im-business", (Object[])new Object[0]), supplyRelationInfo.get("number"))).append("\n");
            }
            if (!STATUS_DISABLE.equals(enable = invStrategy.getString("enable"))) continue;
            msgBuilder.append(String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\uff08\u7f16\u7801\uff1a%1$s\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_5", (String)"scmc-im-business", (Object[])new Object[0]), invStrategy.get("number"))).append("\n");
        }
        return msgBuilder.toString();
    }

    private String getSupplyParamCheckMsg(DynamicObject scheme, Set<String> supplyMatchFields) {
        StringBuilder msgBuilder = new StringBuilder();
        DynamicObject supplyModelInfo = scheme.getDynamicObject("supplymodel");
        String enable = supplyModelInfo.getString("enable");
        if (STATUS_DISABLE.equals(enable)) {
            msgBuilder.append(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u6a21\u578b\uff08\u7f16\u7801\uff1a%1$s\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_8", (String)"scmc-im-business", (Object[])new Object[0]), supplyModelInfo.get("number"))).append("\n");
        }
        DynamicObjectCollection modelEntries = supplyModelInfo.getDynamicObjectCollection("entryentityds");
        HashSet<String> supplyEntitySet = new HashSet<String>(modelEntries.size());
        for (DynamicObject modelEntry : modelEntries) {
            String entityNum = modelEntry.getDynamicObject("srcbillds").getString("number");
            supplyEntitySet.add(entityNum);
            DynamicObject billFieldMapInfo = modelEntry.getDynamicObject("billfieldmap");
            boolean isEnable = billFieldMapInfo.getBoolean("isenable");
            if (!isEnable) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u4f9b\u9700\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\uff08\u7f16\u7801\uff1a%1$s\uff09\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_7", (String)"scmc-im-business", (Object[])new Object[0]), billFieldMapInfo.get("number"))).append("\n");
            }
            DynamicObjectCollection colMaps = billFieldMapInfo.getDynamicObjectCollection("colsmap");
            HashSet<String> fields = new HashSet<String>(colMaps.size());
            for (DynamicObject colMap : colMaps) {
                String targetField = colMap.getString("targetobjcol");
                fields.add(targetField);
            }
            if (entityNum.equals("invp_safestock_record")) continue;
            for (String supplyMatchField : supplyMatchFields) {
                if (fields.contains(supplyMatchField)) continue;
                msgBuilder.append(ResManager.loadKDString((String)"\u4f9b\u9700\u5339\u914d\u7ef4\u5ea6\u4e2d\uff0c\u5e73\u8861\u5229\u5e93\u4f9b\u5e94\u5355\u636e\u7684\u5b57\u6bb5\u201c{0}\u201d\u5728\u7f16\u7801\u4e3a\u201c{1}\u201d\u7684\u4f9b\u9700\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\u4e2d\u4e3a\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"BalanceInvPrepareStep_17", (String)"scmc-im-business", (Object[])new Object[]{supplyMatchField, billFieldMapInfo.get("number")})).append("\n");
            }
        }
        DynamicObjectCollection supplySrcEntries = scheme.getDynamicObjectCollection("supplysrcentry");
        for (DynamicObject supplySrcEntry : supplySrcEntries) {
            DynamicObject entityInfo = supplySrcEntry.getDynamicObject("supplysrc");
            if (supplyEntitySet.contains(entityInfo.getString("number"))) continue;
            msgBuilder.append(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u53c2\u6570\u7684\u4f9b\u5e94\u6570\u636e\u6765\u6e90\u4e2d\uff0c\u4f9b\u5e94\u6765\u6e90\u5b9e\u4f53\u201c%1$s\u201d\u5df2\u4ece\u9700\u6c42\u6a21\u578b\u7684\u9700\u6c42\u6570\u636e\u6e90\u914d\u7f6e\u4e2d\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceInvPrepareStep_15", (String)"scmc-im-business", (Object[])new Object[0]), entityInfo.getString("name"))).append("\n");
        }
        return msgBuilder.toString();
    }
}

