/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.func;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class GetSupplyOrg
implements BOSUDFunction {
    private Log logger = LogFactory.getLog(GetSupplyOrg.class);
    private ExpressionContext expContext;
    private Map<Long, Map<String, Object>> delegationOrgMap = new HashMap<Long, Map<String, Object>>(16);
    private Map<Long, Long> accountOrgMap = new HashMap<Long, Long>(16);

    public GetSupplyOrg() {
    }

    public GetSupplyOrg(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new GetSupplyOrg(expContext);
    }

    public String getName() {
        return "GetSupplyOrg";
    }

    public Object call(Object ... params) {
        String entityNumber = params[0].toString();
        long ownerId = Long.parseLong(params[1].toString());
        Long orgId = Long.parseLong(params[2].toString());
        Long reqOrgId = Long.parseLong(params[3].toString());
        this.logger.info("\u5355\u636e\u7f16\u7801\uff1a" + entityNumber + "\u8d27\u4e3b\uff1a" + ownerId + "\u5e93\u5b58\u7ec4\u7ec7\uff1a" + orgId + "\u9700\u6c42\u7ec4\u7ec7\uff1a" + reqOrgId);
        if ("pm_purorderbill".equals(entityNumber) && ownerId != 0L) {
            return ownerId;
        }
        return this.getSupplyOrg(orgId, reqOrgId);
    }

    private long getSupplyOrg(long orgId, long reqOrgId) {
        if (orgId != 0L) {
            HashMap delegation = this.getDelegationMap(orgId);
            delegation = delegation == null ? new HashMap(0) : delegation;
            List orgIdsList = (List)delegation.get("orgId");
            if (orgIdsList == null || orgIdsList.size() == 0) {
                return this.getAccountOrg(orgId);
            }
            if (reqOrgId != 0L) {
                HashSet orgIdsSet = new HashSet(orgIdsList);
                long reqAccountOrg = this.getAccountOrg(reqOrgId);
                if (orgIdsSet.contains(reqAccountOrg)) {
                    return reqAccountOrg;
                }
                List detailList = (List)delegation.get("data");
                for (Map detailMap : detailList) {
                    Boolean isDefault = (Boolean)detailMap.get("isDefault");
                    Object id = detailMap.get("orgId");
                    if (!isDefault.booleanValue() || id == null) continue;
                    return Long.parseLong(id.toString());
                }
                Object firstOrgId = ((Map)detailList.get(0)).get("orgId");
                if (firstOrgId != null) {
                    return Long.parseLong(firstOrgId.toString());
                }
            }
        }
        return 0L;
    }

    private Map<String, Object> getDelegationMap(long orgId) {
        Map delegation = this.delegationOrgMap.get(orgId);
        if (delegation == null) {
            OrgRelationParam param = new OrgRelationParam();
            param.setOrgId(orgId);
            param.setFromViewType("10");
            param.setToViewType("05");
            param.setDirectViewType("fromorg");
            delegation = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
            this.delegationOrgMap.put(orgId, delegation);
        }
        return delegation;
    }

    private long getAccountOrg(long orgId) {
        long accountOrgId = 0L;
        Long accountOrg = this.accountOrgMap.get(orgId);
        if (accountOrg == null) {
            Map orgMap = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            if (orgMap != null) {
                accountOrgId = (Long)orgMap.get("id");
            }
            this.accountOrgMap.put(orgId, accountOrgId);
        } else {
            accountOrgId = accountOrg;
        }
        return accountOrgId;
    }
}

