/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class SupplyPolicy {
    public static final String algoKey = "kd.scmc.im.business.balanceinv.pojo.SupplyPolicy";
    Map<Long, DynamicObject> storageOrgSetMap = new HashMap<Long, DynamicObject>();
    Set<Long> storeTypeSet = new HashSet<Long>();
    Map<Long, Integer> storeStateMap = new HashMap<Long, Integer>();
    int warehouseSetting = 0;
    DynamicObjectCollection warehouseEntries = null;
    Map<Long, Integer> storageOrderMap = new HashMap<Long, Integer>();
    Map<String, Integer> warehouseOrderMap = new HashMap<String, Integer>();
    Map<String, Integer> locationOrderMap = new HashMap<String, Integer>();

    public SupplyPolicy(DynamicObject supplyPolicy) {
        this.init(supplyPolicy);
    }

    private void init(DynamicObject supplyPolicy) {
        DynamicObjectCollection orgEntries = supplyPolicy.getDynamicObjectCollection("orgentity");
        for (Object orgEntry : orgEntries) {
            long storageOrgId = orgEntry.getDynamicObject("invorg").getLong("id");
            this.storageOrgSetMap.put(storageOrgId, (DynamicObject)orgEntry);
            this.storageOrderMap.put(storageOrgId, orgEntry.getInt("priority"));
        }
        DynamicObjectCollection storeTypeEntries = supplyPolicy.getDynamicObjectCollection("invtypeentry");
        this.storeTypeSet.add(-1L);
        for (DynamicObject storeTypeEntry : storeTypeEntries) {
            if (!storeTypeEntry.getBoolean("isinvtypecal")) continue;
            this.storeTypeSet.add(storeTypeEntry.getDynamicObject("invtype").getLong("id"));
        }
        DynamicObjectCollection storeStateEntries = supplyPolicy.getDynamicObjectCollection("invstatusentry");
        this.storeStateMap.put(-1L, -1);
        for (DynamicObject storeStateEntry : storeStateEntries) {
            if (!storeStateEntry.getBoolean("isstatuscal")) continue;
            int storeStateOrder = storeStateEntry.get("invstatuspriority") == null ? -1 : storeStateEntry.getInt("invstatuspriority");
            this.storeStateMap.put(storeStateEntry.getDynamicObject("invstatus").getLong("id"), storeStateOrder);
        }
        this.warehouseSetting = supplyPolicy.getInt("warehousesetup");
        this.warehouseEntries = supplyPolicy.getDynamicObjectCollection("warehouseentry");
        if (this.warehouseSetting == 2) {
            for (DynamicObject warehouseEntry : this.warehouseEntries) {
                String orderSign;
                DynamicObject location = warehouseEntry.getDynamicObject("location");
                DynamicObject warehouse = warehouseEntry.getDynamicObject("warehouse");
                DynamicObject storageOrg = warehouseEntry.getDynamicObject("warehouseinvorg");
                int order = warehouseEntry.getInt("supplypriority");
                if (location != null) {
                    orderSign = storageOrg.getString("id") + "$" + warehouse.getString("id") + "$" + location.getString("id");
                    this.locationOrderMap.put(orderSign, order);
                    continue;
                }
                orderSign = storageOrg.getString("id") + "$" + warehouse.getString("id");
                this.warehouseOrderMap.put(orderSign, order);
            }
        }
    }

    public List<QFilter> getPolicyFilterList(String storageOrgField, String warehouseField, String locationField, String storeTypeField, String storeStateField, String entityNum) {
        QFilter filter;
        Set<Long> storageOrgIdSet;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (!StringUtils.isEmpty((String)storageOrgField) && this.storageOrgSetMap.size() > 0 && (storageOrgIdSet = this.storageOrgSetMap.keySet()).size() > 0) {
            QFilter filter2 = new QFilter(storageOrgField, "in", storageOrgIdSet);
            filterList.add(filter2);
        }
        if (!StringUtils.isEmpty((String)storeTypeField) && this.storeTypeSet.size() > 0) {
            filter = new QFilter(storeTypeField, "in", this.storeTypeSet);
            filterList.add(filter);
        }
        if (!StringUtils.isEmpty((String)storeStateField) && this.storeStateMap.size() > 0) {
            filter = new QFilter(storeStateField, "in", this.storeStateMap.keySet());
            filterList.add(filter);
        }
        QFilter warehouseEntryFilter = null;
        switch (this.warehouseSetting) {
            case 2: {
                warehouseEntryFilter = this.getWarehouseEntryFilter(storageOrgField, warehouseField, locationField);
                break;
            }
            case 3: {
                warehouseEntryFilter = this.getWarehouseEntryFilter(storageOrgField, warehouseField, locationField);
                DataSet idDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityNum, (String)"id", (QFilter[])warehouseEntryFilter.toArray(), (String)"");
                HashSet<Long> idSet = new HashSet<Long>();
                for (Row row : idDataSet) {
                    idSet.add(row.getLong("id"));
                }
                warehouseEntryFilter = new QFilter("id", "not in", idSet);
                break;
            }
        }
        if (warehouseEntryFilter != null) {
            filterList.add(warehouseEntryFilter);
        }
        return filterList;
    }

    public QFilter getPrePolicyFilterList(String storageOrgField) {
        Set<Long> storageOrgIdSet;
        QFilter filterList = null;
        String string = storageOrgField = StringUtils.isNotEmpty((String)storageOrgField) ? storageOrgField : "entryentity.stockorg";
        if (this.storageOrgSetMap.size() > 0 && (storageOrgIdSet = this.storageOrgSetMap.keySet()).size() > 0) {
            filterList = new QFilter(storageOrgField, "in", storageOrgIdSet);
        }
        return filterList;
    }

    private QFilter getWarehouseEntryFilter(String storageOrgField, String warehouseField, String locationField) {
        if (this.warehouseEntries != null && this.warehouseEntries.size() > 0) {
            ArrayList<QFilter> warehouseEntryFilterList = new ArrayList<QFilter>();
            for (DynamicObject warehouseEntry : this.warehouseEntries) {
                QFilter filter = null;
                if (!StringUtils.isEmpty((String)storageOrgField)) {
                    long storageOrgId = warehouseEntry.getDynamicObject("warehouseinvorg").getLong("id");
                    filter = new QFilter(storageOrgField, "=", (Object)storageOrgId);
                }
                if (!StringUtils.isEmpty((String)warehouseField)) {
                    long warehouseId = warehouseEntry.getDynamicObject("warehouse").getLong("id");
                    if (filter == null) {
                        filter = new QFilter(warehouseField, "=", (Object)warehouseId);
                    } else {
                        filter.and(new QFilter(warehouseField, "=", (Object)warehouseId));
                    }
                }
                if (!StringUtils.isEmpty((String)locationField) && warehouseEntry.get("location") != null) {
                    long locationId = warehouseEntry.getDynamicObject("location").getLong("id");
                    if (filter == null) {
                        filter = new QFilter(locationField, "=", (Object)locationId);
                    } else {
                        filter.and(new QFilter(locationField, "=", (Object)locationId));
                    }
                }
                if (filter == null) continue;
                warehouseEntryFilterList.add(filter);
            }
            if (warehouseEntryFilterList.size() > 0) {
                QFilter filter = (QFilter)warehouseEntryFilterList.get(0);
                int size = warehouseEntryFilterList.size();
                for (int i = 1; i < size; ++i) {
                    filter = filter.or((QFilter)warehouseEntryFilterList.get(i));
                }
                return filter;
            }
        }
        return null;
    }

    public Map<Long, DynamicObject> getStorageOrgSetMap() {
        return this.storageOrgSetMap;
    }

    public Map<Long, Integer> getStoreStateMap() {
        return this.storeStateMap;
    }

    public int getWarehouseSetting() {
        return this.warehouseSetting;
    }

    public DynamicObjectCollection getWarehouseEntries() {
        return this.warehouseEntries;
    }

    public Map<Long, Integer> getStorageOrderMap() {
        return this.storageOrderMap;
    }

    public Map<String, Integer> getWarehouseOrderMap() {
        return this.warehouseOrderMap;
    }

    public Map<String, Integer> getLocationOrderMap() {
        return this.locationOrderMap;
    }
}

