/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.pojo;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class SupplyRelation {
    Map<Long, Integer> supplyOrg2OrderMap = new HashMap<Long, Integer>();
    Map<Long, Boolean> supplyOrg2ProviderMap = new HashMap<Long, Boolean>();

    public SupplyRelation(DynamicObject supplyRelation) {
        this.init(supplyRelation);
    }

    private void init(DynamicObject supplyRelation) {
        DynamicObjectCollection entries = supplyRelation.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            long supplyOrgId = entry.getDynamicObject("supplyorgunit").getLong("id");
            this.supplyOrg2OrderMap.put(supplyOrgId, entry.getInt("supplyorder"));
            this.supplyOrg2ProviderMap.put(supplyOrgId, entry.getBoolean("issafeinvprovide"));
        }
    }

    public Map<Long, Integer> getSupplyOrg2OrderMap() {
        return this.supplyOrg2OrderMap;
    }

    public Map<Long, Boolean> getSupplyOrg2ProviderMap() {
        return this.supplyOrg2ProviderMap;
    }

    public QFilter getRelationFilter(String supplyOrgField) {
        if (!StringUtils.isEmpty((String)supplyOrgField) && this.supplyOrg2OrderMap.size() > 0) {
            return new QFilter(supplyOrgField, "in", this.supplyOrg2OrderMap.keySet());
        }
        return null;
    }
}

