/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.steps.impl;

import java.util.ArrayList;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.business.balanceinv.steps.IBalanceInventoryStep;

public class BalanceInvClearOldDataStep
implements IBalanceInventoryStep {
    private StepResult stepResult = new StepResult();
    private String ALGO = "kd.scmc.im.business.balanceinv.steps.impl.BalanceInvClearOldDataStep";

    @Override
    public StepResult execute() {
        BalanceInvContext ctx = BalanceInvContext.get();
        StringBuilder errorMsgBuilder = new StringBuilder();
        Long schemeId = ctx.getSchemeId();
        int processCount = 0;
        int successCount = 0;
        int failCount = 0;
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter filter = new QFilter("balanceinvscheme", "=", (Object)schemeId).and("billstatus", "=", (Object)"A").and("creator", "=", (Object)currUserId);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.ALGO, (String)"im_balanceinv_advice", (String)"id", (QFilter[])filter.toArray(), (String)"");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (Object row : dataSet) {
            idList.add(row.getLong("id"));
        }
        if (!idList.isEmpty()) {
            block20: {
                Object row;
                processCount = idList.size();
                TXHandle txHandle = TX.requiresNew((String)"balanceinv_delete_advice");
                row = null;
                try {
                    try {
                        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"im_balanceinv_advice", (Object[])idList.toArray(), (OperateOption)OperateOption.create());
                        if (!result.isSuccess()) {
                            errorMsgBuilder.append(ResManager.loadKDString((String)"\u6e05\u7406\u5386\u53f2\u5229\u5e93\u5efa\u8bae\u5931\u8d25\uff1a", (String)"BalanceInvClearOldDataStep_0", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
                            errorMsgBuilder.append(BalanceInvExecuteHelper.getBillOperateErrorMsg(result));
                        }
                    }
                    catch (Exception e) {
                        txHandle.markRollback();
                        errorMsgBuilder.append(ResManager.loadKDString((String)"\u6e05\u7406\u5386\u53f2\u5229\u5e93\u5efa\u8bae\u5931\u8d25\uff1a", (String)"BalanceInvClearOldDataStep_0", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
                        if (ctx.getDebugMode()) {
                            errorMsgBuilder.append(BalanceInvExecuteHelper.getExceptionMessage(e));
                            break block20;
                        }
                        errorMsgBuilder.append(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"BalanceInvStepExecutor_1", (String)"scmc-im-business", (Object[])new Object[0]));
                    }
                }
                catch (Throwable e) {
                    row = e;
                    throw e;
                }
                finally {
                    if (txHandle != null) {
                        if (row != null) {
                            try {
                                txHandle.close();
                            }
                            catch (Throwable e) {
                                ((Throwable)row).addSuppressed(e);
                            }
                        } else {
                            txHandle.close();
                        }
                    }
                }
            }
            dataSet = QueryServiceHelper.queryDataSet((String)this.ALGO, (String)"im_balanceinv_advice", (String)"id", (QFilter[])filter.toArray(), (String)"");
            failCount = dataSet.count("id", true);
            successCount = processCount - failCount;
        }
        this.stepResult.setProcessData(processCount);
        StringBuilder detailMsgBuilder = new StringBuilder();
        detailMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u6e05\u7406\u5386\u53f2\u6570\u636e\uff1a\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"BalanceInvClearOldDataStep_1", (String)"scmc-im-business", (Object[])new Object[0]), successCount, failCount)).append("\n");
        detailMsgBuilder.append((CharSequence)errorMsgBuilder);
        if (!StringUtils.isEmpty((String)errorMsgBuilder.toString())) {
            this.stepResult.setSuccess(false);
            this.stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_B);
        }
        this.stepResult.setDetailMsg(detailMsgBuilder.toString());
        Set<Long> needDeleteIds = BalanceInvExecuteHelper.getNeedClearMatchDetail(ctx.getSchemeId());
        if (needDeleteIds != null && !needDeleteIds.isEmpty()) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"im_balanceinv_matchdetail");
            DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])needDeleteIds.toArray());
        }
        return this.stepResult;
    }
}

