/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.steps.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.reserve.mservice.InventorySearchResult;
import kd.mpscmm.msbd.reserve.mservice.ReserveService;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.MatchInfo;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.business.balanceinv.pojo.SupplyQtyInfo;
import kd.scmc.im.business.balanceinv.pojo.SupplyRelation;
import kd.scmc.im.business.balanceinv.pojo.SupplySafeQtyInfo;
import kd.scmc.im.business.balanceinv.pojo.UnMatchInfo;
import kd.scmc.im.business.balanceinv.steps.IBalanceInventoryStep;
import kd.scmc.im.business.helper.botp.BOTPLinkHelper;

public class BalanceInvMatchStep
implements IBalanceInventoryStep {
    private Log logger = LogFactory.getLog((String)this.getClass().getName());
    private StepResult stepResult = new StepResult();
    private Map<Long, Integer> unitPrecisionCache = new HashMap<Long, Integer>();
    Map<String, List<DynamicObject>> groupedMatchMap = new HashMap<String, List<DynamicObject>>();
    Map<Long, List<UnMatchInfo>> entryIdUnMatchMap = new HashMap<Long, List<UnMatchInfo>>();
    private StringBuilder stepErrorMsg = new StringBuilder();

    @Override
    public StepResult execute() {
        BalanceInvContext ctx = BalanceInvContext.get();
        DynamicObjectCollection demandBillCol = ctx.getDemandBillCol();
        BalanceInventoryScheme scheme = ctx.getScheme();
        this.matchDemandAndSupply(demandBillCol, scheme);
        ctx.getSupplyBillGroupedMap().clear();
        ctx.getEntryId2SupplyQtyMap().clear();
        ctx.setEntryIdUnMatchMap(this.entryIdUnMatchMap);
        ctx.setGroupedMatchMap(this.groupedMatchMap);
        boolean needReserve = BalanceInvExecuteHelper.getNeedReserve();
        if (needReserve) {
            this.doReserve();
        }
        ctx.getDemandBillCol().clear();
        if (!StringUtils.isEmpty((String)this.stepErrorMsg.toString())) {
            this.stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_E);
            this.stepResult.setDetailMsg(this.stepResult.getDetailMsg() + this.stepErrorMsg);
        }
        return this.stepResult;
    }

    private void matchDemandAndSupply(DynamicObjectCollection demandBills, BalanceInventoryScheme balanceScheme) {
        if (demandBills == null || demandBills.isEmpty()) {
            return;
        }
        BalanceInvContext ctx = BalanceInvContext.get();
        int matchCount = 0;
        int unMatchCount = 0;
        List<String> demandNullMatchFields = ctx.getScheme().getDemandNullMatchFields();
        List<String> supplyNullMatchFields = ctx.getScheme().getSupplyNullMatchFields();
        Map demandBillGroupedMap = demandBills.stream().collect(Collectors.groupingBy(demandBill -> demandBill.getString("entryentity.flexmetricid"), Collectors.toList()));
        for (Map.Entry demandBillGroupedEntry : demandBillGroupedMap.entrySet()) {
            int demandOrder = 0;
            List demandBillList = demandBillGroupedEntry.getValue();
            String groupValue = demandBillGroupedEntry.getKey();
            for (DynamicObject demandBill2 : demandBillList) {
                BigDecimal curDemandBaseQty;
                ++demandOrder;
                BigDecimal originDemandBaseQty = demandBill2.getBigDecimal("entryentity.demandqty");
                if (ctx.getDebugMode()) {
                    this.logger.info("\u9700\u6c42\u5355\u7cbe\u786e\u5f00\u59cb\u5339\u914d\u5206\u5f55ID\uff1a" + demandBill2.getString("entryentity.billentryid") + "\u9700\u6c42\u6570\u91cf\uff1a" + originDemandBaseQty.toPlainString() + "\n");
                }
                if (originDemandBaseQty.compareTo(BigDecimal.ZERO) == 0) continue;
                String allMatchKey = demandBill2.getString("entryentity.demandorg") + "$" + demandBill2.getString("allmatchfieldkey");
                if (ctx.getDebugMode()) {
                    this.logger.info("\u5339\u914d\u7ef4\u5ea6\u503c\uff1a" + allMatchKey + "\n");
                }
                List<DynamicObject> supplyBills = ctx.getSupplyNullGroupedMap().get(allMatchKey);
                StringBuilder nullMatchBuilder = new StringBuilder();
                HashSet<String> supplyNullFields = new HashSet<String>();
                for (int i = 0; i < demandNullMatchFields.size(); ++i) {
                    String field = demandNullMatchFields.get(i);
                    if (BalanceInvExecuteHelper.getValue(demandBill2, field) == null || StringUtils.isEmpty((String)BalanceInvExecuteHelper.getValue(demandBill2, field).toString()) || BalanceInvExecuteHelper.getValue(demandBill2, field) instanceof Long && (Long)BalanceInvExecuteHelper.getValue(demandBill2, field) == 0L) {
                        supplyNullFields.add(supplyNullMatchFields.get(i));
                        nullMatchBuilder.append("null");
                    } else {
                        nullMatchBuilder.append(demandBill2.getString(field));
                    }
                    nullMatchBuilder.append("$");
                }
                String demandNullMatchKey = nullMatchBuilder.toString();
                if (supplyBills != null && !supplyBills.isEmpty()) {
                    for (DynamicObject supplyBill : supplyBills) {
                        curDemandBaseQty = demandBill2.getBigDecimal("entryentity.demandqty");
                        if (curDemandBaseQty.compareTo(BigDecimal.ZERO) == 0) break;
                        matchCount = this.matchOneBill(matchCount, demandOrder, demandBill2, originDemandBaseQty, supplyBill);
                    }
                }
                if (demandBill2.getBigDecimal("entryentity.demandqty").compareTo(BigDecimal.ZERO) > 0 && !supplyNullFields.isEmpty() && (supplyBills = ctx.getSupplyBillGroupedMap().get(demandBill2.getString("entryentity.demandorg") + "$" + groupValue)) != null && !supplyBills.isEmpty()) {
                    if (ctx.getDebugMode()) {
                        this.logger.info("\u9700\u6c42\u5355\u5f00\u59cb\u6a21\u7cca\u5339\u914d\u5206\u5f55ID\uff1a" + demandBill2.getString("entryentity.billentryid") + "\u9700\u6c42\u6570\u91cf\uff1a" + demandBill2.getBigDecimal("entryentity.demandqty").toPlainString() + "\n");
                        this.logger.info("\u5339\u914d\u7ef4\u5ea6\u503c\uff1a" + demandBill2.getString("entryentity.demandorg") + "$" + groupValue + "\n");
                    }
                    for (DynamicObject supplyBill : supplyBills) {
                        curDemandBaseQty = demandBill2.getBigDecimal("entryentity.demandqty");
                        if (curDemandBaseQty.compareTo(BigDecimal.ZERO) == 0) break;
                        String supplyNullMatchKey = this.getSupplyNullMatchKey(supplyBill, supplyNullMatchFields, supplyNullFields);
                        if (!demandNullMatchKey.equals(supplyNullMatchKey)) continue;
                        matchCount = this.matchOneBill(matchCount, demandOrder, demandBill2, originDemandBaseQty, supplyBill);
                    }
                }
                if (demandBill2.getBigDecimal("entryentity.demandqty").compareTo(BigDecimal.ZERO) > 0) {
                    ++unMatchCount;
                    DynamicObject matchResultEntry = BalanceInvExecuteHelper.addNoSupplyMatchResultEntry(demandBill2, originDemandBaseQty, demandBill2.getBigDecimal("entryentity.demandqty"), demandOrder);
                    if (ctx.getDebugMode()) {
                        this.logger.info("\u5206\u5f55\uff1a" + demandBill2.get("entryentity.billentryid") + "\u5b58\u5728\u51c0\u9700\u6c42\u6570\u91cf" + demandBill2.getBigDecimal("entryentity.demandqty"));
                    }
                    BigDecimal demandQty = demandBill2.getBigDecimal("entryentity.demandqty");
                    UnMatchInfo unMatchInfo = BalanceInvExecuteHelper.buildUnMatchInfo(demandBill2, demandQty);
                    unMatchInfo.setMatchEntryInfo(matchResultEntry);
                    this.entryIdUnMatchMap.putIfAbsent(unMatchInfo.getEntryId(), new ArrayList());
                    this.entryIdUnMatchMap.get(unMatchInfo.getEntryId()).add(unMatchInfo);
                }
                if (!ctx.getDebugMode()) continue;
                this.logger.info("\u5206\u5f55\uff1a" + demandBill2.get("entryentity.billentryid") + "\u5339\u914d\u7ed3\u675f");
            }
        }
        this.stepResult.setProcessData(matchCount + unMatchCount);
        this.stepResult.setDetailMsg(String.format(ResManager.loadKDString((String)"\u5339\u914d\u6570\u636e\u91cf\uff1a%1$s\u6761\uff0c\u672a\u5339\u914d\u6570\u636e\u91cf\uff1a%2$s\u6761\u3002", (String)"BalanceInvMatchStep_0", (String)"scmc-im-business", (Object[])new Object[0]), matchCount, unMatchCount));
    }

    private String getSupplyNullMatchKey(DynamicObject supplyBill, List<String> supplyNullMatchFields, Set<String> supplyNullFields) {
        StringBuilder matchValueSb = new StringBuilder();
        for (String field : supplyNullMatchFields) {
            if (BalanceInvExecuteHelper.getValue(supplyBill, field) == null || supplyNullFields.contains(field)) {
                matchValueSb.append("null");
            } else {
                matchValueSb.append(supplyBill.getString(field));
            }
            matchValueSb.append("$");
        }
        return matchValueSb.toString();
    }

    private int matchOneBill(int matchCount, int demandOrder, DynamicObject demandBill, BigDecimal originDemandBaseQty, DynamicObject supplyBill) {
        BalanceInvContext ctx = BalanceInvContext.get();
        BalanceInventoryScheme balanceScheme = ctx.getScheme();
        long demandOrgId = demandBill.getLong("entryentity.demandorg");
        SupplyRelation supplyRelation = balanceScheme.getSupplyRelationMap().get(demandOrgId);
        SupplyQtyInfo supplyQtyInfo = ctx.getEntryId2SupplyQtyMap().get(supplyBill.getLong("entryentity.billentryid"));
        if (supplyQtyInfo == null) {
            return matchCount;
        }
        BigDecimal supplyBaseQty = this.getSupplyBaseQty(supplyRelation, supplyBill, supplyQtyInfo);
        if (supplyBaseQty.compareTo(BigDecimal.ZERO) <= 0) {
            return matchCount;
        }
        BigDecimal curDemandBaseQty = demandBill.getBigDecimal("entryentity.demandqty");
        BigDecimal matchBaseQty = curDemandBaseQty.compareTo(supplyBaseQty) <= 0 ? curDemandBaseQty : supplyBaseQty;
        BigDecimal matchQty = BigDecimal.ZERO;
        BigDecimal matchQty2nd = BigDecimal.ZERO;
        if (BalanceInvExecuteHelper.getValue(supplyBill, "entryentity.unit") != null) {
            matchQty = BalanceInvExecuteHelper.calculateQtyByBaseQty(matchBaseQty, supplyBill.getLong("entryentity.material"), supplyBill.getLong("entryentity.unit"), supplyBill.getLong("entryentity.baseunit"), this.unitPrecisionCache);
        }
        if (BalanceInvExecuteHelper.getValue(supplyBill, "entryentity.assistunit") != null && BalanceInvExecuteHelper.getValue(supplyBill, "entryentity.originassitqty") != null && supplyBill.getBigDecimal("entryentity.originassitqty").compareTo(BigDecimal.ZERO) != 0) {
            matchQty2nd = matchBaseQty.multiply(supplyBill.getBigDecimal("entryentity.originassitqty")).divide(supplyBill.getBigDecimal("entryentity.originbaseqty"), BalanceInvExecuteHelper.getUnitPrecision(supplyBill.getLong("entryentity.assistunit"), this.unitPrecisionCache), RoundingMode.HALF_UP);
        }
        MatchInfo matchInfo = new MatchInfo(matchQty, matchBaseQty, matchQty2nd, originDemandBaseQty, curDemandBaseQty);
        demandBill.set("entryentity.demandqty", (Object)curDemandBaseQty.subtract(matchBaseQty));
        supplyQtyInfo.setBaseQty(supplyQtyInfo.getBaseQty().subtract(matchBaseQty));
        supplyQtyInfo.setQty(supplyQtyInfo.getQty().subtract(matchQty));
        supplyQtyInfo.setQty2nd(supplyQtyInfo.getQty2nd().subtract(matchQty2nd));
        SupplySafeQtyInfo safeQtyInfo = supplyQtyInfo.getSafeQtyInfo();
        if (safeQtyInfo != null) {
            safeQtyInfo.setTotalQty(safeQtyInfo.getTotalQty().subtract(matchBaseQty));
        }
        ++matchCount;
        DynamicObject matchResultEntry = BalanceInvExecuteHelper.addMatchResultEntry(demandBill, supplyBill, matchInfo, demandOrder);
        String matchedGroupValue = BalanceInvExecuteHelper.getMatchedGroupValue(matchResultEntry);
        this.groupedMatchMap.putIfAbsent(matchedGroupValue, new ArrayList());
        this.groupedMatchMap.get(matchedGroupValue).add(matchResultEntry);
        return matchCount;
    }

    private BigDecimal getSupplyBaseQty(SupplyRelation supplyRelation, DynamicObject supplyBill, SupplyQtyInfo supplyQtyInfo) {
        boolean safeInvCanSupply = true;
        if (supplyRelation != null && supplyRelation.getSupplyOrg2ProviderMap().containsKey(supplyBill.getLong("entryentity.supplyorgunit"))) {
            safeInvCanSupply = supplyRelation.getSupplyOrg2ProviderMap().get(supplyBill.getLong("entryentity.supplyorgunit"));
        }
        BigDecimal supplyBaseQty = supplyQtyInfo.getBaseQty();
        if (BalanceInvContext.get().getDebugMode()) {
            this.logger.info("\u4f9b\u5e94\u5355\u5206\u5f55ID\uff1a" + supplyBill.getLong("entryentity.billentryid") + "\uff0c\u4f9b\u5e94\u6570\u91cf\uff1a" + supplyBaseQty.toPlainString());
        }
        if (!safeInvCanSupply && supplyQtyInfo.getSafeQtyInfo() != null) {
            BigDecimal usableQty = supplyQtyInfo.getSafeQtyInfo().getUsableQty();
            BigDecimal bigDecimal = supplyBaseQty = supplyBaseQty.compareTo(usableQty) > 0 ? usableQty : supplyBaseQty;
            if (BalanceInvContext.get().getDebugMode()) {
                this.logger.info("\u4f9b\u5e94\u5355\u5206\u5f55ID\uff1a" + supplyBill.getLong("entryentity.billentryid") + "\uff0c\u5b89\u5168\u5e93\u5b58\u4e0d\u53ef\u4f9b\uff0c\u6263\u9664\u5b89\u5168\u5e93\u5b58\u540e\u53ef\u4f9b\u5e94\u6570\u91cf\uff1a" + supplyBaseQty.toPlainString());
            }
        }
        return supplyBaseQty;
    }

    private void doReserve() {
        block22: {
            HashSet<Long> ids = new HashSet<Long>();
            HashSet<Long> entryIds = new HashSet<Long>();
            DynamicObjectCollection demandBillCol = BalanceInvContext.get().getDemandBillCol();
            for (DynamicObject dynamicObject : demandBillCol) {
                ids.add(dynamicObject.getLong("entryentity.billid"));
                entryIds.add(dynamicObject.getLong("entryentity.billentryid"));
            }
            if (ids.isEmpty() || entryIds.isEmpty()) {
                return;
            }
            Map<Long, Map<String, Object>> botpLink = BOTPLinkHelper.getDemandBOTPLinkBillEntryIds("pm_requirapplybill", "billentry", ids.toArray(new Long[0]), entryIds.toArray(new Long[0]));
            HashMap<String, List> reserveParamList = new HashMap<String, List>(16);
            HashMap<Long, String> srcReqBillId2CurBillId = new HashMap<Long, String>(16);
            for (Map.Entry<String, List<DynamicObject>> entry : this.groupedMatchMap.entrySet()) {
                for (DynamicObject matchInfo : entry.getValue()) {
                    String demandBillType = matchInfo.getString("demandbilltype");
                    String invType = matchInfo.getString("invstocktype");
                    if (!"pm_requirapplybill".equals(demandBillType) || !"B".equals(invType)) continue;
                    String supplyBillType = matchInfo.getString("supplybilltype");
                    Object billId = matchInfo.get("demandbillid");
                    Object entryId = matchInfo.get("demandentryid");
                    Map<String, Object> param = BalanceInvExecuteHelper.buildReserveParam(matchInfo, botpLink, true);
                    Long srcBillEntryId = (Long)param.get("billEntryId");
                    srcReqBillId2CurBillId.computeIfAbsent(srcBillEntryId, k -> billId + "-" + entryId);
                    reserveParamList.computeIfAbsent(supplyBillType, k -> new ArrayList()).add(param);
                }
            }
            try (TXHandle h = TX.requiresNew((String)"matchstep-generate-reserve");){
                try {
                    ArrayList<DynamicObject> preSupplyRecordList = new ArrayList<DynamicObject>();
                    for (Map.Entry entry : reserveParamList.entrySet()) {
                        InventorySearchResult result = ReserveService.reserveBatchNoScheme((String)((String)entry.getKey()), (String)"pm_requirapplybill", (boolean)false, (List)((List)entry.getValue()));
                        if (result.isSuccess()) {
                            preSupplyRecordList.addAll(this.createPreSupplyRecordObj(result.getCol(), srcReqBillId2CurBillId));
                            continue;
                        }
                        this.stepErrorMsg.append(ResManager.loadKDString((String)"\u9884\u7559\u5931\u8d25\uff1a", (String)"BalanceInvGenMatchAdviseStep_3", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
                        this.stepErrorMsg.append(result.getErrMsg()).append("\n");
                    }
                    if (preSupplyRecordList.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])preSupplyRecordList.toArray(new DynamicObject[0]));
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                    this.logger.error((Throwable)e);
                    this.stepErrorMsg.append(ResManager.loadKDString((String)"\u8c03\u7528\u9884\u7559\u670d\u52a1\u5931\u8d25\uff1a", (String)"BalanceInvMatchStep_1", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
                    if (BalanceInvContext.get().getDebugMode()) {
                        this.stepErrorMsg.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                        break block22;
                    }
                    this.stepErrorMsg.append(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"BalanceInvStepExecutor_1", (String)"scmc-im-business", (Object[])new Object[0]));
                }
            }
        }
    }

    private List<DynamicObject> createPreSupplyRecordObj(DynamicObjectCollection reserveRecordCol, Map<Long, String> srcReqBillId2CurBillId) {
        Date now = new Date();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        for (DynamicObject reserveRecord : reserveRecordCol) {
            DynamicObject preSupplyRecord = BusinessDataServiceHelper.newDynamicObject((String)"balanceinv_pre_record");
            preSupplyRecord.set("reserverecord", reserveRecord.getPkValue());
            Long reqBillId = 0L;
            Long reqBillEntryId = 0L;
            Long srcBillEntryId = reserveRecord.getLong("billentry_id");
            String reqBillInfo = srcReqBillId2CurBillId.get(srcBillEntryId);
            if (StringUtils.isNotEmpty((String)reqBillInfo)) {
                String[] billInfo = reqBillInfo.split("-");
                reqBillId = Long.valueOf(billInfo[0]);
                reqBillEntryId = Long.valueOf(billInfo[1]);
            }
            preSupplyRecord.set("billid", (Object)reqBillId);
            preSupplyRecord.set("billentryid", (Object)reqBillEntryId);
            preSupplyRecord.set("createdate", (Object)now);
            result.add(preSupplyRecord);
        }
        return result;
    }
}

