/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.steps.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.BalanceInvSchemeChecker;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.business.balanceinv.steps.IBalanceInventoryStep;
import kd.scmc.im.helper.InvDbParamHelper;

public class BalanceInvPrepareStep
implements IBalanceInventoryStep {
    private static final String STATUS_DISABLE = "0";
    private StepResult stepResult = new StepResult();

    @Override
    public StepResult execute() {
        BalanceInvContext ctx = BalanceInvContext.get();
        if (this.reserveValidate()) {
            String errorMsg = ResManager.loadKDString((String)"\u542f\u7528\u603b\u91cf\u9884\u7559\u548c\u5e73\u8861\u5229\u5e93\u4e0d\u80fd\u540c\u65f6\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BalanceInvPrepareStep_21", (String)"scmc-im-business", (Object[])new Object[0]);
            this.buildFailStepResult(errorMsg);
            return this.stepResult;
        }
        DLock lock = ctx.getLock();
        if (!lock.tryLock()) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5229\u5e93\u7ec4\u7ec7\u6b63\u5728\u8fdb\u884c\u5e73\u8861\u5229\u5e93\u8fd0\u7b97\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BalanceInvPrepareStep_0", (String)"scmc-im-business", (Object[])new Object[0]);
            this.buildFailStepResult(errorMsg);
            return this.stepResult;
        }
        Long schemeId = ctx.getSchemeId();
        Long balanceOrgId = ctx.getBalanceOrgId();
        if (schemeId == null) {
            DynamicObject balanceOrgInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)balanceOrgId, (String)"bos_org", (String)"name");
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4%1$s\u7684\u5229\u5e93\u65b9\u6848\u3002", (String)"BalanceInvPrepareStep_1", (String)"scmc-im-business", (Object[])new Object[0]), balanceOrgInfo.getString("name"));
            this.buildFailStepResult(errorMsg);
            return this.stepResult;
        }
        BalanceInvSchemeChecker checker = new BalanceInvSchemeChecker();
        DynamicObject scheme = this.getBalanceSchemeByBalanceOrg(balanceOrgId);
        String checkMsg = checker.checkSchemeDynamicObj(scheme, false);
        if (!StringUtils.isEmpty((String)checkMsg)) {
            this.buildFailStepResult(checkMsg);
            return this.stepResult;
        }
        BalanceInventoryScheme balanceScheme = new BalanceInventoryScheme(scheme);
        ctx.setScheme(balanceScheme);
        checkMsg = checker.checkSchemeInfo(balanceScheme);
        if (!StringUtils.isEmpty((String)checkMsg)) {
            this.buildFailStepResult(checkMsg);
            return this.stepResult;
        }
        DynamicObject matchResultInfo = this.buildMatchResultInfo(balanceScheme);
        matchResultInfo.set("calculatenum", (Object)ctx.getCalcNum());
        ctx.setMatchResultInfo(matchResultInfo);
        Set<Long> materialIdSet = BalanceInvExecuteHelper.getDemandMaterialIdSet(ctx.getEntityNum(), balanceScheme, ctx.getEntryIds());
        ctx.setMaterialIdSet(materialIdSet);
        boolean debugMode = InvDbParamHelper.getInvDbParam((String)"balanceinvdebugmode");
        ctx.setDebugMode(debugMode);
        return this.stepResult;
    }

    private boolean reserveValidate() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)1406552222187325440L, (String)"msmod_total_reserveset", (String)"isenable");
        return dynamicObject.getBoolean("isenable");
    }

    private DynamicObject buildMatchResultInfo(BalanceInventoryScheme balanceScheme) {
        DynamicObject matchResult = BusinessDataServiceHelper.newDynamicObject((String)"im_balanceinv_matchdetail");
        matchResult.set("scheme", (Object)balanceScheme.getId());
        matchResult.set("createtime", (Object)TimeServiceHelper.now());
        matchResult.set("comfirmstatus", (Object)"1");
        matchResult.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        return matchResult;
    }

    private void buildFailStepResult(String errorMsg) {
        this.stepResult.setSuccess(false);
        this.stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_B);
        this.stepResult.setDetailMsg(errorMsg);
    }

    private DynamicObject getBalanceSchemeByBalanceOrg(Long planOrgId) {
        long fieldMapId;
        QFilter[] filterArr = new QFilter("balanceinvorg", "=", (Object)planOrgId).and("enable", "=", (Object)"1").toArray();
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((String)"balanceinv_scheme", (QFilter[])filterArr);
        if (scheme == null) {
            return null;
        }
        DynamicObject demandModel = BusinessDataServiceHelper.loadSingle((Object)scheme.getDynamicObject("demandmodel").getLong("id"), (String)"balanceinv_register");
        scheme.set("demandmodel", (Object)demandModel);
        DynamicObject supplyModel = BusinessDataServiceHelper.loadSingle((Object)scheme.getDynamicObject("supplymodel").getLong("id"), (String)"balanceinv_register");
        scheme.set("supplymodel", (Object)supplyModel);
        HashSet<Long> filedMapIdSet = new HashSet<Long>();
        DynamicObjectCollection demandEntries = demandModel.getDynamicObjectCollection("entryentityds");
        for (Object entry : demandEntries) {
            filedMapIdSet.add(entry.getDynamicObject("billfieldmap").getLong("id"));
        }
        DynamicObjectCollection supplyEntries = supplyModel.getDynamicObjectCollection("entryentityds");
        for (DynamicObject entry : supplyEntries) {
            filedMapIdSet.add(entry.getDynamicObject("billfieldmap").getLong("id"));
        }
        Map fieldMap = BusinessDataServiceHelper.loadFromCache((Object[])filedMapIdSet.toArray(), (String)"sbs_billfieldmapping");
        for (DynamicObject demandEntry : demandEntries) {
            fieldMapId = demandEntry.getDynamicObject("billfieldmap").getLong("id");
            demandEntry.set("billfieldmap", fieldMap.get(fieldMapId));
        }
        for (DynamicObject supplyEntry : supplyEntries) {
            fieldMapId = supplyEntry.getDynamicObject("billfieldmap").getLong("id");
            supplyEntry.set("billfieldmap", fieldMap.get(fieldMapId));
        }
        return scheme;
    }
}

