/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.steps.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.business.balanceinv.steps.IBalanceInventoryStep;

public class BalanceInvSaveMatchResultStep
implements IBalanceInventoryStep {
    private StepResult stepResult = new StepResult();

    @Override
    public StepResult execute() {
        OperationResult result;
        BalanceInvContext ctx = BalanceInvContext.get();
        DynamicObject matchResultInfo = ctx.getMatchResultInfo();
        if (matchResultInfo == null) {
            return this.stepResult;
        }
        DynamicObjectCollection matchResultEntries = matchResultInfo.getDynamicObjectCollection("entryentity");
        int seq = 1;
        ArrayList<Object[]> demandBillEntryId = new ArrayList<Object[]>();
        for (DynamicObject matchResultEntry : matchResultEntries) {
            String demandBillType = matchResultEntry.getString("demandbilltype");
            String invType = matchResultEntry.getString("invstocktype");
            if ("pm_requirapplybill".equals(demandBillType) && "B".equals(invType)) {
                demandBillEntryId.add(new Object[]{matchResultEntry.getLong("demandentryid")});
            }
            matchResultEntry.set("seq", (Object)seq++);
        }
        if (demandBillEntryId.size() > 0) {
            DBRoute dbRoute = new DBRoute(EntityMetadataCache.getDataEntityType((String)"pm_requirapplybill").getDBRouteKey());
            DB.executeBatch((DBRoute)dbRoute, (String)"update t_pm_requirapplybillentry set fbalancestatus = 'A' where fentryid = ?", demandBillEntryId);
        }
        if (!(result = SaveServiceHelper.saveOperate((String)"im_balanceinv_matchdetail", (DynamicObject[])new DynamicObject[]{matchResultInfo}, (OperateOption)OperateOption.create())).isSuccess()) {
            StringBuilder message = new StringBuilder();
            List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
            Map<String, String> saveErrorMsg = BalanceInvExecuteHelper.getOperateErrorMsg(allErrorOrValidateInfo);
            Map billNos = result.getBillNos();
            message.append(ResManager.loadKDString((String)"\u5339\u914d\u660e\u7ec6\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"BalanceInvSaveMatchResultStep_0", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
            message.append(result.getMessage()).append("\n");
            saveErrorMsg.forEach((billId, errorMsg) -> {
                String billNo = (String)billNos.get(Long.parseLong(billId));
                message.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a", (String)"BalanceInvSaveMatchResultStep_1", (String)"scmc-im-business", (Object[])new Object[0])).append(billNo).append("\n");
                message.append((String)errorMsg);
            });
            this.stepResult.setDetailMsg(message.toString());
            this.stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_E);
        }
        this.stepResult.setProcessData(1);
        return this.stepResult;
    }
}

