/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.workbench.steps.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.business.balanceinv.steps.IBalanceInventoryStep;
import kd.scmc.im.business.balanceinv.util.BalanceInvLogUtils;

public abstract class AbstractBalanceInvWorkBenchStep
implements IBalanceInventoryStep {
    private static final Log logger = LogFactory.getLog(AbstractBalanceInvWorkBenchStep.class);
    private StepResult stepResult = new StepResult();
    private StringBuilder infoBuilder = new StringBuilder();
    private StringBuilder warnBuilder = new StringBuilder();
    private StringBuilder errBuilder = new StringBuilder();
    protected BalanceInvContext ctx;

    @Override
    public StepResult execute() {
        this.ctx = BalanceInvContext.get();
        if (this.isUserStop()) {
            this.stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_C);
            this.stepResult.setSuccess(false);
        } else {
            long startTime;
            block6: {
                startTime = System.currentTimeMillis();
                try {
                    this.beforeExecute();
                    this.innerExecute();
                    this.afterExecute();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    this.addErrorMessage(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"BalanceInvStepExecutor_1", (String)"scmc-im-business", (Object[])new Object[0]));
                    if (!this.ctx.getDebugMode()) break block6;
                    this.addErrorMessage(BalanceInvExecuteHelper.getExceptionMessage(e));
                }
            }
            long endTime = System.currentTimeMillis();
            String timeSpan = new BigDecimal(String.valueOf(endTime - startTime)).divide(new BigDecimal("60000"), 4, RoundingMode.UP).toPlainString();
            this.stepResult.setTimeSpan(timeSpan);
            if (this.errBuilder.length() > 0) {
                this.stepResult.setSuccess(false);
                this.stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_B);
            }
            if (this.warnBuilder.length() > 0) {
                this.stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_E);
            }
            this.stepResult.setDetailMsg(this.getStepMsg());
        }
        return this.stepResult;
    }

    public String getStepMsg() {
        return this.infoBuilder.toString() + this.warnBuilder.toString() + this.errBuilder.toString();
    }

    protected void setProcessData(int count) {
        this.stepResult.setProcessData(count);
    }

    protected void addErrorMessage(String errStr) {
        this.errBuilder.append(errStr);
    }

    protected void addWarnMessage(String warnStr) {
        this.warnBuilder.append(warnStr);
    }

    protected void addInfoMessage(String infoStr) {
        this.infoBuilder.append(infoStr);
    }

    public void afterExecute() {
    }

    public abstract void innerExecute();

    public void beforeExecute() {
    }

    private boolean isUserStop() {
        String calcNum = this.ctx.getCalcNum();
        String status = BalanceInvLogUtils.getBalanceInvStatus(calcNum);
        return StringUtils.isBlank((CharSequence)status) || BalanceInvLogConstants.STATUS_USER_STOP.equals(status);
    }
}

