/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.workbench.steps.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.balanceinv.BalanceSupplyBillGetter;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.SupplyModel;
import kd.scmc.im.business.balanceinv.pojo.SupplyPolicy;
import kd.scmc.im.business.balanceinv.pojo.SupplyRelation;
import kd.scmc.im.business.balanceinv.workbench.steps.impl.AbstractBalanceInvWorkBenchStep;

public class BalanceInvWorkBenchGetSupplyStep
extends AbstractBalanceInvWorkBenchStep {
    @Override
    public void innerExecute() {
        this.buildGroupedSupplyBillData();
        this.buildSupplyQtyInfo();
    }

    private void buildSupplyQtyInfo() {
        BalanceInventoryScheme scheme = this.ctx.getScheme();
        Map<String, List<QFilter>> supplyQtyFilterMap = this.getSupplyQtyFilterMap(scheme);
        BalanceSupplyBillGetter getter = new BalanceSupplyBillGetter(this.ctx);
        getter.buildEntryId2SupplyQtyMap(supplyQtyFilterMap, scheme);
    }

    private void buildGroupedSupplyBillData() {
        BalanceSupplyBillGetter getter = new BalanceSupplyBillGetter(this.ctx);
        int processData = getter.buildGroupedSupplyBillData(null);
        this.setProcessData(processData);
        this.addInfoMessage(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u4f9b\u5e94\u6570\u636e\u5171\uff1a%1$s\u6761\u3002", (String)"BalanceInvGetSupplyStep_0", (String)"scmc-im-business", (Object[])new Object[0]), processData));
    }

    private Map<String, List<QFilter>> getSupplyQtyFilterMap(BalanceInventoryScheme balanceScheme) {
        Map<Long, SupplyRelation> supplyRelationMap = balanceScheme.getSupplyRelationMap();
        HashSet<Long> supplyOrgSet = new HashSet<Long>();
        for (Map.Entry<Long, SupplyRelation> supplyRelationEntry : supplyRelationMap.entrySet()) {
            if (supplyRelationEntry.getValue() == null) {
                supplyOrgSet.add(supplyRelationEntry.getKey());
                continue;
            }
            supplyOrgSet.addAll(supplyRelationEntry.getValue().getSupplyOrg2OrderMap().keySet());
        }
        Map<Long, SupplyPolicy> supplyPolicyMap = balanceScheme.getSupplyPolicyMap();
        HashSet<Long> storageOrgIdSet = new HashSet<Long>();
        for (Map.Entry<Long, SupplyPolicy> supplyPolicyEntry : supplyPolicyMap.entrySet()) {
            storageOrgIdSet.addAll(supplyPolicyEntry.getValue().getStorageOrgSetMap().keySet());
        }
        HashMap<String, List<QFilter>> supplyFilterMap = new HashMap<String, List<QFilter>>(balanceScheme.getSupplyDsList().size());
        SupplyModel supplyModel = balanceScheme.getSupplyModel();
        for (String entityNumber : balanceScheme.getSupplyDsList()) {
            QFilter dataSourceFilter;
            Map<String, String> target2SourceFieldMap = supplyModel.getTarget2SourceFieldMap(entityNumber);
            String supplyOrgField = target2SourceFieldMap.get("entryentity.supplyorgunit");
            String storageOrgField = target2SourceFieldMap.get("entryentity.stockorg");
            String materialField = target2SourceFieldMap.get("entryentity.material");
            String ownerTypeField = target2SourceFieldMap.get("entryentity.owertype");
            ArrayList<QFilter> matchFilterList = new ArrayList<QFilter>();
            if (!StringUtils.isEmpty((CharSequence)supplyOrgField)) {
                QFilter supplyOrgFilter = new QFilter(supplyOrgField, "in", supplyOrgSet);
                if (!StringUtils.isEmpty((CharSequence)ownerTypeField)) {
                    QFilter ownerTypeFilter = new QFilter(ownerTypeField, "=", (Object)"bd_supplier");
                    supplyOrgFilter = supplyOrgFilter.or(ownerTypeFilter);
                }
                matchFilterList.add(supplyOrgFilter);
            }
            if (!StringUtils.isEmpty((CharSequence)storageOrgField)) {
                matchFilterList.add(new QFilter(storageOrgField, "in", storageOrgIdSet));
            }
            if (!StringUtils.isEmpty((CharSequence)materialField)) {
                matchFilterList.add(new QFilter(materialField, "in", this.ctx.getMaterialIdSet()));
            }
            if ((dataSourceFilter = supplyModel.getDataSourceFilter(entityNumber)) != null) {
                matchFilterList.add(dataSourceFilter);
            }
            supplyFilterMap.put(entityNumber, matchFilterList);
        }
        return supplyFilterMap;
    }
}

