/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.workbench.steps.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.BalanceInvSchemeChecker;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.workbench.steps.impl.AbstractBalanceInvWorkBenchStep;
import kd.scmc.im.helper.InvDbParamHelper;

public class BalanceInvWorkBenchPrepareStep
extends AbstractBalanceInvWorkBenchStep {
    @Override
    public void innerExecute() {
        if (this.reserveValidate()) {
            return;
        }
        if (!this.checkMutex()) {
            return;
        }
        BalanceInvSchemeChecker schemeChecker = new BalanceInvSchemeChecker();
        DynamicObject scheme = BalanceInvExecuteHelper.getBalanceSchemeInfo(this.ctx.getSchemeId());
        String checkMsg = schemeChecker.checkSchemeDynamicObj(scheme, true);
        if (StringUtils.isNotBlank((CharSequence)checkMsg)) {
            this.addErrorMessage(checkMsg);
            return;
        }
        BalanceInventoryScheme balanceScheme = new BalanceInventoryScheme(scheme);
        this.ctx.setScheme(balanceScheme);
        checkMsg = schemeChecker.checkSchemeInfo(balanceScheme);
        if (StringUtils.isNotBlank((CharSequence)checkMsg)) {
            this.addErrorMessage(checkMsg);
            return;
        }
        boolean debugMode = InvDbParamHelper.getInvDbParam((String)"balanceinvdebugmode");
        this.ctx.setDebugMode(debugMode);
    }

    private boolean checkMutex() {
        BalanceInvContext ctx = BalanceInvContext.get();
        DLock lock = ctx.getLock();
        if (!lock.tryLock()) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5229\u5e93\u7ec4\u7ec7\u6b63\u5728\u8fdb\u884c\u5e73\u8861\u5229\u5e93\u8fd0\u7b97\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BalanceInvPrepareStep_0", (String)"scmc-im-business", (Object[])new Object[0]);
            this.addErrorMessage(errorMsg);
            return false;
        }
        return true;
    }

    private boolean reserveValidate() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)1406552222187325440L, (String)"msmod_total_reserveset", (String)"isenable");
        boolean isSumReserve = dynamicObject.getBoolean("isenable");
        if (isSumReserve) {
            String errorMsg = ResManager.loadKDString((String)"\u542f\u7528\u603b\u91cf\u9884\u7559\u548c\u5e73\u8861\u5229\u5e93\u4e0d\u80fd\u540c\u65f6\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BalanceInvPrepareStep_21", (String)"scmc-im-business", (Object[])new Object[0]);
            this.addErrorMessage(errorMsg);
        }
        return isSumReserve;
    }
}

