/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.workbench.steps.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.func.BillFormulaValueTransFunc;
import kd.scmc.im.business.balanceinv.func.MatchDimensionTransFunc;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.DemandModel;
import kd.scmc.im.business.balanceinv.pojo.InvDimensionInfo;
import kd.scmc.im.business.balanceinv.pojo.MatchInfo;
import kd.scmc.im.business.balanceinv.pojo.SupplyModel;
import kd.scmc.im.business.balanceinv.pojo.UnMatchInfo;
import kd.scmc.im.business.balanceinv.workbench.steps.impl.AbstractBalanceInvWorkBenchStep;

public class BalanceInvWorkBenchProcessSafeInvStep
extends AbstractBalanceInvWorkBenchStep {
    public static final String SCMC_IM_BUSINESS = "scmc-im-business";
    private static String ALGO = "kd.scmc.im.business.balanceinv.workbench.steps.impl.BalanceInvWorkBenchProcessSaveInvStep";
    private Map<Long, Integer> unitPrecisionCache = new HashMap<Long, Integer>();
    Map<Long, List<UnMatchInfo>> entryIdUnMatchMap = new HashMap<Long, List<UnMatchInfo>>();
    private Map<Long, Integer> demandOrderCache = new HashMap<Long, Integer>();
    private Map<Long, BigDecimal> demandOriginQtyCache = new HashMap<Long, BigDecimal>();

    @Override
    public void innerExecute() {
        if (!this.doCheck()) {
            return;
        }
        DynamicObjectCollection invLevelBillCol = this.getSafeInvCollection();
        Map<String, DynamicObjectCollection> demandBillByDimension = this.groupBillByMatchDimension(invLevelBillCol, "entryentity.flexmetricid");
        DynamicObjectCollection realBalCollection = new DynamicObjectCollection();
        DynamicObjectCollection preInCollection = new DynamicObjectCollection();
        this.getSupplyData(realBalCollection, preInCollection);
        Map<String, DynamicObjectCollection> realBalColByDimension = this.groupBillByMatchDimension(realBalCollection, "entryentity.flexmetricid");
        Map<String, DynamicObjectCollection> preInColByDimension = this.groupBillByMatchDimension(preInCollection, "preinmatchfields");
        this.matchDemandByDimension(demandBillByDimension, realBalColByDimension, preInColByDimension);
        BalanceInvExecuteHelper.getGroupedUnMatchInfoWithAdviseType("invp_safestock_record", this.entryIdUnMatchMap);
    }

    private boolean doCheck() {
        if (!this.needBalanceInvLevel(this.ctx.getScheme())) {
            StringBuilder detailMsg = new StringBuilder();
            detailMsg.append(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u5b89\u5168\u5e93\u5b58\u5e73\u8861\u5229\u5e93\u6761\u4ef6\uff1a", (String)"BalanceInvLevelStep_0", (String)SCMC_IM_BUSINESS, (Object[])new Object[0])).append("\n");
            detailMsg.append(ResManager.loadKDString((String)"1.\u9700\u6c42\u6570\u636e\u6e90\u4e2d\u5305\u542b\u5b89\u5168\u5e93\u5b58\u3002", (String)"BalanceInvLevelStep_1", (String)SCMC_IM_BUSINESS, (Object[])new Object[0])).append("\n");
            detailMsg.append(ResManager.loadKDString((String)"2.\u5e73\u8861\u5229\u5e93\u65b9\u6848\u4e2d\u7ef4\u62a4\u4e86\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u3002", (String)"BalanceInvLevelStep_2", (String)SCMC_IM_BUSINESS, (Object[])new Object[0])).append("\n");
            detailMsg.append(ResManager.loadKDString((String)"3.\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u4e2d\u5305\u542b\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u4e14\u5305\u542b\u7269\u6599\u6216\u7269\u6599\u5206\u7c7b\u3002", (String)"BalanceInvLevelStep_3", (String)SCMC_IM_BUSINESS, (Object[])new Object[0])).append("\n");
            this.addInfoMessage(detailMsg.toString());
            return false;
        }
        Set<Long> materialIdSet = this.ctx.getMaterialIdSet();
        return materialIdSet != null && !materialIdSet.isEmpty();
    }

    private DynamicObjectCollection handleReserveQty(DynamicObjectCollection preInCollection) {
        if (preInCollection == null || preInCollection.isEmpty()) {
            return preInCollection;
        }
        Map<Long, BigDecimal> reserveQtyMap = this.getReserveData(preInCollection);
        if (reserveQtyMap.isEmpty()) {
            return preInCollection;
        }
        for (DynamicObject preInData : preInCollection) {
            Long billEntryId = preInData.getLong("entryentity.billentryid");
            if (reserveQtyMap.get(billEntryId) == null) continue;
            BigDecimal reserveBaseQty = reserveQtyMap.get(billEntryId);
            BigDecimal supplyQtyValue = preInData.getBigDecimal("entryentity.usablebaseqty");
            if ((supplyQtyValue = supplyQtyValue.subtract(reserveBaseQty)).compareTo(BigDecimal.ZERO) < 0) {
                supplyQtyValue = BigDecimal.ZERO;
            }
            preInData.set("entryentity.usablebaseqty", (Object)supplyQtyValue);
        }
        return preInCollection;
    }

    private Map<Long, BigDecimal> getReserveData(DynamicObjectCollection preInCollection) {
        HashSet<Long> entryIds = new HashSet<Long>(preInCollection.size());
        for (DynamicObject preInData : preInCollection) {
            Long entryId = preInData.getLong("entryentity.billentryid");
            entryIds.add(entryId);
        }
        HashMap<Long, BigDecimal> reserveQtyMap = new HashMap<Long, BigDecimal>(preInCollection.size());
        if (entryIds.isEmpty()) {
            return reserveQtyMap;
        }
        QFilter qFilter = new QFilter("bal_entryid", "in", entryIds).and("base_qty", ">", (Object)0).and("ispredict", "=", (Object)true);
        DataSet reserveRecord = QueryServiceHelper.queryDataSet((String)ALGO, (String)"msmod_reserve_record", (String)"bal_entryid,qty,base_qty, qty2nd", (QFilter[])new QFilter[]{qFilter}, null);
        while (reserveRecord.hasNext()) {
            Row row = reserveRecord.next();
            Long balEntryId = row.getLong("bal_entryid");
            BigDecimal baseQty = row.getBigDecimal("base_qty");
            if (reserveQtyMap.get(balEntryId) != null) {
                baseQty = baseQty.add((BigDecimal)reserveQtyMap.get(balEntryId));
            }
            reserveQtyMap.put(balEntryId, baseQty);
        }
        return reserveQtyMap;
    }

    private void matchDemandByDimension(Map<String, DynamicObjectCollection> demandBillByDimension, Map<String, DynamicObjectCollection> realBalColByDimension, Map<String, DynamicObjectCollection> preInColByDimension) {
        if (demandBillByDimension == null || demandBillByDimension.isEmpty()) {
            return;
        }
        BalanceInventoryScheme balanceScheme = this.ctx.getScheme();
        ORM orm = ORM.create();
        DynamicObject bizType = orm.newDynamicObject("bd_biztype", (Object)422857170485263360L);
        for (Map.Entry<String, DynamicObjectCollection> demandBillEntry : demandBillByDimension.entrySet()) {
            String dimensionKey = demandBillEntry.getKey();
            DynamicObjectCollection demandBills = demandBillEntry.getValue();
            if (demandBills == null || demandBills.isEmpty()) continue;
            this.matchByDimension(demandBills, realBalColByDimension, dimensionKey, bizType);
            if (!demandBills.isEmpty()) {
                this.matchByDimension(demandBills, preInColByDimension, "preinmatchfields", bizType);
            }
            this.buildPureDemand(demandBills, balanceScheme, bizType);
        }
    }

    private void buildPureDemand(DynamicObjectCollection demandBills, BalanceInventoryScheme balanceScheme, DynamicObject bizType) {
        if (demandBills == null || demandBills.isEmpty()) {
            return;
        }
        for (DynamicObject demandBill : demandBills) {
            if (demandBill.getBigDecimal("entryentity.demandqty").compareTo(BigDecimal.ZERO) <= 0) continue;
            long demandBillId = demandBill.getLong("id");
            DynamicObject matchResultEntry = BalanceInvExecuteHelper.addNoSupplyMatchResultEntry(demandBill, this.demandOriginQtyCache.get(demandBillId), demandBill.getBigDecimal("entryentity.demandqty"), this.demandOrderCache.get(demandBillId));
            this.ctx.getMatchDetailEntries().add(matchResultEntry);
            matchResultEntry.set("biztype", (Object)bizType);
            matchResultEntry.set("demandkind", (Object)"B");
            BigDecimal demandQty = demandBill.getBigDecimal("entryentity.demandqty");
            UnMatchInfo unMatchInfo = BalanceInvExecuteHelper.buildUnMatchInfo(demandBill, demandQty);
            unMatchInfo.setBalanceOrgId(balanceScheme.getBalanceOrgId());
            unMatchInfo.setMatchEntryInfo(matchResultEntry);
            unMatchInfo.setDemandKind("B");
            this.entryIdUnMatchMap.computeIfAbsent(unMatchInfo.getBillId(), k -> new ArrayList()).add(unMatchInfo);
        }
    }

    private void matchByDimension(DynamicObjectCollection demandBills, Map<String, DynamicObjectCollection> supplyColByDimension, String dimensionKey, DynamicObject bizType) {
        Iterator iterator = demandBills.iterator();
        BigDecimal matchBaseQty = BigDecimal.ZERO;
        BigDecimal matchQty = BigDecimal.ZERO;
        BigDecimal matchQty2nd = BigDecimal.ZERO;
        int demandOrder = 0;
        BalanceInvContext ctx = BalanceInvContext.get();
        block0: while (iterator.hasNext()) {
            DynamicObjectCollection supplyBills;
            DynamicObject demandBill = (DynamicObject)iterator.next();
            long demandBillId = demandBill.getLong("id");
            this.demandOrderCache.put(demandBillId, ++demandOrder);
            BigDecimal originDemandBaseQty = demandBill.getBigDecimal("entryentity.demandqty");
            this.demandOriginQtyCache.putIfAbsent(demandBillId, originDemandBaseQty);
            if (originDemandBaseQty.compareTo(BigDecimal.ZERO) <= 0 || (supplyBills = supplyColByDimension.get(dimensionKey = "preinmatchfields".equals(dimensionKey) ? demandBill.getString("preinmatchfields") : dimensionKey)) == null || supplyBills.isEmpty()) continue;
            for (DynamicObject supplyBill : supplyBills) {
                BigDecimal curDemandBaseQty = demandBill.getBigDecimal("entryentity.demandqty");
                if (curDemandBaseQty.compareTo(BigDecimal.ZERO) <= 0) {
                    iterator.remove();
                    continue block0;
                }
                BigDecimal supplyBaseQty = supplyBill.getBigDecimal("entryentity.usablebaseqty");
                if (supplyBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                matchBaseQty = curDemandBaseQty.compareTo(supplyBaseQty) <= 0 ? curDemandBaseQty : supplyBaseQty;
                if (BalanceInvExecuteHelper.getValue(supplyBill, "entryentity.unit") != null) {
                    matchQty = BalanceInvExecuteHelper.calculateQtyByBaseQty(matchBaseQty, supplyBill.getLong("entryentity.material"), supplyBill.getLong("entryentity.unit"), supplyBill.getLong("entryentity.baseunit"), this.unitPrecisionCache);
                }
                if (BalanceInvExecuteHelper.getValue(supplyBill, "entryentity.assistunit") != null && BalanceInvExecuteHelper.getValue(supplyBill, "entryentity.originassitqty") != null && supplyBill.getBigDecimal("entryentity.originassitqty").compareTo(BigDecimal.ZERO) != 0) {
                    matchQty2nd = matchBaseQty.multiply(supplyBill.getBigDecimal("entryentity.originassitqty")).divide(supplyBill.getBigDecimal("entryentity.originbaseqty"), BalanceInvExecuteHelper.getUnitPrecision(supplyBill.getLong("entryentity.assistunit"), this.unitPrecisionCache), RoundingMode.HALF_UP);
                }
                MatchInfo matchInfo = new MatchInfo(matchQty, matchBaseQty, matchQty2nd, this.demandOriginQtyCache.get(demandBillId), curDemandBaseQty);
                BigDecimal demandRemainQty = curDemandBaseQty.subtract(matchBaseQty);
                demandBill.set("entryentity.demandqty", (Object)demandRemainQty);
                supplyBill.set("entryentity.usablebaseqty", (Object)supplyBaseQty.subtract(matchBaseQty));
                DynamicObject matchResultEntry = BalanceInvExecuteHelper.addMatchResultEntry(demandBill, supplyBill, matchInfo, demandOrder);
                ctx.getMatchDetailEntries().add(matchResultEntry);
                matchResultEntry.set("biztype", (Object)bizType);
                matchResultEntry.set("demandkind", (Object)"B");
                if (demandRemainQty.compareTo(BigDecimal.ZERO) > 0) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    private void getSupplyData(DynamicObjectCollection realBalCollection, DynamicObjectCollection preInCollection) {
        Set<Long> materialIdSet = this.ctx.getMaterialIdSet();
        BalanceInventoryScheme balanceScheme = this.ctx.getScheme();
        List<String> supplyDsList = balanceScheme.getSupplyDsList();
        ORM orm = ORM.create();
        for (String supplyEntityNumber : supplyDsList) {
            boolean isRealBalSupply;
            DataSet srcDataSet = this.getSafeStockSupplyDataSet(balanceScheme, supplyEntityNumber, materialIdSet, isRealBalSupply = "im_inv_realbalance".equals(supplyEntityNumber));
            DynamicObjectCollection srcDataCollection = orm.toPlainDynamicObjectCollection(srcDataSet);
            if (srcDataCollection == null || srcDataCollection.isEmpty()) continue;
            if (isRealBalSupply) {
                realBalCollection.addAll((Collection)srcDataCollection);
                continue;
            }
            preInCollection.addAll((Collection)this.handleReserveQty(srcDataCollection));
        }
    }

    private DataSet getSafeStockSupplyDataSet(BalanceInventoryScheme balanceScheme, String supplyEntityNumber, Set<Long> materialIdSet, boolean isRealBalSupply) {
        SupplyModel supplyModel = balanceScheme.getSupplyModel();
        Map<String, String> target2SourceFieldMap = supplyModel.getTarget2SourceFieldMap(supplyEntityNumber);
        String materialField = target2SourceFieldMap.get("entryentity.material");
        String supplyOrgField = target2SourceFieldMap.get("entryentity.supplyorgunit");
        QFilter supplyFilter = supplyModel.getDataSourceFilter(supplyEntityNumber);
        QFilter filter = new QFilter(materialField, "in", materialIdSet).and(supplyFilter);
        if (!StringUtils.isBlank((String)supplyOrgField)) {
            filter.and(supplyOrgField, "in", balanceScheme.getContainSafeInvOrgs());
        }
        String selector = supplyModel.getMatchSelector(supplyEntityNumber);
        StringBuilder selectorBuilder = new StringBuilder();
        selectorBuilder.append(selector);
        selectorBuilder.append(",0 as ").append("supplyorder");
        selectorBuilder.append(",0 as ").append("priority");
        selectorBuilder.append(",0 as ").append("supplypriority");
        selectorBuilder.append(",0 as ").append("invstatuspriority");
        selectorBuilder.append(",'' as ").append("preinmatchfields");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)supplyEntityNumber, (String)selectorBuilder.toString(), (QFilter[])filter.toArray(), (String)"");
        selectorBuilder.setLength(0);
        RowMeta rowMeta = dataSet.getRowMeta();
        InvDimensionInfo invDimensionInfo = balanceScheme.getInvDimensionInfo();
        Map<String, String> targetFormulaMap = supplyModel.getTargetExpressionMap(supplyEntityNumber);
        String matchKey = isRealBalSupply ? "entryentity.flexmetricid" : "preinmatchfields";
        List<String> matchFields = invDimensionInfo.getSupplyFields();
        if (!isRealBalSupply) {
            matchFields = Arrays.asList("entryentity.supplyorgunit", "entryentity.material");
        }
        dataSet = dataSet.map((MapFunction)new BillFormulaValueTransFunc(rowMeta, targetFormulaMap)).map((MapFunction)new MatchDimensionTransFunc(rowMeta, matchFields, matchKey));
        QFilter expressFilterVal = new QFilter("entryentity.supplyorgunit", "in", balanceScheme.getContainSafeInvOrgs());
        dataSet = dataSet.filter(expressFilterVal.toString());
        return dataSet;
    }

    private Map<String, DynamicObjectCollection> groupBillByMatchDimension(DynamicObjectCollection billCol, String matchKey) {
        HashMap<String, DynamicObjectCollection> dimensionGroupBillMap = new HashMap<String, DynamicObjectCollection>(16);
        for (DynamicObject demandBill : billCol) {
            String flexMetricId = demandBill.getString(matchKey);
            dimensionGroupBillMap.computeIfAbsent(flexMetricId, k -> new DynamicObjectCollection()).add((Object)demandBill);
        }
        return dimensionGroupBillMap;
    }

    private boolean needBalanceInvLevel(BalanceInventoryScheme balanceScheme) {
        if (balanceScheme.getDemandModel().getDataSourceMap().containsKey("invp_safestock_record")) {
            if (balanceScheme.getInvDimensionInfo() == null) {
                return false;
            }
            Set<String> dimensionFields = balanceScheme.getInvDimensionInfo().getDimensions();
            if (dimensionFields.contains("bos_org") && (dimensionFields.contains("bd_material") || dimensionFields.contains("bd_materialgroup"))) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObjectCollection getSafeInvCollection() {
        BalanceInventoryScheme balanceScheme = this.ctx.getScheme();
        DemandModel demandModel = balanceScheme.getDemandModel();
        InvDimensionInfo invDimensionInfo = balanceScheme.getInvDimensionInfo();
        List<QFilter> filterList = this.getSafeInvFilter();
        String selector = demandModel.getMatchSelector("invp_safestock_record");
        if (!invDimensionInfo.containsMaterial().booleanValue()) {
            selector = selector + "," + "bd_materialgroup";
        }
        selector = selector + "," + "id";
        selector = selector + ",'' as " + "preinmatchfields";
        try (DataSet demandDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"invp_safestock_record", (String)selector, (QFilter[])filterList.toArray(new QFilter[0]), (String)"modifytime desc");){
            if (!invDimensionInfo.containsMaterial().booleanValue()) {
                QFilter materialFilter = new QFilter("material", "in", this.ctx.getMaterialIdSet());
                DataSet matGroupDataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"bd_materialgroupdetail", (String)"group,material,material.baseunit", (QFilter[])new QFilter[]{materialFilter}, (String)"");
                ArrayList<String> selectorList = new ArrayList<String>(demandDataSet.getRowMeta().getFields().length);
                for (Field field : demandDataSet.getRowMeta().getFields()) {
                    selectorList.add(field.getName());
                }
                selectorList.remove("entryentity.material");
                selectorList.remove("entryentity.baseunit");
                selectorList.add("material as entryentity.material");
                selectorList.add("material.baseunit as entryentity.baseunit");
                demandModel.getTargetExpressionMap("invp_safestock_record").remove("entryentity.baseunit");
                demandDataSet = demandDataSet.join(matGroupDataSet).on("bd_materialgroup", "group").select(selectorList.toArray(new String[0])).finish();
            }
            RowMeta rowMeta = demandDataSet.getRowMeta();
            Map<String, String> targetFormulaMap = demandModel.getTargetExpressionMap("invp_safestock_record");
            List<String> preInMatchFields = Arrays.asList("entryentity.demandorg", "entryentity.material");
            demandDataSet = demandDataSet.map((MapFunction)new BillFormulaValueTransFunc(rowMeta, targetFormulaMap)).map((MapFunction)new MatchDimensionTransFunc(rowMeta, invDimensionInfo.getDemandFields(), "entryentity.flexmetricid")).map((MapFunction)new MatchDimensionTransFunc(rowMeta, preInMatchFields, "preinmatchfields"));
            DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(demandDataSet);
            return dynamicObjectCollection;
        }
    }

    private List<QFilter> getSafeInvFilter() {
        Set<Long> materialIdSet = this.ctx.getMaterialIdSet();
        BalanceInventoryScheme balanceScheme = this.ctx.getScheme();
        DemandModel demandModel = balanceScheme.getDemandModel();
        InvDimensionInfo invDimensionInfo = balanceScheme.getInvDimensionInfo();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter dataSourceFilter = demandModel.getDataSourceFilter("invp_safestock_record");
        filterList.add(dataSourceFilter);
        Set<Long> orgIds = balanceScheme.getContainSafeInvOrgs();
        QFilter orgFilter = new QFilter("bos_org", "in", orgIds);
        filterList.add(orgFilter);
        if (invDimensionInfo.containsMaterial().booleanValue()) {
            QFilter materialFilter = new QFilter("bd_material", "in", materialIdSet);
            filterList.add(materialFilter);
        }
        Long dimensionId = balanceScheme.getInvLevelInfoId();
        QFilter dimensionFilter = new QFilter("dimension", "=", (Object)dimensionId);
        filterList.add(dimensionFilter);
        return filterList;
    }
}

