/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.enums.UnitConvertDirEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.utils.BigDecimalUtils;
import kd.scmc.im.utils.CommonUtils;

public class AuxQtyAndUnitHelper {
    private static Log logger = LogFactory.getLog(BaseDataServiceHelper.class);

    public static void setAuxBizQtyAndUnit(IPageCache pageCache, IDataModel bill, int rowindex, String fieldName, Object newValue) {
        DynamicObject materialInvInfo = (DynamicObject)bill.getValue("material", rowindex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null) {
            return;
        }
        switch (fieldName) {
            case "qty": 
            case "unit": 
            case "auditqty": {
                AuxQtyAndUnitHelper.changeUntAndQty(bill, rowindex, material, auxptyUnit);
                break;
            }
            case "qtyunit2nd": {
                AuxQtyAndUnitHelper.changeAuxptyQty(bill, rowindex, material);
                break;
            }
        }
    }

    private static void changeUntAndQty(IDataModel bill, int rowindex, DynamicObject material, DynamicObject auxptyUnit) {
        boolean isConvert;
        BigDecimal baseQty = (BigDecimal)bill.getValue("baseqty", rowindex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowindex);
        String unitConvertDir = material.getString("unitconvertdir");
        boolean bl = isConvert = UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        if (!isConvert) {
            return;
        }
        if (BigDecimal.ZERO.compareTo(baseQty) == 0) {
            bill.beginInit();
            bill.setValue("qtyunit2nd", (Object)BigDecimal.ZERO, rowindex);
            bill.endInit();
            return;
        }
        BigDecimal qtyUnit2nd = BillUnitAndQtytHelper.getDesQtyConv(material, baseUnit, baseQty, auxptyUnit);
        BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)qtyUnit2nd, (String)"qtyunit2nd");
        bill.beginInit();
        bill.setValue("qtyunit2nd", (Object)qtyUnit2nd, rowindex);
        bill.endInit();
    }

    private static void changeAuxptyQty(IDataModel bill, int rowindex, DynamicObject material) {
        boolean isConvert;
        String unitConvertDir = material.getString("unitconvertdir");
        boolean bl = isConvert = UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        if (!isConvert) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowindex);
        DynamicObject unit2nd = (DynamicObject)bill.getValue("unit2nd", rowindex);
        BigDecimal qtyUnit2nd = (BigDecimal)bill.getValue("qtyunit2nd", rowindex);
        BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv(material, unit2nd, qtyUnit2nd, baseUnit);
        BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)baseQty, (String)"baseqty");
        bill.beginInit();
        bill.setValue("baseqty", (Object)baseQty, rowindex);
        bill.endInit();
        AuxQtyAndUnitHelper.setQtyByBaseQtyChange(bill, rowindex, material, baseUnit, baseQty);
    }

    private static void setQtyByBaseQtyChange(IDataModel bill, int rowindex, DynamicObject material, DynamicObject baseUnit, BigDecimal baseQty) {
        BigDecimal qty = BigDecimal.ZERO;
        if (baseQty.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObject unit = (DynamicObject)bill.getValue("unit", rowindex);
            if (unit == null) {
                return;
            }
            qty = BillUnitAndQtytHelper.getDesQtyConv(material, baseUnit, baseQty, unit);
        }
        if ("im_transapply".equals(bill.getDataEntityType().getName()) || "im_materialreqbill".equals(bill.getDataEntityType().getName()) || "im_mdc_mftreqbill".equals(bill.getDataEntityType().getName()) || "im_mdc_mftomreqapplybill".equals(bill.getDataEntityType().getName()) || "im_mdc_mftreturnapplybill".equals(bill.getDataEntityType().getName())) {
            BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)qty, (String)"qty");
            bill.beginInit();
            bill.setValue("qty", (Object)qty, rowindex);
            bill.setValue("auditqty", (Object)qty, rowindex);
            bill.endInit();
        } else {
            BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)qty, (String)"qty");
            bill.beginInit();
            bill.setValue("qty", (Object)qty, rowindex);
            bill.endInit();
        }
    }

    @Deprecated
    public static BigDecimal getRateCache(IPageCache pageCache, DynamicObject material, String rateKey) {
        return AuxQtyAndUnitHelper.getAuxptyRateCache(pageCache, material);
    }

    public static BigDecimal getAuxptyRateCache(IPageCache pageCache, DynamicObject material) {
        if (material == null) {
            return null;
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        DynamicObject baseUnit = material.getDynamicObject("baseunit");
        if (auxptyUnit == null || baseUnit == null) {
            return null;
        }
        BigDecimal unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv((Long)material.getPkValue(), (Long)auxptyUnit.getPkValue(), (Long)baseUnit.getPkValue(), pageCache);
        return unit2ndRate;
    }

    public static void showQtyErrorTip(BigDecimal qtyAmount) {
        CommonUtils.showQtyErrorTip((BigDecimal)qtyAmount);
    }

    public static Map<Long, List<Long>> getAssistMUListResult(List<Long> materialIds, String convertType) {
        QFilter qf = new QFilter("id", "in", materialIds);
        Map fromCache = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,baseunit", (QFilter[])qf.toArray());
        HashMap<Long, List<Long>> desmulistMap = new HashMap<Long, List<Long>>(fromCache.size());
        AuxQtyAndUnitHelper.getAssistMUList(materialIds, convertType, desmulistMap);
        for (DynamicObject material : fromCache.values()) {
            Long baseunitId = (Long)material.getDynamicObject("baseunit").getPkValue();
            ArrayList<Long> unitList = (ArrayList<Long>)desmulistMap.get(material.getPkValue());
            if (unitList == null) {
                unitList = new ArrayList<Long>();
            }
            if (!unitList.contains(baseunitId)) {
                unitList.add(baseunitId);
            }
            desmulistMap.put((Long)material.getPkValue(), unitList);
        }
        return desmulistMap;
    }

    private static Map<Long, List<Long>> getAssistMUList(List<Long> materialIds, String convertType, Map<Long, List<Long>> desmuListMap) {
        ArrayList<Long> searchList = new ArrayList<Long>();
        if (materialIds.isEmpty()) {
            return desmuListMap;
        }
        StringBuffer sql = null;
        StringBuffer convertTypeSql = new StringBuffer();
        if (convertType != null && !convertType.trim().equals("")) {
            if (convertType.equals("2") || convertType.equals("1")) {
                convertTypeSql = convertTypeSql.append(" and u.fconverttype= '").append(convertType).append("'");
            } else {
                logger.error("\u6362\u7b97\u7c7b\u578b\u53c2\u6570\u5f02\u5e38!");
                return new HashMap<Long, List<Long>>(16);
            }
        }
        StringBuilder materialIdBulid = new StringBuilder(" (");
        for (int i = 0; i < materialIds.size(); ++i) {
            if (i != 0) {
                materialIdBulid.append(',');
            }
            materialIdBulid.append(materialIds.get(i));
        }
        materialIdBulid.append(") ");
        String materialIdSql = materialIdBulid.toString();
        sql = new StringBuffer("select m.fid materialid,u.fdesmuid as unitId, u.fnumerator as numerator, u.fdenominator as denominator from t_bd_measureunitconv u  inner join T_BD_Material m on  u.fsrcmuid = m.fbaseunit   where  m.fid in  ").append(materialIdSql).append(convertTypeSql);
        AuxQtyAndUnitHelper.getDesUnitList(desmuListMap, sql, searchList);
        sql = new StringBuffer("select m.fid materialid, u.fsrcmuid as unitId, u.fnumerator as numerator, u.fdenominator as denominator from t_bd_measureunitconv u inner join T_BD_Material m on  u.fdesmuid = m.fbaseunit   where  m.fid in ").append(materialIdSql).append(convertTypeSql);
        AuxQtyAndUnitHelper.getDesUnitList(desmuListMap, sql, searchList);
        sql = new StringBuffer(" select m.fid materialid, u.fmeasureunitid as unitId, u.fdenominator as numerator, u.fnumerator as denominator ").append("from t_bd_multimeasureunit u left join t_bd_material m on u.fmaterialid = m.fid").append(" where m.fid in ").append(materialIdSql).append(convertTypeSql);
        AuxQtyAndUnitHelper.getDesUnitList(desmuListMap, sql, searchList);
        sql = new StringBuffer(" select m.fid materialid,m.fbaseunit as unitId, u.fdenominator as numerator, u.fnumerator as denominator ").append("from t_bd_multimeasureunit u left join t_bd_material m on u.fmaterialid = m.fid").append(" where u.fmeasureunitid = m.fbaseunit  and m.fid in  ").append(materialIdSql).append(convertTypeSql);
        AuxQtyAndUnitHelper.getDesUnitList(desmuListMap, sql, searchList);
        if (searchList.isEmpty()) {
            return desmuListMap;
        }
        HashSet<Long> oldSrcIds = new HashSet<Long>();
        HashSet<Long> oldUnitIds = new HashSet<Long>();
        AuxQtyAndUnitHelper.addDesOrSrcUnit(desmuListMap, searchList, convertType, "srcmuid", oldSrcIds);
        AuxQtyAndUnitHelper.addDesOrSrcUnit(desmuListMap, searchList, convertType, "unitid", oldUnitIds);
        return desmuListMap;
    }

    private static void addDesOrSrcUnit(Map<Long, List<Long>> desmuListMap, List<Long> searchList, String convertType, String desOrSrc, Set<Long> oldUnitIds) {
        StringBuffer convertTypeSql = new StringBuffer();
        if (convertType != null && (convertType.equals("2") || convertType.equals("1"))) {
            convertTypeSql = convertTypeSql.append(" and u.fconverttype= '").append(convertType).append("'");
        }
        StringBuilder unitBulid = new StringBuilder(" (");
        for (int i = 0; i < searchList.size(); ++i) {
            if (i != 0) {
                unitBulid.append(',');
            }
            unitBulid.append(searchList.get(i));
        }
        unitBulid.append(") ");
        String unitIdSql = unitBulid.toString();
        StringBuffer sql = null;
        if ("srcmuid".equals(desOrSrc)) {
            sql = new StringBuffer("select u.fsrcmuid srcmuid,u.fdesmuid as unitid  from t_bd_measureunitconv u  where  u.fsrcmuid in  ").append(unitIdSql).append(convertTypeSql);
        } else if ("unitid".equals(desOrSrc)) {
            sql = new StringBuffer("select u.fsrcmuid srcmuid,u.fdesmuid as unitid  from t_bd_measureunitconv u  where  u.fdesmuid in  ").append(unitIdSql).append(convertTypeSql);
        } else {
            return;
        }
        oldUnitIds.addAll(searchList);
        List<Long> desorSrcUnit = AuxQtyAndUnitHelper.queryDesorSrcUnit(desmuListMap, sql, desOrSrc, oldUnitIds);
        if (desorSrcUnit == null || desorSrcUnit.isEmpty()) {
            return;
        }
        AuxQtyAndUnitHelper.addDesOrSrcUnit(desmuListMap, desorSrcUnit, convertType, desOrSrc, oldUnitIds);
    }

    private static List<Long> queryDesorSrcUnit(final Map<Long, List<Long>> desmuListMap, StringBuffer sql, final String desOrSrc, final Set<Long> oldUnitIds) {
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> searchList = new ArrayList<Long>(desmuListMap.size());
                while (rs.next()) {
                    String valKey = "srcmuid".equals(desOrSrc) ? "unitid" : "srcmuid";
                    Long srcId = rs.getLong(desOrSrc);
                    Long unitId = rs.getLong(valKey);
                    if (oldUnitIds.contains(unitId)) continue;
                    oldUnitIds.add(unitId);
                    Collection values = desmuListMap.values();
                    searchList.add(unitId);
                    for (List units : values) {
                        if (!units.contains(srcId) || units.contains(unitId)) continue;
                        units.add(unitId);
                    }
                }
                return searchList;
            }
        });
    }

    private static void getDesUnitList(final Map<Long, List<Long>> desmuListMap, StringBuffer sql, final List<Long> searchList) {
        DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    Long unitId = rs.getLong("unitId");
                    Long materialId = rs.getLong("materialid");
                    ArrayList<Long> desmuList = (ArrayList<Long>)desmuListMap.get(materialId);
                    if (desmuList != null) {
                        if (desmuList.contains(unitId)) continue;
                        desmuList.add(unitId);
                    } else {
                        desmuList = new ArrayList<Long>(1);
                        desmuList.add(unitId);
                        desmuListMap.put(materialId, desmuList);
                    }
                    if (searchList.contains(unitId)) continue;
                    searchList.add(unitId);
                }
                return searchList;
            }
        });
    }
}

