/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.botp.BusinessFlowDataService;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class BotpPushHepler {
    public static List<DynamicObject> getTargetObject(ConvertOperationResult result) {
        if (!result.isSuccess()) {
            return null;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)result.getTargetEntityNumber());
        List targetOrder = result.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] paramArrayOfObject, IDataEntityType paramDataEntityType) {
            }
        }, mainType);
        return targetOrder;
    }

    public static List<DynamicObject> getTargetObjectWithRefence(ConvertOperationResult result) {
        if (!result.isSuccess()) {
            return null;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)result.getTargetEntityNumber());
        List targetOrder = result.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] paramArrayOfObject, IDataEntityType paramDataEntityType) {
                BusinessDataServiceHelper.loadRefence((Object[])paramArrayOfObject, (IDataEntityType)paramDataEntityType);
            }
        }, mainType);
        return targetOrder;
    }

    public static Set<Long> getAllTrackDowBillInfo(String srcBillEntity, String srcEntryEntity, Collection<Long> srcEntryIds) {
        HashSet<Long> targetEntryId = new HashSet<Long>(srcEntryIds.size());
        List loadLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)srcBillEntity, (String)srcEntryEntity, (Long[])srcEntryIds.toArray(new Long[0]));
        for (BFRowLinkDownNode downNode : loadLinkDownNodes) {
            List findAllChildNodes = downNode.findAllChildNodes();
            for (BFRowLinkDownNode childNode : findAllChildNodes) {
                targetEntryId.add(childNode.getRowId().getEntryId());
            }
        }
        return targetEntryId;
    }

    public static Set<Long> getTrackDownBillInfo(String srcBillEntity, String srcEntryEntity, Collection<Long> srcEntryIds, String tgtBillEntity, String tgtEntryEntity) {
        List dowNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)srcBillEntity, (String)srcEntryEntity, (Long[])srcEntryIds.toArray(new Long[srcEntryIds.size()]));
        if (dowNodes == null || dowNodes.isEmpty()) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> badDealEntryId = new HashSet<Long>(dowNodes.size());
        TableDefine tableDifine = new ConvertDataService().loadTableDefine(tgtBillEntity, tgtEntryEntity);
        if (tableDifine == null) {
            return badDealEntryId;
        }
        Long badDealTableId = tableDifine.getTableId();
        for (BFRowLinkDownNode node : dowNodes) {
            Collection values = node.getTNodes().values();
            for (BFRowLinkDownNode upNode : values) {
                BFRowId rowId = upNode.getRowId();
                if (!badDealTableId.equals(rowId.getTableId())) continue;
                badDealEntryId.add(rowId.getEntryId());
            }
        }
        return badDealEntryId;
    }

    public static Set<Long> getTrackUpBillInfo(String srcBillEntity, String srcEntryEntity, Collection<Long> srcEntryIds, String tgtBillEntity, String tgtEntryEntity) {
        HashSet<Long> badDealEntryId = new HashSet<Long>(16);
        TableDefine tableDifine = new ConvertDataService().loadTableDefine(tgtBillEntity, tgtEntryEntity);
        if (tableDifine == null) {
            return badDealEntryId;
        }
        Long badDealTableId = tableDifine.getTableId();
        List upNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)srcBillEntity, (String)srcEntryEntity, (Long[])srcEntryIds.toArray(new Long[srcEntryIds.size()]));
        if (upNodes == null || upNodes.isEmpty()) {
            return new HashSet<Long>(0);
        }
        for (BFRowLinkUpNode node : upNodes) {
            Collection values = node.getSNodes().values();
            for (BFRowLinkUpNode upNode : values) {
                BFRowId rowId = upNode.getRowId();
                if (!badDealTableId.equals(rowId.getTableId())) continue;
                badDealEntryId.add(rowId.getEntryId());
            }
        }
        return badDealEntryId;
    }

    @Deprecated
    public static Map<Long, Long> getTrackDownBillMap(String srcBillEntity, String srcEntryEntity, Collection<Long> srcEntryIds, String tgtBillEntity, String tgtEntryEntity) {
        if (srcEntryIds == null || srcEntryIds.isEmpty()) {
            return new HashMap<Long, Long>(0);
        }
        BusinessFlowDataService service = new BusinessFlowDataService();
        List dowNodes = service.loadTargetRowIds(srcBillEntity, srcEntryEntity, srcEntryIds.toArray(new Long[srcEntryIds.size()]));
        return BotpPushHepler.getDownBillMap(srcEntryIds, tgtBillEntity, tgtEntryEntity, dowNodes);
    }

    public static Map<Long, Long> getTrackDownBillMap(String srcBillEntity, String srcEntryEntity, Collection<Long> srcIds, Collection<Long> srcEntryIds, String tgtBillEntity, String tgtEntryEntity) {
        if (srcEntryIds == null || srcEntryIds.isEmpty()) {
            return new HashMap<Long, Long>(0);
        }
        BusinessFlowDataService service = new BusinessFlowDataService();
        List dowNodes = service.loadTargetRowIds(srcBillEntity, srcEntryEntity, srcIds.toArray(new Long[srcIds.size()]), srcEntryIds.toArray(new Long[srcEntryIds.size()]), OperateOption.create());
        return BotpPushHepler.getDownBillMap(srcEntryIds, tgtBillEntity, tgtEntryEntity, dowNodes);
    }

    private static Map<Long, Long> getDownBillMap(Collection<Long> srcEntryIds, String tgtBillEntity, String tgtEntryEntity, List<BFRow> dowNodes) {
        if (dowNodes == null || dowNodes.isEmpty()) {
            return new HashMap<Long, Long>(0);
        }
        HashMap<Long, Long> badDealEntryIdMap = new HashMap<Long, Long>(dowNodes.size());
        TableDefine tableDifine = new ConvertDataService().loadTableDefine(tgtBillEntity, tgtEntryEntity);
        if (tableDifine == null) {
            return badDealEntryIdMap;
        }
        Long badDealTableId = tableDifine.getTableId();
        for (BFRow bFRow : dowNodes) {
            BFRowId rowId;
            if (!srcEntryIds.contains(bFRow.getSId().getEntryId()) || !badDealTableId.equals((rowId = bFRow.getId()).getTableId())) continue;
            badDealEntryIdMap.put(rowId.getEntryId(), bFRow.getSId().getEntryId());
        }
        for (Map.Entry entry : badDealEntryIdMap.entrySet()) {
            Long value = (Long)entry.getValue();
            Long srcId = (Long)badDealEntryIdMap.get(value);
            if (srcId == null) continue;
            badDealEntryIdMap.put((Long)entry.getKey(), srcId);
        }
        return badDealEntryIdMap;
    }

    public static Map<Long, List<Long>> getTrackDownEntryIdsMap(String srcBillEntity, String srcEntryEntity, Set<Long> srcBillIds, Collection<Long> srcEntryIds, String tgtBillEntity, String tgtEntryEntity) {
        Long entryId;
        BFRowId sId;
        BFRowId id;
        HashMap<Long, List<Long>> srcEntryIdTarEntryIdsMap = new HashMap<Long, List<Long>>(16);
        if (srcEntryIds == null || srcEntryIds.isEmpty() || srcBillIds == null || srcBillIds.isEmpty()) {
            return srcEntryIdTarEntryIdsMap;
        }
        BusinessFlowDataService service = new BusinessFlowDataService();
        List dowNodes = service.loadTargetRowIds(srcBillEntity, srcEntryEntity, srcBillIds.toArray(new Long[0]), srcEntryIds.toArray(new Long[0]), OperateOption.create());
        if (dowNodes == null || dowNodes.isEmpty()) {
            return srcEntryIdTarEntryIdsMap;
        }
        TableDefine tableDifine = new ConvertDataService().loadTableDefine(tgtBillEntity, tgtEntryEntity);
        if (tableDifine == null) {
            return srcEntryIdTarEntryIdsMap;
        }
        HashSet<Long> srcIdsSet = new HashSet<Long>(srcEntryIds);
        for (BFRow node : dowNodes) {
            id = node.getId();
            sId = node.getSId();
            entryId = sId.getEntryId();
            Long tarEntryId = id.getEntryId();
            if (!srcIdsSet.contains(entryId)) continue;
            List tarEntryIds = srcEntryIdTarEntryIdsMap.computeIfAbsent(entryId, k -> new ArrayList(8));
            tarEntryIds.add(tarEntryId);
        }
        for (BFRow node : dowNodes) {
            id = node.getId();
            sId = node.getSId();
            entryId = sId.getEntryId();
            if (srcEntryIdTarEntryIdsMap.containsKey(entryId)) continue;
            for (Map.Entry entry : srcEntryIdTarEntryIdsMap.entrySet()) {
                List value = (List)entry.getValue();
                if (value == null || !value.contains(entryId)) continue;
                List list = (List)srcEntryIdTarEntryIdsMap.get(entry.getKey());
                list.add(id.getEntryId());
            }
        }
        return srcEntryIdTarEntryIdsMap;
    }
}

