/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.DateUtils;

public class CloseDateHelper {
    protected static final Log logger = LogFactory.getLog(CloseDateHelper.class);
    private static final String INV = "inv";
    private static final String CAL = "cal";
    public static final List<String> TRANSFORMBILL = Arrays.asList("im_assembbill", "im_adjustbill", "im_disassemblebill");

    public static Map<String, Object> getCloseDateMap(String entityName, DynamicObject bill) {
        Date closeDate;
        HashMap<String, Object> closeDateMap = new HashMap<String, Object>(2);
        String flag = INV;
        Date invCloseDate = CloseDateHelper.getInvCloseDate(entityName, bill);
        Date calCloseDate = CloseDateHelper.getCalCloseDate(entityName, bill);
        if (null == invCloseDate && null == calCloseDate) {
            return null;
        }
        if (null != invCloseDate && null != calCloseDate) {
            if (invCloseDate.after(calCloseDate)) {
                closeDate = invCloseDate;
            } else {
                closeDate = calCloseDate;
                flag = CAL;
            }
        } else if (null == invCloseDate) {
            closeDate = calCloseDate;
            flag = CAL;
        } else {
            closeDate = invCloseDate;
        }
        closeDateMap.put("closeDate", closeDate);
        closeDateMap.put("key", flag);
        return closeDateMap;
    }

    public static Date getInvCloseDate(String entityName, DynamicObject bill) {
        DynamicObject scheme;
        BillEntityType dataEntityType = (BillEntityType)bill.getDataEntityType();
        IDataEntityProperty property = dataEntityType.findProperty("invscheme");
        if (property != null && ((scheme = bill.getDynamicObject("invscheme")) == null || scheme.getBoolean("isnotupdate"))) {
            return null;
        }
        HashMap<Long, Set<Long>> orgWarehouseMap = CloseDateHelper.getAllOrgWarehouseMap(entityName, bill);
        QFilter closeFilter = CloseDateHelper.buildOrgWarehousesFilter(orgWarehouseMap);
        if (closeFilter == null) {
            return null;
        }
        closeFilter.and(new QFilter("isdelete", "<>", (Object)true));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"im_closeaccountrecord", (String)"im_closeaccountrecord", (String)"closedate", (QFilter[])closeFilter.toArray(), (String)"closedate desc").top(1);
        Date closeDate = null;
        for (Row row : dataSet) {
            closeDate = row.getDate("closedate");
        }
        return closeDate;
    }

    private static HashMap<Long, Set<Long>> getAllOrgWarehouseMap(String entityName, DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        HashMap<Long, Set<Long>> orgWarehouseMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject entry : entrys) {
            DynamicObject warehouseDyc = entry.getDynamicObject("warehouse");
            DynamicObject orgDyc = bill.getDynamicObject("org");
            CloseDateHelper.getAllOrgWarehouse(orgWarehouseMap, orgDyc, warehouseDyc);
            if (entityName.equals("im_transdirbill")) {
                DynamicObject outWarehouseDyc = entry.getDynamicObject("outwarehouse");
                DynamicObject outOrg = bill.getDynamicObject("outorg");
                CloseDateHelper.getAllOrgWarehouse(orgWarehouseMap, outOrg, outWarehouseDyc);
            }
            if (TRANSFORMBILL.contains(entityName)) {
                DynamicObjectCollection afterEntryDycs = entry.getDynamicObjectCollection("afterentity");
                for (DynamicObject afterDyc : afterEntryDycs) {
                    DynamicObject afterWarehouseDyc = afterDyc.getDynamicObject("warehouse1");
                    CloseDateHelper.getAllOrgWarehouse(orgWarehouseMap, orgDyc, afterWarehouseDyc);
                }
            }
            if (!entityName.equals("im_invinspectbill")) continue;
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject outWarehouseDyc = entry.getDynamicObject("outwarehouse");
            CloseDateHelper.getAllOrgWarehouse(orgWarehouseMap, org, outWarehouseDyc);
        }
        return orgWarehouseMap;
    }

    private static void getAllOrgWarehouse(HashMap<Long, Set<Long>> orgWarehouseMap, DynamicObject org, DynamicObject warehouse) {
        if (CommonUtils.isNull((Object)org) || CommonUtils.isNull((Object)warehouse)) {
            return;
        }
        orgWarehouseMap.computeIfAbsent((Long)org.getPkValue(), k -> new HashSet());
        orgWarehouseMap.get(org.getPkValue()).add((Long)warehouse.getPkValue());
    }

    private static QFilter buildOrgWarehousesFilter(Map<Long, Set<Long>> orgWarehouseMap) {
        QFilter orgWarehouseFilters = null;
        for (Map.Entry<Long, Set<Long>> entry : orgWarehouseMap.entrySet()) {
            QFilter orgf = new QFilter("org.id", "=", (Object)entry.getKey());
            QFilter orgWarehousef = new QFilter("warehouse.id", "in", (Object)entry.getValue().toArray());
            orgWarehousef.and(orgf);
            orgWarehouseFilters = orgWarehouseFilters == null ? orgWarehousef : orgWarehouseFilters.or(orgWarehousef);
        }
        return orgWarehouseFilters;
    }

    public static Set<Long> getAllOwnerIds(String entityName, DynamicObjectCollection entrys) {
        HashSet<Long> ownerIds = new HashSet<Long>(16);
        for (DynamicObject entry : entrys) {
            Object owner = entry.get("owner");
            if (owner != null) {
                Long ownerId = ((DynamicObject)owner).getLong("id");
                ownerIds.add(ownerId);
            }
            if (TRANSFORMBILL.contains(entityName) || "im_locationtransfer".equals(entityName) || entry.get("outowner") == null) continue;
            Object outOwner = entry.get("outowner");
            Long outOwnerId = ((DynamicObject)outOwner).getLong("id");
            ownerIds.add(outOwnerId);
        }
        return ownerIds;
    }

    public static Date getCalCloseDate(String entityName, DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        Set<Long> ownerIds = CloseDateHelper.getAllOwnerIds(entityName, entrys);
        if (!SystemCallParamHelper.isEnable("sbs_intersystemcallconf", "KC0001")) {
            return null;
        }
        Date calCloseDate = null;
        try {
            Map ownerCloseDate = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)CAL, (String)"CalCloseService", (String)"getOwnerCloseDate", (Object[])new Object[]{ownerIds});
            Map closeDateMap = (Map)ownerCloseDate.get("closeDate");
            for (Object[] closeDate : closeDateMap.values()) {
                Date singleOwnerCloseDate = (Date)closeDate[0];
                if (calCloseDate == null) {
                    calCloseDate = singleOwnerCloseDate;
                    continue;
                }
                calCloseDate = calCloseDate.after(singleOwnerCloseDate) ? calCloseDate : singleOwnerCloseDate;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5b58\u8d27\u6838\u7b97\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CloseDateHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        return calCloseDate;
    }

    public static void initBookDate(String entityId, DynamicObject bill) {
        boolean bookDateBill = MetaDataHelper.isExistField((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId), "bookdate");
        if (!bookDateBill) {
            return;
        }
        Date bookDate = (Date)bill.get("bookdate");
        Date bizDate = (Date)bill.get("biztime");
        if (null == bizDate) {
            bizDate = new Date();
        }
        if (SystemCallParamHelper.isEnable("sbs_scmcapplevelparam", "INV0004")) {
            bookDate = bizDate;
        } else {
            Date closeDate;
            Date addDate;
            boolean includeInitBizBill = MetaDataHelper.isExistField((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId), "isinitbill");
            if (("im_initbill".equals(entityId) || includeInitBizBill && ((Boolean)bill.get("isinitbill")).booleanValue()) && null == bookDate) {
                bookDate = bizDate;
                bill.set("bookdate", (Object)bizDate);
            }
            if (null != bookDate) {
                return;
            }
            Map<String, Object> closeDateMap = CloseDateHelper.getCloseDateMap(entityId, bill);
            bookDate = null != closeDateMap ? (bizDate.before(addDate = DateUtils.addOneDay((Date)(closeDate = (Date)closeDateMap.get("closeDate")))) ? addDate : (null == bizDate ? new Date() : bizDate)) : (null == bizDate ? new Date() : bizDate);
        }
        bill.set("bookdate", (Object)bookDate);
    }

    public static boolean isSkip(DynamicObject invBill) {
        boolean isExist = MetaDataHelper.isExistField(invBill.getDataEntityType(), "isinitbill");
        boolean check = isExist && invBill.getBoolean("isinitbill");
        boolean initCheck = "im_initbill".equals(invBill.getDataEntityType().getName());
        return check || initCheck;
    }

    public static void setBookdate2Biztime(String entityId, DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            boolean includeInitBizBill = MetaDataHelper.isExistField((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId), "isinitbill");
            if (!"im_initbill".equals(entityId) && (!includeInitBizBill || !((Boolean)bill.get("isinitbill")).booleanValue())) continue;
            bill.set("bookdate", bill.get("biztime"));
        }
    }
}

