/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

final class CommonVerifyHelper {
    CommonVerifyHelper() {
    }

    static boolean isMscommon(Map<String, Object> param) {
        Object object = param.get("ismscommon");
        if (object != null) {
            return Boolean.parseBoolean(object.toString());
        }
        return false;
    }

    static boolean isNotWriteBackJoinQty(Map<String, Object> param) {
        Object object = param.get("noupdjoinqty");
        if (object != null) {
            return Boolean.parseBoolean(object.toString());
        }
        return false;
    }

    static Map<Long, List<Long>> getSpecEntryList(String billType, Set<Long> entityIds, List<Long> entryIds, String tgtEntity, String tgtEntryKey) {
        if (entityIds == null || entryIds == null || entryIds.isEmpty() || entityIds.isEmpty()) {
            return Collections.emptyMap();
        }
        if (QueryServiceHelper.exists((String)"im_invdbparam", (QFilter[])new QFilter("key", "=", (Object)"verifyLD").toArray())) {
            try (TraceSpan trace = Tracer.create((String)"ImVerify.getSpecEntryListByLoadLinkDownNodes", (String)"getSpecEntryList");){
                Map<Long, List<Long>> map = CommonVerifyHelper.getSpecEntryListByLoadLinkDownNodes(billType, entityIds, entryIds, tgtEntity, tgtEntryKey);
                return map;
            }
        }
        try (TraceSpan trace = Tracer.create((String)"ImVerify.getSpecEntryListByLoadTargetRowIds", (String)"getSpecEntryList");){
            Map<Long, List<Long>> map = CommonVerifyHelper.getSpecEntryListByLoadTargetRowIds(billType, entityIds, entryIds, tgtEntity, tgtEntryKey);
            return map;
        }
    }

    private static Map<Long, List<Long>> getSpecEntryListByLoadLinkDownNodes(String billType, Set<Long> entityIds, List<Long> entryIds, String tgtEntity, String tgtEntryKey) {
        List loadLinkDownRowIds = BFTrackerServiceHelper.loadLinkDownNodes((String)billType, (String)"billentry", (Long[])entityIds.toArray(new Long[entityIds.size()]), (Long[])entryIds.toArray(new Long[entryIds.size()]), (OperateOption)OperateOption.create());
        if (loadLinkDownRowIds.isEmpty()) {
            return Collections.emptyMap();
        }
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)tgtEntity, (String)tgtEntryKey);
        if (tableDefine == null) {
            return Collections.emptyMap();
        }
        Long upTableId = tableDefine.getTableId();
        HashMap<Long, List<Long>> arEntryIdMap = new HashMap<Long, List<Long>>(16);
        for (BFRowLinkDownNode linkDwonNode : loadLinkDownRowIds) {
            ArrayList<Long> specChildEntryIds = new ArrayList<Long>(16);
            List childNodes = linkDwonNode.findAllChildNodes();
            for (BFRowLinkDownNode childNode : childNodes) {
                BFRowId childRow = childNode.getRowId();
                if (!upTableId.equals(childRow.getTableId())) continue;
                specChildEntryIds.add(childRow.getEntryId());
            }
            Long entryId = linkDwonNode.getRowId().getEntryId();
            ArrayList entryIdChilds = (ArrayList)arEntryIdMap.get(entryId);
            if (entryIdChilds == null) {
                entryIdChilds = new ArrayList(16);
                arEntryIdMap.put(entryId, entryIdChilds);
            }
            entryIdChilds.addAll(specChildEntryIds);
        }
        return arEntryIdMap;
    }

    private static Map<Long, List<Long>> getSpecEntryListByLoadTargetRowIds(String billType, Set<Long> entityIds, List<Long> entryIds, String tgtEntity, String tgtEntryKey) {
        HashMap<Long, List<Long>> arEntryIdMap = new HashMap<Long, List<Long>>();
        List loadTargetRowIds = BFTrackerServiceHelper.loadTargetRowIds((String)billType, (String)"billentry", (Long[])entityIds.toArray(new Long[entityIds.size()]), (Long[])entryIds.toArray(new Long[entryIds.size()]), (OperateOption)OperateOption.create());
        if (loadTargetRowIds != null && !loadTargetRowIds.isEmpty()) {
            List<BFRowId> list;
            ConvertDataService reader2 = new ConvertDataService();
            TableDefine revcFmTableDefine = reader2.loadTableDefine(tgtEntity, tgtEntryKey);
            Long revcFmTableId = revcFmTableDefine.getTableId();
            ConvertDataService srReader = new ConvertDataService();
            TableDefine srTableDefine = srReader.loadTableDefine(billType, "billentry");
            Long srTableId = srTableDefine.getTableId();
            HashMap targetRowMap = new HashMap();
            for (BFRow bFRow : loadTargetRowIds) {
                BFRowId sid = bFRow.getSId();
                Long sTableId = sid.getTableId();
                Long sentryId = sid.getEntryId();
                BFRowId tagertId = bFRow.getId();
                Long tagertEntryId = tagertId.getEntryId();
                if (sTableId == null || !sTableId.equals(srTableId)) continue;
                list = (ArrayList)targetRowMap.get(sentryId);
                if (list == null) {
                    list = new ArrayList();
                    targetRowMap.put(sentryId, list);
                }
                boolean isContains = false;
                for (BFRowId bfRowId : list) {
                    if (!bfRowId.getEntryId().equals(tagertEntryId)) continue;
                    isContains = true;
                }
                if (isContains) continue;
                list.add(tagertId);
                CommonVerifyHelper.addTargetRowId(loadTargetRowIds, tagertId, list);
            }
            for (Map.Entry entry : targetRowMap.entrySet()) {
                Long sEntryId = (Long)entry.getKey();
                List tagerIdList = (List)entry.getValue();
                for (BFRowId tagerId : tagerIdList) {
                    Long tagerEntryId;
                    Long tableId = tagerId.getTableId();
                    if (!revcFmTableId.equals(tableId)) continue;
                    list = (List)arEntryIdMap.get(sEntryId);
                    if (list == null) {
                        list = new ArrayList();
                        arEntryIdMap.put(sEntryId, list);
                    }
                    if (list.contains(tagerEntryId = tagerId.getEntryId())) continue;
                    list.add((BFRowId)tagerEntryId);
                }
            }
        }
        return arEntryIdMap;
    }

    private static void addTargetRowId(List<BFRow> loadTargetRowIds, BFRowId targetRowId, List<BFRowId> targetRowIdList) {
        for (BFRow bfRow : loadTargetRowIds) {
            BFRowId sid = bfRow.getSId();
            Long sentryId = sid.getEntryId();
            BFRowId tagertId = bfRow.getId();
            Long tagertEntryId = tagertId.getEntryId();
            if (sentryId == null || !sentryId.equals(targetRowId.getEntryId())) continue;
            boolean isContains = false;
            for (BFRowId bfRowId : targetRowIdList) {
                if (!bfRowId.getEntryId().equals(tagertEntryId)) continue;
                isContains = true;
            }
            if (isContains) continue;
            targetRowIdList.add(tagertId);
            CommonVerifyHelper.addTargetRowId(loadTargetRowIds, tagertId, targetRowIdList);
        }
    }

    public static Set<Long> getUpEntryList(String sourceBillEntity, String targeBillEntity, Collection<Long> entityIds) {
        HashSet<Long> badDealEntryId = new HashSet<Long>(16);
        TableDefine tableDifine = new ConvertDataService().loadTableDefine(targeBillEntity, targeBillEntity);
        if (tableDifine == null) {
            return badDealEntryId;
        }
        Long badDealTableId = tableDifine.getTableId();
        Long[] entityNumberIds = entityIds.toArray(new Long[entityIds.size()]);
        List upNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)sourceBillEntity, (Long[])entityNumberIds, null);
        if (upNodes == null || upNodes.isEmpty()) {
            return badDealEntryId;
        }
        for (BFRowLinkUpNode node : upNodes) {
            BFRowId srcRowId = node.getRowId();
            Long entryId = srcRowId.getEntryId();
            Collection values = node.getSNodes().values();
            for (BFRowLinkUpNode upNode : values) {
                BFRowId rowId = upNode.getRowId();
                if (!badDealTableId.equals(rowId.getMainTableId())) continue;
                badDealEntryId.add(entryId);
            }
        }
        return badDealEntryId;
    }
}

