/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.consts.Constants;

public class CurrencyHelper {
    private static final Log logger = LogFactory.getLog(CurrencyHelper.class);
    private static final String CURRENCY_DT = "bd_currency";
    private static final String EXRATETABLE_DT = "bd_exratetable";
    private static final String BASECURRRENCY = "baseCurrencyID";
    private static final String EXRATETABLE = "exchangeRateTableID";
    private static String EXRATE_DT = "bd_exrate_tree";
    private static String EXRATE_ORGCUR = "orgcur";
    private static String EXRATE_CUR = "cur";
    private static final String EXRATE_EXCTABLE = "exctable";
    private static final String EXRATE_EXCVAL = "excval";
    private static Map<Long, Map<String, Long>> cacheMap = new HashMap<Long, Map<String, Long>>();

    public static Map<String, Long> getCurrencyAndExRateTableCache(Long orgId) {
        Map<String, Long> currencyAndExRateTable = cacheMap.get(orgId);
        if (currencyAndExRateTable == null) {
            currencyAndExRateTable = CurrencyHelper.getCurrencyAndExRateTable(orgId);
            cacheMap.put(orgId, currencyAndExRateTable);
        }
        return currencyAndExRateTable;
    }

    @Deprecated
    public static DynamicObject getCurrency() {
        DynamicObject currency = BusinessDataServiceHelper.loadSingle((Object)1, (String)CURRENCY_DT);
        return currency;
    }

    public static DynamicObject getCurrency(Long orgId) {
        Map<String, Long> map;
        if (orgId != 0L && (map = CurrencyHelper.getCurrencyAndExRateTable(orgId)) != null) {
            return BusinessDataServiceHelper.loadSingle((Object)map.get(BASECURRRENCY), (String)CURRENCY_DT);
        }
        return null;
    }

    public static DynamicObject getExRateTable(Long orgId) {
        Map<String, Long> map;
        if (orgId != 0L && (map = CurrencyHelper.getCurrencyAndExRateTable(orgId)) != null) {
            return BusinessDataServiceHelper.loadSingle((Object)map.get(EXRATETABLE), (String)EXRATETABLE_DT);
        }
        return null;
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map mapOrg;
        if (orgId != 0L && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)false, (Boolean)true)) != null && mapOrg.get("id") != null) {
            logger.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u9700\u6c42\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\uff1a" + mapOrg);
            Map map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")));
            if (map != null && map.size() != 0) {
                logger.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u6838\u7b97\u4e3b\u4f53\u7684\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868\uff1a" + map);
                return map;
            }
        }
        return null;
    }

    public static BigDecimal getExChangeRate(Long curId, Long settleCurId) {
        BigDecimal exChangeRate = Constants.ZERO;
        if (curId.equals(settleCurId)) {
            exChangeRate = Constants.ONE;
        } else {
            QFilter q2 = new QFilter(EXRATE_CUR, "=", (Object)curId);
            QFilter q1 = new QFilter(EXRATE_ORGCUR, "=", (Object)settleCurId);
            QFilter[] filters = new QFilter[]{q1, q2};
            DynamicObject exchangeRate = BusinessDataServiceHelper.loadSingle((String)EXRATE_DT, (String)EXRATE_EXCVAL, (QFilter[])filters);
            if (exchangeRate != null) {
                exChangeRate = exchangeRate.getBigDecimal(EXRATE_EXCVAL);
            }
        }
        return exChangeRate;
    }
}

