/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.biz.balance.engine.BalanceUpdateManager;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.scmc.im.business.balance.BalanceUpdateHandle;
import kd.scmc.im.business.helper.DymAccDSMappingBill;
import kd.scmc.im.consts.InvAccConst;

public class DymAccDataSourceHelper {
    private static final ThreadLocal<List<String>> updateKeyCol = new ThreadLocal();
    private static final ThreadLocal<String[]> balanceUpdateKeys = new ThreadLocal();

    public static ThreadLocal<String[]> getBalanceUpdateKeys() {
        return balanceUpdateKeys;
    }

    public static List<DymAccDSMappingBill> getUpdateBillFromDymAccDS(boolean includeInitbill) {
        List<DymAccDSMappingBill> listDymAccDSMappingBill = DymAccDataSourceHelper.getDataSource(includeInitbill);
        if (listDymAccDSMappingBill.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u89c4\u5219\u76f8\u5173\u5185\u5bb9\u672a\u914d\u7f6e\u6216\u5df2\u7981\u7528\u3002", (String)"DymAccDataSourceHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        if (!"im_invacc".equals(InvAccConst.getBalTb())) {
            return listDymAccDSMappingBill;
        }
        for (DymAccDSMappingBill dymAccDSMappingBill : listDymAccDSMappingBill) {
            Map<String, String> mappingTarget;
            Map<String, String> mapping;
            if ("im_assembbill".equals(dymAccDSMappingBill.getSrcbill()) && "SUB".equals(dymAccDSMappingBill.getUpdateType())) {
                mapping = dymAccDSMappingBill.getMapping();
                mappingTarget = dymAccDSMappingBill.getMapping();
                for (Map.Entry<String, String> map : mapping.entrySet()) {
                    if ("org".equals(map.getKey()) || "biztime".equals(map.getKey())) continue;
                    mappingTarget.put(map.getKey(), "billentry." + map.getValue());
                }
                dymAccDSMappingBill.setMapping(mappingTarget);
            }
            if (!"im_adjustbill".equals(dymAccDSMappingBill.getSrcbill()) && !"im_disassemblebill".equals(dymAccDSMappingBill.getSrcbill()) || !"ADD".equals(dymAccDSMappingBill.getUpdateType())) continue;
            mapping = dymAccDSMappingBill.getMapping();
            mappingTarget = dymAccDSMappingBill.getMapping();
            for (Map.Entry<String, String> map : mapping.entrySet()) {
                if ("org".equals(map.getKey()) || "biztime".equals(map.getKey())) continue;
                mappingTarget.put(map.getKey(), "billentry." + map.getValue());
            }
            dymAccDSMappingBill.setMapping(mappingTarget);
        }
        return listDymAccDSMappingBill;
    }

    private static List<DymAccDSMappingBill> getDataSource(boolean includeInitbill) {
        ArrayList<DymAccDSMappingBill> listDymAccDSMappingBill = new ArrayList<DymAccDSMappingBill>(20);
        String balTb = InvAccConst.getBalTb();
        String entityInvbalance = "im_invbalance";
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            entityInvbalance = "im_inv_periodbalance";
        }
        DataEntityPropertyCollection balProps = EntityMetadataCache.getDataEntityType((String)entityInvbalance).getProperties();
        if ("im_invacc".equals(balTb)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5207\u6362\u4f7f\u7528\u65b0\u7684\u4f59\u989d\u6a21\u578b\u3002", (String)"DymAccDataSourceHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        List rules = BalanceUpdateManager.loadUpdateRule((String)balTb);
        for (UpdateRule rule : rules) {
            if (!rule.isEnable()) continue;
            String billFormId = rule.getEntityNumber();
            if (updateKeyCol.get() == null || updateKeyCol.get().size() == 0) {
                updateKeyCol.set(rule.getUpdateKeyCol());
                List<String> updateKeyCol = DymAccDataSourceHelper.updateKeyCol.get();
                String[] array = updateKeyCol.toArray(new String[updateKeyCol.size()]);
                int length = array.length;
                ArrayList<String> balanceUpdateKeys_perThread = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    if (!balProps.containsKey((Object)array[i]) && !"lotnum".equals(array[i])) continue;
                    if ("lotnum".equals(array[i])) {
                        balanceUpdateKeys_perThread.add("lotnumber");
                        continue;
                    }
                    balanceUpdateKeys_perThread.add(array[i]);
                }
                balanceUpdateKeys.set(balanceUpdateKeys_perThread.toArray(new String[balanceUpdateKeys_perThread.size()]));
            }
            if (!includeInitbill && "im_initbill".equals(billFormId)) continue;
            DymAccDSMappingBill dymAccDSMappingBill = new DymAccDSMappingBill(billFormId, rule.getUpdateType() == -1 ? "SUB" : "ADD", rule.getFilter());
            Map targetSrcColMap = rule.getTargetSrcColMap();
            Map srcColFullNameMap = rule.getSrcColFullNameMap();
            HashMap<String, String> mapping = new HashMap<String, String>(32);
            for (Map.Entry col : targetSrcColMap.entrySet()) {
                mapping.put((String)col.getKey(), (String)srcColFullNameMap.get(col.getValue()));
            }
            dymAccDSMappingBill.setMapping(mapping);
            listDymAccDSMappingBill.add(dymAccDSMappingBill);
        }
        return listDymAccDSMappingBill;
    }
}

