/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class ErrorCodeHelper {
    private static final String REPLACE_SIGN = "%s";

    public static void showErrorCode(String description, String msgBox, String msgType, String messageType, String detail, int duration, String callBackID, String btnoption, String confirmtype, AbstractFormPlugin formPlugin) {
        ErrorCodeHelper.showErrorCode(description, msgBox, msgType, messageType, detail, duration, callBackID, btnoption, confirmtype, null, formPlugin);
    }

    public static void showErrorCode(String description, String msgBox, String msgType, String messageType, String detail, int duration, String callBackID, String btnoption, String confirmtype, Object[] args, AbstractFormPlugin formPlugin) {
        IFormView view = formPlugin.getView();
        String msg = description;
        if (args != null && args.length > 0 && description.indexOf(REPLACE_SIGN) != -1) {
            int split = description.split(REPLACE_SIGN).length - 1;
            int param = args.length;
            Object[] newArgs = new Object[split];
            if (split > param) {
                System.arraycopy(args, 0, newArgs, 0, param);
                for (int j = param; j < split; ++j) {
                    args[j] = REPLACE_SIGN;
                }
                args = newArgs;
            } else if (split < param) {
                System.arraycopy(args, 0, newArgs, 0, split);
            } else {
                newArgs = args;
            }
            msg = String.format(description, newArgs);
        }
        if ("n".equals(msgBox)) {
            if ("succ".equals(msgType)) {
                if (duration == 0 || duration == 2) {
                    view.showSuccessNotification(msg);
                } else {
                    view.showSuccessNotification(msg, Integer.valueOf(duration * 1000));
                }
            } else if ("tip".equals(msgType)) {
                if (duration == 0 || duration == 3) {
                    view.showTipNotification(msg);
                } else {
                    view.showTipNotification(msg, Integer.valueOf(duration * 1000));
                }
            } else if ("error".equals(msgType)) {
                view.showErrorNotification(msg);
            }
        } else if ("m".equals(msgBox)) {
            if ("succ".equals(msgType) || "tip".equals(msgType)) {
                if (StringUtils.isBlank((CharSequence)messageType)) {
                    view.showMessage(msg);
                } else {
                    MessageTypes[] messageTypes = MessageTypes.values();
                    int messageIndex = Integer.parseInt(messageType);
                    if (StringUtils.isBlank((CharSequence)callBackID)) {
                        view.showMessage(msg, detail, messageTypes[messageIndex]);
                    } else {
                        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(callBackID, (IFormPlugin)formPlugin);
                        view.showMessage(msg, messageTypes[messageIndex], confirmCallBackListener);
                    }
                }
            } else if ("error".equals(msgType)) {
                view.showErrMessage(msg, detail);
            }
        } else if ("c".equals(msgBox)) {
            int boxIndex = Integer.parseInt(btnoption);
            MessageBoxOptions[] messageBoxOptions = MessageBoxOptions.values();
            MessageBoxOptions messageBoxOption = messageBoxOptions[boxIndex];
            int confirmIndex = Integer.parseInt(confirmtype);
            if (StringUtils.isBlank((CharSequence)callBackID)) {
                view.showConfirm(msg, messageBoxOption);
            } else {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(callBackID, (IFormPlugin)formPlugin);
                if (StringUtils.isBlank((Object)confirmIndex)) {
                    view.showConfirm(msg, messageBoxOption, confirmCallBackListener);
                } else {
                    ConfirmTypes[] confirmTypes = ConfirmTypes.values();
                    ConfirmTypes confirmType = confirmTypes[confirmIndex];
                    if (StringUtils.isBlank((CharSequence)detail)) {
                        view.showConfirm(msg, messageBoxOption, confirmType, confirmCallBackListener);
                    } else {
                        view.showConfirm(msg, detail, messageBoxOption, confirmType, confirmCallBackListener);
                    }
                }
            }
        }
    }
}

