/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ExRateCacheHelper {
    private static Map<String, BigDecimal> map = new HashMap<String, BigDecimal>();
    private static Set<String> noneExrate = new HashSet<String>();

    public static BigDecimal getExRate(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        String key = ExRateCacheHelper.getKey(exchangeTableID, sourceCurrencyID, targetCurrencyID, date);
        Object exRate = map.get(key);
        if (exRate == null && !noneExrate.contains(key)) {
            exRate = targetCurrencyID.equals(sourceCurrencyID) ? BigDecimal.ONE : (sourceCurrencyID == 0L || targetCurrencyID == 0L ? null : BaseDataServiceHelper.getExchangeRate((Long)exchangeTableID, (Long)sourceCurrencyID, (Long)targetCurrencyID, (Date)date));
            if (exRate == null) {
                noneExrate.add(key);
            }
            map.put(key, (BigDecimal)exRate);
        }
        return exRate;
    }

    public static String getKey(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(exchangeTableID);
        stringBuilder.append('-');
        stringBuilder.append(sourceCurrencyID);
        stringBuilder.append('-');
        stringBuilder.append(targetCurrencyID);
        stringBuilder.append('-');
        if (date == null) {
            stringBuilder.append(0);
        } else {
            stringBuilder.append(date.getTime());
        }
        return stringBuilder.toString();
    }
}

