/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.Collection;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.BasedataProp;
import org.apache.commons.collections4.CollectionUtils;

public class FieldLangFormTranslator {
    private final IDataModel model;
    private final String langName;

    private FieldLangFormTranslator(IDataModel model, String langName) {
        this.model = model;
        this.langName = langName;
    }

    public static FieldLangFormTranslator create(IDataModel model) {
        return new FieldLangFormTranslator(model, RequestContext.get().getLang().name());
    }

    public static String getEntityKeyWithLang(String langName, MainEntityType dt, String fieldKey) {
        String[] splitKey = fieldKey.split("\\.");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < splitKey.length; ++i) {
            String curSplitKey;
            String name = curSplitKey = splitKey[i];
            if (builder.length() != 0) {
                builder.append(".");
            }
            IDataEntityProperty property = dt.findProperty(curSplitKey);
            if ("id".equals(curSplitKey)) {
                name = ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"EntityParseHelper_1", (String)"scmc-im-business", (Object[])new Object[]{""});
                name = name.substring(1);
            } else if (property == null && i > 0) {
                IDataEntityProperty preProperty = dt.findProperty(splitKey[i - 1]);
                if (preProperty instanceof BasedataProp) {
                    BasedataProp prop = (BasedataProp)preProperty;
                    MainEntityType baseDt = EntityMetadataCache.getDataEntityType((String)prop.getBaseEntityId());
                    IDataEntityProperty baseProperty = baseDt.findProperty(curSplitKey);
                    name = (String)baseProperty.getDisplayName().get((Object)langName);
                }
            } else if (property != null && StringUtils.isEmpty((CharSequence)(name = (String)property.getDisplayName().get((Object)langName)))) {
                if ("zh_CN".equals(langName)) {
                    return fieldKey;
                }
                name = property.getName();
            }
            builder.append(name);
        }
        return builder.toString();
    }

    public void headFieldTranslate(String entityKey, String fieldKey, String displayKey) {
        if (StringUtils.isBlank((CharSequence)entityKey) || StringUtils.isBlank((CharSequence)fieldKey) || StringUtils.isBlank((CharSequence)displayKey)) {
            return;
        }
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        this.bindFieldName(billEntityType, fieldKey, displayKey);
    }

    public void entryFieldTranslate(String entryKey, String entityKey, String fieldKey, String displayKey) {
        if (StringUtils.isBlank((CharSequence)entryKey) || StringUtils.isBlank((CharSequence)entityKey) || StringUtils.isBlank((CharSequence)fieldKey) || StringUtils.isBlank((CharSequence)displayKey)) {
            return;
        }
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        int count = this.model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            this.bindColNames(i, billEntityType, fieldKey, displayKey);
        }
    }

    private void bindFieldName(MainEntityType billEntityType, String fieldKey, String displayKey) {
        String sourceValue = String.valueOf(this.model.getValue(fieldKey));
        if (billEntityType != null && StringUtils.isNotBlank((CharSequence)sourceValue)) {
            String sourceColName = FieldLangFormTranslator.getEntityKeyWithLang(this.langName, billEntityType, sourceValue);
            this.model.setValue(displayKey, (Object)sourceColName);
        }
    }

    private void bindColNames(int index, MainEntityType billEntityType, String fieldKey, String displayKey) {
        String sourceValue = String.valueOf(this.model.getValue(fieldKey, index));
        if (billEntityType != null && StringUtils.isNotBlank((CharSequence)sourceValue)) {
            String sourceColName = FieldLangFormTranslator.getEntityKeyWithLang(this.langName, billEntityType, sourceValue);
            this.model.setValue(displayKey, (Object)sourceColName, index);
        }
    }

    public void filterTranslate(String entityKey, String fieldKey, String displayKey) {
        if (StringUtils.isBlank((CharSequence)entityKey) || StringUtils.isBlank((CharSequence)fieldKey) || StringUtils.isBlank((CharSequence)displayKey)) {
            return;
        }
        String filterJson = (String)this.model.getValue(fieldKey);
        if (StringUtils.isBlank((CharSequence)filterJson)) {
            return;
        }
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterJson, CRCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(billEntityType, crCondition.getFilterCondition());
        String[] scripts = filterBuilder.buildFilterScript();
        this.model.setValue(displayKey, (Object)scripts[1]);
    }

    public void entryFormulaTranslate(String entryKey, String entityKey, String fieldKey, String displayKey) {
        if (StringUtils.isBlank((CharSequence)entryKey) || StringUtils.isBlank((CharSequence)entityKey) || StringUtils.isBlank((CharSequence)fieldKey) || StringUtils.isBlank((CharSequence)displayKey)) {
            return;
        }
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        int count = this.model.getEntryRowCount(entryKey);
        for (int index = 0; index < count; ++index) {
            CRValByConditions crCondition;
            String filterJson = String.valueOf(this.model.getValue(fieldKey, index));
            if (StringUtils.isBlank((CharSequence)filterJson) || CollectionUtils.isEmpty((Collection)(crCondition = (CRValByConditions)SerializationUtils.fromJsonString((String)filterJson, CRValByConditions.class)).getItems())) continue;
            StringJoiner stringJoiner = new StringJoiner("\\");
            for (CRValByCondition item : crCondition.getItems()) {
                CRValByCondition crValByCondition = item;
                if (null == crValByCondition.getFormula()) continue;
                String formula = crValByCondition.getFormula().getExpression();
                String sourceColName = FieldLangFormTranslator.getEntityKeyWithLang(this.langName, billEntityType, formula);
                stringJoiner.add(sourceColName);
            }
            this.model.setValue(displayKey, (Object)stringJoiner.toString(), index);
        }
    }

    public void entryFilterTranslate(String entryKey, String entityKey, String fieldKey, String displayKey) {
        if (StringUtils.isBlank((CharSequence)entryKey) || StringUtils.isBlank((CharSequence)entityKey) || StringUtils.isBlank((CharSequence)fieldKey) || StringUtils.isBlank((CharSequence)displayKey)) {
            return;
        }
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        int count = this.model.getEntryRowCount(entryKey);
        for (int index = 0; index < count; ++index) {
            String filterJson = (String)this.model.getValue(fieldKey, index);
            if (StringUtils.isBlank((CharSequence)filterJson)) continue;
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterJson, CRCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(billEntityType, crCondition.getFilterCondition());
            String[] scripts = filterBuilder.buildFilterScript();
            this.model.setValue(displayKey, (Object)scripts[1], index);
        }
    }
}

