/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class ImBillEditHelper {
    private IFormView view;

    public ImBillEditHelper(IFormView view) {
        this.view = view;
    }

    public void warehouseSelect(BeforeF7SelectEvent e, ListShowParameter showParameter, IDataModel bill) {
        DynamicObject org = (DynamicObject)bill.getValue("org");
        if (org == null) {
            this.view.showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG(), (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        int rowIdx = bill.getEntryCurrentRowIndex("billentry");
        DynamicObject row = bill.getEntryRowEntity("billentry", rowIdx);
        String formId = bill.getDataEntityType().getName();
        String warehouse = e.getProperty().getName();
        if ("im_invinspectbill".equals(formId) && ("qualifiedwarehouse".equals(warehouse) || "unqualifiedwarehouse".equals(warehouse))) {
            warehouse = "warehouse";
        }
        WareHouseIsolateHelper.setWarehouseQFilterByDataCtrl(org.getLong("id"), showParameter, formId, row, warehouse);
    }

    public void locationSelect(BeforeF7SelectEvent e, ListShowParameter showParameter, IDataModel bill, int rowIndex, String field) {
        DynamicObject warehouse = (DynamicObject)bill.getValue(field, rowIndex);
        if (null == warehouse) {
            this.view.showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_WAREHOUSE(), (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            QFilter qFilter1 = WarehouseHelper.buildLocationQFilter(warehouse);
            showParameter.getListFilterParameter().setFilter(qFilter1);
        }
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    public void updateEnableLocation(String location, DynamicObject warehouse, int rowindex) {
        if (!CommonUtils.isNull((Object)warehouse)) {
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            this.view.setEnable(Boolean.valueOf(isopenlocation), rowindex, new String[]{location});
        } else {
            this.view.setEnable(Boolean.FALSE, rowindex, new String[]{location});
        }
    }

    public static boolean isMainOrgByF7(IFormView view, IDataModel bill, String fieldKey) {
        MainEntityType entityType = bill.getDataEntityType();
        String mainOrg = entityType.getMainOrg();
        if (mainOrg == null) {
            return true;
        }
        DynamicProperty orgProp = entityType.getProperty(mainOrg);
        if (!mainOrg.equals(fieldKey) && bill.getValue(mainOrg) == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9{0}\u3002", (String)"IM-W-068466", (String)"scmc-im-business", (Object[])new Object[]{orgProp.getDisplayName()}));
            return false;
        }
        return true;
    }
}

