/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ImLotHelper {
    public static Map<String, DynamicObject> getLotIntrackMap(Collection<Object> orgIds, Collection<Object> materialIds, Collection<String> lotNums) {
        QFilter matFilter = new QFilter("id", "in", materialIds);
        HashMap<Long, Long> materialBase2InvMap = new HashMap<Long, Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ImLotHelper.class.getName(), (String)"bd_materialinventoryinfo", (String)"id,masterid", (QFilter[])matFilter.toArray(), (String)"");){
            for (Row row : dataSet) {
                materialBase2InvMap.put(row.getLong("masterid"), row.getLong("id"));
            }
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        HashMap<String, DynamicObject> lotIntrackMap = new HashMap<String, DynamicObject>(16);
        if (orgIds != null && !orgIds.isEmpty()) {
            filterList.add(new QFilter("org", "in", orgIds));
        }
        if (materialIds != null && !materialIds.isEmpty()) {
            filterList.add(new QFilter("materialmaster", "in", materialBase2InvMap.keySet()));
        }
        if (lotNums != null && !lotNums.isEmpty()) {
            filterList.add(new QFilter("lotnumber", "in", lotNums));
        }
        if (filterList.isEmpty()) {
            return lotIntrackMap;
        }
        Map lotIntracks = BusinessDataServiceHelper.loadFromCache((String)"im_lotintrack", (String)"org,materialmaster,lotnumber,producedate,expirydate", (QFilter[])filterList.toArray(new QFilter[filterList.size()]), (String)"biztime desc, createtime desc");
        for (DynamicObject lotIntrack : lotIntracks.values()) {
            Long materialInvId = (Long)materialBase2InvMap.get(lotIntrack.getLong("materialmaster.id"));
            String key = lotIntrack.getString("org_id") + "_" + materialInvId + "_" + lotIntrack.getString("lotnumber");
            if (lotIntrackMap.containsKey(key)) continue;
            lotIntrackMap.put(key, lotIntrack);
        }
        return lotIntrackMap;
    }
}

